<?php

/**
 * Loading the parent theme css.
 */
function divi_child_load_parent_css() {

	wp_enqueue_style( 'divi-parent-style', get_template_directory_uri() . '/style.css', false, '' );

}
add_action( 'wp_enqueue_scripts', 'divi_child_load_parent_css' );

function get_image_alt_text($image_url) {

  if ( ! $image_url )
    return '';

  if ( '/' === $image_url[0] )
    $post_id = attachment_url_to_postid(home_url() . $image_url);
  else
    $post_id = attachment_url_to_postid($image_url);

  $alt_text = get_post_meta($post_id, '_wp_attachment_image_alt', true);
  if ( '' === $alt_text )
    $alt_text = get_the_title($post_id);

  return $alt_text;

}

function update_module_alt_text( $attrs, $unprocessed_attrs, $slug ) {

  if ( ( $slug === 'et_pb_image' || $slug === 'et_pb_fullwidth_image' ) && '' === $attrs['alt'] )
    $attrs['alt'] = get_image_alt_text($attrs['src']);
  elseif ( $slug === 'et_pb_blurb' && 'off' === $attrs['use_icon'] && '' === $attrs['alt'] )
    $attrs['alt'] = get_image_alt_text($attrs['image']);
  elseif ( $slug === 'et_pb_slide' && '' !== $attrs['image'] && '' === $attrs['image_alt'] )
    $attrs['image_alt'] = get_image_alt_text($attrs['image']);
  elseif ( $slug === 'et_pb_fullwidth_header' ) {
    if ( '' !== $attrs['logo_image_url'] && '' === $attrs['logo_alt_text'] )
      $attrs['logo_alt_text'] = get_image_alt_text($attrs['logo_image_url']);
    if ( '' !== $attrs['header_image_url'] && '' === $attrs['image_alt_text'] )
      $attrs['image_alt_text'] = get_image_alt_text($attrs['header_image_url']);
  }

  return $attrs;
}
/* Injection du filtre */
add_filter( 'et_pb_module_shortcode_attributes', 'update_module_alt_text', 20, 3 );

/*MASQUER LES INFOS DE MISES A JOUR SAUF POUR LES ADMIN*/
function wpm_hide_update_notice_to_all_but_admin_users(){
	// Si l'utilisateur n'a pas les droits pour mettre à jour WordPress

    if (!current_user_can('update_core')) {
		// On supprime les notifications de mises à jour
        remove_action( 'admin_notices', 'update_nag', 3 );
    }
}
add_action( 'admin_head', 'wpm_hide_update_notice_to_all_but_admin_users', 1 );


function masquer_version() { 
return ''; 
} 
add_filter('the_generator', 'masquer_version');
