-- ---------------------------------------------------------
-- Backup with BackWPup ver.: 4.0.0
-- http://backwpup.com/
-- Blog Name: Artus Sécurité et Protection
-- Blog URL: https://artus-securite.fr/
-- Blog ABSPATH: /home/xdrvhgi/www/
-- Blog Charset: UTF-8
-- Table Prefix: mod284_
-- Database Name: xdrvhgi619
-- Backup on: 2023-12-14 10:37.23
-- ---------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='SYSTEM' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


--
-- Table structure for `mod284_blc_filters`
--

DROP TABLE IF EXISTS `mod284_blc_filters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_blc_filters` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_blc_filters`
--

LOCK TABLES `mod284_blc_filters` WRITE;
/*!40000 ALTER TABLE `mod284_blc_filters` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod284_blc_filters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_blc_instances`
--

DROP TABLE IF EXISTS `mod284_blc_instances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_blc_instances` (
  `instance_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `link_id` int(10) unsigned NOT NULL,
  `container_id` int(10) unsigned NOT NULL,
  `container_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `link_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parser_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'link',
  `container_field` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_context` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `raw_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`instance_id`),
  KEY `link_id` (`link_id`),
  KEY `source_id` (`container_type`,`container_id`),
  KEY `parser_type` (`parser_type`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_blc_instances`
--

LOCK TABLES `mod284_blc_instances` WRITE;
/*!40000 ALTER TABLE `mod284_blc_instances` DISABLE KEYS */;
INSERT INTO `mod284_blc_instances` (`instance_id`, `link_id`, `container_id`, `container_type`, `link_text`, `parser_type`, `container_field`, `link_context`, `raw_url`) VALUES 
(19, 1, 49797, 'et_footer_layout', 'Création du site internet', 'link', 'post_content', '', 'groupe-echo.fr'),
(20, 2, 49797, 'et_footer_layout', '<i class=\"fa fa-linkedin\"></i></i>', 'link', 'post_content', '', 'https://www.linkedin.com/company/artus-securite-protection/'),
(21, 3, 49797, 'et_footer_layout', 'Mentions légales', 'link', 'post_content', '', '/mentions-legales'),
(22, 4, 49797, 'et_footer_layout', 'Contact', 'link', 'post_content', '', '/contact'),
(23, 6, 49550, 'page', 'contact@groupe-echo.fr', 'link', 'post_content', '', 'mailto:contact@groupe-echo.fr'),
(24, 7, 49550, 'page', 'contact.commercial@artus-securite.fr', 'link', 'post_content', '', 'mailto:'),
(25, 8, 49550, 'page', 'http://www.adobe.com/', 'plaintext-url', 'post_content', '', 'http://www.adobe.com/'),
(26, 9, 49550, 'page', 'https://conso.bloctel.fr/', 'plaintext-url', 'post_content', '', 'https://conso.bloctel.fr/');
/*!40000 ALTER TABLE `mod284_blc_instances` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_blc_links`
--

DROP TABLE IF EXISTS `mod284_blc_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_blc_links` (
  `link_id` int(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` text CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `first_failure` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_check` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_success` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_check_attempt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `check_count` int(4) unsigned NOT NULL DEFAULT '0',
  `final_url` text CHARACTER SET latin1 COLLATE latin1_general_cs NOT NULL,
  `redirect_count` smallint(5) unsigned NOT NULL DEFAULT '0',
  `log` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `http_code` smallint(6) NOT NULL DEFAULT '0',
  `status_code` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `status_text` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `request_duration` float NOT NULL DEFAULT '0',
  `timeout` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `broken` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `warning` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `may_recheck` tinyint(1) NOT NULL DEFAULT '1',
  `being_checked` tinyint(1) NOT NULL DEFAULT '0',
  `result_hash` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `false_positive` tinyint(1) NOT NULL DEFAULT '0',
  `dismissed` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`link_id`),
  KEY `url` (`url`(150)),
  KEY `final_url` (`final_url`(150)),
  KEY `http_code` (`http_code`),
  KEY `broken` (`broken`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_blc_links`
--

LOCK TABLES `mod284_blc_links` WRITE;
/*!40000 ALTER TABLE `mod284_blc_links` DISABLE KEYS */;
INSERT INTO `mod284_blc_links` (`link_id`, `url`, `first_failure`, `last_check`, `last_success`, `last_check_attempt`, `check_count`, `final_url`, `redirect_count`, `log`, `http_code`, `status_code`, `status_text`, `request_duration`, `timeout`, `broken`, `warning`, `may_recheck`, `being_checked`, `result_hash`, `false_positive`, `dismissed`) VALUES 
(1, 0x68747470733a2f2f61727475732d73656375726974652e66722f65745f666f6f7465725f6c61796f75742f746f75732d6c65732d70616765732f67726f7570652d6563686f2e6672, '0000-00-00 00:00:00', '2023-12-13 23:58:08', '2023-12-13 23:58:08', '2023-12-13 23:58:08', 0, 'https://artus-securite.fr/', 1, '=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 301 \r\ndate: Wed, 13 Dec 2023 23:58:09 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nserver: Apache\r\nx-powered-by: PHP/8.0\r\nexpires: Wed, 11 Jan 1984 05:00:00 GMT\r\ncache-control: no-cache, must-revalidate, max-age=0\r\nx-redirect-by: WordPress\r\nlocation: https://artus-securite.fr\r\nvary: Accept-Encoding\r\n\r\nHTTP/2 200 \r\ndate: Wed, 13 Dec 2023 23:58:09 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nserver: Apache\r\nvary: User-Agent,Accept-Encoding\r\naccept-ranges: bytes\r\ncache-control: max-age=0, public\r\nexpires: Wed, 13 Dec 2023 23:58:09 GMT\r\nx-powered-by: WP Rocket/3.10.5.1\r\n\r\nRequest headers\n================\nGET / HTTP/2\r\nHost: artus-securite.fr\r\nUser-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.34 Safari/537.36\r\nAccept: */*\r\nReferer: https://artus-securite.fr\r\nConnection: close\r\nRange: bytes=0-2048\r\n\r\n\nLe lien est valide.', 200, '', '', 0.672664, 0, 0, 0, 1, 0, '200|0|0|https://artus-securite.fr/', 0, 0),
(2, 0x68747470733a2f2f7777772e6c696e6b6564696e2e636f6d2f636f6d70616e792f61727475732d73656375726974652d70726f74656374696f6e2f, '2021-04-07 16:06:28', '2023-12-13 23:58:10', '0000-00-00 00:00:00', '2023-12-13 23:58:10', 952, 'https://www.linkedin.com/company/artus-securite-protection/', 0, '=== Code HTTP : 999 ===\n\nResponse headers\n================\nHTTP/2 999 \r\ncache-control: no-cache, no-store\r\npragma: no-cache\r\ncontent-length: 1530\r\ncontent-type: text/html\r\nexpires: Thu, 01 Jan 1970 00:00:00 GMT\r\nset-cookie: trkCode=bf; Max-Age=5\r\nset-cookie: trkInfo=AQHN0xRaiB0tnQAAAYxlnc5QX5qyFmkmc7BPFijhK54aVgt-O7qT7OTMYzdanmU9XzVEOomYKgfGfBiEnLBFnPsY9ZstTmqmJj0icqPlaMRbObKT3uNaWO-qC-feppN5IyLVR7g=; Max-Age=5\r\nset-cookie: rtc=AQEAhW-H_ic7YgAAAYxlnc5QnQENfLIVWNp9sZSzjZPlX7zlWYEMIl5gtMVpUubIpMI1Elw5chMNnxGX2O7Ax1WAZ2IFhqXBKOLFi1oj9IkvKOY6py9KllBaxnL2FPNZ3BkFRptGCwMra1oBDwHjKjrIl-s7uz_Leyu9Y8_DYltsNXPwrSt0DBF_JDCAZqF_NnBxu5pEJEgbwi5QV8ca5ZcpdoVwDtz37VXa19Iaj8y0flVpnkH5MfQ=; Max-Age=120; path=/; domain=.linkedin.com\r\nx-li-fabric: prod-lor1\r\nx-li-pop: afd-prod-lor1-x\r\nx-li-proto: http/2\r\nx-li-uuid: AAYMbPBy1plu3W4PLLV4dw==\r\nx-cache: CONFIG_NOCACHE\r\nx-msedge-ref: Ref A: EC42B54A6BEF470AAF6DAF1A94CF3CD9 Ref B: PAR02EDGE0907 Ref C: 2023-12-13T23:58:10Z\r\ndate: Wed, 13 Dec 2023 23:58:10 GMT\r\n\r\nRequest headers\n================\nHEAD /company/artus-securite-protection/ HTTP/2\r\nHost: www.linkedin.com\r\nUser-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.34 Safari/537.36\r\nAccept: */*\r\nReferer: https://artus-securite.fr\r\nConnection: close\r\n\r\n\nLe lien est cassé.', 999, 'warning', 'Erreur inconnue', 0.293991, 0, 0, 1, 1, 0, '999|0|0|https://www.linkedin.com/company/artus-securite-protection/', 0, 0),
(3, 0x68747470733a2f2f61727475732d73656375726974652e66722f6d656e74696f6e732d6c6567616c6573, '0000-00-00 00:00:00', '2023-12-13 23:58:09', '2023-12-13 23:58:09', '2023-12-13 23:58:09', 0, 'https://artus-securite.fr/mentions-legales', 0, '=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 200 \r\ndate: Wed, 13 Dec 2023 23:58:10 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nserver: Apache\r\nx-powered-by: PHP/8.0\r\nlast-modified: Wed, 13 Dec 2023 16:59:14 GMT\r\ncache-control: max-age=0\r\nexpires: Wed, 13 Dec 2023 23:58:10 GMT\r\nvary: Accept-Encoding\r\n\r\nRequest headers\n================\nHEAD /mentions-legales HTTP/2\r\nHost: artus-securite.fr\r\nUser-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.34 Safari/537.36\r\nAccept: */*\r\nReferer: https://artus-securite.fr\r\nConnection: close\r\n\r\n\nLe lien est valide.', 200, '', '', 0.05244, 0, 0, 0, 1, 0, '200|0|0|https://artus-securite.fr/mentions-legales', 0, 0),
(4, 0x68747470733a2f2f61727475732d73656375726974652e66722f636f6e74616374, '0000-00-00 00:00:00', '2023-12-13 23:57:50', '2023-12-13 23:57:50', '2023-12-13 23:57:50', 0, 'https://artus-securite.fr/', 1, '=== Code HTTP : 200 ===\n\nResponse headers\n================\nHTTP/2 301 \r\ndate: Wed, 13 Dec 2023 23:58:07 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nserver: Apache\r\nx-powered-by: PHP/8.0\r\nexpires: Wed, 11 Jan 1984 05:00:00 GMT\r\ncache-control: no-cache, must-revalidate, max-age=0\r\nx-redirect-by: WordPress\r\nlocation: https://artus-securite.fr\r\nvary: Accept-Encoding\r\n\r\nHTTP/2 200 \r\ndate: Wed, 13 Dec 2023 23:58:08 GMT\r\ncontent-type: text/html; charset=UTF-8\r\nserver: Apache\r\nvary: User-Agent,Accept-Encoding\r\naccept-ranges: bytes\r\ncache-control: max-age=0, public\r\nexpires: Wed, 13 Dec 2023 23:58:08 GMT\r\nx-powered-by: WP Rocket/3.10.5.1\r\n\r\nRequest headers\n================\nGET / HTTP/2\r\nHost: artus-securite.fr\r\nUser-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.34 Safari/537.36\r\nAccept: */*\r\nReferer: https://artus-securite.fr\r\nConnection: close\r\nRange: bytes=0-2048\r\n\r\n\nLe lien est valide.', 200, '', '', 1.31946, 0, 0, 0, 1, 0, '200|0|0|https://artus-securite.fr/', 0, 0),
(6, 0x6d61696c746f3a636f6e746163744067726f7570652d6563686f2e6672, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2023-12-13 23:58:10', 952, '', 0, 'L’extension ne sait pas comment vérifier ce type de lien.', 0, '', '', 0, 0, 0, 0, 1, 0, '', 0, 0),
(7, 0x6d61696c746f3a, '0000-00-00 00:00:00', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '2023-12-13 23:58:10', 952, '', 0, 'L’extension ne sait pas comment vérifier ce type de lien.', 0, '', '', 0, 0, 0, 0, 1, 0, '', 0, 0),
(8, 0x687474703a2f2f7777772e61646f62652e636f6d2f, '2022-07-18 23:51:42', '2023-12-13 23:57:20', '2022-07-17 23:40:25', '2023-12-13 23:57:20', 504, 'http://www.adobe.com/', 0, 'Operation timed out after 30001 milliseconds with 0 bytes received [Error #28]\n=== (aucune réponse) ===\n\nResponse headers\n================\nRequest headers\n================\nHEAD / HTTP/1.1\r\nHost: www.adobe.com\r\nUser-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/104.0.5112.34 Safari/537.36\r\nAccept: */*\r\nReferer: https://artus-securite.fr\r\nConnection: close\r\n\r\n\n(Il semblerait que la connexion a expiré ou que le domaine n’existe pas.)\nLe lien est cassé.', 0, '', '', 30.0019, 1, 1, 0, 1, 0, '0|broken|timeout|http://www.adobe.com/', 0, 0),
(9, 0x68747470733a2f2f636f6e736f2e626c6f6374656c2e66722f, '2021-10-01 08:19:08', '2023-12-13 23:58:09', '2021-09-30 08:13:51', '2023-12-13 23:58:09', 785, 'https://conso.bloctel.fr/', 0, 'Could not resolve host: conso.bloctel.fr [Error #6]\n=== (aucune réponse) ===\n\nResponse headers\n================\n\nLe lien est cassé.', 0, 'warning', 'Serveur non trouvé', 0.000509, 0, 1, 0, 1, 0, '0|broken|0|https://conso.bloctel.fr/', 0, 0);
/*!40000 ALTER TABLE `mod284_blc_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_blc_synch`
--

DROP TABLE IF EXISTS `mod284_blc_synch`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_blc_synch` (
  `container_id` int(20) unsigned NOT NULL,
  `container_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `synched` tinyint(2) unsigned NOT NULL,
  `last_synch` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`container_type`,`container_id`),
  KEY `synched` (`synched`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_blc_synch`
--

LOCK TABLES `mod284_blc_synch` WRITE;
/*!40000 ALTER TABLE `mod284_blc_synch` DISABLE KEYS */;
INSERT INTO `mod284_blc_synch` (`container_id`, `container_type`, `synched`, `last_synch`) VALUES 
(8, 'acf_field', 1, '2021-04-07 18:06:15'),
(119, 'acf_field', 1, '2021-04-07 18:06:15'),
(120, 'acf_field', 1, '2021-04-07 18:06:15'),
(121, 'acf_field', 1, '2021-04-07 18:06:15'),
(124, 'acf_field', 1, '2021-04-07 18:06:15'),
(267, 'acf_field', 1, '2021-04-07 18:06:15'),
(299, 'acf_field', 1, '2021-04-07 18:06:15'),
(313, 'acf_field', 1, '2021-04-07 18:06:15'),
(319, 'acf_field', 1, '2021-04-07 18:06:15'),
(510, 'acf_field', 1, '2021-04-07 18:06:15'),
(512, 'acf_field', 1, '2021-04-07 18:06:15'),
(516, 'acf_field', 1, '2021-04-07 18:06:15'),
(640, 'acf_field', 1, '2021-04-07 18:06:15'),
(669, 'acf_field', 1, '2021-04-07 18:06:15'),
(670, 'acf_field', 1, '2021-04-07 18:06:15'),
(709, 'acf_field', 1, '2021-04-07 18:06:15'),
(725, 'acf_field', 1, '2021-04-07 18:06:15'),
(726, 'acf_field', 1, '2021-04-07 18:06:15'),
(736, 'acf_field', 1, '2021-04-07 18:06:15'),
(21266, 'acf_field', 1, '2021-04-07 18:06:15'),
(49476, 'acf_field', 1, '2021-04-07 18:06:15'),
(49507, 'acf_field', 1, '2021-04-07 18:06:15'),
(49521, 'acf_field', 1, '2021-04-07 18:06:15'),
(49550, 'acf_field', 1, '2021-04-07 18:06:15'),
(49587, 'acf_field', 1, '2021-04-07 18:06:15'),
(49797, 'acf_field', 1, '2021-04-07 18:06:15'),
(49798, 'acf_field', 1, '2021-04-07 18:06:15'),
(49860, 'acf_field', 1, '2021-04-07 18:06:15'),
(8, 'custom_css', 0, '2021-04-07 18:06:15'),
(8, 'custom_field', 1, '2021-04-07 18:06:15'),
(119, 'custom_field', 1, '2021-04-07 18:06:15'),
(120, 'custom_field', 1, '2021-04-07 18:06:15'),
(121, 'custom_field', 1, '2021-04-07 18:06:15'),
(124, 'custom_field', 1, '2021-04-07 18:06:15'),
(267, 'custom_field', 1, '2021-04-07 18:06:15'),
(299, 'custom_field', 1, '2021-04-07 18:06:15'),
(313, 'custom_field', 1, '2021-04-07 18:06:15'),
(319, 'custom_field', 1, '2021-04-07 18:06:15'),
(510, 'custom_field', 1, '2021-04-07 18:06:15'),
(512, 'custom_field', 1, '2021-04-07 18:06:15'),
(516, 'custom_field', 1, '2021-04-07 18:06:15'),
(640, 'custom_field', 1, '2021-04-07 18:06:15'),
(669, 'custom_field', 1, '2021-04-07 18:06:15'),
(670, 'custom_field', 1, '2021-04-07 18:06:15'),
(709, 'custom_field', 1, '2021-04-07 18:06:15'),
(725, 'custom_field', 1, '2021-04-07 18:06:15'),
(726, 'custom_field', 1, '2021-04-07 18:06:15'),
(736, 'custom_field', 1, '2021-04-07 18:06:15'),
(21266, 'custom_field', 1, '2021-04-07 18:06:15'),
(49476, 'custom_field', 1, '2021-04-07 18:06:15'),
(49507, 'custom_field', 1, '2021-04-07 18:06:15'),
(49521, 'custom_field', 1, '2021-04-07 18:06:15'),
(49550, 'custom_field', 1, '2021-04-07 18:06:15'),
(49587, 'custom_field', 1, '2021-04-07 18:06:15'),
(49797, 'custom_field', 1, '2021-04-07 18:06:15'),
(49798, 'custom_field', 1, '2021-04-07 18:06:15'),
(49860, 'custom_field', 1, '2021-04-07 18:06:15'),
(267, 'et_footer_layout', 1, '2021-04-07 18:06:15'),
(319, 'et_footer_layout', 1, '2021-04-07 18:06:15'),
(510, 'et_footer_layout', 1, '2021-04-07 18:06:15'),
(709, 'et_footer_layout', 1, '2021-04-07 18:06:15'),
(726, 'et_footer_layout', 1, '2021-04-07 18:06:15'),
(49797, 'et_footer_layout', 1, '2022-08-19 09:14:43'),
(124, 'et_header_layout', 1, '2021-04-07 18:06:15'),
(299, 'et_header_layout', 1, '2021-04-07 18:06:15'),
(669, 'et_header_layout', 1, '2021-04-07 18:06:15'),
(725, 'et_header_layout', 1, '2021-04-07 18:06:15'),
(49798, 'et_header_layout', 1, '2021-04-07 18:06:16'),
(120, 'et_template', 1, '2021-04-07 18:06:16'),
(121, 'et_template', 1, '2021-04-07 18:06:16'),
(313, 'et_template', 1, '2021-04-07 18:06:16'),
(512, 'et_template', 1, '2021-04-07 18:06:16'),
(670, 'et_template', 1, '2021-04-07 18:06:16'),
(736, 'et_template', 1, '2021-04-07 18:06:16'),
(119, 'et_theme_builder', 1, '2021-04-07 18:06:16'),
(516, 'oembed_cache', 1, '2021-04-07 18:06:16'),
(49860, 'oembed_cache', 1, '2021-04-07 18:06:16'),
(640, 'page', 1, '2021-04-07 18:06:16'),
(21266, 'page', 1, '2021-04-07 18:06:16'),
(49476, 'page', 1, '2021-04-07 18:06:16'),
(49501, 'page', 1, '2021-04-13 15:43:44'),
(49507, 'page', 1, '2021-04-07 18:06:16'),
(49521, 'page', 1, '2021-04-07 18:06:16'),
(49550, 'page', 1, '2023-11-13 10:43:12'),
(49587, 'page', 1, '2021-10-15 10:43:51');
/*!40000 ALTER TABLE `mod284_blc_synch` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_cf_form_entries`
--

DROP TABLE IF EXISTS `mod284_cf_form_entries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_cf_form_entries` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` varchar(18) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL,
  `datestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'active',
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `user_id` (`user_id`),
  KEY `date_time` (`datestamp`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=260 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_cf_form_entries`
--

LOCK TABLES `mod284_cf_form_entries` WRITE;
/*!40000 ALTER TABLE `mod284_cf_form_entries` DISABLE KEYS */;
INSERT INTO `mod284_cf_form_entries` (`id`, `form_id`, `user_id`, `datestamp`, `status`) VALUES 
(1, 'CF6047390b6259c', 0, '2021-04-09 08:08:57', 'active'),
(2, 'CF6047390b6259c', 0, '2021-04-09 08:23:27', 'active'),
(3, 'CF6047390b6259c', 0, '2021-04-09 08:56:31', 'active'),
(4, 'CF6047298f195ee', 3, '2021-04-13 13:03:37', 'active'),
(5, 'CF6047390b6259c', 3, '2021-04-13 13:08:21', 'active'),
(6, 'CF6047298f195ee', 0, '2021-05-22 20:24:27', 'active'),
(7, 'CF6047298f195ee', 0, '2021-05-25 18:19:37', 'active'),
(8, 'CF6047298f195ee', 0, '2021-08-24 01:02:26', 'active'),
(9, 'CF6047298f195ee', 0, '2021-08-26 07:08:24', 'active'),
(10, 'CF6047298f195ee', 0, '2021-09-23 15:49:55', 'active'),
(11, 'CF6047390b6259c', 0, '2021-10-12 16:20:19', 'active'),
(12, 'CF6047390b6259c', 0, '2021-10-13 18:03:18', 'active'),
(13, 'CF6047390b6259c', 0, '2021-11-16 09:46:27', 'active'),
(14, 'CF6047298f195ee', 0, '2021-12-01 11:40:50', 'active'),
(15, 'CF6047390b6259c', 0, '2021-12-02 09:12:40', 'active'),
(16, 'CF6047298f195ee', 0, '2021-12-16 20:27:02', 'active'),
(17, 'CF6047298f195ee', 0, '2021-12-29 11:25:44', 'active'),
(18, 'CF6047298f195ee', 0, '2021-12-31 17:33:39', 'active'),
(19, 'CF6047298f195ee', 0, '2022-01-07 14:03:45', 'active'),
(20, 'CF6047390b6259c', 0, '2022-01-31 08:31:06', 'active'),
(21, 'CF6047298f195ee', 0, '2022-02-05 12:05:11', 'active'),
(22, 'CF6047390b6259c', 0, '2022-02-08 17:21:26', 'active'),
(23, 'CF6047298f195ee', 0, '2022-02-13 10:13:55', 'active'),
(24, 'CF6047390b6259c', 0, '2022-02-16 10:51:44', 'active'),
(25, 'CF6047390b6259c', 0, '2022-02-25 16:32:50', 'active'),
(26, 'CF6047390b6259c', 0, '2022-02-28 12:50:41', 'active'),
(27, 'CF6047298f195ee', 0, '2022-03-22 18:33:22', 'active'),
(28, 'CF6047298f195ee', 0, '2022-03-24 13:16:43', 'active'),
(29, 'CF6047390b6259c', 0, '2022-04-01 11:58:40', 'active'),
(30, 'CF6047390b6259c', 0, '2022-04-02 10:37:25', 'active'),
(31, 'CF6047298f195ee', 0, '2022-04-06 14:16:21', 'active'),
(32, 'CF6047298f195ee', 0, '2022-04-08 06:34:36', 'active'),
(33, 'CF6047390b6259c', 0, '2022-04-12 10:14:05', 'active'),
(34, 'CF6047390b6259c', 0, '2022-04-14 12:12:09', 'active'),
(35, 'CF6047298f195ee', 0, '2022-04-20 20:43:02', 'active'),
(36, 'CF6047298f195ee', 0, '2022-04-29 11:57:13', 'active'),
(37, 'CF6047390b6259c', 0, '2022-05-05 15:11:06', 'active'),
(38, 'CF6047390b6259c', 0, '2022-05-19 14:55:23', 'active'),
(39, 'CF6047298f195ee', 0, '2022-05-20 14:06:03', 'active'),
(40, 'CF6047390b6259c', 0, '2022-05-23 10:07:10', 'active'),
(41, 'CF6047298f195ee', 0, '2022-06-03 07:35:18', 'active'),
(42, 'CF6047298f195ee', 0, '2022-06-08 21:52:35', 'active'),
(43, 'CF6047298f195ee', 0, '2022-06-17 14:32:52', 'active'),
(44, 'CF6047390b6259c', 0, '2022-06-21 23:33:33', 'active'),
(45, 'CF6047298f195ee', 0, '2022-06-30 17:31:42', 'active'),
(46, 'CF6047298f195ee', 0, '2022-07-04 12:39:47', 'active'),
(47, 'CF6047390b6259c', 0, '2022-07-05 17:40:09', 'active'),
(48, 'CF6047390b6259c', 0, '2022-07-10 09:50:43', 'active'),
(49, 'CF6047390b6259c', 0, '2022-07-11 09:21:06', 'active'),
(50, 'CF6047390b6259c', 0, '2022-07-11 12:53:36', 'active'),
(51, 'CF6047298f195ee', 0, '2022-07-13 22:39:19', 'active'),
(52, 'CF6047298f195ee', 0, '2022-08-07 17:46:51', 'active'),
(53, 'CF6047390b6259c', 0, '2022-08-10 21:24:32', 'active'),
(54, 'CF6047298f195ee', 0, '2022-08-20 09:32:45', 'active'),
(55, 'CF6047390b6259c', 0, '2022-08-21 20:07:13', 'active'),
(56, 'CF6047390b6259c', 0, '2022-10-07 08:59:00', 'active'),
(57, 'CF6047390b6259c', 0, '2022-10-25 15:53:17', 'active'),
(58, 'CF6047390b6259c', 0, '2022-10-26 07:18:35', 'active'),
(59, 'CF6047390b6259c', 0, '2022-11-05 11:50:23', 'active'),
(60, 'CF6047390b6259c', 0, '2022-11-22 10:46:55', 'active'),
(61, 'CF6047390b6259c', 0, '2022-12-06 10:51:24', 'active'),
(62, 'CF6047390b6259c', 0, '2022-12-08 13:46:13', 'active'),
(63, 'CF6047390b6259c', 0, '2022-12-09 08:26:38', 'active'),
(64, 'CF6047390b6259c', 0, '2022-12-09 14:23:15', 'active'),
(65, 'CF6047390b6259c', 0, '2022-12-10 11:50:09', 'active'),
(66, 'CF6047390b6259c', 0, '2022-12-10 11:58:09', 'active'),
(67, 'CF6047390b6259c', 0, '2022-12-13 16:32:38', 'active'),
(68, 'CF6047390b6259c', 0, '2022-12-23 16:45:18', 'active'),
(69, 'CF6047390b6259c', 0, '2022-12-29 15:10:05', 'active'),
(70, 'CF6047390b6259c', 0, '2023-01-03 15:10:46', 'active'),
(71, 'CF6047390b6259c', 0, '2023-01-04 14:15:55', 'active'),
(72, 'CF6047390b6259c', 0, '2023-01-12 22:27:49', 'active'),
(73, 'CF6047390b6259c', 0, '2023-01-13 07:36:21', 'active'),
(74, 'CF6047390b6259c', 0, '2023-01-15 12:48:08', 'active'),
(75, 'CF6047298f195ee', 0, '2023-01-16 13:16:07', 'active'),
(76, 'CF6047390b6259c', 0, '2023-01-17 15:20:00', 'active'),
(77, 'CF6047390b6259c', 0, '2023-01-17 15:46:57', 'active'),
(78, 'CF6047298f195ee', 0, '2023-01-17 16:50:34', 'active'),
(79, 'CF6047390b6259c', 0, '2023-01-17 19:16:48', 'active'),
(80, 'CF6047298f195ee', 0, '2023-01-18 12:20:20', 'active'),
(81, 'CF6047298f195ee', 0, '2023-01-19 14:45:35', 'active'),
(82, 'CF6047390b6259c', 0, '2023-01-19 22:45:30', 'active'),
(83, 'CF6047390b6259c', 0, '2023-01-25 18:35:01', 'active'),
(84, 'CF6047298f195ee', 0, '2023-01-30 13:41:44', 'active'),
(85, 'CF6047390b6259c', 0, '2023-02-02 18:11:49', 'active'),
(86, 'CF6047390b6259c', 0, '2023-02-03 05:16:51', 'active'),
(87, 'CF6047390b6259c', 0, '2023-02-03 11:52:59', 'active'),
(88, 'CF6047298f195ee', 2, '2023-02-03 15:21:59', 'active'),
(89, 'CF6047390b6259c', 0, '2023-02-03 18:10:33', 'active'),
(90, 'CF6047390b6259c', 0, '2023-02-04 11:40:41', 'active'),
(91, 'CF6047390b6259c', 0, '2023-02-04 13:46:23', 'active'),
(92, 'CF6047390b6259c', 0, '2023-02-12 15:24:37', 'active'),
(93, 'CF6047390b6259c', 0, '2023-02-14 14:34:14', 'active'),
(94, 'CF6047298f195ee', 0, '2023-02-14 21:05:11', 'active'),
(95, 'CF6047390b6259c', 0, '2023-02-17 17:23:28', 'active'),
(96, 'CF6047390b6259c', 0, '2023-02-21 07:46:41', 'active'),
(97, 'CF6047390b6259c', 0, '2023-02-26 14:20:35', 'active'),
(98, 'CF6047390b6259c', 0, '2023-03-02 19:14:08', 'active'),
(99, 'CF6047390b6259c', 0, '2023-03-05 15:51:52', 'active'),
(100, 'CF6047390b6259c', 0, '2023-03-05 16:41:32', 'active'),
(101, 'CF6047298f195ee', 0, '2023-03-05 19:39:47', 'active'),
(102, 'CF6047390b6259c', 0, '2023-03-07 08:53:30', 'active'),
(103, 'CF6047390b6259c', 0, '2023-03-09 15:31:21', 'active'),
(104, 'CF6047390b6259c', 0, '2023-03-13 00:00:37', 'active'),
(105, 'CF6047390b6259c', 0, '2023-03-16 11:03:11', 'active'),
(106, 'CF6047390b6259c', 0, '2023-03-17 05:02:46', 'active'),
(107, 'CF6047390b6259c', 0, '2023-03-18 09:31:17', 'active'),
(108, 'CF6047390b6259c', 0, '2023-03-20 04:16:55', 'active'),
(109, 'CF6047390b6259c', 0, '2023-03-22 16:52:47', 'active'),
(110, 'CF6047390b6259c', 0, '2023-03-23 13:23:33', 'active'),
(111, 'CF6047390b6259c', 0, '2023-03-23 13:28:18', 'active'),
(112, 'CF6047390b6259c', 0, '2023-03-24 12:07:01', 'active'),
(113, 'CF6047390b6259c', 0, '2023-03-29 09:31:15', 'active'),
(114, 'CF6047390b6259c', 0, '2023-04-10 10:29:01', 'active'),
(115, 'CF6047390b6259c', 0, '2023-04-14 05:26:01', 'active'),
(116, 'CF6047390b6259c', 0, '2023-04-14 09:57:34', 'active'),
(117, 'CF6047390b6259c', 0, '2023-04-16 09:42:22', 'active'),
(118, 'CF6047390b6259c', 0, '2023-04-18 15:09:12', 'active'),
(119, 'CF6047390b6259c', 0, '2023-04-18 20:32:46', 'active'),
(120, 'CF6047390b6259c', 0, '2023-04-20 05:04:26', 'active'),
(121, 'CF6047390b6259c', 0, '2023-04-21 21:40:56', 'active'),
(122, 'CF6047390b6259c', 0, '2023-04-26 10:48:29', 'active'),
(123, 'CF6047390b6259c', 0, '2023-04-27 09:43:21', 'active'),
(124, 'CF6047390b6259c', 0, '2023-04-27 14:46:29', 'active'),
(125, 'CF6047390b6259c', 0, '2023-04-29 05:44:50', 'active'),
(126, 'CF6047390b6259c', 0, '2023-04-30 02:32:13', 'active'),
(127, 'CF6047390b6259c', 0, '2023-04-30 04:16:06', 'active'),
(128, 'CF6047390b6259c', 0, '2023-05-02 18:54:20', 'active'),
(129, 'CF6047390b6259c', 0, '2023-05-05 11:47:22', 'active'),
(130, 'CF6047390b6259c', 0, '2023-05-06 16:41:01', 'active'),
(131, 'CF6047390b6259c', 0, '2023-05-08 23:52:17', 'active'),
(132, 'CF6047390b6259c', 0, '2023-05-11 21:56:11', 'active'),
(133, 'CF6047390b6259c', 0, '2023-05-12 13:26:00', 'active'),
(134, 'CF6047390b6259c', 0, '2023-05-19 15:44:14', 'active'),
(135, 'CF6047390b6259c', 0, '2023-05-19 20:55:03', 'active'),
(136, 'CF6047390b6259c', 0, '2023-05-19 22:39:00', 'active'),
(137, 'CF6047390b6259c', 0, '2023-05-21 00:13:52', 'active'),
(138, 'CF6047390b6259c', 0, '2023-05-21 07:37:44', 'active'),
(139, 'CF6047390b6259c', 0, '2023-05-22 19:45:09', 'active'),
(140, 'CF6047390b6259c', 0, '2023-05-26 19:52:54', 'active'),
(141, 'CF6047390b6259c', 0, '2023-05-27 05:54:55', 'active'),
(142, 'CF6047390b6259c', 0, '2023-05-28 09:35:34', 'active'),
(143, 'CF6047298f195ee', 0, '2023-05-30 12:34:23', 'active'),
(144, 'CF6047390b6259c', 0, '2023-06-01 17:36:19', 'active'),
(145, 'CF6047298f195ee', 0, '2023-06-05 19:26:40', 'active'),
(146, 'CF6047298f195ee', 0, '2023-06-07 12:24:05', 'active'),
(147, 'CF6047298f195ee', 0, '2023-06-09 12:58:50', 'active'),
(148, 'CF6047390b6259c', 0, '2023-06-16 03:39:49', 'active'),
(149, 'CF6047390b6259c', 0, '2023-06-17 14:55:42', 'active'),
(150, 'CF6047390b6259c', 0, '2023-06-18 02:14:43', 'active'),
(151, 'CF6047390b6259c', 0, '2023-06-18 10:03:25', 'active'),
(152, 'CF6047390b6259c', 0, '2023-06-20 12:02:01', 'active'),
(153, 'CF6047390b6259c', 0, '2023-06-21 00:10:56', 'active'),
(154, 'CF6047298f195ee', 0, '2023-06-22 19:31:53', 'active'),
(155, 'CF6047390b6259c', 0, '2023-06-29 09:36:24', 'active'),
(156, 'CF6047390b6259c', 0, '2023-07-03 12:28:49', 'active'),
(157, 'CF6047390b6259c', 0, '2023-07-03 21:26:23', 'active'),
(158, 'CF6047298f195ee', 0, '2023-07-04 09:19:39', 'active'),
(159, 'CF6047390b6259c', 0, '2023-07-04 09:35:09', 'active'),
(160, 'CF6047390b6259c', 0, '2023-07-10 06:31:04', 'active'),
(161, 'CF6047390b6259c', 0, '2023-07-13 10:49:17', 'active'),
(162, 'CF6047390b6259c', 0, '2023-07-13 12:32:34', 'active'),
(163, 'CF6047390b6259c', 0, '2023-07-15 14:42:04', 'active'),
(164, 'CF6047390b6259c', 0, '2023-07-16 22:11:53', 'active'),
(165, 'CF6047390b6259c', 0, '2023-07-20 03:44:14', 'active'),
(166, 'CF6047390b6259c', 0, '2023-07-21 13:33:39', 'active'),
(167, 'CF6047390b6259c', 0, '2023-07-31 23:11:02', 'active'),
(168, 'CF6047390b6259c', 0, '2023-08-01 18:51:48', 'active'),
(169, 'CF6047390b6259c', 0, '2023-08-06 13:27:07', 'active'),
(170, 'CF6047390b6259c', 0, '2023-08-06 13:34:37', 'active'),
(171, 'CF6047390b6259c', 0, '2023-08-08 07:17:13', 'active'),
(172, 'CF6047390b6259c', 0, '2023-08-10 13:09:48', 'active'),
(173, 'CF6047298f195ee', 0, '2023-08-11 14:42:17', 'active'),
(174, 'CF6047390b6259c', 0, '2023-08-13 07:59:54', 'active'),
(175, 'CF6047390b6259c', 0, '2023-08-13 08:46:11', 'active'),
(176, 'CF6047390b6259c', 0, '2023-08-13 09:43:03', 'active'),
(177, 'CF6047390b6259c', 0, '2023-08-13 09:47:59', 'active'),
(178, 'CF6047390b6259c', 0, '2023-08-18 13:48:51', 'active'),
(179, 'CF6047390b6259c', 0, '2023-08-19 19:25:17', 'active'),
(180, 'CF6047390b6259c', 0, '2023-08-27 12:10:46', 'active'),
(181, 'CF6047390b6259c', 0, '2023-08-29 07:57:14', 'active'),
(182, 'CF6047390b6259c', 0, '2023-08-30 03:36:26', 'active'),
(183, 'CF6047390b6259c', 0, '2023-08-31 23:49:50', 'active'),
(184, 'CF6047390b6259c', 0, '2023-09-01 20:07:53', 'active'),
(185, 'CF6047390b6259c', 0, '2023-09-02 00:09:39', 'active'),
(186, 'CF6047298f195ee', 0, '2023-09-02 21:39:13', 'active'),
(187, 'CF6047390b6259c', 0, '2023-09-11 20:30:19', 'active'),
(188, 'CF6047390b6259c', 0, '2023-09-11 20:37:47', 'active'),
(189, 'CF6047390b6259c', 0, '2023-09-12 13:20:58', 'active'),
(190, 'CF6047390b6259c', 0, '2023-09-12 23:14:02', 'active'),
(191, 'CF6047390b6259c', 0, '2023-09-19 18:45:29', 'active'),
(192, 'CF6047390b6259c', 0, '2023-09-19 23:46:41', 'active'),
(193, 'CF6047390b6259c', 0, '2023-09-20 01:59:06', 'active'),
(194, 'CF6047298f195ee', 0, '2023-09-21 12:22:13', 'active'),
(195, 'CF6047390b6259c', 0, '2023-09-21 12:33:35', 'active'),
(196, 'CF6047390b6259c', 0, '2023-09-23 09:24:30', 'active'),
(197, 'CF6047390b6259c', 0, '2023-09-25 15:29:38', 'active'),
(198, 'CF6047298f195ee', 0, '2023-09-25 21:28:34', 'active'),
(199, 'CF6047390b6259c', 0, '2023-09-26 08:55:17', 'active'),
(200, 'CF6047390b6259c', 0, '2023-09-28 04:22:16', 'active'),
(201, 'CF6047390b6259c', 0, '2023-09-28 07:12:02', 'active'),
(202, 'CF6047390b6259c', 0, '2023-09-28 20:49:12', 'active'),
(203, 'CF6047390b6259c', 0, '2023-09-29 10:09:07', 'active'),
(204, 'CF6047390b6259c', 0, '2023-10-04 02:42:11', 'active'),
(205, 'CF6047390b6259c', 0, '2023-10-04 09:34:32', 'active'),
(206, 'CF6047390b6259c', 0, '2023-10-05 00:14:56', 'active'),
(207, 'CF6047390b6259c', 0, '2023-10-05 16:49:34', 'active'),
(208, 'CF6047390b6259c', 0, '2023-10-09 03:40:04', 'active'),
(209, 'CF6047390b6259c', 0, '2023-10-09 09:48:06', 'active'),
(210, 'CF6047390b6259c', 0, '2023-10-09 10:40:14', 'active'),
(211, 'CF6047298f195ee', 0, '2023-10-10 16:26:24', 'active'),
(212, 'CF6047390b6259c', 0, '2023-10-11 12:05:48', 'active'),
(213, 'CF6047390b6259c', 0, '2023-10-12 11:04:00', 'active'),
(214, 'CF6047390b6259c', 0, '2023-10-12 12:49:46', 'active'),
(215, 'CF6047298f195ee', 0, '2023-10-16 10:50:40', 'active'),
(216, 'CF6047390b6259c', 0, '2023-10-17 12:21:52', 'active'),
(217, 'CF6047390b6259c', 0, '2023-10-19 15:44:52', 'active'),
(218, 'CF6047390b6259c', 0, '2023-10-22 12:00:19', 'active'),
(219, 'CF6047390b6259c', 0, '2023-10-23 04:46:40', 'active'),
(220, 'CF6047390b6259c', 0, '2023-10-23 05:37:50', 'active'),
(221, 'CF6047298f195ee', 0, '2023-10-24 21:14:20', 'active'),
(222, 'CF6047390b6259c', 0, '2023-10-25 10:45:08', 'active'),
(223, 'CF6047390b6259c', 0, '2023-10-25 13:54:23', 'active'),
(224, 'CF6047390b6259c', 0, '2023-10-26 13:23:04', 'active'),
(225, 'CF6047390b6259c', 0, '2023-10-27 01:03:00', 'active'),
(226, 'CF6047390b6259c', 0, '2023-10-27 08:44:12', 'active'),
(227, 'CF6047390b6259c', 0, '2023-10-28 00:35:00', 'active'),
(228, 'CF6047390b6259c', 0, '2023-11-06 18:55:15', 'active'),
(229, 'CF6047390b6259c', 0, '2023-11-10 16:51:26', 'active'),
(230, 'CF6047390b6259c', 0, '2023-11-16 06:11:34', 'active'),
(231, 'CF6047390b6259c', 0, '2023-11-19 14:00:53', 'active'),
(232, 'CF6047390b6259c', 0, '2023-11-19 23:52:34', 'active'),
(233, 'CF6047390b6259c', 0, '2023-11-21 13:07:55', 'active'),
(234, 'CF6047390b6259c', 0, '2023-11-22 10:53:39', 'active'),
(235, 'CF6047390b6259c', 0, '2023-11-22 10:54:35', 'active'),
(236, 'CF6047390b6259c', 0, '2023-11-22 18:13:18', 'active'),
(237, 'CF6047390b6259c', 0, '2023-11-22 23:01:59', 'active'),
(238, 'CF6047390b6259c', 0, '2023-11-23 10:16:04', 'active'),
(239, 'CF6047390b6259c', 0, '2023-11-25 01:09:16', 'active'),
(240, 'CF6047390b6259c', 0, '2023-11-26 14:54:47', 'active'),
(241, 'CF6047390b6259c', 0, '2023-11-27 07:51:12', 'active'),
(242, 'CF6047390b6259c', 0, '2023-11-29 18:57:22', 'active'),
(243, 'CF6047390b6259c', 0, '2023-11-30 00:10:43', 'active'),
(244, 'CF6047390b6259c', 0, '2023-11-30 01:24:03', 'active'),
(245, 'CF6047390b6259c', 0, '2023-11-30 15:45:46', 'active'),
(246, 'CF6047390b6259c', 0, '2023-11-30 15:51:29', 'active'),
(247, 'CF6047298f195ee', 0, '2023-12-01 08:35:28', 'active'),
(248, 'CF6047390b6259c', 0, '2023-12-02 21:28:59', 'active'),
(249, 'CF6047390b6259c', 0, '2023-12-05 12:47:42', 'active'),
(250, 'CF6047390b6259c', 0, '2023-12-06 06:24:16', 'active'),
(251, 'CF6047390b6259c', 0, '2023-12-06 10:44:42', 'active'),
(252, 'CF6047390b6259c', 0, '2023-12-06 19:31:53', 'active'),
(253, 'CF6047390b6259c', 0, '2023-12-06 20:09:04', 'active'),
(254, 'CF6047390b6259c', 0, '2023-12-08 13:53:38', 'active'),
(255, 'CF6047390b6259c', 0, '2023-12-10 13:02:52', 'active'),
(256, 'CF6047390b6259c', 0, '2023-12-11 18:22:47', 'active'),
(257, 'CF6047390b6259c', 0, '2023-12-11 18:24:44', 'active'),
(258, 'CF6047390b6259c', 0, '2023-12-12 12:56:58', 'active'),
(259, 'CF6047390b6259c', 0, '2023-12-13 08:53:35', 'active');
/*!40000 ALTER TABLE `mod284_cf_form_entries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_cf_form_entry_meta`
--

DROP TABLE IF EXISTS `mod284_cf_form_entry_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_cf_form_entry_meta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `process_id` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `entry_id` (`entry_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_cf_form_entry_meta`
--

LOCK TABLES `mod284_cf_form_entry_meta` WRITE;
/*!40000 ALTER TABLE `mod284_cf_form_entry_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod284_cf_form_entry_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_cf_form_entry_values`
--

DROP TABLE IF EXISTS `mod284_cf_form_entry_values`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_cf_form_entry_values` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` int(11) NOT NULL,
  `field_id` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`entry_id`),
  KEY `field_id` (`field_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3276 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_cf_form_entry_values`
--

LOCK TABLES `mod284_cf_form_entry_values` WRITE;
/*!40000 ALTER TABLE `mod284_cf_form_entry_values` DISABLE KEYS */;
INSERT INTO `mod284_cf_form_entry_values` (`id`, `entry_id`, `field_id`, `slug`, `value`) VALUES 
(1, 1, 'fld_5462783', 'nom', 'LASZCZYNSKI'),
(2, 1, 'fld_3436924', 'prenom', 'Francois'),
(3, 1, 'fld_2124341', 'adresse_mail', 'f.laszczynski@artus-securite.fr'),
(4, 1, 'fld_724362', 'num_tel', '06 42 05 55 20'),
(5, 1, 'fld_475276', 'socite', 'ARTUS SECURITE PROTECTION'),
(6, 1, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(7, 1, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(8, 1, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(9, 1, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(10, 1, 'fld_2695739', 'objet', 'test'),
(11, 1, 'fld_3396882', 'message', 'bonjour'),
(12, 1, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(13, 1, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(14, 1, 'fld_3201949', 'envoyer', 'click'),
(15, 2, 'fld_5462783', 'nom', 'LASZCZYNSKI'),
(16, 2, 'fld_3436924', 'prenom', 'Francois'),
(17, 2, 'fld_2124341', 'adresse_mail', 'f.laszczynski@artus-securite.fr'),
(18, 2, 'fld_724362', 'num_tel', '06 42 05 55 20'),
(19, 2, 'fld_475276', 'socite', 'ARTUS SECURITE PROTECTION'),
(20, 2, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(21, 2, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(22, 2, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(23, 2, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(24, 2, 'fld_2695739', 'objet', 'test test'),
(25, 2, 'fld_3396882', 'message', 'Bonjour Eric j\\\'ai mis test dans l\\\'objet et tu reçois recrutement '),
(26, 2, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(27, 2, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(28, 2, 'fld_3201949', 'envoyer', 'click'),
(29, 3, 'fld_5462783', 'nom', 'CRETON'),
(30, 3, 'fld_3436924', 'prenom', 'Eric'),
(31, 3, 'fld_2124341', 'adresse_mail', 'contact.commercial@artus-securite.fr'),
(32, 3, 'fld_724362', 'num_tel', '06 09 24 90 31'),
(33, 3, 'fld_475276', 'socite', 'BIL'),
(34, 3, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(35, 3, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(36, 3, 'fld_2695739', 'objet', 'Demande de devis'),
(37, 3, 'fld_3396882', 'message', 'Test'),
(38, 3, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(39, 3, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(40, 3, 'fld_3201949', 'envoyer', 'click'),
(41, 4, 'fld_5462783', 'nom', 'lefevre'),
(42, 4, 'fld_3436924', 'prenom', 'sandrine'),
(43, 4, 'fld_2124341', 'adresse_mail', 'yodappy@gmail.com'),
(44, 4, 'fld_724362', 'num_tel', '06 61 89 05 30'),
(45, 4, 'fld_6078931', 'agence_souhait.opt1916226', 'Hauts-de-France '),
(46, 4, 'fld_6078931', 'agence_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(47, 4, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/PASSEPORT-SL.pdf'),
(48, 4, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/PASSEPORT-SL.pdf'),
(49, 4, 'fld_3396882', 'message', 'dqfqfqf'),
(50, 4, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(51, 4, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(52, 4, 'fld_3201949', 'envoyer', 'click'),
(53, 5, 'fld_5462783', 'nom', 'lefevre'),
(54, 5, 'fld_3436924', 'prenom', 'sandrine'),
(55, 5, 'fld_2124341', 'adresse_mail', 'yodappy@gmail.com'),
(56, 5, 'fld_724362', 'num_tel', '06 61 89 05 30'),
(57, 5, 'fld_475276', 'socite', 'YODAPPY'),
(58, 5, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(59, 5, 'fld_6078931', 'secteur_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(60, 5, 'fld_2695739', 'objet', 'test'),
(61, 5, 'fld_3396882', 'message', 'DSDFF<'),
(62, 5, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(63, 5, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(64, 5, 'fld_3201949', 'envoyer', 'click'),
(65, 6, 'fld_5462783', 'nom', 'Seck'),
(66, 6, 'fld_3436924', 'prenom', 'Elimane'),
(67, 6, 'fld_2124341', 'adresse_mail', 'elimseck@gmail.com'),
(68, 6, 'fld_724362', 'num_tel', '07 53 00 22 32'),
(69, 6, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(70, 6, 'fld_6078931', 'agence_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(71, 6, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-Elimane-SECK-vn-1.pdf'),
(72, 6, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/CV-Elimane-SECK-vn-1.pdf'),
(73, 6, 'fld_3396882', 'message', 'Actuellement à la recherche d\\\'un emploi, je suis vivement intéressé par le secteur de la sécurité. C\\\'est pourquoi, je me permets, de vous soumettre ma candidature pour le poste d\\\'agent de sécurité .\r\n\r\nMon profil et mes expériences professionnelles m\\\'ont conduit à m’intéresser plus particulièrement au métier d\\\'agent de sécurité. Je pense disposer des qualités pour occuper le poste que vous souhaitez pourvoir. Calme, intégrité, maîtrise de soi, diplomatie, discipline, esprit d\\\'équipe et réactivité sont autant de qualificatifs qui me correspondent, tant dans le monde du travail que dans ma vie privée. Pour toutes ces raisons, je suis convaincu d\\\'être le candidat idéal pour exécuter au mieux les missions confiées à un agent de sécurité.\r\n\r\nDoté d\\\'un grand sens des responsabilités, je souhaiterais mettre au service de votre entreprise mes compétences professionnelles et humaines. Je pense être capable de vous accompagner dans le développement de votre entreprise et contribuer à son succès.\r\n\r\nJe reste à votre disposition pour toute information complémentaire ou pour vous rencontrer lors d\\\'un entretien.\r\n\r\nVeuillez agréer,Monsieur, l’expression de mes sincères salutations.'),
(74, 6, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(75, 6, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(76, 6, 'fld_3201949', 'envoyer', 'click'),
(77, 7, 'fld_5462783', 'nom', 'NOYON'),
(78, 7, 'fld_3436924', 'prenom', 'Hervé'),
(79, 7, 'fld_2124341', 'adresse_mail', 'h.nounours78@gmail.com'),
(80, 7, 'fld_724362', 'num_tel', '06 62 59 59 54'),
(81, 7, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(82, 7, 'fld_6078931', 'agence_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(83, 7, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-Herve-NOYON.pdf'),
(84, 7, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Carte-Pro.pdf'),
(85, 7, 'fld_3396882', 'message', 'LIBRE DE TOUT ENGAGEMENT , VEHICULE , JE VOUS PROPOSE DE METTRE MON EXPERIENCE A VOTRE SERVICE'),
(86, 7, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(87, 7, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(88, 7, 'fld_3201949', 'envoyer', 'click'),
(89, 8, 'fld_5462783', 'nom', 'La'),
(90, 8, 'fld_3436924', 'prenom', 'Dinh Trung'),
(91, 8, 'fld_2124341', 'adresse_mail', 'dinhla@live.fr'),
(92, 8, 'fld_724362', 'num_tel', '07 69 79 34 70'),
(93, 8, 'fld_6078931', 'agence_souhait.opt1109492', 'Est Champagne Ardenne '),
(94, 8, 'fld_6078931', 'agence_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(95, 8, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-nouveau-pdf.pdf'),
(96, 8, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Lettre-motivation-Dinh-ARTUS-pdf.pdf'),
(97, 8, 'fld_3396882', 'message', 'Bonjour Monsieur, Madame,\r\n\r\nVoilà ci-joint mon CV, je serai honoré de travailler et collaborer dans votre société\r\n\r\nBonne réception et cordialement à vous'),
(98, 8, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(99, 8, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(100, 8, 'fld_3201949', 'envoyer', 'click'),
(101, 9, 'fld_5462783', 'nom', 'BIYOUDI '),
(102, 9, 'fld_3436924', 'prenom', 'Harry '),
(103, 9, 'fld_2124341', 'adresse_mail', 'harrycbiyoudi@gmail.com'),
(104, 9, 'fld_724362', 'num_tel', '06 11 56 90 20'),
(105, 9, 'fld_6078931', 'agence_souhait.opt1916226', 'Hauts-de-France '),
(106, 9, 'fld_6078931', 'agence_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(107, 9, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-.pdf'),
(108, 9, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/CV-.pdf'),
(109, 9, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nActuellement chef d’équipe sécurité dans la grande distribution en CDI, je souhaite évoluer  dans la sécurité dans un autre secteur tel que: l’administration, les musées..\r\nMa position géographique s’étend sur Compiegne et ces environs.\r\n\r\nCordialement.'),
(110, 9, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(111, 9, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(112, 9, 'fld_3201949', 'envoyer', 'click'),
(113, 10, 'fld_5462783', 'nom', 'Gonçalves '),
(114, 10, 'fld_3436924', 'prenom', 'Gilbert'),
(115, 10, 'fld_2124341', 'adresse_mail', 'g.goncalves988@gmail.com'),
(116, 10, 'fld_724362', 'num_tel', '07 82 55 79 44'),
(117, 10, 'fld_6078931', 'agence_souhait.opt1109492', 'Est Champagne Ardenne '),
(118, 10, 'fld_6078931', 'agence_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(119, 10, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/C.V.-ssiap-2-1.pdf'),
(120, 10, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/C.V.-ssiap-2-1.pdf'),
(121, 10, 'fld_3396882', 'message', 'Bonjour,\r\nJe suis à la recherche d\\\'un poste en t\\\'en que SSIAP 2 ou AUTRE en temps PLEIN ou MI TEMPS.\r\n\r\nAyant des diplômes à jour (CQP, SSIAP 1 et SSIAP 2, SST, H0B0) ainsi qu\\\'un numéro de carte professionnel a jour et une bonne connaissance du métier je me permet de vous laissez mon C.V. \r\n\r\nJe reste dans l\\\'attente d\\\'une réponse. \r\n\r\nM. Gonçalves'),
(122, 10, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(123, 10, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(124, 10, 'fld_3201949', 'envoyer', 'click'),
(125, 11, 'fld_5462783', 'nom', 'DEGARDIN'),
(126, 11, 'fld_3436924', 'prenom', 'Benjamin'),
(127, 11, 'fld_2124341', 'adresse_mail', 'benjamin.degardin@sfr.fr'),
(128, 11, 'fld_724362', 'num_tel', '06 11 32 40 77'),
(129, 11, 'fld_475276', 'socite', 'Étudiant'),
(130, 11, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(131, 11, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(132, 11, 'fld_2695739', 'objet', 'Demande de stage du 8/11 au 17/12/2021'),
(133, 11, 'fld_3396882', 'message', 'Bonsoir,\r\n\r\nJe suis actuellement en 2ème année de BTS Management Opérationnel de la sécurité (MOS). Je dois effectuer un stage en entreprise du 8 novembre au 17 décembre 2021.\r\nJe vous remercie par avance de l\\\'intérêt que vous porterez à ma demande et je suis disponible pour vous rencontrer lors d\\\'un entretien à votre convenance.\r\n\r\nCordialement\r\nBenjamin DÉGARDIN '),
(134, 11, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(135, 11, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(136, 11, 'fld_3201949', 'envoyer', 'click'),
(137, 12, 'fld_5462783', 'nom', 'environnement'),
(138, 12, 'fld_3436924', 'prenom', 'france'),
(139, 12, 'fld_2124341', 'adresse_mail', 'legrand.mathieu@franceenvronnement.fr'),
(140, 12, 'fld_724362', 'num_tel', '33 64 84 66 60'),
(141, 12, 'fld_475276', 'socite', 'France environnement '),
(142, 12, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(143, 12, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(144, 12, 'fld_2695739', 'objet', 'sécurisation chantier aire de jeux urgent '),
(145, 12, 'fld_3396882', 'message', 'bonjour \r\nj\\\'ai  deux chantier d\\\'aire de jeux sur la ville de Compiègne à sécuriser sur le site de la mare Gaudry et square Puy du Roy   a surveiller lors du séchage le 14/10/21  de 17h à  8h et 15/10/2021 de 17h à 8h \r\ncordialement '),
(146, 12, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(147, 12, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(148, 12, 'fld_3201949', 'envoyer', 'click'),
(149, 13, 'fld_5462783', 'nom', 'RIEGEL'),
(150, 13, 'fld_3436924', 'prenom', 'Marie'),
(151, 13, 'fld_2124341', 'adresse_mail', 'marie_riegel@yahoo.fr'),
(152, 13, 'fld_724362', 'num_tel', '06 80 23 51 95'),
(153, 13, 'fld_475276', 'socite', 'Musique En Collège'),
(154, 13, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(155, 13, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(156, 13, 'fld_2695739', 'objet', 'demande de Devis'),
(157, 13, 'fld_3396882', 'message', 'Madame, Monsieur\r\n\r\nJe sollicite votre société pour un devis. Nous aurions besoin de 5 de vos personnels pour assurer la sécurité du concert de nos élèves collégiens le 07 juin prochain au Théâtre de Champagne.\r\nLe concert aurait lieu de 20h environ à 22h30 grand maximum.\r\n\r\nCordialement'),
(158, 13, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(159, 13, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(160, 13, 'fld_3201949', 'envoyer', 'click'),
(161, 14, 'fld_5462783', 'nom', 'Paignon'),
(162, 14, 'fld_3436924', 'prenom', 'Gilles'),
(163, 14, 'fld_2124341', 'adresse_mail', 'gilles.paignon@sfr.fr'),
(164, 14, 'fld_724362', 'num_tel', '06 46 72 38 02'),
(165, 14, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(166, 14, 'fld_6078931', 'agence_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(167, 14, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-Paignon-G-Manager-securite-et-risques.pdf'),
(168, 14, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/LM-Paignon-G-Manager-securite-et-risques.pdf'),
(169, 14, 'fld_3396882', 'message', 'Madame, monsieur,\r\n\r\nComme suite aux rencontres \\\"entreprises et territoires\\\" de Compiègne, je vous propose mes compétences pour compléter judicieusement celles de votre équipe déjà constituée.\r\n\r\nJe me ferai un plaisir de d\\\'enrichir les informations figurant dans mon CV joint lors d\\\'un prochain rendez vous à convenir.\r\n\r\nJe vous prie d’agréer, madame, monsieur, mes respectueuses salutations.\r\n\r\nGilles Paignon\r\n06.46.72.38.02'),
(170, 14, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(171, 14, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(172, 14, 'fld_3201949', 'envoyer', 'click'),
(173, 15, 'fld_5462783', 'nom', 'COSTA'),
(174, 15, 'fld_3436924', 'prenom', 'Hugo'),
(175, 15, 'fld_2124341', 'adresse_mail', 'hugo@seowin.app'),
(176, 15, 'fld_724362', 'num_tel', '0725871922'),
(177, 15, 'fld_475276', 'socite', 'Jyosf qmefbb'),
(178, 15, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(179, 15, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(180, 15, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(181, 15, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(182, 15, 'fld_2695739', 'objet', 'artus-securite.fr'),
(183, 15, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nJe me permets de vous contacter car notre outil d\\\'analyse de site pourrait vous intéresser.\r\n\r\nN\\\'hésitez pas à visiter notre site https://seowin.app et à le tester gratuitement.\r\n\r\nJe reste à votre disposition si vous avez la moindre question.\r\n\r\nBien à vous,\r\n\r\nHugo'),
(184, 15, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(185, 15, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(186, 16, 'fld_5462783', 'nom', 'El jabbari '),
(187, 16, 'fld_3436924', 'prenom', 'Yannis'),
(188, 16, 'fld_2124341', 'adresse_mail', 'yanniselpro@gmail.com'),
(189, 16, 'fld_724362', 'num_tel', '06 37 96 19 27'),
(190, 16, 'fld_6078931', 'agence_souhait.opt1109492', 'Est Champagne Ardenne '),
(191, 16, 'fld_6078931', 'agence_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(192, 16, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/Yannis_El_jabbari_-_1-3.pdf'),
(193, 16, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/motivation-ads-pdf.pdf'),
(194, 16, 'fld_3396882', 'message', 'Bonjour,\r\nVoici mon CV et ma lettre de motivation.\r\nJe recherche principalement un emploi de nuit,\r\nCordialement.'),
(195, 16, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(196, 16, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(197, 16, 'fld_3201949', 'envoyer', 'click'),
(198, 17, 'fld_5462783', 'nom', 'lica'),
(199, 17, 'fld_3436924', 'prenom', 'alain'),
(200, 17, 'fld_2124341', 'adresse_mail', 'alsm77@free.fr'),
(201, 17, 'fld_724362', 'num_tel', '07 69 57 33 36'),
(202, 17, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(203, 17, 'fld_6078931', 'agence_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(204, 17, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/AGENT-DE-SECURITE-CV-A.-LICA.pdf'),
(205, 17, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/CV-Stes-de-Securite-1.pdf'),
(206, 17, 'fld_3396882', 'message', 'Bonjour Madame, Monsieur, J\\\'ai l\\\'honneur de m\\\'adresser à vous. J\\\'ai été militaire de la gendarmerie pendant 29 ans et souhaite intégrer une société de sécurité privée.\r\nJe désire mettre mon expérience au profit de votre entreprise. Comme vous pouvez le constater, mon CV ne manque pas d\\\'intérêt. Je suis donc à votre disposition pour de plus amples renseignements et plus de précisions. En cette période de fêtes, je vous souhaite d\\\'ores et déjà une bonne année. Cordialement Mr LICA Alain.'),
(207, 17, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(208, 17, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(209, 17, 'fld_3201949', 'envoyer', 'click'),
(210, 18, 'fld_5462783', 'nom', 'Fauveau'),
(211, 18, 'fld_3436924', 'prenom', 'Aurélien'),
(212, 18, 'fld_2124341', 'adresse_mail', 'au.fauveau45@gmail.com'),
(213, 18, 'fld_724362', 'num_tel', '07 83 87 42 82'),
(214, 18, 'fld_6078931', 'agence_souhait.opt1916226', 'Hauts-de-France '),
(215, 18, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(216, 18, 'fld_6078931', 'agence_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \"}'),
(217, 18, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/Aurelien_Fauveau_CV.pdf'),
(218, 18, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Document-sans-titre.pdf'),
(219, 18, 'fld_3396882', 'message', 'Je suis disponible tout de suite et prêt à travailler pour votre entreprise Artus Sécurité Protection.'),
(220, 18, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(221, 18, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(222, 18, 'fld_3201949', 'envoyer', 'click'),
(223, 19, 'fld_5462783', 'nom', 'lica'),
(224, 19, 'fld_3436924', 'prenom', 'alain'),
(225, 19, 'fld_2124341', 'adresse_mail', 'alsm77@free.fr'),
(226, 19, 'fld_724362', 'num_tel', '07 69 57 33 36'),
(227, 19, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(228, 19, 'fld_6078931', 'agence_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(229, 19, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/AGENT-DE-SECURITE-CV-A.-LICA.pdf'),
(230, 19, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Lettre-de-motivation.pdf'),
(231, 19, 'fld_3396882', 'message', 'Bonjour Monsieur, Je souhaite intégrer votre société de sécurité. Je vous envoie mes documents car vous recherchez un agent de sécurité dans mon secteur (Montereau Fault Yonne). Dans l\\\'attente d\\\'une réponse que je souhaite favorable, veuillez agréer, Monsieur, mes sincères salutations. Mr LICA Alain'),
(232, 19, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(233, 19, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(234, 19, 'fld_3201949', 'envoyer', 'click'),
(235, 20, 'fld_5462783', 'nom', 'rezkallah'),
(236, 20, 'fld_3436924', 'prenom', 'saida'),
(237, 20, 'fld_2124341', 'adresse_mail', 'saida.rezkallah@lesessentielles.fr'),
(238, 20, 'fld_724362', 'num_tel', '06 99 56 89 96'),
(239, 20, 'fld_475276', 'socite', 'Résidence Seniors les essentielles'),
(240, 20, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(241, 20, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(242, 20, 'fld_2695739', 'objet', 'Urgent - devis '),
(243, 20, 'fld_3396882', 'message', 'Bonjour à tous,\r\n\r\nPourriez vous m\\\'etablir un devis pour une surveillance du vendredi soir à 18h jusqu\\\'au lundi matin 8h pour les wk du 4 fevrier et 11 fev 2022. C\\\'est une résidence basée à Compiègne place d\\\'armes. Pour le moment personne habite la résidence;\r\nMerci de votre retour urgent.\r\nBien à vous '),
(244, 20, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(245, 20, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(246, 20, 'fld_3201949', 'envoyer', 'click'),
(247, 21, 'fld_5462783', 'nom', 'Houdeyer'),
(248, 21, 'fld_3436924', 'prenom', 'Gilles'),
(249, 21, 'fld_2124341', 'adresse_mail', 'Gilles.houd@hotmail.com'),
(250, 21, 'fld_724362', 'num_tel', '06 83 39 61 81'),
(251, 21, 'fld_6078931', 'agence_souhait.opt1916226', 'Hauts-de-France '),
(252, 21, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(253, 21, 'fld_6078931', 'agence_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \"}'),
(254, 21, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/Gilles-Houdeyer1-1.pdf'),
(255, 21, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/lettre-de-motivation-Agent-de-securite.pdf'),
(256, 21, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nJ\\\'ai le plaisir de me porter candidat pour un poste d\\\'agent de prévention et de sécurite et à ce titre,\r\nvous prie de trouver ci-joint mon cv ainsi que ma lettre de motivation.\r\n\r\nDans l\\\'espoir de vous rencontrer prochainement.\r\n\r\nCordialement,\r\nHoudeyer Gilles'),
(257, 21, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(258, 21, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(259, 21, 'fld_3201949', 'envoyer', 'click'),
(260, 22, 'fld_5462783', 'nom', 'CHARDIN'),
(261, 22, 'fld_3436924', 'prenom', 'LUCIE'),
(262, 22, 'fld_2124341', 'adresse_mail', 'lucie.chardin@alexandrebonnet.com'),
(263, 22, 'fld_724362', 'num_tel', '06 45 07 03 77'),
(264, 22, 'fld_475276', 'socite', 'SAS MAISON ALEXANDRE BONNET'),
(265, 22, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(266, 22, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(267, 22, 'fld_2695739', 'objet', 'DEMANDE DE RENSEIGNEMENT'),
(268, 22, 'fld_3396882', 'message', 'Madame, Monsieur,\r\n\r\nChampagne Alexandre Bonnet organise une soirée qui rassemblera 600 personnes au Château de la Cordelière (10210 Chaource) un vendredi de juin (date exacte non encore définie).\r\n\r\nPour ce faire, nous avons besoin d’une équipe de sécurité de 18H30 à 6H. Cette équipe devra notamment placer les voitures sur le parking, gérer l’accueil à la soirée et assurer la sécurité tout au long de la soirée. \r\n\r\nN’hésitez pas à me contacter au 06.45.07.03.77 ou à mon adresse électronique pour plus de renseignements et pour nous conseiller sur l’organisation de la sécurité de cette soirée.\r\n\r\nSalutations,\r\n\r\nLucie CHARDIN'),
(269, 22, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(270, 22, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(271, 22, 'fld_3201949', 'envoyer', 'click'),
(272, 23, 'fld_5462783', 'nom', 'bouguerrouche'),
(273, 23, 'fld_3436924', 'prenom', 'moussa'),
(274, 23, 'fld_2124341', 'adresse_mail', 'moussa.bouguerrouche@gmail.com'),
(275, 23, 'fld_724362', 'num_tel', '07 82 53 21 07'),
(276, 23, 'fld_6078931', 'agence_souhait.opt1916226', 'Hauts-de-France '),
(277, 23, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(278, 23, 'fld_6078931', 'agence_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \"}'),
(279, 23, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-agent-de-securite.pdf'),
(280, 23, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/lettre-de-motivation_Artus.pdf'),
(281, 23, 'fld_3396882', 'message', 'Madame, Monsieur,\r\n\r\nActuellement à la recherche d’un poste d’agent de sécurité que je peux exercer pendant les Week ends, je me permet de venir déposer ma candidature auprès de votre\r\nentreprise.\r\nJe suis libre de suite et très motivé à mettre mes qualités à votre service.\r\n\r\nReste à votre entière disposition\r\nMoussa'),
(282, 23, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(283, 23, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(284, 23, 'fld_3201949', 'envoyer', 'click'),
(285, 24, 'fld_5462783', 'nom', 'Lebaillif'),
(286, 24, 'fld_3436924', 'prenom', 'Pierre'),
(287, 24, 'fld_2124341', 'adresse_mail', 'lebaillif.pierre@gmail.com'),
(288, 24, 'fld_724362', 'num_tel', '06 64 44 20 24'),
(289, 24, 'fld_475276', 'socite', 'Asso. Les Enfants Terribles'),
(290, 24, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(291, 24, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(292, 24, 'fld_2695739', 'objet', 'sécurité concert'),
(293, 24, 'fld_3396882', 'message', 'Bonjour, \r\n\r\nJe suis Pierre Lebaillif, président de l\\\'association Les Enfants Terribles qui organise un concert à La Chapelle Argence de Troyes le vendredi 22 avril 2022.\r\nPour permettre à ce concert d\\\'avoir lieu j\\\'aurai besoin des services de 5 agents de sécurité.\r\nParmi ces 5 agents il me faudra\r\n- un homme et une femme à l\\\'entrée du site pour contrôle sac, fouille et palpation\r\n- un agent chargé de scanner les pass vaccinaux (si cela est toujours en vigueur à ce moment là)\r\n- deux agents dans la salle.\r\n\r\nCes agents devront être présent de 19h30 à 00h30.\r\n\r\nJe me tiens à votre disposition pour toutes questions supplémentaire.\r\n\r\nBien à vous\r\n\r\nPierre Lebaillif'),
(294, 24, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(295, 24, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(296, 24, 'fld_3201949', 'envoyer', 'click'),
(297, 25, 'fld_5462783', 'nom', 'CHAZELON'),
(298, 25, 'fld_3436924', 'prenom', 'Marvin'),
(299, 25, 'fld_2124341', 'adresse_mail', 'marvin.chazelon@gmail.com'),
(300, 25, 'fld_724362', 'num_tel', '07 56 82 62 86'),
(301, 25, 'fld_475276', 'socite', 'Association sportive Basket Sancéo Troyen'),
(302, 25, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(303, 25, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(304, 25, 'fld_2695739', 'objet', 'Agent de sécurité pour un événement sportif (match)'),
(305, 25, 'fld_3396882', 'message', 'Bonjour,\r\nNotre club sportif organise un match le 12/03/22 au centre ville de Troyes (gymnase Beurnonville, non loin de vos locaux).\r\nNous souhaiterions disposer d\\\'un agent de 19h00 à 23h00 pour :\r\n- être avec les bénévoles à l\\\'entrée lors du contrôle du pass sanitaire (19h30-20h15)\r\n- être en surveillance pendant toute la durée du match (tribunes, entrée, etc...) (20h00-22h00)\r\nLe délai est un peu court désolé (deux semaines) mais il s\\\'agit d\\\'un changement de dates.\r\nNous avons d\\\'autres événements programmés plus tard dans l\\\'année.\r\nMerci de privilégier un contact par email et/ou bloquer un rdv téléphonique par email.\r\nBien à vous.'),
(306, 25, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(307, 25, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(308, 25, 'fld_3201949', 'envoyer', 'click'),
(309, 26, 'fld_5462783', 'nom', 'Ogé'),
(310, 26, 'fld_3436924', 'prenom', 'Pauline'),
(311, 26, 'fld_2124341', 'adresse_mail', 'alchimie@asso-atelier.fr'),
(312, 26, 'fld_724362', 'num_tel', '02 38 31 60 37'),
(313, 26, 'fld_475276', 'socite', 'Association l\\\'Atelier'),
(314, 26, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(315, 26, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(316, 26, 'fld_2695739', 'objet', 'Demande de devis '),
(317, 26, 'fld_3396882', 'message', 'Bonjour, \r\n \r\nJe me permets de vous contacter concernant la deuxième édition d\\\'Alchimie Music Festival que nous organisons au Château de Vaux le vendredi 24 juin prochain. \r\nNous souhaiterions avoir un devis pour une prestation de 6 agents : \r\n\r\n-3 agents de 19h à 2h \r\n-3 agents de 21h à 2h \r\n\r\nJe reste à votre entière disposition pour tous compléments d’informations. \r\nBien à vous,\r\nPauline \r\n'),
(318, 26, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(319, 26, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(320, 26, 'fld_3201949', 'envoyer', 'click'),
(321, 27, 'fld_5462783', 'nom', 'Camara '),
(322, 27, 'fld_3436924', 'prenom', 'Chiekou '),
(323, 27, 'fld_2124341', 'adresse_mail', 'mrcamara@live.fr'),
(324, 27, 'fld_724362', 'num_tel', '06 52 93 26 86'),
(325, 27, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(326, 27, 'fld_6078931', 'agence_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(327, 27, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/Monsieur_Camara_Chiekou-2.pdf'),
(328, 27, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Monsieur_Camara_Chiekou-1.pdf'),
(329, 27, 'fld_3396882', 'message', 'Bonjour\r\nMadame, Monsieur\r\nJe souhaite savoir si vous recrutez en ce moment ?'),
(330, 27, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(331, 27, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(332, 27, 'fld_3201949', 'envoyer', 'click'),
(333, 28, 'fld_5462783', 'nom', 'Djeddi '),
(334, 28, 'fld_3436924', 'prenom', 'Belkacem '),
(335, 28, 'fld_2124341', 'adresse_mail', 'bel.djeddi@gmail.com'),
(336, 28, 'fld_724362', 'num_tel', '07 61 85 48 63'),
(337, 28, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(338, 28, 'fld_6078931', 'agence_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(339, 28, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/cv-bondy-fevrier1.pdf'),
(340, 28, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/cv-bondy-fevrier1.pdf'),
(341, 28, 'fld_3396882', 'message', 'Bonjour,\r\nCi-joint CV pour le poste d’agent de sécurité incendie ssiap 1 pour Pantin \r\nBien cordialement,\r\nMr Djeddi '),
(342, 28, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(343, 28, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(344, 28, 'fld_3201949', 'envoyer', 'click'),
(345, 29, 'fld_5462783', 'nom', 'Ken'),
(346, 29, 'fld_3436924', 'prenom', 'Ken'),
(347, 29, 'fld_2124341', 'adresse_mail', 'kenp38491@aol.com'),
(348, 29, 'fld_724362', 'num_tel', '+18149737130'),
(349, 29, 'fld_475276', 'socite', 'Hfzusq dlf K u'),
(350, 29, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(351, 29, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(352, 29, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(353, 29, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(354, 29, 'fld_2695739', 'objet', 'Um R k'),
(355, 29, 'fld_3396882', 'message', 'Hey this is Ken. I lost your number but I remembered your site. Need you to contact me ASAP regarding that one issue you were having +18149737130‬   \r\nAtwCDWz8V3pBzRHs'),
(356, 29, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(357, 29, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(358, 30, 'fld_5462783', 'nom', 'Faith'),
(359, 30, 'fld_3436924', 'prenom', 'Faith'),
(360, 30, 'fld_2124341', 'adresse_mail', 'faith@topdatalist.com'),
(361, 30, 'fld_724362', 'num_tel', '(11) 5410-2925'),
(362, 30, 'fld_475276', 'socite', 'T h zu'),
(363, 30, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(364, 30, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(365, 30, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(366, 30, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(367, 30, 'fld_2695739', 'objet', 'Lkjghwa'),
(368, 30, 'fld_3396882', 'message', 'It is with sad regret to inform you that TopDataList.com is shutting down.\r\n\r\nWe have made available over 300 million records for $149.\r\n\r\nRegards,\r\nTopDataList.com'),
(369, 30, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(370, 30, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(371, 31, 'fld_5462783', 'nom', 'LIN'),
(372, 31, 'fld_3436924', 'prenom', 'Mickael'),
(373, 31, 'fld_2124341', 'adresse_mail', 'm.lin219@laposte.net'),
(374, 31, 'fld_724362', 'num_tel', '03 23 55 59 40'),
(375, 31, 'fld_6078931', 'agence_souhait.opt1916226', 'Hauts-de-France '),
(376, 31, 'fld_6078931', 'agence_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(377, 31, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/lin-mickael-CV-20-OCTOBRE-photo-2.pdf'),
(378, 31, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/LETTRE-MOTIVATION-mickael.pdf'),
(379, 31, 'fld_3396882', 'message', 'Bonjour Madame Monsieur,\r\nActuellement disponible je suis à la recherche d\\\'un poste d\\\'agent de sécurité.\r\nCi-joint mon CV et lettre de motivation.\r\nTrès cordialement\r\nLIN Mickael'),
(380, 31, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(381, 31, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(382, 31, 'fld_3201949', 'envoyer', 'click'),
(383, 32, 'fld_5462783', 'nom', 'AMROUCHE'),
(384, 32, 'fld_3436924', 'prenom', 'Mohamed'),
(385, 32, 'fld_2124341', 'adresse_mail', 'mo.amrouche@gmail.com'),
(386, 32, 'fld_724362', 'num_tel', '06 23 45 46 80'),
(387, 32, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(388, 32, 'fld_6078931', 'agence_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(389, 32, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/SSIAP2-a-jour.pdf'),
(390, 32, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/L.M-SSIAP2.pdf'),
(391, 32, 'fld_3396882', 'message', 'Bonjour;\r\n\r\nJe suis actuellement a la recherche active d\\\'un temps partiel vendredi, samedi et dimanche.\r\n\r\nCordialement.'),
(392, 32, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(393, 32, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(394, 32, 'fld_3201949', 'envoyer', 'click'),
(395, 33, 'fld_5462783', 'nom', 'Drouot'),
(396, 33, 'fld_3436924', 'prenom', 'Sabrina'),
(397, 33, 'fld_2124341', 'adresse_mail', 'sab.drouot@orange.fr'),
(398, 33, 'fld_724362', 'num_tel', '06 85 33 65 45'),
(399, 33, 'fld_475276', 'socite', 'Atelier des Arts'),
(400, 33, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(401, 33, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(402, 33, 'fld_2695739', 'objet', 'demande de devis'),
(403, 33, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nDans le cadre du spectacle de fin d\\\'année de l\\\'atelier des arts le Samedi 25 Juin 2022 au Théâtre de Champagne, et en accord avec Frédéric Gambey, je vous remercie de me faire parvenir un devis pour la prestation de 5 agents de sécurité dont voici les horaires : 19h30 à minuit (le spectacle commence à 20h30 et se terminera vers 23h30)\r\n\r\nAdresse de facturation (la même qu\\\'en 2019) :\r\nAtelier des Arts\r\nMme Sabrina DROUOT\r\n3 Rue VOLTAIRE\r\n10 000 TROYES\r\n\r\nDans l\\\'attente de votre retour, je vous souhaite une bonne journée.\r\n\r\nCordialement,\r\n\r\nSabrina Drouot'),
(404, 33, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(405, 33, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(406, 33, 'fld_3201949', 'envoyer', 'click'),
(407, 34, 'fld_5462783', 'nom', 'Pinel'),
(408, 34, 'fld_3436924', 'prenom', 'Jeanne'),
(409, 34, 'fld_2124341', 'adresse_mail', 'pinelj@live.fr'),
(410, 34, 'fld_724362', 'num_tel', '06 10 53 01 26'),
(411, 34, 'fld_475276', 'socite', 'Asptt danse Troyes '),
(412, 34, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(413, 34, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(414, 34, 'fld_2695739', 'objet', 'Demande de devis 5 ADS - spectacle de danse '),
(415, 34, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nLa section danse de l’asptt Troyes organise son spectacle annuelle au théâtre de champagne à Troyes le samedi 11 juin 2022. \r\n\r\nAussi, pour respecter la réglementation, nous avons besoin de 5 agents de sécurité de 19h à 23h. \r\n\r\nPouvez-vous m’envoyer un devis avant le vendredi 29 avril afin de répondre à cette demande ?\r\n\r\nEn vous remerciant par avance, je reste à votre entière disposition pour davantage d’informations.\r\n\r\nCordialement,'),
(416, 34, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(417, 34, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(418, 34, 'fld_3201949', 'envoyer', 'click'),
(419, 35, 'fld_5462783', 'nom', 'ESPLACATON '),
(420, 35, 'fld_3436924', 'prenom', 'Jonathan '),
(421, 35, 'fld_2124341', 'adresse_mail', 'jonathan.ekr@hotmail.com'),
(422, 35, 'fld_724362', 'num_tel', '06 04 44 95 42'),
(423, 35, 'fld_6078931', 'agence_souhait.opt1109492', 'Est Champagne Ardenne '),
(424, 35, 'fld_6078931', 'agence_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(425, 35, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-JONATHAN-2.pdf'),
(426, 35, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/CV-JONATHAN-2.pdf'),
(427, 35, 'fld_3396882', 'message', 'Bonjour , je suis à la recherche un emploi en tant que Agent de sécurité incendie dans le département de l’aube. \r\nJ’ai obtenu les deux diplômes ( ssiap 1 et TfP aps ) '),
(428, 35, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(429, 35, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(430, 35, 'fld_3201949', 'envoyer', 'click'),
(431, 36, 'fld_5462783', 'nom', 'TURLET'),
(432, 36, 'fld_3436924', 'prenom', 'Rémi'),
(433, 36, 'fld_2124341', 'adresse_mail', 'rmturlet@gmail.com'),
(434, 36, 'fld_724362', 'num_tel', '06 20 89 34 21'),
(435, 36, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(436, 36, 'fld_6078931', 'agence_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(437, 36, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-SSIAP.pdf'),
(438, 36, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/CV-SSIAP.pdf'),
(439, 36, 'fld_3396882', 'message', 'TURLET Rémi\r\n\r\n6 rue Magellan\r\n91300 Massy\r\n\r\nMail : rmturlet@gmail.com\r\nTel : 0620893421\r\n\r\n\r\nObjet : Candidature au poste d’agent de sécurité Incendie SSIAP1. (Temps Partiel) \r\n\r\n\r\nMadame, Monsieur,\r\n\r\nActuellement en poste en tant qu\\\'agent de sécurité incendie SSIAP 1 et à la recherche d\\\'un emploi à temps partiel pouvant se rapprocher d\\\'un temps plein en fonction de vos besoins, je me permets de vous soumettre ma candidature.\r\n\r\nJe suis disponible trois à quatre jours par semaine ainsi qu\\\'un week-end sur deux.\r\nTous mes diplômes sont à jour (CQP-APS, SSIAP1, SST, H0B0) \r\n\r\nJe suis dynamique, flexible, respectueux et je m\\\'adapte à toutes les situations.\r\n\r\nDans l\\\'attente d\\\'une réponse favorable de votre part, je reste à votre entière disposition.\r\n\r\nVeuillez agréer, Madame, Monsieur, mes salutations distinguées.\r\n\r\n\r\nTURLET Rémi '),
(440, 36, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(441, 36, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(442, 36, 'fld_3201949', 'envoyer', 'click'),
(443, 37, 'fld_5462783', 'nom', 'Maple'),
(444, 37, 'fld_3436924', 'prenom', 'Maple'),
(445, 37, 'fld_2124341', 'adresse_mail', 'maple@customdata.click'),
(446, 37, 'fld_724362', 'num_tel', '(08) 9019 3945'),
(447, 37, 'fld_475276', 'socite', 'Cmgsifda'),
(448, 37, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(449, 37, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(450, 37, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(451, 37, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(452, 37, 'fld_2695739', 'objet', 'I Sqds c'),
(453, 37, 'fld_3396882', 'message', 'Hello, from CustomData.click we are a provider of unique databases that could help your business.\r\n\r\nPlease visit us at CustomData.click to see if we can help you.\r\n\r\nRegards,\r\nMaple'),
(454, 37, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(455, 37, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(456, 38, 'fld_5462783', 'nom', 'Wartelle');
INSERT INTO `mod284_cf_form_entry_values` (`id`, `entry_id`, `field_id`, `slug`, `value`) VALUES 
(457, 38, 'fld_3436924', 'prenom', 'Adrien'),
(458, 38, 'fld_2124341', 'adresse_mail', 'adrien.wartelle@utt.fr'),
(459, 38, 'fld_724362', 'num_tel', '06 02 05 86 21'),
(460, 38, 'fld_475276', 'socite', 'BDE UTT'),
(461, 38, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(462, 38, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(463, 38, 'fld_2695739', 'objet', 'Devis pour l\\\'organisation de la sécurité pour la représentation théâtrale à Troyes le mardi 7 juin 2022'),
(464, 38, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nNous sommes le club de théâtre Ch\\\'UTT de vers associé à l\\\'association du BDE UTT de l\\\'Université Technologique de Troyes.\r\nNous organisons prochainement une représentation d\\\'une pièce de théâtre le mardi 7 juin prochain dans le grand amphithéâtre de de l\\\'UTT avec 447 places.\r\nCyril Dufour, l\\\'ingénieur responsable de la sécurité de l\\\'UTT, notamment dans le cadre des événements, nous a conseillé de vous contacter pour l\\\'organisation de la sécurité, son numéro est le 03 25 71 76 60 et son mail cyril.dufour@utt.fr (le 06 donné en formulaire est le mien).\r\n\r\nNous souhaiterions faire un devis pour 1 Agent Incendie SSIAP 1 ainsi que 2 Agents de Sécurités  (ADS) de 19:30 à 23:00 le mardi 7 juin 2022.\r\nNous nous excusons si la demande est un peu tardive, nous avons rencontré beaucoup des difficultés d\\\'organisation ces derniers mois.\r\n\r\nCordialement,\r\nAdrien Wartelle metteur en scène des Ch\\\'UTT de vers'),
(465, 38, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(466, 38, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(467, 38, 'fld_3201949', 'envoyer', 'click'),
(468, 39, 'fld_5462783', 'nom', 'Aïssani'),
(469, 39, 'fld_3436924', 'prenom', 'Ali'),
(470, 39, 'fld_2124341', 'adresse_mail', 'aissani39@yahoo.fr'),
(471, 39, 'fld_724362', 'num_tel', '06 80 15 00 05'),
(472, 39, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(473, 39, 'fld_6078931', 'agence_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(474, 39, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/cv_cds.pdf'),
(475, 39, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/LM-P.pdf'),
(476, 39, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nje désirerai postuler chez vous car je suis à la recherche d\\\'un poste en cdi à temps partiel en ssiap 2 ou en ssiap 1,\r\n\r\ncependant je reste ouvert à certaines propositions éventuelles comme un poste de ssiap 2 de nuit à temps plein \r\n\r\nou encore un poste de formateur ou de ssiap 3 de jour à temps complet. J\\\'espère que mon profil vous plaira et \r\n\r\nreste à votre disposition.\r\n\r\nCordialement,\r\n\r\nAli Aïssani'),
(477, 39, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(478, 39, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(479, 39, 'fld_3201949', 'envoyer', 'click'),
(480, 40, 'fld_5462783', 'nom', 'METGE'),
(481, 40, 'fld_3436924', 'prenom', 'MELANIE'),
(482, 40, 'fld_2124341', 'adresse_mail', 'mpainmetge@yahoo.com'),
(483, 40, 'fld_724362', 'num_tel', '06 81 48 29 32'),
(484, 40, 'fld_475276', 'socite', 'Association TG Danse'),
(485, 40, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(486, 40, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(487, 40, 'fld_2695739', 'objet', 'Devis pour prestation Théâtre de Champagne.'),
(488, 40, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nJe suis présidente de l\\\'association Compagnie Troyes Gymnique Danse, avenue Robert Schumann à Troyes.\r\nNous organisons le spectacle de danse de la compagnie le samedi 02 juillet au Théâtre de Champagne.\r\nNous avons donc besoin pour ce soir là de 5 personnes pour assurer la sécurité.\r\n\r\nDébut du spectacle à 20h30, fin prévu vers 22h30\r\nPouvez-vous svp me faire parvenir un devis ?\r\nJe vous remercie par avance\r\nCordialement\r\n\r\nMélanie METGE\r\nPour TG Danse\r\n06 81 48 29 32\r\n'),
(489, 40, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(490, 40, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(491, 40, 'fld_3201949', 'envoyer', 'click'),
(492, 41, 'fld_5462783', 'nom', 'ouendeno'),
(493, 41, 'fld_3436924', 'prenom', 'lamine'),
(494, 41, 'fld_2124341', 'adresse_mail', 'lamineouendeno@hotmail.fr'),
(495, 41, 'fld_724362', 'num_tel', '07 87 44 40 60'),
(496, 41, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(497, 41, 'fld_6078931', 'agence_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(498, 41, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/LAMINE_OUENDENO_secu.pdf'),
(499, 41, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/LAMINE_OUENDENO_secu.pdf'),
(500, 41, 'fld_3396882', 'message', 'fort d\\\'une experience de 7 ans en securité incendie et avec tous mes documents a jour je sais mon sens de responsabilité , ma connaissance du metier sont des atouts pour moi .je reste a la disponibilité de vos service pour toute information complementaire .\r\n'),
(501, 41, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(502, 41, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(503, 41, 'fld_3201949', 'envoyer', 'click'),
(504, 42, 'fld_5462783', 'nom', 'konate'),
(505, 42, 'fld_3436924', 'prenom', 'Abdoulaye'),
(506, 42, 'fld_2124341', 'adresse_mail', 'lay548@hotmail.fr'),
(507, 42, 'fld_724362', 'num_tel', '07 86 68 34 54'),
(508, 42, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(509, 42, 'fld_6078931', 'agence_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(510, 42, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/MON-CV-1.pdf'),
(511, 42, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/MON-CV-1.pdf'),
(512, 42, 'fld_3396882', 'message', 'Bonjour,Je suis agent de sécurité et je suis en recherche d\\\'un poste de nuit ou soirée CDD ou CDI temps plein idéalement . Je suis disponible dans la région ile de France. Si ma candidature vous intéresse n\\\'hésitez pas à m\\\'appeler. Dans l\\\'attente d\\\'un retour de votre part, veuillez considérer l\\\'expression de mes salutations les plus distinguées.'),
(513, 42, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(514, 42, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(515, 42, 'fld_3201949', 'envoyer', 'click'),
(516, 43, 'fld_5462783', 'nom', 'Trap'),
(517, 43, 'fld_3436924', 'prenom', 'Mélanie'),
(518, 43, 'fld_2124341', 'adresse_mail', 'trap.melanie@hotmail.com'),
(519, 43, 'fld_724362', 'num_tel', '07 81 57 34 49'),
(520, 43, 'fld_6078931', 'agence_souhait.opt1916226', 'Hauts-de-France '),
(521, 43, 'fld_6078931', 'agence_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(522, 43, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV05.pdf'),
(523, 43, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/LMCyno.pdf'),
(524, 43, 'fld_3396882', 'message', 'Madame, Monsieur,\r\n\r\nJe me permet de vous envoyer ce mail dans l\\\'espoir d\\\'obtenir un poste au sein de vos équipes et mettre au profit de votre société mes compétences ainsi que celles de mon binôme.\r\n\r\nDisponible dès à présent et à votre disposition pour toute information supplémentaire, veuillez agréer Monsieur, Madame, l\\\'expression de mes salutations distinguées.\r\n\r\nCordialement.\r\n\r\nTRAP Mélanie.\r\nConducteur de Chien en Intervention.\r\n07.81.57.34.49\r\ntrap.melanie@hotmail.com'),
(525, 43, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(526, 43, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(527, 43, 'fld_3201949', 'envoyer', 'click'),
(528, 44, 'fld_5462783', 'nom', 'Rod'),
(529, 44, 'fld_3436924', 'prenom', 'Rod'),
(530, 44, 'fld_2124341', 'adresse_mail', 'onlineb2bconsulting@gmail.com'),
(531, 44, 'fld_724362', 'num_tel', '04.01.50.74.17'),
(532, 44, 'fld_475276', 'socite', 'A Ooraee vldk'),
(533, 44, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(534, 44, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(535, 44, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(536, 44, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(537, 44, 'fld_2695739', 'objet', 'Swlhonep phh'),
(538, 44, 'fld_3396882', 'message', 'Would you like to send targeted messages to website owners, just like this one?\r\n\r\nContact Page Marketing..  \r\n\r\nWe will deliver your message to website owners, excellent for B2B products.\r\n\r\nhttps://cutt.ly/ChatToUs'),
(539, 44, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(540, 44, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(541, 45, 'fld_5462783', 'nom', 'amandine'),
(542, 45, 'fld_3436924', 'prenom', 'Bayart'),
(543, 45, 'fld_2124341', 'adresse_mail', 'amandine.bayart60@gmail.com'),
(544, 45, 'fld_724362', 'num_tel', '06 07 69 55 93'),
(545, 45, 'fld_6078931', 'agence_souhait.opt1916226', 'Hauts-de-France '),
(546, 45, 'fld_6078931', 'agence_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(547, 45, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/OVT2.pdf'),
(548, 45, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Lettre-motiv-amandine.pdf'),
(549, 45, 'fld_3396882', 'message', 'Bonjour, j\\\'ai travaillé 2 mois a Aéroville au PC sécurité.\r\n'),
(550, 45, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(551, 45, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(552, 45, 'fld_3201949', 'envoyer', 'click'),
(553, 46, 'fld_5462783', 'nom', 'NICE'),
(554, 46, 'fld_3436924', 'prenom', 'THOMAS'),
(555, 46, 'fld_2124341', 'adresse_mail', 'eciny601@gmail.com'),
(556, 46, 'fld_724362', 'num_tel', '06 75 56 71 30'),
(557, 46, 'fld_6078931', 'agence_souhait.opt1916226', 'Hauts-de-France '),
(558, 46, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(559, 46, 'fld_6078931', 'agence_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \"}'),
(560, 46, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV_Nice_Thomas-1.pdf'),
(561, 46, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Thomas-Nice-lettre-de-motivation.pdf'),
(562, 46, 'fld_3396882', 'message', 'Titulaire d\\\'un BTS management opérationnel de la sécurité , je poursuis mes études afin d\\\'obtenir dans la continuité le Bachelor Responsable d\\\'Unité Opérationnel de la Sécurité.\r\n\r\nPour mener à bien ces études, je suis à la recherche d\\\'une entreprise qui pourrait m\\\'accueillir dans le cadre d\\\'un apprentissage dans leur service HSE d\\\'une durée d\\\'un an pour l\\\'année 2022-2023.\r\n\r\nSi mon profil vous intéresse, probablement souhaiteriez-vous me rencontrer, je suis dans ce cas à votre entière disposition, vous pouvez me contacter par téléphone ou par mail aux coordonnées situées en en-tête.\r\n\r\nAvec mes remerciements. T Nice'),
(563, 46, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(564, 46, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(565, 46, 'fld_3201949', 'envoyer', 'click'),
(566, 47, 'fld_5462783', 'nom', 'Bernardin'),
(567, 47, 'fld_3436924', 'prenom', 'Alexis'),
(568, 47, 'fld_2124341', 'adresse_mail', 'alexis.message@hotmail.fr'),
(569, 47, 'fld_724362', 'num_tel', '07 78 24 38 10'),
(570, 47, 'fld_475276', 'socite', 'LES BEUDEURS DE TORCY LE GRAND'),
(571, 47, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(572, 47, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(573, 47, 'fld_2695739', 'objet', 'Demande prestation vigile fete patronale torcy le grand samedi 30 juillet'),
(574, 47, 'fld_3396882', 'message', 'Bonjour, n\\\'ayant pas eu de retour en envoyant ma demande à b.bado@artus-securite.fr je réitère ici : \r\n\r\nBonjour,\r\n\r\nNous aimerions bénéficier des services de sécurité de 2 de vos agents pour notre fête patronale :  \r\n\r\nDu samedi 30 juillet à partir de 23h jusqu\\\'au dimanche 31 juillet 6h du matin\r\nPlace de la mairie, 10700 Torcy Le Grand\r\n\r\nAvez vous des agents disponibles pour cette mission ? Si oui merci de me faire suivre un \\\"bon de commande\\\" que je vous donne mon bon pour accord.\r\nJe reste à votre disposition si vous avez besoin d\\\'autres informations,\r\n\r\n\r\nBon journée,\r\n\r\n\r\n\r\nAlexis Bernardin\r\nPrésident des BEUDEURS DE TORCY\r\n07 78 24 38 10'),
(575, 47, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(576, 47, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(577, 47, 'fld_3201949', 'envoyer', 'click'),
(578, 48, 'fld_5462783', 'nom', 'Eric'),
(579, 48, 'fld_3436924', 'prenom', 'Eric'),
(580, 48, 'fld_2124341', 'adresse_mail', 'eric.jones.z.mail@gmail.com'),
(581, 48, 'fld_724362', 'num_tel', '555-555-1212'),
(582, 48, 'fld_475276', 'socite', 'Gl Ugf tzlh'),
(583, 48, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(584, 48, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(585, 48, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(586, 48, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(587, 48, 'fld_2695739', 'objet', 'Titnfgkxpp b'),
(588, 48, 'fld_3396882', 'message', 'Hi, my name is Eric and I’m betting you’d like your website artus-securite.fr to generate more leads.\r\n\r\nHere’s how:\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at artus-securite.fr.\r\n\r\nTalk With Web Visitor – CLICK HERE http://boostleadgeneration.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Talk With Web Visitor and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(589, 48, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(590, 48, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(591, 49, 'fld_5462783', 'nom', 'Chouisnard'),
(592, 49, 'fld_3436924', 'prenom', 'Laura'),
(593, 49, 'fld_2124341', 'adresse_mail', 'laura@barfontarc.com'),
(594, 49, 'fld_724362', 'num_tel', '03 25 27 07 09'),
(595, 49, 'fld_475276', 'socite', 'CHAMPAGNE DE BARFONTARC'),
(596, 49, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(597, 49, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(598, 49, 'fld_2695739', 'objet', 'Demande de devis pour gardiennage matériel Route du Champagne en Fête 2022'),
(599, 49, 'fld_3396882', 'message', 'Madame, Monsieur, \r\n\r\nCave participante à la Route du Champagne en Fête, nous aurions souhaité avoir un devis pour du gardiennage de matériel pour 2 nuits : \r\n•	Vendredi 29 juillet 2022, de 18h à 8h\r\n•	Samedi 30 juillet 2022, de 18h à 8h\r\n\r\nNous aurons du matériel devant notre bâtiment, qui donne directement sur la voie publique. \r\nEn sachant qu’une soirée aura lieu dans notre salle de réception, jointe au bâtiment, le samedi 30 juillet et qu’il y aura donc des invités dans nos locaux une partie de la nuit. \r\n\r\nJe ne saurais estimer le nombre de personnes nécessaires mais n\\\'hésitez pas à nous contacter si vous souhaitez plus d\\\'informations ou des photos de notre bâtiment pour vous rendre compte. \r\n\r\nDans l’attente de votre devis, bonne journée à vous. \r\n\r\nBien Cordialement, \r\n\r\nLaura CHOUISNARD \r\nChargée d\\\'Oenotourisme, Champagne de Barfontarc\r\n'),
(600, 49, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(601, 49, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(602, 49, 'fld_3201949', 'envoyer', 'click'),
(603, 50, 'fld_5462783', 'nom', 'MAILLARD'),
(604, 50, 'fld_3436924', 'prenom', 'Lolita'),
(605, 50, 'fld_2124341', 'adresse_mail', 'lolita.maillard@croix-rouge.fr'),
(606, 50, 'fld_724362', 'num_tel', '06 07 17 92 32'),
(607, 50, 'fld_475276', 'socite', 'Croix Rouge française'),
(608, 50, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(609, 50, 'fld_6078931', 'secteur_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(610, 50, 'fld_2695739', 'objet', 'Demande devis'),
(611, 50, 'fld_3396882', 'message', 'Bonjour \r\n\r\nNous souhaiterions un devis pour notre établissement pour des veilles de nuit . Nous sommes un pole d\\\'établissement de protection de l\\\'enfance .\r\n\r\n\r\n'),
(612, 50, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(613, 50, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(614, 50, 'fld_3201949', 'envoyer', 'click'),
(615, 51, 'fld_5462783', 'nom', 'NICOLAS'),
(616, 51, 'fld_3436924', 'prenom', 'Robin'),
(617, 51, 'fld_2124341', 'adresse_mail', 'robin.nicolas2003@gmail.com'),
(618, 51, 'fld_724362', 'num_tel', '06 27 24 05 10'),
(619, 51, 'fld_6078931', 'agence_souhait.opt1109492', 'Est Champagne Ardenne '),
(620, 51, 'fld_6078931', 'agence_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(621, 51, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-1.pdf'),
(622, 51, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Lettre-de-motivation-Arthus-Securite-2-1.pdf'),
(623, 51, 'fld_3396882', 'message', 'Bonjour, c\\\'est pour une demande d\\\'alternance pour un BTS MOS, vous trouverez comme demandé mon CV ainsi que ma lettre de motivation.\r\nJe peux aussi vous faire parvenir le planning de l\\\'alternance avec mes jours de cours.\r\nUne aide de l\\\'état de de 8000 euros est disponible pour les employeurs qui recrutent en apprentissage dans le cadre du plan \\\"1 jeune, 1 solution\\\".\r\n'),
(624, 51, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(625, 51, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(626, 51, 'fld_3201949', 'envoyer', 'click'),
(627, 52, 'fld_5462783', 'nom', 'DELOOZ'),
(628, 52, 'fld_3436924', 'prenom', 'Katy'),
(629, 52, 'fld_2124341', 'adresse_mail', 'katy.delooz@orange.fr'),
(630, 52, 'fld_724362', 'num_tel', '06 88 32 06 72'),
(631, 52, 'fld_6078931', 'agence_souhait.opt1109492', 'Est Champagne Ardenne '),
(632, 52, 'fld_6078931', 'agence_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(633, 52, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/Katy-Delooz-CV-PACK-SECURITE.pdf'),
(634, 52, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Katy-Delooz-LM-PACK-SECURITE.pdf'),
(635, 52, 'fld_3396882', 'message', 'Je souhaiterais postuler pour un poste à l\\\'agence Est Champagne Ardenne (Troyes) n\\\'ayant pas encore le permis mais je peux être véhiculée sur Troyes et alentours.'),
(636, 52, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(637, 52, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(638, 52, 'fld_3201949', 'envoyer', 'click'),
(639, 53, 'fld_5462783', 'nom', 'Email'),
(640, 53, 'fld_3436924', 'prenom', 'Email'),
(641, 53, 'fld_2124341', 'adresse_mail', 'contact@emailinfluence.xyz'),
(642, 53, 'fld_724362', 'num_tel', '916-837-0522'),
(643, 53, 'fld_475276', 'socite', 'Qwqq jdfsbytxz'),
(644, 53, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(645, 53, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(646, 53, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(647, 53, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(648, 53, 'fld_2695739', 'objet', 'Y Qranvxtlt'),
(649, 53, 'fld_3396882', 'message', 'Are you missing out on email marketing for your site? Running a site is a full time job. With limited time and resources, it be difficult to put energy in marketing your business. But with email marketing, promoting your business becomes a whole lot easier. Receive your free guide here https://emailinfluence.xyz/email/?e8x2_7kvwsz.io \r\n\r\nTo remove your site from our list visit https://emailinfluence.xyz/unsubscribe/'),
(650, 53, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(651, 53, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(652, 54, 'fld_5462783', 'nom', 'becart'),
(653, 54, 'fld_3436924', 'prenom', 'Gabin'),
(654, 54, 'fld_2124341', 'adresse_mail', 'gabin.becart@outlook.com'),
(655, 54, 'fld_724362', 'num_tel', '06 22 36 52 05'),
(656, 54, 'fld_6078931', 'agence_souhait.opt1916226', 'Hauts-de-France '),
(657, 54, 'fld_6078931', 'agence_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(658, 54, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-Gabin.pdf'),
(659, 54, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Lettre-de-motivation.pdf'),
(660, 54, 'fld_3396882', 'message', 'Bonjour, \r\n\r\nJe suis à la recherche d\\\'une entreprise pour pouvoir réaliser mon BTS MOS (Management Opérationnel de la Sécurité) en apprentissage à la rentrée.\r\nJe vous envoie donc ma candidature avec mon CV, ma lettre de motivation ainsi que mon CV vidéo juste en-dessous.\r\n\r\nCordialement.\r\n\r\n\r\nhttps://vimeo.com/731259675/3734ce6089'),
(661, 54, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(662, 54, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(663, 54, 'fld_3201949', 'envoyer', 'click'),
(664, 55, 'fld_5462783', 'nom', 'Buddy'),
(665, 55, 'fld_3436924', 'prenom', 'Buddy'),
(666, 55, 'fld_2124341', 'adresse_mail', 'buddy.holzman@outlook.com'),
(667, 55, 'fld_724362', 'num_tel', '081 334 81 30'),
(668, 55, 'fld_475276', 'socite', 'Gdis Nh'),
(669, 55, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(670, 55, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(671, 55, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(672, 55, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(673, 55, 'fld_2695739', 'objet', 'Vxez L'),
(674, 55, 'fld_3396882', 'message', 'Hi,\r\nI just want to share with you a great website which provide account for SEO, affiliate marketing, dropshipping, ecommerce at cheap price. Here it is: https://groupbuyserver.com\r\nExample:\r\nAhrefs account for just $30 (this tool is for seo business)\r\nSemrush account for just $10.\r\nAdplexity account for just $30.\r\nAdspy account for just $20 (this tool is for dropshipping/ecommerce business)\r\nHelium10 for just $10.\r\nSTM forum for just $15.\r\nAnd about more than 30+ internet marketing tools at Affordable Price.\r\nThis website is group buy service. You can visit this link https://groupbuyserver.com\r\nThank!'),
(675, 55, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(676, 55, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(677, 56, 'fld_5462783', 'nom', 'Bourgueil'),
(678, 56, 'fld_3436924', 'prenom', 'Pierre'),
(679, 56, 'fld_2124341', 'adresse_mail', 'pierre.bourgueil@utt.fr'),
(680, 56, 'fld_724362', 'num_tel', '07 66 00 85 40'),
(681, 56, 'fld_475276', 'socite', 'Cheers UTT'),
(682, 56, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(683, 56, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(684, 56, 'fld_2695739', 'objet', 'Demande de Devis'),
(685, 56, 'fld_3396882', 'message', 'Bonjour.\r\nJe participe à l’organisation du TUC (Tournois Universitaire de Cheerleading) qui aura lieu le samedi 10 décembre à la halle sportive de l’UTT (12 Rue Marie Curie, 10300 Troyes).\r\nJe souhaiterai donc avoir un devis pour les agents de sécurité et agents SSIAP.\r\nL\\\'événement aura lieu entre 13h et 17h et il y aura environ 200 personnes dans le public (en dehors des athlètes).\r\nJe me tiens à votre disposition pour d’éventuelles questions.\r\nCordialement.\r\nPierre Bourgueil'),
(686, 56, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(687, 56, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(688, 56, 'fld_3201949', 'envoyer', 'click'),
(689, 57, 'fld_5462783', 'nom', 'Alex'),
(690, 57, 'fld_3436924', 'prenom', 'Alex'),
(691, 57, 'fld_2124341', 'adresse_mail', 'support@cheapestdigitalbooks.com'),
(692, 57, 'fld_724362', 'num_tel', '06-56734602'),
(693, 57, 'fld_475276', 'socite', 'P gfjsjrilzl W'),
(694, 57, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(695, 57, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(696, 57, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(697, 57, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(698, 57, 'fld_2695739', 'objet', 'L keudbd jcer'),
(699, 57, 'fld_3396882', 'message', 'To whom it may concern,\r\n\r\nI hope you are well.\r\n\r\nI just wanted to reach out to check If you are interested to exchange Dofollow Backlinks with our website. Currently, our domain has DA-10/PA-50 score on Moz. If you want to climb up to the top of Google Search, acquiring high-quality backlinks is a foolproof way to accelerate your progress. So if you are interested let me know for further discussion.\r\n\r\nOur Website: http://m.ulinksparker.xyz/cheapestdigitalbooks\r\n\r\nKind regards,\r\nAlex\r\nCheapest Digital Books'),
(700, 57, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(701, 57, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(702, 58, 'fld_5462783', 'nom', 'SAVIGNI'),
(703, 58, 'fld_3436924', 'prenom', 'SANDRA'),
(704, 58, 'fld_2124341', 'adresse_mail', 'ssavigni@hotmail.fr'),
(705, 58, 'fld_724362', 'num_tel', '06 07 09 19 61'),
(706, 58, 'fld_475276', 'socite', 'NADA'),
(707, 58, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(708, 58, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(709, 58, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \"}'),
(710, 58, 'fld_2695739', 'objet', 'TEST/ESSAI'),
(711, 58, 'fld_3396882', 'message', 'BONJOUR\r\n\r\nCECI EST UN ESSAI'),
(712, 58, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(713, 58, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(714, 58, 'fld_3201949', 'envoyer', 'click'),
(715, 59, 'fld_5462783', 'nom', 'Debié'),
(716, 59, 'fld_3436924', 'prenom', 'Maxime'),
(717, 59, 'fld_2124341', 'adresse_mail', 'maximedebie44@gmail.com'),
(718, 59, 'fld_724362', 'num_tel', '07 81 62 64 89'),
(719, 59, 'fld_475276', 'socite', 'UTT Arena'),
(720, 59, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(721, 59, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(722, 59, 'fld_2695739', 'objet', 'Recherche de deux agents de sécurité pour sécuriser un événement e-sport'),
(723, 59, 'fld_3396882', 'message', 'Bonjour Madame, Monsieur,\r\nNous souhaiterions établir un devis avec vous pour 2 agents de sécurité pour la sécurisation de l’UTT arena, un tournoi de e-sport organisé au sein du CUBE, le 3 et 4 décembre 2022. L’événement aura lieu du samedi 3 décembre à 8h30 jusqu’au dimanche à 17h et nous aurions besoin de vos agents pendant toute la période (nuit incluse) soit 32,5h. Dans l’attente d’une réponse de votre part, cordialement.'),
(724, 59, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(725, 59, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(726, 59, 'fld_3201949', 'envoyer', 'click'),
(727, 60, 'fld_5462783', 'nom', 'Eric'),
(728, 60, 'fld_3436924', 'prenom', 'Eric'),
(729, 60, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(730, 60, 'fld_724362', 'num_tel', '555-555-1212'),
(731, 60, 'fld_475276', 'socite', 'Bp gbvocbx fmz'),
(732, 60, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(733, 60, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(734, 60, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(735, 60, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(736, 60, 'fld_2695739', 'objet', 'D Gav'),
(737, 60, 'fld_3396882', 'message', 'Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at artus-securite.fr.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(738, 60, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(739, 60, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(740, 61, 'fld_5462783', 'nom', 'HOUET'),
(741, 61, 'fld_3436924', 'prenom', 'Victorine'),
(742, 61, 'fld_2124341', 'adresse_mail', 'victorine.houet@beumer.com'),
(743, 61, 'fld_724362', 'num_tel', '06 75 40 18 95'),
(744, 61, 'fld_475276', 'socite', 'BEUMER Group'),
(745, 61, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(746, 61, 'fld_6078931', 'secteur_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(747, 61, 'fld_2695739', 'objet', 'Demande devis installation extincteurs'),
(748, 61, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nNotre entreprise est installée au sein de l\\\'aéroport CDG, au sein du satellite 3. \r\n\r\nLes locaux que nous louons ne sont actuellement pas dotés d\\\'extincteurs: \r\n- un espace bureaux/zone de restauration au niveau 0 (niveau des pistes) \r\n- un espace pour nos équipes de maintenance (Bureau + local de maintenance) au niveau -3. \r\n\r\nSerait-il possible de réaliser un devis pour une potentielle installation de votre part?\r\n\r\nBien à vous\r\n\r\nVictorine HOUET\r\nResponsable QHSE BEUME Group\r\n\r\n'),
(749, 61, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(750, 61, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(751, 61, 'fld_3201949', 'envoyer', 'click'),
(752, 62, 'fld_5462783', 'nom', 'Griffin'),
(753, 62, 'fld_3436924', 'prenom', 'Sean'),
(754, 62, 'fld_2124341', 'adresse_mail', 'theatre@utt.fr'),
(755, 62, 'fld_724362', 'num_tel', '06 87 07 57 74'),
(756, 62, 'fld_475276', 'socite', 'Ch\\\'UTT De Vers'),
(757, 62, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(758, 62, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(759, 62, 'fld_2695739', 'objet', 'Demande de devis'),
(760, 62, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nPour notre représentation théâtrale du semestre, nous aurions besoin de 2 ADS le jeudi 15 et vendredi 16 décembre entre 19h30 et 22h30.\r\nNous avions déjà fait appel à vous pour notre dernière représentation en juin et désirerions renouveler l\\\'expérience.\r\nSerait il possible d\\\'avoir un devis ?\r\n\r\nMerci d\\\'avance.\r\nSean GRIFFIN, président des Ch\\\'UTT de Vers\r\n'),
(761, 62, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(762, 62, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(763, 62, 'fld_3201949', 'envoyer', 'click'),
(764, 63, 'fld_5462783', 'nom', 'Eric'),
(765, 63, 'fld_3436924', 'prenom', 'Eric'),
(766, 63, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(767, 63, 'fld_724362', 'num_tel', '555-555-1212'),
(768, 63, 'fld_475276', 'socite', 'Qjbg'),
(769, 63, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(770, 63, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(771, 63, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(772, 63, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(773, 63, 'fld_2695739', 'objet', 'Bisg abkgs'),
(774, 63, 'fld_3396882', 'message', 'Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at artus-securite.fr.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr'),
(775, 63, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(776, 63, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(777, 64, 'fld_5462783', 'nom', 'Eric'),
(778, 64, 'fld_3436924', 'prenom', 'Eric'),
(779, 64, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(780, 64, 'fld_724362', 'num_tel', '555-555-1212'),
(781, 64, 'fld_475276', 'socite', 'Emt bdw D'),
(782, 64, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(783, 64, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(784, 64, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(785, 64, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(786, 64, 'fld_2695739', 'objet', 'Gttig Wk'),
(787, 64, 'fld_3396882', 'message', 'Hello, my name’s Eric and I just ran across your website at artus-securite.fr...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(788, 64, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(789, 64, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(790, 65, 'fld_5462783', 'nom', 'Eric'),
(791, 65, 'fld_3436924', 'prenom', 'Eric'),
(792, 65, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(793, 65, 'fld_724362', 'num_tel', '555-555-1212'),
(794, 65, 'fld_475276', 'socite', 'Vu Hg'),
(795, 65, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(796, 65, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(797, 65, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(798, 65, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(799, 65, 'fld_2695739', 'objet', 'Oxo nzkrhar'),
(800, 65, 'fld_3396882', 'message', 'My name’s Eric and I just found your site artus-securite.fr.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nTalk With Web Visitor – CLICK HERE https://boostleadgeneration.com for a live demo now.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(801, 65, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(802, 65, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(803, 66, 'fld_5462783', 'nom', 'Eric'),
(804, 66, 'fld_3436924', 'prenom', 'Eric'),
(805, 66, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(806, 66, 'fld_724362', 'num_tel', '555-555-1212'),
(807, 66, 'fld_475276', 'socite', 'Wabhd'),
(808, 66, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(809, 66, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(810, 66, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(811, 66, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(812, 66, 'fld_2695739', 'objet', 'Rbnhxwio'),
(813, 66, 'fld_3396882', 'message', 'My name’s Eric and I just found your site artus-securite.fr.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nTalk With Web Visitor – CLICK HERE https://boostleadgeneration.com for a live demo now.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(814, 66, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.');
INSERT INTO `mod284_cf_form_entry_values` (`id`, `entry_id`, `field_id`, `slug`, `value`) VALUES 
(815, 66, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(816, 67, 'fld_5462783', 'nom', 'Marjorie'),
(817, 67, 'fld_3436924', 'prenom', 'Marjorie'),
(818, 67, 'fld_2124341', 'adresse_mail', 'atomicmouse.bonjour@gmail.com'),
(819, 67, 'fld_724362', 'num_tel', 'E R pleng'),
(820, 67, 'fld_475276', 'socite', 'Ietiwccfyp N'),
(821, 67, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(822, 67, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(823, 67, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(824, 67, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(825, 67, 'fld_2695739', 'objet', 'Uzygla Gkp a'),
(826, 67, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(827, 67, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(828, 68, 'fld_5462783', 'nom', 'Eric'),
(829, 68, 'fld_3436924', 'prenom', 'Eric'),
(830, 68, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(831, 68, 'fld_724362', 'num_tel', '555-555-1212'),
(832, 68, 'fld_475276', 'socite', 'Tnwisx'),
(833, 68, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(834, 68, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(835, 68, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(836, 68, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(837, 68, 'fld_2695739', 'objet', 'Qcj qh'),
(838, 68, 'fld_3396882', 'message', 'Cool website!\r\n\r\nMy name’s Eric, and I just found your site - artus-securite.fr - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across artus-securite.fr, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought – what if there was an easy way for every visitor to “raise their hand” to get a phone call from you INSTANTLY… the second they hit your site and said, “call me now.”\r\n\r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead feature… because once you’ve captured the visitor’s phone number, you can automatically start a text message (SMS) conversation.\r\n  \r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE http://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(839, 68, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(840, 68, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(841, 69, 'fld_5462783', 'nom', 'Anderson'),
(842, 69, 'fld_3436924', 'prenom', 'Anderson'),
(843, 69, 'fld_2124341', 'adresse_mail', 'support@wocaro.com'),
(844, 69, 'fld_724362', 'num_tel', '089 81 40 78'),
(845, 69, 'fld_475276', 'socite', 'Crdkobmeg t'),
(846, 69, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(847, 69, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(848, 69, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(849, 69, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(850, 69, 'fld_2695739', 'objet', 'Ggp pornh'),
(851, 69, 'fld_3396882', 'message', 'Wocaro is a ending its lead provider service at the end of the year.\r\n\r\nWe have made all 365 million leads available for a once off fee of $15.\r\n\r\nYou can view the samples here: https://wocaro.com/samples\r\n\r\nAnd go to our homepage to get instant access Wocaro.com'),
(852, 69, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(853, 69, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(854, 70, 'fld_5462783', 'nom', 'Jaqueline'),
(855, 70, 'fld_3436924', 'prenom', 'Jaqueline'),
(856, 70, 'fld_2124341', 'adresse_mail', 'jaqueline.gault@outlook.com'),
(857, 70, 'fld_724362', 'num_tel', '0373 2049661'),
(858, 70, 'fld_475276', 'socite', 'Uqoaakt sdf'),
(859, 70, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(860, 70, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(861, 70, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(862, 70, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(863, 70, 'fld_2695739', 'objet', 'Ogczb'),
(864, 70, 'fld_3396882', 'message', 'La façon la plus simple de gérer les annonces publicitaires.\r\n\r\nCe que vous allez obtenir :\r\n\r\nChangements intelligents des annonces grâce au Machine Learning.\r\n\r\nRevenus Explosifs :  Accès aux Réseaux d’annonces publicitaires majeurs.\r\n\r\nSites plus rentables : Moins d’annonces publicitaires, + de revenus.\r\n\r\nC\\\'est tout simple inscrivez-vous ici :\r\nhttps://www.ezoic.com/fr-lang/?tap_a=96831-7af5aa&tap_s=3247952-f01cb7\r\n\r\nOn se retrouve de l\\\'autre côté\r\n'),
(865, 70, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(866, 70, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(867, 71, 'fld_5462783', 'nom', 'Eric'),
(868, 71, 'fld_3436924', 'prenom', 'Eric'),
(869, 71, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(870, 71, 'fld_724362', 'num_tel', '555-555-1212'),
(871, 71, 'fld_475276', 'socite', 'Vrnl Qnjwrnvq'),
(872, 71, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(873, 71, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(874, 71, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(875, 71, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(876, 71, 'fld_2695739', 'objet', 'P rsamn'),
(877, 71, 'fld_3396882', 'message', 'Cool website!\r\n\r\nMy name’s Eric, and I just found your site - artus-securite.fr - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across artus-securite.fr, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought – what if there was an easy way for every visitor to “raise their hand” to get a phone call from you INSTANTLY… the second they hit your site and said, “call me now.”\r\n\r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead feature… because once you’ve captured the visitor’s phone number, you can automatically start a text message (SMS) conversation.\r\n  \r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(878, 71, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(879, 71, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(880, 72, 'fld_5462783', 'nom', 'Eric'),
(881, 72, 'fld_3436924', 'prenom', 'Eric'),
(882, 72, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(883, 72, 'fld_724362', 'num_tel', '555-555-1212'),
(884, 72, 'fld_475276', 'socite', 'Rzsme Y i Dgc'),
(885, 72, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(886, 72, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(887, 72, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(888, 72, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(889, 72, 'fld_2695739', 'objet', 'Ielfvwyqw lid'),
(890, 72, 'fld_3396882', 'message', 'Hi, Eric here with a quick thought about your website artus-securite.fr...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://boostleadgeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(891, 72, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(892, 72, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(893, 73, 'fld_5462783', 'nom', 'Eric'),
(894, 73, 'fld_3436924', 'prenom', 'Eric'),
(895, 73, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(896, 73, 'fld_724362', 'num_tel', '555-555-1212'),
(897, 73, 'fld_475276', 'socite', 'Xmudxipj nk'),
(898, 73, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(899, 73, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(900, 73, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(901, 73, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(902, 73, 'fld_2695739', 'objet', 'Voxmgi'),
(903, 73, 'fld_3396882', 'message', 'Good day, \r\n\r\nMy name is Eric and unlike a lot of emails you might get, I wanted to instead provide you with a word of encouragement – Congratulations\r\n\r\nWhat for?  \r\n\r\nPart of my job is to check out websites and the work you’ve done with artus-securite.fr definitely stands out. \r\n\r\nIt’s clear you took building a website seriously and made a real investment of time and resources into making it top quality.\r\n\r\nThere is, however, a catch… more accurately, a question…\r\n\r\nSo when someone like me happens to find your site – maybe at the top of the search results (nice job BTW) or just through a random link, how do you know? \r\n\r\nMore importantly, how do you make a connection with that person?\r\n\r\nStudies show that 7 out of 10 visitors don’t stick around – they’re there one second and then gone with the wind.\r\n\r\nHere’s a way to create INSTANT engagement that you may not have known about… \r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know INSTANTLY that they’re interested – so that you can talk to that lead while they’re literally checking out artus-securite.fr.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be a game-changer for your business – and it gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately (and there’s literally a 100X difference between contacting someone within 5 minutes versus 30 minutes.)\r\n\r\nPlus then, even if you don’t close a deal right away, you can connect later on with text messages for new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is simple, easy, and effective. \r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(904, 73, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(905, 73, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(906, 74, 'fld_5462783', 'nom', 'Maurice'),
(907, 74, 'fld_3436924', 'prenom', 'Maurice'),
(908, 74, 'fld_2124341', 'adresse_mail', 'dennis.maurice@msn.com'),
(909, 74, 'fld_724362', 'num_tel', '04.46.60.02.05'),
(910, 74, 'fld_475276', 'socite', 'Qet ngw'),
(911, 74, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(912, 74, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(913, 74, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(914, 74, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(915, 74, 'fld_2695739', 'objet', 'Tptiur'),
(916, 74, 'fld_3396882', 'message', 'Créez les contenus sur votre site web.\r\n\r\nCe que vous allez obtenir :\r\n\r\nSite rentable : Rédigez à la vitesse de l\\\'éclair.\r\n\r\nCréations d\\\'images Haute Résolutions.\r\n\r\nPrise en main rapide : Simple d\\\'utilisation.\r\n\r\nProfitez de l\\\'essai gratuit.\r\n\r\nC\\\'est tout simple inscrivez-vous ici :\r\n\r\nhttps://www.jasper.ai/free-trial?fpr=yaelle96\r\n\r\nOn se retrouve de l\\\'autre côté\r\n'),
(917, 74, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(918, 74, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(919, 75, 'fld_5462783', 'nom', 'Moutoussamy'),
(920, 75, 'fld_3436924', 'prenom', 'Patrice Brigitte'),
(921, 75, 'fld_2124341', 'adresse_mail', 'p.moutoussamy@outlook.fr'),
(922, 75, 'fld_724362', 'num_tel', '07 81 85 27 46'),
(923, 75, 'fld_6078931', 'agence_souhait.opt1916226', 'Hauts-de-France '),
(924, 75, 'fld_6078931', 'agence_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(925, 75, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-PATRICE-MOUTOUSSAMY-SSIAP-1-1.pdf'),
(926, 75, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/SOCIETE-ARTUS-PROTECTION-LETTRE-DE-MOTIVATION.pdf'),
(927, 75, 'fld_3396882', 'message', 'Monsieur, \r\n\r\nJe vous envoie par ce formulaire une candidature spontanée. \r\n\r\nJe suis véhiculé et disponible à partir du 1er Février. Titulaire de la carte professionnelle en cours de validité, du SSIAP 1 recyclé, et du SST valide. \r\n\r\nSi je ne répond pas de suite au téléphone, laissez moi un message sur le répondeur et je vous recontacte dès que possible. \r\n\r\nOu si vous préférez, par mail. \r\n\r\nCordialement. \r\n\r\nMonsieur Patrice Moutoussamy. '),
(928, 75, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(929, 75, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(930, 75, 'fld_3201949', 'envoyer', 'click'),
(931, 76, 'fld_5462783', 'nom', 'Eric'),
(932, 76, 'fld_3436924', 'prenom', 'Eric'),
(933, 76, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(934, 76, 'fld_724362', 'num_tel', '555-555-1212'),
(935, 76, 'fld_475276', 'socite', 'Ywrhf'),
(936, 76, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(937, 76, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(938, 76, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(939, 76, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(940, 76, 'fld_2695739', 'objet', 'G xadase'),
(941, 76, 'fld_3396882', 'message', 'Hey there, I just found your site, quick question…\r\n\r\nMy name’s Eric, I found artus-securite.fr after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTalk With Web Visitor is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(942, 76, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(943, 76, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(944, 77, 'fld_5462783', 'nom', 'SAVIGNI'),
(945, 77, 'fld_3436924', 'prenom', 'SANDRA'),
(946, 77, 'fld_2124341', 'adresse_mail', 'ssavigni@hotmail.fr'),
(947, 77, 'fld_724362', 'num_tel', '06 16 69 62 92'),
(948, 77, 'fld_475276', 'socite', 'TEST'),
(949, 77, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(950, 77, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(951, 77, 'fld_2695739', 'objet', 'TEST'),
(952, 77, 'fld_3396882', 'message', 'TEST'),
(953, 77, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(954, 77, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(955, 77, 'fld_3201949', 'envoyer', 'click'),
(956, 78, 'fld_5462783', 'nom', 'savigni'),
(957, 78, 'fld_3436924', 'prenom', 'sandra'),
(958, 78, 'fld_2124341', 'adresse_mail', 'ssavigni@hotmail.fr'),
(959, 78, 'fld_724362', 'num_tel', '06 16 69 62 92'),
(960, 78, 'fld_6078931', 'agence_souhait.opt1916226', 'Hauts-de-France '),
(961, 78, 'fld_6078931', 'agence_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(962, 78, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/Artus-Organigramme-recadre.pdf'),
(963, 78, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Artus-Organigramme.pdf'),
(964, 78, 'fld_3396882', 'message', 'tec'),
(965, 78, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(966, 78, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(967, 78, 'fld_3201949', 'envoyer', 'click'),
(968, 79, 'fld_5462783', 'nom', 'Miranda'),
(969, 79, 'fld_3436924', 'prenom', 'Miranda'),
(970, 79, 'fld_2124341', 'adresse_mail', 'miranda.ogilvy@gmail.com'),
(971, 79, 'fld_724362', 'num_tel', '53 662 04 57'),
(972, 79, 'fld_475276', 'socite', 'Yanspxzpz T'),
(973, 79, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(974, 79, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(975, 79, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(976, 79, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(977, 79, 'fld_2695739', 'objet', 'Govluqlbrvn'),
(978, 79, 'fld_3396882', 'message', 'Augmentez les gains sur votre site web.\r\n\r\nCe que vous allez obtenir :\r\n\r\nRevenus Explosifs:  Accès aux Réseaux d’annonces publicitaires majeurs (Adsence, etc...)\r\n\r\nSite rentable : Moins d’annonces pour + de revenus (même avec peu de visites sur votre site).\r\n\r\nC\\\'est tout simple inscrivez-vous ici :\r\nhttps://www.ezoic.com/fr-lang/?tap_a=96831-7af5aa&tap_s=3247952-f01cb7\r\n\r\nOn se retrouve de l\\\'autre côté\r\n'),
(979, 79, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(980, 79, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(981, 80, 'fld_5462783', 'nom', 'Colliere'),
(982, 80, 'fld_3436924', 'prenom', 'Alexis'),
(983, 80, 'fld_2124341', 'adresse_mail', 'acolliere.pro@gmail.com'),
(984, 80, 'fld_724362', 'num_tel', '06 95 06 32 28'),
(985, 80, 'fld_6078931', 'agence_souhait.opt1109492', 'Est Champagne Ardenne '),
(986, 80, 'fld_6078931', 'agence_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(987, 80, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/BTS-MOS-CV-REF-3.pdf'),
(988, 80, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/mos-artus-securite-protection-lettre-de-motivation.pdf'),
(989, 80, 'fld_3396882', 'message', 'Demande d\\\'alternance dans votre entreprise en vue d\\\'intégrer un BTS Management opérationnel de la sécurité dès Septembre 2023.'),
(990, 80, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(991, 80, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(992, 80, 'fld_3201949', 'envoyer', 'click'),
(993, 81, 'fld_5462783', 'nom', 'Rigollé '),
(994, 81, 'fld_3436924', 'prenom', 'David '),
(995, 81, 'fld_2124341', 'adresse_mail', 'da.rigolle@laposte.net'),
(996, 81, 'fld_724362', 'num_tel', '06 48 85 24 89'),
(997, 81, 'fld_6078931', 'agence_souhait.opt1916226', 'Hauts-de-France '),
(998, 81, 'fld_6078931', 'agence_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(999, 81, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/Cv-general-et-agent-securite-2023-4.pdf'),
(1000, 81, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Cv-agent-securite-et-general-2023.pdf');
INSERT INTO `mod284_cf_form_entry_values` (`id`, `entry_id`, `field_id`, `slug`, `value`) VALUES 
(1001, 81, 'fld_3396882', 'message', 'Bonjour \r\nJe me permets de faire une candidature spontanée pour un poste d\\\'agent de sécurité ( gardiennage).\r\nÉtant titulaire du diplôme d\\\'agent de prévention et de sécurité, j\\\'aimerais vivement rejoindre votre équipe afin d\\\'acquérir une nouvelle expérience professionnelle.\r\nAu cours de mes premières expériences en tant qu\\\'agent de sécurité, j\\\'ai appris à surveiller efficacement un lieu en effectuant des rondes régulières.\r\nJe postule en connaissance de cause : je sais que dans le cadre de son activité professionnelle, un agent de sécurité peut être amené à travailler de jour, comme de nuit, sans parler des weekends ou des jours fériés. Je suis prêt à assurer les fonctions que vous voudrez bien m\\\'accorder et ce, malgré les horaires décalés.\r\nDisponible de suite, je souhaiterais obtenir un entretien afin de discuter plus amplement de ma candidature avec vous et donc, de mes motivations.\r\nDans cette attente, veuillez recevoir, Madame, Monsieur, l\\\'expression de mes salutations distinguées.'),
(1002, 81, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1003, 81, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1004, 81, 'fld_3201949', 'envoyer', 'click'),
(1005, 82, 'fld_5462783', 'nom', 'Milla'),
(1006, 82, 'fld_3436924', 'prenom', 'Milla'),
(1007, 82, 'fld_2124341', 'adresse_mail', 'sherman.milla@gmail.com'),
(1008, 82, 'fld_724362', 'num_tel', '041 372 22 60'),
(1009, 82, 'fld_475276', 'socite', 'Xkqfxt'),
(1010, 82, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1011, 82, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1012, 82, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1013, 82, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1014, 82, 'fld_2695739', 'objet', 'Y hir l am'),
(1015, 82, 'fld_3396882', 'message', 'Participez pour une carte Sephora!\r\n\r\nC\\\'est tout simple inscrivez-vous ici :\r\n\r\nhttps://tundrafile.com/show.php?l=0&u=320546&id=42162\r\n\r\nOn se retrouve de l\\\'autre côté\r\n'),
(1016, 82, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1017, 82, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1018, 83, 'fld_5462783', 'nom', 'Marjorie'),
(1019, 83, 'fld_3436924', 'prenom', 'Marjorie'),
(1020, 83, 'fld_2124341', 'adresse_mail', 'atomicmouse.shop@gmail.com'),
(1021, 83, 'fld_724362', 'num_tel', '06-78941238'),
(1022, 83, 'fld_475276', 'socite', 'Pmeb Lptuwjt'),
(1023, 83, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1024, 83, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1025, 83, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1026, 83, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1027, 83, 'fld_2695739', 'objet', 'Cmkgczc F'),
(1028, 83, 'fld_3396882', 'message', 'Bonjour !\r\n\r\nEt si vous faisiez ronronner votre service client tout en faisant + de ventes\r\n\r\nJ\\\'ai enregistré une petite vidéo de 2 mn 30 pour vous montrer comment vous pouvez automatiser votre support client.\r\nC\\\'est facile et rapide.\r\n\r\nLa vidéo est ici : https://youtu.be/fHnw9SX1kpI\r\n\r\nJe reste à votre écoute,\r\nMarjorie - Atomic Mouse'),
(1029, 83, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1030, 83, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1031, 84, 'fld_5462783', 'nom', 'MARTINOT'),
(1032, 84, 'fld_3436924', 'prenom', 'Sophie'),
(1033, 84, 'fld_2124341', 'adresse_mail', 'sopmar7@gmail.com'),
(1034, 84, 'fld_724362', 'num_tel', '06 17 80 93 25'),
(1035, 84, 'fld_6078931', 'agence_souhait.opt1109492', 'Est Champagne Ardenne '),
(1036, 84, 'fld_6078931', 'agence_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1037, 84, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-SM.pdf'),
(1038, 84, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Lettre-motivation-SM.pdf'),
(1039, 84, 'fld_3396882', 'message', 'Bonjour,\r\nJe me permets de vous transmettre ma candidature spontanée au poste d\\\'agent de sécurité. Je suis motivée, rigouseuse, disponible et souhaite intégrer votre entreprise.\r\nN\\\' hésitez pas à me contacter si vous souhaitez me rencontrer.\r\nBien cordialement\r\nSophie Martinot'),
(1040, 84, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1041, 84, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1042, 84, 'fld_3201949', 'envoyer', 'click'),
(1043, 85, 'fld_5462783', 'nom', 'PARADE'),
(1044, 85, 'fld_3436924', 'prenom', 'Sébastien'),
(1045, 85, 'fld_2124341', 'adresse_mail', 'sebastien.parade1@gmail.com'),
(1046, 85, 'fld_724362', 'num_tel', '07 86 04 15 44'),
(1047, 85, 'fld_475276', 'socite', 'Aucune'),
(1048, 85, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1049, 85, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(1050, 85, 'fld_2695739', 'objet', 'Demande de renseignement - Embauche d\\\'extras'),
(1051, 85, 'fld_3396882', 'message', 'Bonsoir,\r\n\r\nJe me permets de vous adresser ce message afin de savoir si il vous arrive d\\\'embaucher des personnes en extra dans le Compiègnois ( contrat à la journée ou à la soirée notamment ).\r\nConcernant mon profil, je ne détiens pas de carte professionnelle d\\\'agent de sécurité mais exerce ma profession au sein des forces de l\\\'ordre.\r\nEn vous remerciant par avance de votre réponse.\r\n\r\nCordialement.\r\nM; PARADE Sébastien.'),
(1052, 85, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1053, 85, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1054, 85, 'fld_3201949', 'envoyer', 'click'),
(1055, 86, 'fld_5462783', 'nom', 'Eric'),
(1056, 86, 'fld_3436924', 'prenom', 'Eric'),
(1057, 86, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1058, 86, 'fld_724362', 'num_tel', '555-555-1212'),
(1059, 86, 'fld_475276', 'socite', 'Viynf Fond'),
(1060, 86, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1061, 86, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1062, 86, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1063, 86, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1064, 86, 'fld_2695739', 'objet', 'Mbguwizg'),
(1065, 86, 'fld_3396882', 'message', 'Hi, Eric here with a quick thought about your website artus-securite.fr...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr'),
(1066, 86, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1067, 86, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1068, 87, 'fld_5462783', 'nom', 'Eric'),
(1069, 87, 'fld_3436924', 'prenom', 'Eric'),
(1070, 87, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1071, 87, 'fld_724362', 'num_tel', '555-555-1212'),
(1072, 87, 'fld_475276', 'socite', 'Ap qo'),
(1073, 87, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1074, 87, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1075, 87, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1076, 87, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1077, 87, 'fld_2695739', 'objet', 'Wcy ht cwoc'),
(1078, 87, 'fld_3396882', 'message', 'Hey, my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at artus-securite.fr.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr'),
(1079, 87, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1080, 87, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1081, 88, 'fld_5462783', 'nom', 'Facque'),
(1082, 88, 'fld_3436924', 'prenom', 'Amandine'),
(1083, 88, 'fld_2124341', 'adresse_mail', 'a.facque@groupe-echo.fr'),
(1084, 88, 'fld_724362', 'num_tel', '03 10 94 00 10'),
(1085, 88, 'fld_6078931', 'agence_souhait.opt1109492', 'Est Champagne Ardenne '),
(1086, 88, 'fld_6078931', 'agence_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1087, 88, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/test-pj.pdf'),
(1088, 88, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/test-pj.pdf'),
(1089, 88, 'fld_3396882', 'message', 'Message de test du formulaire de recrutement.'),
(1090, 88, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1091, 88, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1092, 88, 'fld_3201949', 'envoyer', 'click'),
(1093, 89, 'fld_5462783', 'nom', 'Eric'),
(1094, 89, 'fld_3436924', 'prenom', 'Eric'),
(1095, 89, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1096, 89, 'fld_724362', 'num_tel', '555-555-1212'),
(1097, 89, 'fld_475276', 'socite', 'Lfr Tk frjp x'),
(1098, 89, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1099, 89, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1100, 89, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1101, 89, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1102, 89, 'fld_2695739', 'objet', 'Qibkzb'),
(1103, 89, 'fld_3396882', 'message', 'Hello, my name’s Eric and I just ran across your website at artus-securite.fr...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1104, 89, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1105, 89, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1106, 90, 'fld_5462783', 'nom', 'Eric'),
(1107, 90, 'fld_3436924', 'prenom', 'Eric'),
(1108, 90, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1109, 90, 'fld_724362', 'num_tel', '555-555-1212'),
(1110, 90, 'fld_475276', 'socite', 'Jhdwv T Rny'),
(1111, 90, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1112, 90, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1113, 90, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1114, 90, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1115, 90, 'fld_2695739', 'objet', 'Efu tgaqbsq'),
(1116, 90, 'fld_3396882', 'message', 'Hey, this is Eric and I ran across artus-securite.fr a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Talk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1117, 90, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1118, 90, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1119, 91, 'fld_5462783', 'nom', 'Vicky'),
(1120, 91, 'fld_3436924', 'prenom', 'Vicky'),
(1121, 91, 'fld_2124341', 'adresse_mail', 'noreply.pmeconsulting@gmail.com'),
(1122, 91, 'fld_724362', 'num_tel', '0474 98 46 39'),
(1123, 91, 'fld_475276', 'socite', 'Zxzuf'),
(1124, 91, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1125, 91, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1126, 91, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1127, 91, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1128, 91, 'fld_2695739', 'objet', 'Cg slv'),
(1129, 91, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nConvaincus que posséder un site web est important et que son référencement l’est beaucoup plus, nous avons décidé de lancer une petite campagne où nous allons collaborer avec beaucoup de partenaires qui partagent avec nous le même objectif : Celui de gagner en notoriété et d’avoir une bonne visibilité sur les moteurs de recherche, plus de visiteurs et donc plus de clients ! \r\n\r\nC’est notre objectif à tous ! \r\nOn en est bien d’accord là-dessus, n’est-ce pas ? \r\n\r\nLa réponse est surement oui. \r\n\r\nEt c’est justement pour cette raison que je vous contacte aujourd’hui ! \r\nContinuez donc à lire ! Ces deux minutes de lecture vous feront gagner trois mois de référencement, croyez-moi ! \r\n\r\nQui suis-je ? \r\n\r\nJe suis Said. Je suis spécialiste en Marketing digital et expert SEO / Référencement depuis 2007. J’ai une agence de référencement naturel. Avec mon équipe, j’ai pu monter pas mal de sites web dont certains nous appartiennent, d’autres à nos clients.\r\n\r\nGoogle est notre première source de trafic.\r\n\r\nEn effet, je veux vous aider à augmenter votre trafic et visibilité en ligne. Avant que je vous dise comment, sachez que mon service est totalement gratuit. Tout ce que je veux en échange est la possibilité de poster un article invité sur votre site.\r\n\r\nDans cet article, je vais intégrer un lien vers un de mes sites. L’article sera rédigé par un de mes rédacteurs hautement qualifié, il saura fournir un contenu qui s’adaptera parfaitement à votre style et à vos exigences.\r\n\r\nEn guise de remerciement, je vais vous offrir un cadeau de grande valeur.\r\n\r\nLisez jusqu’au bout pour connaître votre cadeau. \r\n\r\nÉtant experts dans le domaine, nous avons réussi à réaliser les objectifs souhaités grâce à une stratégie efficace et à des analyses techniques à forte valeur ajoutée.\r\n\r\nIci, je vous parle du : SEO Technique (Référencement technique)\r\n\r\nCe que je vous propose est de vous aider avec un audit SEO Technique de votre site Ce serait gratuit.\r\n\r\nCet Audit va vous montrer les erreurs techniques qui doivent être corrigées.\r\n\r\nGoogle déteste ces erreurs sur les sites. Et pénalise les sites ayant beaucoup d\\\'erreurs techniques en les décalant dans les résultats de recherche, ce qui génère une mauvaise visibilité.\r\n\r\nAvec mon audit, vous aurez les informations nécessaires pour les corriger vous-même. Si vous faites ça, votre positionnement s’améliorera.\r\n\r\nNotre solution logicielle analysera plus de 300 facteurs pour chaque page de votre site web. Le temps que prend cette procédure dépend évidemment de la taille de votre site. \r\n\r\nComme vous pouvez l\\\'imaginer, de nombreux sites nous demandent de réaliser des audits et nous traiterons votre site dans l\\\'ordre de la liste d\\\'attente. En général, le processus prend entre une et deux semaines.\r\n\r\nCe travail nous demandera donc des sources matérielles et logicielles, mais surtout un esprit d\\\'analyse que nous sommes fiers de maîtriser.\r\n\r\nD’ailleurs, d’habitude, nous proposons ce même service à partir de 299€ en hors taxe.\r\nAujourd\\\'hui, il vous est complètement offert.\r\n\r\nUn cadeau d’une valeur de 299€, c’est intéressant n’est-ce pas ? \r\n\r\nUne fois la correction effectuée correctement, il faut prévoir un délai de 3 mois au maximum pour toucher de bons résultats. Vous aurez plus de visiteurs, plus de clics et plus de ventes de vos services ou produits. \r\n\r\nOui, oui ! \r\nParfois moins ! \r\n\r\nSi vous ne savez pas par où commencer, nous serons aussi disponibles pour vous conseiller ou alors pour corriger ses erreurs pour vous.\r\n\r\nSi vous êtes intéressé, (je sais que vous vous dîtes maintenant, pourquoi pas ! Après tout, rien à perdre), n\\\'hésitez pas à m\\\'écrire sur editionsmasters@gmail.com pour que je puisse réserver un spot pour vous.(Merci de ne pas utiliser la fonction répondre de votre email)\r\n\r\nComme vous pouvez l\\\'imaginer, les spots sont limités vu que ceci dépend principalement de la capacité limitée de nos serveurs limitée.\r\n\r\nDonc premier arrivé, premier servi ! \r\n\r\nPour respecter tous nos partenaires, nous traitons les demandes selon l\\\'ordre dans lequel on les reçoit, donc plus tôt vous répondez, plus vite, vous obtiendrez votre audit gratuit.\r\n\r\nC’est l’occasion ou jamais ! \r\n\r\nAu plaisir de collaborer avec vous\r\n\r\nCordialement\r\nSaid'),
(1130, 91, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1131, 91, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1132, 92, 'fld_5462783', 'nom', 'Eric'),
(1133, 92, 'fld_3436924', 'prenom', 'Eric'),
(1134, 92, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1135, 92, 'fld_724362', 'num_tel', '555-555-1212'),
(1136, 92, 'fld_475276', 'socite', 'Gfjszi'),
(1137, 92, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1138, 92, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1139, 92, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1140, 92, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1141, 92, 'fld_2695739', 'objet', 'El fenl'),
(1142, 92, 'fld_3396882', 'message', 'Hi, my name is Eric and I’m betting you’d like your website artus-securite.fr to generate more leads.\r\n\r\nHere’s how:\r\nTalk With Web Visitor is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at artus-securite.fr.\r\n\r\nTalk With Web Visitor – CLICK HERE https://boostleadgeneration.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://boostleadgeneration.com to discover what Talk With Web Visitor can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Talk With Web Visitor and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nTalk With Web Visitor offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://boostleadgeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://boostleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1143, 92, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1144, 92, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1145, 93, 'fld_5462783', 'nom', 'Degodet'),
(1146, 93, 'fld_3436924', 'prenom', 'Bertrand'),
(1147, 93, 'fld_2124341', 'adresse_mail', 'bertrand.degodet@sddea.fr'),
(1148, 93, 'fld_724362', 'num_tel', '07 85 73 17 77'),
(1149, 93, 'fld_475276', 'socite', 'REGIE DU SDDEA'),
(1150, 93, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1151, 93, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1152, 93, 'fld_2695739', 'objet', 'Agents de sécurité - devis'),
(1153, 93, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nDans le cadre de notre réunion du personnel, le 13 juin 2023, nous allons accueillir quelque 300 agents du SDDEA et sa Régie à l’Espace Didier-Bienaimé, à La Chapelle Saint-Luc. Nous devons attester de la présence de 2 agents de sécurité qualifié SSIAP niveau 1 pour cet événement, qui se tiendra de 14h à 17h (horaires indicatifs).\r\nAuriez-vous des disponibilités ce jour ?\r\n\r\nParallèlement, nous aurons sans doute besoin également d’agents de sécurité sur notre site de La Chapelle Saint-Luc (rue G.-Bizet), où va se tenir en extérieur le barbecue du personnel, comme l’année dernière (vous étiez prestataires), jusque 22h30. Mais pour le moment nous sommes encore en train de définir le programme de cette soirée. Seriez-vous également disponibles ?\r\n\r\nPour établir le devis, préférez-vous faire un seul document avec les prestations de l’ensemble de la journée, ou 2 devis séparés, 1 pour chaque site et chaque prestation ?\r\nJe reste joignable pour toute précision supplémentaire,\r\n\r\nCordialement.'),
(1154, 93, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1155, 93, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1156, 93, 'fld_3201949', 'envoyer', 'click'),
(1157, 94, 'fld_5462783', 'nom', 'JOLY'),
(1158, 94, 'fld_3436924', 'prenom', 'NICOLAS'),
(1159, 94, 'fld_2124341', 'adresse_mail', 'nicolas.1991@hotmail.fr'),
(1160, 94, 'fld_724362', 'num_tel', '06 18 43 47 82'),
(1161, 94, 'fld_6078931', 'agence_souhait.opt1109492', 'Est Champagne Ardenne '),
(1162, 94, 'fld_6078931', 'agence_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1163, 94, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-Nicolas-Joly-1.pdf'),
(1164, 94, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Joly-Nicolas-lettre-SSIAP.pdf'),
(1165, 94, 'fld_3396882', 'message', ' Bonjour,\r\n\r\nje vous propose mon profil pour un éventuel poste à pourvoir.\r\n\r\nCordialement\r\nNicolas Joly'),
(1166, 94, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1167, 94, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1168, 94, 'fld_3201949', 'envoyer', 'click'),
(1169, 95, 'fld_5462783', 'nom', 'Eric'),
(1170, 95, 'fld_3436924', 'prenom', 'Eric'),
(1171, 95, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1172, 95, 'fld_724362', 'num_tel', '555-555-1212'),
(1173, 95, 'fld_475276', 'socite', 'X Gi Xt Zuiu'),
(1174, 95, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1175, 95, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1176, 95, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1177, 95, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1178, 95, 'fld_2695739', 'objet', 'Bdrwynt'),
(1179, 95, 'fld_3396882', 'message', 'Dear artus-securite.fr Owner.\r\n\r\nMy name is Eric and I’m betting you’d like your website artus-securite.fr to generate more leads.\r\n\r\nHere’s how:\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at artus-securite.fr.\r\n\r\nWeb Visitors Into Leads – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1180, 95, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1181, 95, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1182, 96, 'fld_5462783', 'nom', 'Eric'),
(1183, 96, 'fld_3436924', 'prenom', 'Eric'),
(1184, 96, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1185, 96, 'fld_724362', 'num_tel', '555-555-1212'),
(1186, 96, 'fld_475276', 'socite', 'Mj gy'),
(1187, 96, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1188, 96, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1189, 96, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1190, 96, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1191, 96, 'fld_2695739', 'objet', 'Mrs G fpxh Q'),
(1192, 96, 'fld_3396882', 'message', 'Dear artus-securite.fr Webmaster!\r\n\r\nMy name’s Eric and I just came across your website - artus-securite.fr - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like artus-securite.fr will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Web Visitors Into Leads.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to learn more about everything Web Visitors Into Leads can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1193, 96, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1194, 96, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1195, 97, 'fld_5462783', 'nom', 'Eric'),
(1196, 97, 'fld_3436924', 'prenom', 'Eric'),
(1197, 97, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1198, 97, 'fld_724362', 'num_tel', '555-555-1212'),
(1199, 97, 'fld_475276', 'socite', 'Xdhhzzxl'),
(1200, 97, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1201, 97, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1202, 97, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1203, 97, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1204, 97, 'fld_2695739', 'objet', 'Fxfsz Cf Fy V'),
(1205, 97, 'fld_3396882', 'message', 'To the artus-securite.fr Admin. my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at artus-securite.fr.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1206, 97, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1207, 97, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1208, 98, 'fld_5462783', 'nom', 'Eric'),
(1209, 98, 'fld_3436924', 'prenom', 'Eric'),
(1210, 98, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1211, 98, 'fld_724362', 'num_tel', '555-555-1212'),
(1212, 98, 'fld_475276', 'socite', 'Exsjit nakld'),
(1213, 98, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1214, 98, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1215, 98, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1216, 98, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1217, 98, 'fld_2695739', 'objet', 'C Xgbro klqv'),
(1218, 98, 'fld_3396882', 'message', 'Hello artus-securite.fr Webmaster! this is Eric and I ran across artus-securite.fr a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1219, 98, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1220, 98, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1221, 99, 'fld_5462783', 'nom', 'Eric'),
(1222, 99, 'fld_3436924', 'prenom', 'Eric'),
(1223, 99, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1224, 99, 'fld_724362', 'num_tel', '555-555-1212'),
(1225, 99, 'fld_475276', 'socite', 'Fen Fneqaydnfo'),
(1226, 99, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1227, 99, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1228, 99, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1229, 99, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1230, 99, 'fld_2695739', 'objet', 'Wzfjvuuifn'),
(1231, 99, 'fld_3396882', 'message', 'To the artus-securite.fr Administrator. my name’s Eric and I just ran across your website at artus-securite.fr...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1232, 99, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1233, 99, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1234, 100, 'fld_5462783', 'nom', 'Eric'),
(1235, 100, 'fld_3436924', 'prenom', 'Eric'),
(1236, 100, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1237, 100, 'fld_724362', 'num_tel', '555-555-1212'),
(1238, 100, 'fld_475276', 'socite', 'Zwunz o tibbg'),
(1239, 100, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1240, 100, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1241, 100, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1242, 100, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1243, 100, 'fld_2695739', 'objet', 'Fmzn');
INSERT INTO `mod284_cf_form_entry_values` (`id`, `entry_id`, `field_id`, `slug`, `value`) VALUES 
(1244, 100, 'fld_3396882', 'message', 'Hi artus-securite.fr Admin.\r\n\r\nMy name’s Eric and I just ran across your website at artus-securite.fr...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1245, 100, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1246, 100, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1247, 101, 'fld_5462783', 'nom', 'FERTIN'),
(1248, 101, 'fld_3436924', 'prenom', 'Vincent'),
(1249, 101, 'fld_2124341', 'adresse_mail', 'vinali@live.fr'),
(1250, 101, 'fld_724362', 'num_tel', '06 98 69 53 69'),
(1251, 101, 'fld_6078931', 'agence_souhait.opt1916226', 'Hauts-de-France '),
(1252, 101, 'fld_6078931', 'agence_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(1253, 101, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/securite__APS_1.pdf'),
(1254, 101, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Lettre-Emploi.pdf'),
(1255, 101, 'fld_3396882', 'message', 'Bonjour  Messieurs ,Madame,\r\n\r\nJe me  présente , je suis  Mr FERTIN Vincent .\r\nJe suis  actuellement  à la recherche d’emploi dans la sécurité .\r\nJe suis  titulaire  de la carte professionnelle  valide ( 17.02.2028) et du SST (22.09.2024).\r\nVoila pourquoi je vous envoi  mon  cv et ma  lettre de motivation. \r\nJe me tiens à votre disposition pour plus de renseignements à mon sujet \r\n\r\nJe vous prie d’agréer mes meilleures salutations .\r\n\r\nFERTIIN Vincent\r\n'),
(1256, 101, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1257, 101, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1258, 101, 'fld_3201949', 'envoyer', 'click'),
(1259, 102, 'fld_5462783', 'nom', 'Eric'),
(1260, 102, 'fld_3436924', 'prenom', 'Eric'),
(1261, 102, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1262, 102, 'fld_724362', 'num_tel', '555-555-1212'),
(1263, 102, 'fld_475276', 'socite', 'Xjc euxf pt'),
(1264, 102, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1265, 102, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1266, 102, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1267, 102, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1268, 102, 'fld_2695739', 'objet', 'Ix bej X dq'),
(1269, 102, 'fld_3396882', 'message', 'To the artus-securite.fr Admin.\r\n\r\nMy name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at artus-securite.fr.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1270, 102, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1271, 102, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1272, 103, 'fld_5462783', 'nom', 'Atché'),
(1273, 103, 'fld_3436924', 'prenom', 'Lilian'),
(1274, 103, 'fld_2124341', 'adresse_mail', 'lilian.atche@utt.fr'),
(1275, 103, 'fld_724362', 'num_tel', '06 48 64 27 79'),
(1276, 103, 'fld_475276', 'socite', 'AS UTT'),
(1277, 103, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1278, 103, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1279, 103, 'fld_2695739', 'objet', 'Devis pour agent(s) de sécurité'),
(1280, 103, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nNous organisons un évènement sportif à la Halle sportive de l\\\'UTT (12 rue Marie Curie, 10000 Troyes), cet évènement devrait rassembler entre 150 et 200 personnes. Nous aurions besoin de la présence d\\\'un (ou deux) agent(s) de sécurité sur place le Samedi 3 Juin de 9h à 19h et  peut-être le Dimanche 4 Juin de 9h à 12h. Les repas seront fournis par l\\\'organisation de l\\\'évènement.\r\nMerci de nous faire parvenir un devis en faisant apparaître les prix avec sans la prestation du Dimanche.\r\n\r\nCordialement,\r\n\r\nLilian Atché\r\nÉtudiant ingénieur en Génie Mécanique à l\\\'Université de Technologie de Troyes (UTT)\r\nlilian.atche@utt.fr\r\n0648642779'),
(1281, 103, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1282, 103, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1283, 103, 'fld_3201949', 'envoyer', 'click'),
(1284, 104, 'fld_5462783', 'nom', 'Eric'),
(1285, 104, 'fld_3436924', 'prenom', 'Eric'),
(1286, 104, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1287, 104, 'fld_724362', 'num_tel', '555-555-1212'),
(1288, 104, 'fld_475276', 'socite', 'Jkcpoo'),
(1289, 104, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1290, 104, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1291, 104, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1292, 104, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1293, 104, 'fld_2695739', 'objet', 'Gnqjzl'),
(1294, 104, 'fld_3396882', 'message', 'To the artus-securite.fr Owner. my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at artus-securite.fr.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1295, 104, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1296, 104, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1297, 105, 'fld_5462783', 'nom', 'Elsie'),
(1298, 105, 'fld_3436924', 'prenom', 'Elsie'),
(1299, 105, 'fld_2124341', 'adresse_mail', 'elsie.morrice@gmail.com'),
(1300, 105, 'fld_724362', 'num_tel', 'A dkxtoce r'),
(1301, 105, 'fld_475276', 'socite', 'V fdcgq'),
(1302, 105, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1303, 105, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1304, 105, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1305, 105, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1306, 105, 'fld_2695739', 'objet', 'Qwvgfi'),
(1307, 105, 'fld_3396882', 'message', '10 méthodes pour gagner entre 1XXX et 1XXXXX euros...\r\n...enseignées par des entrepreneurs.\r\n(je ne vous demande pas de me croire, juste de regarder votre vie, \r\nl’état de votre pays et vous demander ce qui va se passer pour vous et votre famille...\r\nsi vous ne devenez pas indépendant du système très rapidement)\r\n\r\nJe vous laisse lire cette page ici :\r\n\r\nhttps://go.hotmart.com/T73683451G?ap=5daa\r\n\r\nOn se retrouve de l\\\'autre côté'),
(1308, 105, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1309, 105, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1310, 106, 'fld_5462783', 'nom', 'Di Martino'),
(1311, 106, 'fld_3436924', 'prenom', 'Elsa'),
(1312, 106, 'fld_2124341', 'adresse_mail', 'groupejet@jet-events.fr'),
(1313, 106, 'fld_724362', 'num_tel', '07 87 70 46 70'),
(1314, 106, 'fld_475276', 'socite', 'JET EVENTS'),
(1315, 106, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1316, 106, 'fld_6078931', 'secteur_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(1317, 106, 'fld_2695739', 'objet', 'Sous traitance'),
(1318, 106, 'fld_3396882', 'message', 'Bonjour,\r\nVous faites face à des missions ponctuelles liées à une hausse temporaire d’activité ou un besoin plus ou moins récurrent de faire appel à une entité extérieure ?\r\nFaire appel à JET GUARDS société privée spécialisée dans la sécurité, la sécurité incendie et la mise à disposition d’agents cynophiles, vous permet de garder la maîtrise du projet tout en y répondant de manière adaptée : vous ne perdez pas le client, nous vous aidons simplement à satisfaire son besoin.\r\nPour absorber une charge de travail exceptionnellement élevée.\r\nUn pic d’activité ou une commande d’envergure peut nécessiter de recourir à la sous-traitance. Si vos ressources ne sont pas suffisantes pour exécuter le service commandé, sous-traiter à JET GUARDS tout ou partie de la commande complémente votre production : vous répondez à la demande du client malgré vos capacités réduites.\r\nAvantages de la sous-traitance avec JET GUARDS\r\nQuelle que soit la raison qui motive votre recours à la sous-traitance, vous pourriez envisager d’autres alternatives : investir dans les moyens nécessaires, ou embaucher en interne. \r\nFace à ces solutions, la sous-traitance présente des intérêts notables :\r\n•	Vous n’êtes pas lié au sous-traitant par un contrat de travail. Chaque partie conserve sa liberté, vous mettez plus facilement un terme à la collaboration avec JET GUARDS si le résultat ne vous satisfait pas.\r\n•	 En vous engageant dans un contrat de sous-traitance avec JET GUARDS, vous transformez une charge fixe en une charge variable. Un bon moyen de mieux maîtriser vos coûts et de limiter vos risques financiers.\r\n•	Vous vous offrez plus de flexibilité et vous gagnez en réactivité. Vous accédez aux compétences et ressources « à la carte » de JET GUARDS, au gré de vos besoins, sans investissements lourds.\r\nNous intervenons aussi bien pour des communes, des théâtres, des Domaines privés ou encore dans des lieux où se déroulent des évènements sportifs, des réceptions et bien plus encore…\r\nNotre force : l’adaptabilité !\r\nContacts :\r\ngroupejet@jet-events.fr\r\nDirecteur Opérationnel M. Khiari 07 82 70 46 70\r\n'),
(1319, 106, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1320, 106, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1321, 106, 'fld_3201949', 'envoyer', 'click'),
(1322, 107, 'fld_5462783', 'nom', 'Sharon'),
(1323, 107, 'fld_3436924', 'prenom', 'Sharon'),
(1324, 107, 'fld_2124341', 'adresse_mail', 'sharon.dang@yahoo.com'),
(1325, 107, 'fld_724362', 'num_tel', '03.10.69.30.10'),
(1326, 107, 'fld_475276', 'socite', 'Zckyv a'),
(1327, 107, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1328, 107, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1329, 107, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1330, 107, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1331, 107, 'fld_2695739', 'objet', 'Snapk i'),
(1332, 107, 'fld_3396882', 'message', 'Congratulations on the new website! Get it listed in our directory for more potential. https://cutt.ly/z4iM7ZY'),
(1333, 107, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1334, 107, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1335, 108, 'fld_5462783', 'nom', 'Eric'),
(1336, 108, 'fld_3436924', 'prenom', 'Eric'),
(1337, 108, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1338, 108, 'fld_724362', 'num_tel', '555-555-1212'),
(1339, 108, 'fld_475276', 'socite', 'Kojnc gvnw ug'),
(1340, 108, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1341, 108, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1342, 108, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1343, 108, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1344, 108, 'fld_2695739', 'objet', 'Bwh sar gxas b'),
(1345, 108, 'fld_3396882', 'message', 'To the artus-securite.fr Admin!\r\n\r\nMy name’s Eric and I just came across your website - artus-securite.fr - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like artus-securite.fr will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Web Visitors Into Leads.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to learn more about everything Web Visitors Into Leads can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1346, 108, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1347, 108, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1348, 109, 'fld_5462783', 'nom', 'Unicorn'),
(1349, 109, 'fld_3436924', 'prenom', 'Unicorn'),
(1350, 109, 'fld_2124341', 'adresse_mail', 'medic.cloud42@gmail.com'),
(1351, 109, 'fld_724362', 'num_tel', '06144 90 03 00'),
(1352, 109, 'fld_475276', 'socite', 'Vp zmg Quuy tq'),
(1353, 109, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1354, 109, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1355, 109, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1356, 109, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1357, 109, 'fld_2695739', 'objet', 'P mvrs dv Aml'),
(1358, 109, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nQue feriez-vous avec une liste de prospects B2B RGPD sur mesure ?\r\n\r\nGagner du temps d\\\'acquisition ?\r\n\r\nEt surtout... avoir du trafic vers vos Offres ?\r\n\r\nFaire de GROSSES VENTES à des Entreprises !\r\n\r\nParmi eux, il y a votre futur collaborateur ou votre client à long terme.\r\n\r\nNe passez pas à côté de cette opportunité parce que... si ce n\\\'est pas vous, ce sera peut-être votre concurrent.\r\n\r\nSi vous êtes intéressé, il vous suffit de répondre à cet email.\r\n\r\nCordialement.\r\n\r\nYaelle\r\n--------------------------------------\r\nUnicorn Leads\r\n37 Rue Saint-Francois de Sales, Chambery\r\nFrance\r\n---------------------\r\nmedic.cloud42@gmail.com\r\n\r\nPS: N\\\'oubliez pas qu\\\'un B2B est aussi un B2C ;)\r\n\r\nOn se retrouve de l\\\'autre côté'),
(1359, 109, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1360, 109, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1361, 110, 'fld_5462783', 'nom', 'Eric'),
(1362, 110, 'fld_3436924', 'prenom', 'Eric'),
(1363, 110, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1364, 110, 'fld_724362', 'num_tel', '555-555-1212'),
(1365, 110, 'fld_475276', 'socite', 'Zticvb Q'),
(1366, 110, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1367, 110, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1368, 110, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1369, 110, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1370, 110, 'fld_2695739', 'objet', 'Lfednl S Nqm'),
(1371, 110, 'fld_3396882', 'message', 'Hello artus-securite.fr Webmaster!\r\n\r\nEric here with a quick thought about your website artus-securite.fr...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr'),
(1372, 110, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1373, 110, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1374, 111, 'fld_5462783', 'nom', 'Eric'),
(1375, 111, 'fld_3436924', 'prenom', 'Eric'),
(1376, 111, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1377, 111, 'fld_724362', 'num_tel', '555-555-1212'),
(1378, 111, 'fld_475276', 'socite', 'Rtq N'),
(1379, 111, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1380, 111, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1381, 111, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1382, 111, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1383, 111, 'fld_2695739', 'objet', 'Ubs qla g bf'),
(1384, 111, 'fld_3396882', 'message', 'Hello artus-securite.fr Administrator!\r\n\r\nEric here with a quick thought about your website artus-securite.fr...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr'),
(1385, 111, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1386, 111, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1387, 112, 'fld_5462783', 'nom', 'Eric'),
(1388, 112, 'fld_3436924', 'prenom', 'Eric'),
(1389, 112, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1390, 112, 'fld_724362', 'num_tel', '555-555-1212'),
(1391, 112, 'fld_475276', 'socite', 'Eslcii Kx'),
(1392, 112, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1393, 112, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1394, 112, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1395, 112, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1396, 112, 'fld_2695739', 'objet', 'Cezony'),
(1397, 112, 'fld_3396882', 'message', 'Hi artus-securite.fr Owner! my name’s Eric and I just ran across your website at artus-securite.fr...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1398, 112, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1399, 112, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1400, 113, 'fld_5462783', 'nom', 'Dedours'),
(1401, 113, 'fld_3436924', 'prenom', 'Violette'),
(1402, 113, 'fld_2124341', 'adresse_mail', 'comet.utc@gmail.com'),
(1403, 113, 'fld_724362', 'num_tel', '33 77 87 07 79'),
(1404, 113, 'fld_475276', 'socite', 'Association étudiante COMET'),
(1405, 113, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1406, 113, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(1407, 113, 'fld_2695739', 'objet', 'Sécurité/accueil évènement étudiant'),
(1408, 113, 'fld_3396882', 'message', 'Bonjour,\r\nJe vous contacte au nom de l\\\'association étudiante Comet qui organise des évènements pour les étudiants de l\\\'Université de Technologie de Compiègne.\r\nAfin d\\\'encadrer et assurer l\\\'accueil du prochain évènement, nous aurions besoin de 4 agents de sécurité le mercredi 17 mai 2023 de 19h à 22h devant le centre Benjamin Franklin de l\\\'UTC à Compiègne.\r\nSerait-il possible d\\\'obtenir un devis pour une telle prestation s\\\'il vous plaît?\r\nEn vous remerciant par avance pour votre réponse,\r\nTrès cordialement,\r\nViolette Dedours pour Comet'),
(1409, 113, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1410, 113, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1411, 113, 'fld_3201949', 'envoyer', 'click'),
(1412, 114, 'fld_5462783', 'nom', 'Eric'),
(1413, 114, 'fld_3436924', 'prenom', 'Eric'),
(1414, 114, 'fld_2124341', 'adresse_mail', 'eric.jones.z.mail@gmail.com'),
(1415, 114, 'fld_724362', 'num_tel', '555-555-1212'),
(1416, 114, 'fld_475276', 'socite', 'Iv wjs er u'),
(1417, 114, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1418, 114, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1419, 114, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1420, 114, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1421, 114, 'fld_2695739', 'objet', 'Sfxqcacvoe'),
(1422, 114, 'fld_3396882', 'message', 'Dear artus-securite.fr Admin.\r\n\r\nMy name’s Eric and I just found your site artus-securite.fr.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nWeb Visitors Into Leads – CLICK HERE http://advanceleadgeneration.com for a live demo now.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1423, 114, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1424, 114, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1425, 115, 'fld_5462783', 'nom', 'bayle'),
(1426, 115, 'fld_3436924', 'prenom', 'Georges'),
(1427, 115, 'fld_2124341', 'adresse_mail', 'georgesbayle@hotmail.fr'),
(1428, 115, 'fld_724362', 'num_tel', '06 62 88 49 40'),
(1429, 115, 'fld_475276', 'socite', 'Association '),
(1430, 115, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1431, 115, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1432, 115, 'fld_2695739', 'objet', 'kermesse 1er juillet 2023'),
(1433, 115, 'fld_3396882', 'message', 'bonjour, \r\nje suis membre de l\\\'association de parents d\\\'élèves de l\\\'école sainte jule  5 rue sainte Antoine à Troyes .\r\nj\\\'aimerais avoir un devis pour une prestation le jour de notre Kermesse pour sécuriser l\\\'accès principale.\r\nla personne devra être présente de 11h à 18h  . \r\ndans l\\\'attente cordialement georges BAYLE\r\n'),
(1434, 115, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1435, 115, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1436, 115, 'fld_3201949', 'envoyer', 'click'),
(1437, 116, 'fld_5462783', 'nom', 'Eric'),
(1438, 116, 'fld_3436924', 'prenom', 'Eric'),
(1439, 116, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1440, 116, 'fld_724362', 'num_tel', '555-555-1212'),
(1441, 116, 'fld_475276', 'socite', 'Bdhezdqyvkt'),
(1442, 116, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1443, 116, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1444, 116, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1445, 116, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1446, 116, 'fld_2695739', 'objet', 'Ctmdtj'),
(1447, 116, 'fld_3396882', 'message', 'To the artus-securite.fr Webmaster. my name is Eric and I’m betting you’d like your website artus-securite.fr to generate more leads.\r\n\r\nHere’s how:\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at artus-securite.fr.\r\n\r\nWeb Visitors Into Leads – CLICK HERE https://advanceleadgeneration.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1448, 116, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1449, 116, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1450, 117, 'fld_5462783', 'nom', 'Eric'),
(1451, 117, 'fld_3436924', 'prenom', 'Eric'),
(1452, 117, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1453, 117, 'fld_724362', 'num_tel', '555-555-1212'),
(1454, 117, 'fld_475276', 'socite', 'Iufjx hmf'),
(1455, 117, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1456, 117, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1457, 117, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1458, 117, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1459, 117, 'fld_2695739', 'objet', 'Wzzm V'),
(1460, 117, 'fld_3396882', 'message', 'To the artus-securite.fr Administrator.\r\n\r\nMy name’s Eric and I just ran across your website at artus-securite.fr...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1461, 117, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1462, 117, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1463, 118, 'fld_5462783', 'nom', 'Faith'),
(1464, 118, 'fld_3436924', 'prenom', 'Faith'),
(1465, 118, 'fld_2124341', 'adresse_mail', 'faith.mcdonnell@gmail.com'),
(1466, 118, 'fld_724362', 'num_tel', '229-266-3349'),
(1467, 118, 'fld_475276', 'socite', 'Ggigfg'),
(1468, 118, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1469, 118, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1470, 118, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1471, 118, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1472, 118, 'fld_2695739', 'objet', 'I S knc h D'),
(1473, 118, 'fld_3396882', 'message', 'Cet article explore le phénomène de la théorie de l’attraction au travers de la physique quantique.\r\n\r\n﻿﻿﻿﻿CHAMPS VIBRATOIRES, VORTEX D´ABONDANCE, SINGULARITÉ VIBRATOIRE, \r\n﻿﻿﻿﻿THÉORIE DE L´ATTRACTION...\r\n﻿﻿La physique quantique nous enseigne que des énergies similaires attirent des énergies similaires.\r\nSelon la théorie quantique, le passé est encore lá, et le futur est déjà arrivé. \r\n﻿﻿Le moment présent, lui, se trouverai ailleurs, hors du temps justement.\r\nEt c´est précisément ce que nous allons étudier ici, quel est cette position particulière dans le temps qui permet de générer ce fameux \\\"Vortex\\\" d\\\'abondance.\r\n\r\nCLIQUEZ SUR CE LIEN POUR LIRE L´ARTICLE: \r\nhttps://franckstella2001.systeme.io/175e5a41-fb4918be-a63b9a67-301f4c43-55a07d3f?sa=sa00080915093931cbe4ebc039ba58b7f8621c583811\r\n'),
(1474, 118, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1475, 118, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1476, 119, 'fld_5462783', 'nom', 'NAYRAGUET'),
(1477, 119, 'fld_3436924', 'prenom', 'CYRIL'),
(1478, 119, 'fld_2124341', 'adresse_mail', 'nayraguet.cyril@gmail.com'),
(1479, 119, 'fld_724362', 'num_tel', '06 95 32 13 50'),
(1480, 119, 'fld_475276', 'socite', ' NC'),
(1481, 119, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1482, 119, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(1483, 119, 'fld_2695739', 'objet', 'Réclamation '),
(1484, 119, 'fld_3396882', 'message', 'Madame, Monsieur\r\n\r\nJe me permets de vous écrire pour vous exprimer mon profond mécontement. \r\nEn effet, suite à une urgence il m\\\'a été nécessaire de conduire une personne âgée au Centre Hospitalier de Compiègne. Quelle ne fut pas ma surprise d\\\'être accueilli, des l\\\'entrée, par l\\\'un de vos agents, qui au delà d\\\'être arrogant s\\\'est montré des plus agressif.\r\nCette attitude est des plus dommageable pour votre entreprise. \r\nJ\\\'espère que cela n\\\'est pas une norme au sein de votre société car il serait regrettable de considérer que l\\\'agressivité est le cœur de votre métier. \r\n\r\nVous souhaitant bonne réception. \r\nCordialement \r\n'),
(1485, 119, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1486, 119, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1487, 119, 'fld_3201949', 'envoyer', 'click'),
(1488, 120, 'fld_5462783', 'nom', 'Eric'),
(1489, 120, 'fld_3436924', 'prenom', 'Eric'),
(1490, 120, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1491, 120, 'fld_724362', 'num_tel', '555-555-1212'),
(1492, 120, 'fld_475276', 'socite', 'Cy fbw O R'),
(1493, 120, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1494, 120, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1495, 120, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1496, 120, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1497, 120, 'fld_2695739', 'objet', 'Ofse a adjr ue'),
(1498, 120, 'fld_3396882', 'message', 'To the artus-securite.fr Webmaster.\r\n\r\nMy name’s Eric and I just came across your website - artus-securite.fr - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like artus-securite.fr will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Web Visitors Into Leads.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to learn more about everything Web Visitors Into Leads can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1499, 120, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.');
INSERT INTO `mod284_cf_form_entry_values` (`id`, `entry_id`, `field_id`, `slug`, `value`) VALUES 
(1500, 120, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1501, 121, 'fld_5462783', 'nom', 'Charleux'),
(1502, 121, 'fld_3436924', 'prenom', 'Lucien'),
(1503, 121, 'fld_2124341', 'adresse_mail', 'arena@utt.fr'),
(1504, 121, 'fld_724362', 'num_tel', '07 85 12 25 32'),
(1505, 121, 'fld_475276', 'socite', 'UTt Arena'),
(1506, 121, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1507, 121, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1508, 121, 'fld_2695739', 'objet', 'UTT Arena : demande de devis'),
(1509, 121, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nl\\\'UTT Arena est une compétition de jeux vidéos accueillant plusieurs centaines de joueurs l\\\'espace d\\\'un weekend.\r\nNotre prochaine édition aura lieu les 1, 2 et 3 Décembre et nous souhaitons avoir un devis pour bénéficier en continu (24h/24) de deux agents de sécurité et de deux SSIAP.\r\n\r\nCordialement,\r\nLucien Charleux'),
(1510, 121, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1511, 121, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1512, 121, 'fld_3201949', 'envoyer', 'click'),
(1513, 122, 'fld_5462783', 'nom', 'Eric'),
(1514, 122, 'fld_3436924', 'prenom', 'Eric'),
(1515, 122, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1516, 122, 'fld_724362', 'num_tel', '555-555-1212'),
(1517, 122, 'fld_475276', 'socite', 'Ibf Plwhco'),
(1518, 122, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1519, 122, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1520, 122, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1521, 122, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1522, 122, 'fld_2695739', 'objet', 'Om Ewdekn F'),
(1523, 122, 'fld_3396882', 'message', 'Dear artus-securite.fr Administrator.\r\n\r\nMy name’s Eric and I just came across your website - artus-securite.fr - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like artus-securite.fr will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Web Visitors Into Leads.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Web Visitors Into Leads can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1524, 122, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1525, 122, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1526, 123, 'fld_5462783', 'nom', 'Eric'),
(1527, 123, 'fld_3436924', 'prenom', 'Eric'),
(1528, 123, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1529, 123, 'fld_724362', 'num_tel', '555-555-1212'),
(1530, 123, 'fld_475276', 'socite', 'Wboc'),
(1531, 123, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1532, 123, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1533, 123, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1534, 123, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1535, 123, 'fld_2695739', 'objet', 'Kg q c'),
(1536, 123, 'fld_3396882', 'message', 'Hello artus-securite.fr Administrator. my name’s Eric and I just ran across your website at artus-securite.fr...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1537, 123, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1538, 123, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1539, 124, 'fld_5462783', 'nom', 'Katy'),
(1540, 124, 'fld_3436924', 'prenom', 'Katy'),
(1541, 124, 'fld_2124341', 'adresse_mail', 'katytrilly9@gmail.com'),
(1542, 124, 'fld_724362', 'num_tel', '978-552-2580'),
(1543, 124, 'fld_475276', 'socite', 'Ri Nvep'),
(1544, 124, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1545, 124, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1546, 124, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1547, 124, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1548, 124, 'fld_2695739', 'objet', 'Yugrkbt P'),
(1549, 124, 'fld_3396882', 'message', 'Hi,\r\n\r\nWe\\\'d like to introduce to you our explainer video service, which we feel can benefit your site artus-securite.fr.\r\n\r\nCheck out some of our existing videos here:\r\nhttps://www.youtube.com/watch?v=bWz-ELfJVEI\r\nhttps://www.youtube.com/watch?v=Y46aNG-Y3rM\r\nhttps://www.youtube.com/watch?v=hJCFX1AjHKk\r\n\r\nAll of our videos are in a similar animated format as the above examples, and we have voice over artists with US/UK/Australian accents.\r\nWe can also produce voice overs in languages other than English.\r\n\r\nThey can show a solution to a problem or simply promote one of your products or services. They are concise, can be uploaded to video sites such as YouTube, and can be embedded into your website or featured on landing pages.\r\n\r\nOur prices are as follows depending on video length:\r\nUp to 1 minute = $239\r\n1-2 minutes = $339\r\n2-3 minutes = $439\r\n\r\n*All prices above are in USD and include a full script, voice-over and video.\r\n\r\nIf this is something you would like to discuss further, don\\\'t hesitate to reply.\r\n\r\nKind Regards,\r\nKaty'),
(1550, 124, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1551, 124, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1552, 125, 'fld_5462783', 'nom', 'Eric'),
(1553, 125, 'fld_3436924', 'prenom', 'Eric'),
(1554, 125, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1555, 125, 'fld_724362', 'num_tel', '555-555-1212'),
(1556, 125, 'fld_475276', 'socite', 'Rtgwfcssli tbg'),
(1557, 125, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1558, 125, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1559, 125, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1560, 125, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1561, 125, 'fld_2695739', 'objet', 'Gymhu'),
(1562, 125, 'fld_3396882', 'message', 'Hello artus-securite.fr Administrator.\r\n\r\nMy name’s Eric and I just found your site artus-securite.fr.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nWeb Visitors Into Leads – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr'),
(1563, 125, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1564, 125, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1565, 126, 'fld_5462783', 'nom', 'Eric'),
(1566, 126, 'fld_3436924', 'prenom', 'Eric'),
(1567, 126, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1568, 126, 'fld_724362', 'num_tel', '555-555-1212'),
(1569, 126, 'fld_475276', 'socite', 'Q ltrvfnxm'),
(1570, 126, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1571, 126, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1572, 126, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1573, 126, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1574, 126, 'fld_2695739', 'objet', 'Bp ua hr sxcod'),
(1575, 126, 'fld_3396882', 'message', 'To the artus-securite.fr Administrator! my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at artus-securite.fr.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1576, 126, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1577, 126, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1578, 127, 'fld_5462783', 'nom', 'Eric'),
(1579, 127, 'fld_3436924', 'prenom', 'Eric'),
(1580, 127, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1581, 127, 'fld_724362', 'num_tel', '555-555-1212'),
(1582, 127, 'fld_475276', 'socite', 'Lfqciqbd'),
(1583, 127, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1584, 127, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1585, 127, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1586, 127, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1587, 127, 'fld_2695739', 'objet', 'Zvcj Ew ombxa'),
(1588, 127, 'fld_3396882', 'message', 'Hi artus-securite.fr Administrator! my name is Eric and I’m betting you’d like your website artus-securite.fr to generate more leads.\r\n\r\nHere’s how:\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at artus-securite.fr.\r\n\r\nWeb Visitors Into Leads – CLICK HERE https://advanceleadgeneration.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1589, 127, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1590, 127, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1591, 128, 'fld_5462783', 'nom', 'Marcelo'),
(1592, 128, 'fld_3436924', 'prenom', 'Marcelo'),
(1593, 128, 'fld_2124341', 'adresse_mail', 'info@simpsonshop.fr'),
(1594, 128, 'fld_724362', 'num_tel', '+33752051172'),
(1595, 128, 'fld_475276', 'socite', 'Rviyqv eze'),
(1596, 128, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1597, 128, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1598, 128, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1599, 128, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1600, 128, 'fld_2695739', 'objet', 'Rr oopuq em'),
(1601, 128, 'fld_3396882', 'message', 'Hello'),
(1602, 128, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1603, 128, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1604, 129, 'fld_5462783', 'nom', 'Eric'),
(1605, 129, 'fld_3436924', 'prenom', 'Eric'),
(1606, 129, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1607, 129, 'fld_724362', 'num_tel', '555-555-1212'),
(1608, 129, 'fld_475276', 'socite', 'Ray uq gi'),
(1609, 129, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1610, 129, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1611, 129, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1612, 129, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1613, 129, 'fld_2695739', 'objet', 'Ex pjg B fzks'),
(1614, 129, 'fld_3396882', 'message', 'Hello artus-securite.fr Webmaster. my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at artus-securite.fr.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1615, 129, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1616, 129, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1617, 130, 'fld_5462783', 'nom', 'Marc'),
(1618, 130, 'fld_3436924', 'prenom', 'Marc'),
(1619, 130, 'fld_2124341', 'adresse_mail', 'prestataire@unplanfacile.com'),
(1620, 130, 'fld_724362', 'num_tel', '0600000000'),
(1621, 130, 'fld_475276', 'socite', 'Un Plan Facile'),
(1622, 130, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1623, 130, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1624, 130, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1625, 130, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1626, 130, 'fld_2695739', 'objet', 'Une collaboration gagnant-gagnant'),
(1627, 130, 'fld_3396882', 'message', 'Bonjour, je tiens à vous exprimer mes félicitations pour la qualité de votre site et à vous proposer une offre intéressante. Nous aimerions publier un article rédigé par un professionnel sur votre site, qui met en avant notre plateforme \\\"Un plan facile\\\". Cette collaboration sera récompensée par un système d\\\'affiliation, où vous pourrez bénéficier d\\\'une commission de 20% sur chaque vente générée par cet article. Vous recevrez également nos exclusivités gratuitement. Notre objectif est d\\\'établir une relation de partenariat solide avec vous. De plus, nous afficherons votre logo et un lien vers votre site sur notre plateforme. \r\nAvec plus de 47 000 visiteurs quotidiens en France, ce backlink peut améliorer considérablement votre référencement naturel sur les moteurs de recherche. Si notre proposition vous intéresse, je vous invite à vous inscrire sur notre page d\\\'affiliation (https://unplanfacile.com/affiliation/). \r\nJe procéderai personnellement à la validation de votre compte et vous enverrai un article ainsi qu\\\'une photo à publier sur votre site. Si vous ne vous sentez pas à l\\\'aise avec l\\\'informatique, je me ferai un plaisir de gérer cela pour vous.\r\nNous vous prions de bien vouloir noter que cette boîte mail n\\\'est pas consultée. Si vous avez des questions, nous vous invitons à nous contacter en envoyant un mail à information@unplanfacile.com\r\nCordialement,\r\n\r\nMarc Michelet\r\nLien affiliation : https://unplanfacile.com/affiliation/'),
(1628, 130, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1629, 130, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1630, 131, 'fld_5462783', 'nom', 'AI Content'),
(1631, 131, 'fld_3436924', 'prenom', 'AI Content'),
(1632, 131, 'fld_2124341', 'adresse_mail', 'darley.hermelinda87@gmail.com'),
(1633, 131, 'fld_724362', 'num_tel', '(02) 4080 6291'),
(1634, 131, 'fld_475276', 'socite', 'Akqc'),
(1635, 131, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1636, 131, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1637, 131, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1638, 131, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1639, 131, 'fld_2695739', 'objet', 'T A E ltvki'),
(1640, 131, 'fld_3396882', 'message', 'Want to generate high-quality content fast and efficiently? \r\n\r\nIntroducing the Ultimate AI Content Writer that passes AI detections with flying colors! \r\nGet prepared to create UNLIMITED content which appears to be authentic using AI, without sacrificing the quality of your writing. \r\n \r\nClick here:  https://tinyurl.com/yvjt9fam\r\n\r\nBoost your efficiency and save your time by writing 750K words per month for only! \r\nOur content writing software includes: \r\n \r\n- Topic and Idea Generator: Eliminate writer\\\'s block, get amazing topics for your copy in seconds. \r\n- Optimization for Video SEO: Boost your SEO with optimized video content. \r\n- Paste URL & Write With AI: Write copy more quickly with just copying and pasting the link and letting our content writing software handle the work. \r\n- People Also Ask AI Writer: Receive great copy topics with the PAA feature and create high-quality content more quickly. \r\n- AI-assisted Writing for Testimonials and Reviews: Make client\\\'s testimonials and reviews more effective with our AI writing tool that writes amazing feedback faster. \r\n- AI-assisted Writing for Web Pages: Generate website copy faster with the content writing software that writes amazing website copy in seconds. \r\n \r\nDo not delay! Sign up for our Most Powerful AI Content Writer today and start generating high-quality content more quickly than ever before!\r\n\r\nStart today!  https://tinyurl.com/yvjt9fam'),
(1641, 131, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1642, 131, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1643, 132, 'fld_5462783', 'nom', 'Eric'),
(1644, 132, 'fld_3436924', 'prenom', 'Eric'),
(1645, 132, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1646, 132, 'fld_724362', 'num_tel', '555-555-1212'),
(1647, 132, 'fld_475276', 'socite', 'Z Szlr xun er'),
(1648, 132, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1649, 132, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1650, 132, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1651, 132, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1652, 132, 'fld_2695739', 'objet', 'Bgrjst Gmwtf'),
(1653, 132, 'fld_3396882', 'message', 'Hello artus-securite.fr Webmaster.\r\n\r\nMy name is Eric and I’m betting you’d like your website artus-securite.fr to generate more leads.\r\n\r\nHere’s how:\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at artus-securite.fr.\r\n\r\nWeb Visitors Into Leads – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1654, 132, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1655, 132, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1656, 133, 'fld_5462783', 'nom', 'Expired'),
(1657, 133, 'fld_3436924', 'prenom', 'Expired'),
(1658, 133, 'fld_2124341', 'adresse_mail', 'vernita.gay@outlook.com'),
(1659, 133, 'fld_724362', 'num_tel', '22-58-26-94'),
(1660, 133, 'fld_475276', 'socite', 'G jdlutsq'),
(1661, 133, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1662, 133, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1663, 133, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1664, 133, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1665, 133, 'fld_2695739', 'objet', 'Uybyeluo'),
(1666, 133, 'fld_3396882', 'message', 'Greetings!\r\n\r\nDo you need the top-notch expired domains available?\r\nSearch no more, because we has got you covered! We are dedicated to raising the standard of expired domains and making an impact in the market. And the best part is, we always deliver what we promise!\r\n\r\nhttps://tinyurl.com/yuzcetvd\r\n\r\nWith more than 100,000 domains expiring daily, we understand that finding top-quality expired domains can be a struggle. No need to worry we have got you covered!\r\nWe identify the best expired domains while adhering to strict quality check processes. As a result, you can rest assured that you will get the best possible expired domain names to boost your brand.\r\n\r\nSo why wait? Reach out to Domain Coasters as soon as possible and let us help you discover the best expired domains in the industry!\r\n\r\nhttps://tinyurl.com/yuzcetvd'),
(1667, 133, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1668, 133, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1669, 134, 'fld_5462783', 'nom', 'Jamel'),
(1670, 134, 'fld_3436924', 'prenom', 'Jamel'),
(1671, 134, 'fld_2124341', 'adresse_mail', 'banning.jamel@outlook.com'),
(1672, 134, 'fld_724362', 'num_tel', '08705 65 23 27'),
(1673, 134, 'fld_475276', 'socite', 'Pm Bxcqldia'),
(1674, 134, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1675, 134, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1676, 134, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1677, 134, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1678, 134, 'fld_2695739', 'objet', 'Df E Cizict'),
(1679, 134, 'fld_3396882', 'message', 'Le système complet pour « copier » légalement et éthiquement un business qui cartonne pour ajouter jusqu’à 10 000€ à votre compte en seulement 28 jours. \r\n\r\nDécomposé en plusieurs étapes, ce système clé en main est accessible à tout entrepreneur doté de bon sens, de détermination et de volonté. \r\n\r\nVoici le plan :\r\n\r\n- Jours 1 à 3 : chercher un funnel « mimétisable » et construire l’avatar client. \r\n- Jours 4 à 6 : créer (ou faire créer) le produit. \r\n- Jours 7 à 14 : rédiger un texte de vente (scripts fournis !) et assembler un tunnel de vente rapidement.\r\n- Jours 15 à 28 : mise en vente (sans se faire censurer). \r\n- Jour 29, le jour d’après : optimiser le business et construire une machine à cash !\r\n\r\nJe vous laisse lire cette page ici :\r\n\r\nhttps://go.hotmart.com/C72900589I'),
(1680, 134, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1681, 134, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1682, 135, 'fld_5462783', 'nom', 'Carla'),
(1683, 135, 'fld_3436924', 'prenom', 'Carla'),
(1684, 135, 'fld_2124341', 'adresse_mail', 'pehihaw180@netfxd.com'),
(1685, 135, 'fld_724362', 'num_tel', '01.82.70.73.69'),
(1686, 135, 'fld_475276', 'socite', 'Ef xinh Imsyip'),
(1687, 135, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1688, 135, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1689, 135, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1690, 135, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1691, 135, 'fld_2695739', 'objet', 'Jhe iwdu'),
(1692, 135, 'fld_3396882', 'message', 'Hi,\r\n\r\nYour website is only listed in 8 out of a possible 12,489 directories.\r\n\r\nWe are a service that lists your website in all these directories.\r\n\r\nPlease visit us on DirectoryBump.com to find our more.\r\n\r\nRegards,\r\nCarla Brack'),
(1693, 135, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1694, 135, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1695, 136, 'fld_5462783', 'nom', 'Eric'),
(1696, 136, 'fld_3436924', 'prenom', 'Eric'),
(1697, 136, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1698, 136, 'fld_724362', 'num_tel', '555-555-1212'),
(1699, 136, 'fld_475276', 'socite', 'Mdlnwtdve d'),
(1700, 136, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1701, 136, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1702, 136, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1703, 136, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1704, 136, 'fld_2695739', 'objet', 'Qq b dxt k'),
(1705, 136, 'fld_3396882', 'message', 'Hi artus-securite.fr Admin. Eric here with a quick thought about your website artus-securite.fr...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n\r\n'),
(1706, 136, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1707, 136, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1708, 137, 'fld_5462783', 'nom', 'Eric'),
(1709, 137, 'fld_3436924', 'prenom', 'Eric'),
(1710, 137, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1711, 137, 'fld_724362', 'num_tel', '555-555-1212'),
(1712, 137, 'fld_475276', 'socite', 'X ptmv mudca'),
(1713, 137, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1714, 137, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1715, 137, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1716, 137, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1717, 137, 'fld_2695739', 'objet', 'Bym f Xzy zs t'),
(1718, 137, 'fld_3396882', 'message', 'Hi artus-securite.fr Webmaster. this is Eric and I ran across artus-securite.fr a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1719, 137, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1720, 137, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1721, 138, 'fld_5462783', 'nom', 'Eric'),
(1722, 138, 'fld_3436924', 'prenom', 'Eric'),
(1723, 138, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1724, 138, 'fld_724362', 'num_tel', '555-555-1212'),
(1725, 138, 'fld_475276', 'socite', 'S Er'),
(1726, 138, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1727, 138, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1728, 138, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1729, 138, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1730, 138, 'fld_2695739', 'objet', 'Szsjpiyd'),
(1731, 138, 'fld_3396882', 'message', 'Hi artus-securite.fr Webmaster!\r\n\r\nMy name’s Eric and I just came across your website - artus-securite.fr - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like artus-securite.fr will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Web Visitors Into Leads.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to learn more about everything Web Visitors Into Leads can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1732, 138, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1733, 138, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1734, 139, 'fld_5462783', 'nom', 'Eric'),
(1735, 139, 'fld_3436924', 'prenom', 'Eric'),
(1736, 139, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1737, 139, 'fld_724362', 'num_tel', '555-555-1212'),
(1738, 139, 'fld_475276', 'socite', 'Zhgexur'),
(1739, 139, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1740, 139, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1741, 139, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1742, 139, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1743, 139, 'fld_2695739', 'objet', 'Dbtd eoq pgzta'),
(1744, 139, 'fld_3396882', 'message', 'Dear artus-securite.fr Owner. my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at artus-securite.fr.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1745, 139, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.');
INSERT INTO `mod284_cf_form_entry_values` (`id`, `entry_id`, `field_id`, `slug`, `value`) VALUES 
(1746, 139, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1747, 140, 'fld_5462783', 'nom', 'Rosalyn'),
(1748, 140, 'fld_3436924', 'prenom', 'Rosalyn'),
(1749, 140, 'fld_2124341', 'adresse_mail', 'rosalyn.kiernan@gmail.com'),
(1750, 140, 'fld_724362', 'num_tel', '0393 8917146'),
(1751, 140, 'fld_475276', 'socite', 'Ojmozkl Eajo'),
(1752, 140, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1753, 140, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1754, 140, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1755, 140, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1756, 140, 'fld_2695739', 'objet', 'Ic O sjyh W'),
(1757, 140, 'fld_3396882', 'message', 'Congratulations! Your website https://artus-securite.fr/contactdevis/ has been approved for submission to our directory. Enjoy lots of targeted traffic to your site for free! Visit: https://bit.ly/3oBT41j'),
(1758, 140, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1759, 140, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1760, 141, 'fld_5462783', 'nom', 'Katrina'),
(1761, 141, 'fld_3436924', 'prenom', 'Katrina'),
(1762, 141, 'fld_2124341', 'adresse_mail', 'katrina.yamada@hotmail.com'),
(1763, 141, 'fld_724362', 'num_tel', '081 207 38 88'),
(1764, 141, 'fld_475276', 'socite', 'Qad mfc'),
(1765, 141, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1766, 141, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1767, 141, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1768, 141, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1769, 141, 'fld_2695739', 'objet', 'X bfa shnet'),
(1770, 141, 'fld_3396882', 'message', 'Bid farewell to gambling your advertising funds, we promise tangible results! Visit: https://bit.ly/45C9SWD'),
(1771, 141, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1772, 141, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1773, 142, 'fld_5462783', 'nom', 'Larue'),
(1774, 142, 'fld_3436924', 'prenom', 'Larue'),
(1775, 142, 'fld_2124341', 'adresse_mail', 'casas.larue@gmail.com'),
(1776, 142, 'fld_724362', 'num_tel', '04971 92 95 99'),
(1777, 142, 'fld_475276', 'socite', 'E Jpwje'),
(1778, 142, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1779, 142, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1780, 142, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1781, 142, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1782, 142, 'fld_2695739', 'objet', 'Au I q'),
(1783, 142, 'fld_3396882', 'message', 'We provide Google reviews, trustpilot reviews, country targeted website visitors, social media services,\r\nWebsite Traffic, SEO Services, Backlinks, Classified ADS, Social Followers etc.\r\n\r\nIf you are interested then please visit our website.\r\n\r\nhttps://www.websboost.com/\r\n\r\n\r\nThanks\r\nWebs Boost'),
(1784, 142, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1785, 142, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1786, 143, 'fld_5462783', 'nom', 'LECLERCQ'),
(1787, 143, 'fld_3436924', 'prenom', 'SEBASTIEN'),
(1788, 143, 'fld_2124341', 'adresse_mail', 'seb-leclercq@laposte.net'),
(1789, 143, 'fld_724362', 'num_tel', '06 19 88 83 02'),
(1790, 143, 'fld_6078931', 'agence_souhait.opt1916226', 'Hauts-de-France '),
(1791, 143, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(1792, 143, 'fld_6078931', 'agence_souhait.opt1109492', 'Est Champagne Ardenne '),
(1793, 143, 'fld_6078931', 'agence_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1794, 143, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-LECLERCQ-ssiap1-aps.pdf'),
(1795, 143, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/LdM.pdf'),
(1796, 143, 'fld_3396882', 'message', 'Madame, Monsieur,\r\n\r\nVous trouverez ci-joint mon CV et ma lettre de motivation.\r\n\r\nCordialement,\r\nM. LECLERCQ'),
(1797, 143, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1798, 143, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1799, 143, 'fld_3201949', 'envoyer', 'click'),
(1800, 144, 'fld_5462783', 'nom', 'Eric'),
(1801, 144, 'fld_3436924', 'prenom', 'Eric'),
(1802, 144, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1803, 144, 'fld_724362', 'num_tel', '555-555-1212'),
(1804, 144, 'fld_475276', 'socite', 'Bvh pydbjh gp'),
(1805, 144, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1806, 144, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1807, 144, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1808, 144, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1809, 144, 'fld_2695739', 'objet', 'Cmynof x C'),
(1810, 144, 'fld_3396882', 'message', 'Dear artus-securite.fr Webmaster.\r\n\r\nMy name’s Eric and I just came across your website - artus-securite.fr - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like artus-securite.fr will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Web Visitors Into Leads.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to learn more about everything Web Visitors Into Leads can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1811, 144, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1812, 144, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1813, 145, 'fld_5462783', 'nom', 'Wagner'),
(1814, 145, 'fld_3436924', 'prenom', 'Emmanuel'),
(1815, 145, 'fld_2124341', 'adresse_mail', 'man.wagner71@gmail.com'),
(1816, 145, 'fld_724362', 'num_tel', '07 68 60 19 09'),
(1817, 145, 'fld_6078931', 'agence_souhait.opt1916226', 'Hauts-de-France '),
(1818, 145, 'fld_6078931', 'agence_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(1819, 145, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/cv-manu-2022-correct.pdf'),
(1820, 145, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Lettre-a-jour-.pdf'),
(1821, 145, 'fld_3396882', 'message', 'Bonjour \r\nJe serais désireux d’intégrer votre société \r\n\r\nCordialement '),
(1822, 145, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1823, 145, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1824, 145, 'fld_3201949', 'envoyer', 'click'),
(1825, 146, 'fld_5462783', 'nom', 'MATHURIN'),
(1826, 146, 'fld_3436924', 'prenom', 'Morgane'),
(1827, 146, 'fld_2124341', 'adresse_mail', 'mathurin.morgane@gmail.com'),
(1828, 146, 'fld_724362', 'num_tel', '07 72 32 25 84'),
(1829, 146, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(1830, 146, 'fld_6078931', 'agence_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(1831, 146, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV_MATHURIN_Morgane_BUT-1-GEA.pdf'),
(1832, 146, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/LM_MATHURIN_Morgane_Artus-Securite-Protection.pdf'),
(1833, 146, 'fld_3396882', 'message', 'Objet : Candidature spontanée Stage en Comptabilité - 4 semaines - Disponibilité immédiate\r\n\r\nBonjour,\r\n\r\nJe m\\\'appelle Morgane MATHURIN et je suis étudiante en première année de BUT Gestion des Entreprises et des Administrations. Dans le cadre de ma formation, j\\\'ai l\\\'opportunité d\\\'effectuer un stage et je souhaiterais donc vous adresser ma candidature pour un stage en Comptabilité au sein de votre entreprise pour une durée de 4 semaines. \r\n\r\nCordialement,\r\n\r\nMorgane MATHURIN'),
(1834, 146, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1835, 146, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1836, 146, 'fld_3201949', 'envoyer', 'click'),
(1837, 147, 'fld_5462783', 'nom', 'schiff'),
(1838, 147, 'fld_3436924', 'prenom', 'anthony'),
(1839, 147, 'fld_2124341', 'adresse_mail', 'a.schiff@hotmail.fr'),
(1840, 147, 'fld_724362', 'num_tel', '06 58 62 00 32'),
(1841, 147, 'fld_6078931', 'agence_souhait.opt1916226', 'Hauts-de-France '),
(1842, 147, 'fld_6078931', 'agence_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(1843, 147, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/C.V-agent-de-securite-SCHIFF-Anthony.pdf'),
(1844, 147, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/lettre-de-presentation-SCHIFF-Anthony.pdf'),
(1845, 147, 'fld_3396882', 'message', 'Ayant renouvelé mon CQP APS il y a peu et étant à la recherche d\\\'un emploi, je vous \r\nprie de bien vouloir trouver ci-joint mon CV. Je souhaite postuler pour tout poste que \r\nvous pourrez me proposer dans le secteur de Compiègne.'),
(1846, 147, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1847, 147, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1848, 147, 'fld_3201949', 'envoyer', 'click'),
(1849, 148, 'fld_5462783', 'nom', 'Maryanne'),
(1850, 148, 'fld_3436924', 'prenom', 'Maryanne'),
(1851, 148, 'fld_2124341', 'adresse_mail', 'alder.maryanne@gmail.com'),
(1852, 148, 'fld_724362', 'num_tel', '403-257-4788'),
(1853, 148, 'fld_475276', 'socite', 'W fvkrs'),
(1854, 148, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1855, 148, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1856, 148, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1857, 148, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1858, 148, 'fld_2695739', 'objet', 'Vebqtd Dpe'),
(1859, 148, 'fld_3396882', 'message', 'Hey Fellow Business Owner,\r\n\r\nHope this message finds you crushing it in the online marketing game. I\\\'ve got something epic to share with you today that\\\'ll blow your mind and take your Google My Business (GMB) domination to a whole new level. Buckle up, my friend, because it\\\'s time to introduce you to CTR Booster (https://bit.ly/3WlqCMM) – the ultimate weapon for click-through rate optimization.\r\n\r\nYou know how crucial it is to make your GMB listing stand out, right? Well, get ready to leave your competitors in the dust. CTR Booster, developed by the geniuses at Turboware.net, is designed to skyrocket your click-through rate and make your GMB listing the irresistible choice for potential customers.\r\n\r\nCheck out the insane benefits of adding CTR Booster to your SEO arsenal:\r\n\r\nCrush Your CTR Records: CTR Booster employs wickedly advanced algorithms and battle-tested strategies to optimize your click-through rate on GMB. Kiss average CTRs goodbye, my friend. Get ready to shatter your KPI\\\'s and watch as your listing climbs to the top, leaving competitors scratching their heads.\r\n\r\nOutrank and Outshine: Time to go from average Joe to SEO superhero. With CTR Booster, you can outperform your competitors, leaving them in the dust. Manipulate that click-through rate like a boss and secure top rankings on GMB. You\\\'ll become the local legend everyone looks up to, while others wonder how the heck you did it.\r\n\r\nTraffic Galore: Picture this – a stampede of highly targeted traffic rushing to your business. CTR Booster makes it happen. By optimizing your click-through rate, you\\\'ll attract a swarm of potential customers who can\\\'t resist clicking on your listing. Get ready to welcome more foot traffic, more inquiries, and more sales than ever before.\r\n\r\nNow, here\\\'s the kicker. I\\\'ve managed to score you an exclusive 30% discount on CTR Booster (https://bit.ly/3WlqCMM). That\\\'s right, my friend, a whopping 30% off to unlock the true power of click-through rate manipulation. Just click on this link now (https://bit.ly/3WlqCMM) to claim your copy of CTR Booster and lock in your low price.\r\n\r\nDon\\\'t let this opportunity slip through your fingers. Take action now and grab your unfair advantage in the SEO game. Head over to our website [https://bit.ly/3WlqCMM] to learn more about CTR Booster and secure your copy today. And hey, if you\\\'ve got any questions or need ninja-level support, my team is ready to rock and roll.\r\n\r\nPrepare to dominate GMB like never before with CTR Booster. Don\\\'t forget to use promo code BOOST30 to claim your 30% discount!\r\n\r\nCheers,\r\n\r\nSEO Enthusiast and Traffic Ninja\r\nCTR Booster Sales Rep\r\nMax Winters'),
(1860, 148, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1861, 148, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1862, 149, 'fld_5462783', 'nom', 'Megan'),
(1863, 149, 'fld_3436924', 'prenom', 'Megan'),
(1864, 149, 'fld_2124341', 'adresse_mail', 'meganatkinson352@gmail.com'),
(1865, 149, 'fld_724362', 'num_tel', '(08) 9049 2205'),
(1866, 149, 'fld_475276', 'socite', 'Hgizn Ca Zxgt'),
(1867, 149, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1868, 149, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1869, 149, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1870, 149, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1871, 149, 'fld_2695739', 'objet', 'Pafuf'),
(1872, 149, 'fld_3396882', 'message', 'Hi there,\r\n\r\nWe run an Instagram growth service, which increases your number of followers both safely and practically. \r\n\r\n- We guarantee to gain you 400-1000+ followers per month.\r\n- People follow you because they are interested in you, increasing likes, comments and interaction.\r\n- All actions are made manually by our team. We do not use any \\\'bots\\\'.\r\n\r\nThe price is just $60 (USD) per month, and we can start immediately.\r\n\r\nIf you\\\'d like to see some of our previous work, let me know, and we can discuss it further.\r\n\r\nKind Regards,\r\nMegan'),
(1873, 149, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1874, 149, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1875, 150, 'fld_5462783', 'nom', 'Eric'),
(1876, 150, 'fld_3436924', 'prenom', 'Eric'),
(1877, 150, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1878, 150, 'fld_724362', 'num_tel', '555-555-1212'),
(1879, 150, 'fld_475276', 'socite', 'Xwb V Xlvs'),
(1880, 150, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1881, 150, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1882, 150, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1883, 150, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1884, 150, 'fld_2695739', 'objet', 'Lsufpy'),
(1885, 150, 'fld_3396882', 'message', 'To the artus-securite.fr Admin!\r\n\r\nMy name’s Eric and I just found your site artus-securite.fr.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nWeb Visitors Into Leads – CLICK HERE https://advanceleadgeneration.com for a live demo now.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1886, 150, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1887, 150, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1888, 151, 'fld_5462783', 'nom', 'Pattie'),
(1889, 151, 'fld_3436924', 'prenom', 'Pattie'),
(1890, 151, 'fld_2124341', 'adresse_mail', 'raul.edwin@gmail.com'),
(1891, 151, 'fld_724362', 'num_tel', '078 8037 7413'),
(1892, 151, 'fld_475276', 'socite', 'U R e'),
(1893, 151, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1894, 151, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1895, 151, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1896, 151, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1897, 151, 'fld_2695739', 'objet', 'E Npinw'),
(1898, 151, 'fld_3396882', 'message', 'Hi owner of artus-securite.fr\r\n\r\n\r\nWe are currently recruiting new beginner paid online writers from your country.\r\n\r\nA number of Amazon stores on our platform are hiring assistants to help with simple writing tasks. These positions are open to anyone with moderate English skills, but we are particularly short of candidates from your country.\r\n\r\nThese are remote positions, meaning that as long as you can work the required hours, you can work from home. The businesses that hire our members are all looking for new remote workers who don’t need experience but are willing to learn.\r\n\r\nClick here to complete your application if you are interested: https://www.trustne.com/writingjobs .  \r\n\r\nWhat you will be doing: Your job will be to write simple descriptions for various products being added to Amazon stores. This is as simple as writing a few bullet points based on the information given by the client. You will be supplied with all the information needed, plus clear instructions on what to do.\r\n\r\nContract length: No fixed term\r\n\r\nRate: $30 per hour (Depending on the type of job and experience)\r\n\r\nSkills/background needed: To qualify to apply, you must:\r\n\r\n- Have access to a phone or laptop\r\n\r\n- Be able to work independently\r\n\r\n- Read and write English at least a basic level\r\n\r\n- Be ready to follow provided steps and instructions\r\n\r\n- Want to work at least 5 hours per week\r\n\r\n- Have a reliable internet connection\r\n\r\nHours per week: Flexible\r\n\r\nLocation: You can work online from your country.\r\n\r\nWe are currently expanding the number of remote workers for these positions significantly. If you can start right away, please apply below.\r\n\r\nClick here to complete your application now: https://www.trustne.com/writingjobs . \r\n\r\nLooking out for you, \r\n\r\n\r\nPattie\r\n\r\n(The relationship between Trustne and Paidonlinewritingjobs is a partnership, we are two separate companies.)\r\nUNSUBSCRIBE: https://www.trustne.com/unsubscribe'),
(1899, 151, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1900, 151, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1901, 152, 'fld_5462783', 'nom', 'Eric'),
(1902, 152, 'fld_3436924', 'prenom', 'Eric'),
(1903, 152, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1904, 152, 'fld_724362', 'num_tel', '555-555-1212'),
(1905, 152, 'fld_475276', 'socite', 'J zwx A'),
(1906, 152, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1907, 152, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1908, 152, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1909, 152, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1910, 152, 'fld_2695739', 'objet', 'Z Gjkdgs'),
(1911, 152, 'fld_3396882', 'message', 'Hi artus-securite.fr Administrator. my name is Eric and I’m betting you’d like your website artus-securite.fr to generate more leads.\r\n\r\nHere’s how:\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at artus-securite.fr.\r\n\r\nWeb Visitors Into Leads – CLICK HERE http://advanceleadgeneration.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1912, 152, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1913, 152, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1914, 153, 'fld_5462783', 'nom', 'Eric'),
(1915, 153, 'fld_3436924', 'prenom', 'Eric'),
(1916, 153, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1917, 153, 'fld_724362', 'num_tel', '555-555-1212'),
(1918, 153, 'fld_475276', 'socite', 'Ik E E'),
(1919, 153, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1920, 153, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1921, 153, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1922, 153, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1923, 153, 'fld_2695739', 'objet', 'Pd Twvb'),
(1924, 153, 'fld_3396882', 'message', 'Dear artus-securite.fr Admin!\r\n\r\nThis is Eric and I ran across artus-securite.fr a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1925, 153, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1926, 153, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1927, 154, 'fld_5462783', 'nom', 'BOUTAIEBI'),
(1928, 154, 'fld_3436924', 'prenom', 'Kamel'),
(1929, 154, 'fld_2124341', 'adresse_mail', 'k.boutaiebi@gmail.com'),
(1930, 154, 'fld_724362', 'num_tel', '07 66 65 14 82'),
(1931, 154, 'fld_6078931', 'agence_souhait.opt1109492', 'Est Champagne Ardenne '),
(1932, 154, 'fld_6078931', 'agence_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1933, 154, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/BOUTAIEBIKamelCV.pdf'),
(1934, 154, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/BOUTAIEBIKamelCV.pdf'),
(1935, 154, 'fld_3396882', 'message', 'Bonjour ,\r\n\r\nJe souhaite postuler pour le poste d\\\'agent de sécurité ayant une belle expérience au seins de l\\\'armée de terre j\\\'ai pu développer plus compétence qui pourront être intéressant pour votre entreprise je suis quelqu\\\'un de sérieux et plein d\\\'envie dans ce que j\\\'entreprend .\r\n\r\nÉtant disponible à partir du 31 août 2023 je reste à disposition pour un éventuel entretien.\r\n\r\nCordialement ,\r\n\r\n                                BOUTAIEBI Kamel\r\n                                0766651482'),
(1936, 154, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1937, 154, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1938, 154, 'fld_3201949', 'envoyer', 'click'),
(1939, 155, 'fld_5462783', 'nom', 'Eric'),
(1940, 155, 'fld_3436924', 'prenom', 'Eric'),
(1941, 155, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1942, 155, 'fld_724362', 'num_tel', '555-555-1212'),
(1943, 155, 'fld_475276', 'socite', 'Cad g'),
(1944, 155, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1945, 155, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1946, 155, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1947, 155, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1948, 155, 'fld_2695739', 'objet', 'Skwwxit rkwm'),
(1949, 155, 'fld_3396882', 'message', 'Hi artus-securite.fr Webmaster. my name is Eric and I’m betting you’d like your website artus-securite.fr to generate more leads.\r\n\r\nHere’s how:\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at artus-securite.fr.\r\n\r\nWeb Visitors Into Leads – CLICK HERE https://advanceleadgeneration.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1950, 155, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1951, 155, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1952, 156, 'fld_5462783', 'nom', 'Heath'),
(1953, 156, 'fld_3436924', 'prenom', 'Heath'),
(1954, 156, 'fld_2124341', 'adresse_mail', 'mas@123bricolage.fr'),
(1955, 156, 'fld_724362', 'num_tel', '619-337-1479'),
(1956, 156, 'fld_475276', 'socite', 'Qs Dg'),
(1957, 156, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1958, 156, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1959, 156, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1960, 156, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1961, 156, 'fld_2695739', 'objet', 'Lgtxtwuwuj'),
(1962, 156, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nJe m\\\'appelle Medali S. et je suis le responsable du développement de deux sites web bien établis, 123bricolage.fr (bricolage, écologie, amélioration de l\\\'habitat) et beauxreves.fr (sommeil, santé, gestion du stress). Je vous contacte aujourd\\\'hui via le formulaire de contact de votre site avec une proposition qui pourrait enrichir nos contenus respectifs, même si nos niches peuvent sembler différentes à première vue.\r\n\r\nPour être clair, nous proposons une collaboration 100% légale entre nos entreprises respectives qui pourrait améliorer le référencement (SEO) de nos sites. En termes simples, un meilleur SEO signifie que nos sites seront plus visibles sur les moteurs de recherche, ce qui peut entraîner une augmentation du trafic et, éventuellement, des ventes ou des engagements.\r\n\r\nVoici comment cela pourrait fonctionner : nous pouvons échanger des liens entre nos sites ou collaborer sur du contenu qui serait mutuellement bénéfique. En créant des liens vers nos sites, nous signalons aux moteurs de recherche que nos sites sont fiables et utiles, ce qui peut améliorer notre classement dans les résultats de recherche.\r\n\r\nMême si nos niches peuvent sembler différentes, il existe de nombreuses façons d\\\'ajuster les niches pour rendre une collaboration ou un échange de liens pertinents.\r\n\r\nPour 123bricolage.fr, nous pouvons créer des liens avec des niches telles que :\r\n\r\nAmélioration de l\\\'habitat\r\nJardinage\r\nVie durable\r\nAuto-suffisance\r\nMaisons minuscules\r\nDesign d\\\'intérieur\r\nÉnergie verte\r\nRecyclage & Upcycling\r\nVie en plein air\r\nAlimentation biologique\r\nFinancement de projets d\\\'amélioration de l\\\'habitat\r\nConseils de rénovation\r\nEt beaucoup d\\\'autres !\r\n\r\nPour beauxreves.fr, les niches ajustables pourraient inclure :\r\n\r\nYoga & Méditation\r\nNutrition\r\nFitness & Exercice\r\nSanté mentale\r\nProductivité\r\nSanté holistique\r\nDéveloppement personnel\r\nParentalité & Famille\r\nPleine conscience\r\nCoaching de vie\r\nEt bien plus encore !\r\nSi vous êtes intéressé par cette proposition, n\\\'hésitez pas à me contacter pour que nous puissions en discuter davantage.\r\n\r\nMerci d\\\'avoir pris le temps de lire ce message. Je suis convaincu que cette collaboration pourrait apporter une valeur ajoutée significative à vos sites, quelle que soit leur niche.\r\n\r\nCordialement,\r\n\r\nMedali S.\r\nExpert SEO\r\nmas@123bricolage.fr\r\n\r\nP.S. Si vous possédez d\\\'autres sites qui pourraient bénéficier de cette opportunité, je serais ravi d\\\'en discuter avec vous.'),
(1963, 156, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1964, 156, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1965, 157, 'fld_5462783', 'nom', 'Eric'),
(1966, 157, 'fld_3436924', 'prenom', 'Eric'),
(1967, 157, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1968, 157, 'fld_724362', 'num_tel', '555-555-1212'),
(1969, 157, 'fld_475276', 'socite', 'Mqt Nkk'),
(1970, 157, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1971, 157, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1972, 157, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1973, 157, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1974, 157, 'fld_2695739', 'objet', 'Md U zsszejs'),
(1975, 157, 'fld_3396882', 'message', 'Dear artus-securite.fr Owner.\r\n\r\nMy name’s Eric and I just came across your website - artus-securite.fr - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like artus-securite.fr will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Web Visitors Into Leads.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Web Visitors Into Leads can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(1976, 157, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1977, 157, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1978, 158, 'fld_5462783', 'nom', 'Mangeot'),
(1979, 158, 'fld_3436924', 'prenom', 'Thiffany'),
(1980, 158, 'fld_2124341', 'adresse_mail', 'manymangeot04@gmail.com'),
(1981, 158, 'fld_724362', 'num_tel', '07 67 74 70 54'),
(1982, 158, 'fld_6078931', 'agence_souhait.opt1109492', 'Est Champagne Ardenne '),
(1983, 158, 'fld_6078931', 'agence_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1984, 158, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/Minimalist-Modern-Professional-CV-Resume.pdf'),
(1985, 158, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/L.M-Thiffany-Mangeot.pdf'),
(1986, 158, 'fld_3396882', 'message', '  Madame, Monsieur,\r\n\r\nJe voudrais travailler avec vous en tant qu’alternantes ci cela est possible. Cela ce feras avec l’ENS de Troyes (École Nationale de Sécurité). \r\nJe suis disponible pour toutes questions. \r\n\r\nCordialement Mangeot Thiffany. '),
(1987, 158, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(1988, 158, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(1989, 158, 'fld_3201949', 'envoyer', 'click'),
(1990, 159, 'fld_5462783', 'nom', 'Eric'),
(1991, 159, 'fld_3436924', 'prenom', 'Eric'),
(1992, 159, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(1993, 159, 'fld_724362', 'num_tel', '555-555-1212'),
(1994, 159, 'fld_475276', 'socite', 'Vgaakd d'),
(1995, 159, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(1996, 159, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(1997, 159, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(1998, 159, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(1999, 159, 'fld_2695739', 'objet', 'Ndsnpjxcgeb'),
(2000, 159, 'fld_3396882', 'message', 'Dear artus-securite.fr Administrator! I just found your site, quick question…\r\n\r\nMy name’s Eric, I found artus-securite.fr after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://advanceleadgeneration.com to learn more about everything Web Visitors Into Leads can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(2001, 159, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2002, 159, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2003, 160, 'fld_5462783', 'nom', 'CELCE'),
(2004, 160, 'fld_3436924', 'prenom', 'Aurelie'),
(2005, 160, 'fld_2124341', 'adresse_mail', 'Aureliepinilla@hotmail.com'),
(2006, 160, 'fld_724362', 'num_tel', '06 72 69 44 26'),
(2007, 160, 'fld_475276', 'socite', 'Association Loches Loisirs Culture'),
(2008, 160, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2009, 160, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2010, 160, 'fld_2695739', 'objet', 'Devis'),
(2011, 160, 'fld_3396882', 'message', 'Bonjour, nous aimerions avoir recours à 2 agents de sécurité pour le bon déroulement de notre soirée annuelle samedi 22 juillet à Loches sur Ource de 22h30 à  3h. C\\\'est une fête de village qui prend de l\\\'ampleur et où il est préférable de veiller au bon comportement des visiteurs. Pourriez-vous me faire parvenir un devis s\\\'il vous plait.\r\nMerci,\r\nAurélie Celce'),
(2012, 160, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2013, 160, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2014, 160, 'fld_3201949', 'envoyer', 'click'),
(2015, 161, 'fld_5462783', 'nom', 'Walid'),
(2016, 161, 'fld_3436924', 'prenom', 'Walid'),
(2017, 161, 'fld_2124341', 'adresse_mail', 'efficall@outlook.com');
INSERT INTO `mod284_cf_form_entry_values` (`id`, `entry_id`, `field_id`, `slug`, `value`) VALUES 
(2018, 161, 'fld_724362', 'num_tel', '+216 27 328 389'),
(2019, 161, 'fld_475276', 'socite', 'R Psm Rk Stovd'),
(2020, 161, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2021, 161, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2022, 161, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2023, 161, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2024, 161, 'fld_2695739', 'objet', 'Urnqqs'),
(2025, 161, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nJe suis spécialiste en publicité sur Facebook et Google, et je peux vous aider à générer des leads ou à  gérer votre compte publicitaire. \r\n\r\nJe travaille avec des artisans comme vous depuis des années et comprends vos besoins d\\\'acquérir des leads qualifiés pour une meilleure conversion. \r\n\r\nSi vous êtes intéressé, contactez-moi pour une consultation gratuite.\r\n\r\nCordialement,\r\nWalid\r\nWHATSSAP : +216 27 328 389'),
(2026, 161, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2027, 161, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2028, 162, 'fld_5462783', 'nom', 'Frédéric Cordier  '),
(2029, 162, 'fld_3436924', 'prenom', 'Cordier  '),
(2030, 162, 'fld_2124341', 'adresse_mail', 'frederic.cordier@vrp-seo.com'),
(2031, 162, 'fld_724362', 'num_tel', '87 55 51 48 1_'),
(2032, 162, 'fld_475276', 'socite', 'VRP'),
(2033, 162, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2034, 162, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2035, 162, 'fld_2695739', 'objet', 'AUDIT SEO'),
(2036, 162, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nVotre site m’intéresse.\r\n\r\nJe suis un VRP multicarte en SEO et représente plusieurs agences SEO sélectionnées pour leur performance du moment.\r\n\r\nPour faire simple je jongle avec les agences et c’est ma FORCE car suivant les mises à jour perpétuelles de Google, la performance des agences est impactée significativement.\r\n\r\nAprès un scan rapide de votre site, il y a plusieurs pistes pour améliorer votre référencement naturel, attention au netlinking ( un gros volet à voir) qui est à double tranchant et peut vous pénaliser, un maillage interne plus structuré peut vous faire gagner plusieurs pages d’un coup, certaines pages à optimiser encore plus … Maintenant tout est dans le détail.\r\n\r\nCette approche est très différente d’une agence seo qui n’a qu’UNE solution à vendre coûte que coûte.\r\n\r\nSi vous n\\\'êtes pas engagé avec une agence seo, Je peux vous proposer des solutions pertinentes sans engagement.\r\n\r\nDans l\\\'attente active de votre retour\r\n\r\nFrédéric Cordier  \r\nConsultant SEO \r\nVRP SEO \r\nfrederic.cordier@vrp-seo.com\r\n07 55 51 48 15'),
(2037, 162, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2038, 162, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2039, 162, 'fld_3201949', 'envoyer', 'click'),
(2040, 163, 'fld_5462783', 'nom', 'Eric'),
(2041, 163, 'fld_3436924', 'prenom', 'Eric'),
(2042, 163, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2043, 163, 'fld_724362', 'num_tel', '555-555-1212'),
(2044, 163, 'fld_475276', 'socite', 'Aeumnyepxt l R'),
(2045, 163, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2046, 163, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2047, 163, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2048, 163, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2049, 163, 'fld_2695739', 'objet', 'Qghix Rz'),
(2050, 163, 'fld_3396882', 'message', 'Hello artus-securite.fr Webmaster. this is Eric and I ran across artus-securite.fr a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(2051, 163, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2052, 163, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2053, 164, 'fld_5462783', 'nom', 'Eric'),
(2054, 164, 'fld_3436924', 'prenom', 'Eric'),
(2055, 164, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2056, 164, 'fld_724362', 'num_tel', '555-555-1212'),
(2057, 164, 'fld_475276', 'socite', 'Gyhinzx'),
(2058, 164, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2059, 164, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2060, 164, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2061, 164, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2062, 164, 'fld_2695739', 'objet', 'Hokpqw mof Zp'),
(2063, 164, 'fld_3396882', 'message', 'Dear artus-securite.fr Owner! this is Eric and I ran across artus-securite.fr a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(2064, 164, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2065, 164, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2066, 165, 'fld_5462783', 'nom', 'Eric'),
(2067, 165, 'fld_3436924', 'prenom', 'Eric'),
(2068, 165, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2069, 165, 'fld_724362', 'num_tel', '555-555-1212'),
(2070, 165, 'fld_475276', 'socite', 'Tsamyt Dj'),
(2071, 165, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2072, 165, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2073, 165, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2074, 165, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2075, 165, 'fld_2695739', 'objet', 'Llona Y'),
(2076, 165, 'fld_3396882', 'message', 'Dear artus-securite.fr Webmaster! Eric here with a quick thought about your website artus-securite.fr...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n\r\n'),
(2077, 165, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2078, 165, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2079, 166, 'fld_5462783', 'nom', 'Eric'),
(2080, 166, 'fld_3436924', 'prenom', 'Eric'),
(2081, 166, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2082, 166, 'fld_724362', 'num_tel', '555-555-1212'),
(2083, 166, 'fld_475276', 'socite', 'Cc Nx'),
(2084, 166, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2085, 166, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2086, 166, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2087, 166, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2088, 166, 'fld_2695739', 'objet', 'Qlxrs Is'),
(2089, 166, 'fld_3396882', 'message', 'Hi artus-securite.fr Administrator!\r\n\r\nCool website!\r\n\r\nMy name’s Eric, and I just found your site - artus-securite.fr - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across artus-securite.fr, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought – what if there was an easy way for every visitor to “raise their hand” to get a phone call from you INSTANTLY… the second they hit your site and said, “call me now.”\r\n\r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead feature… because once you’ve captured the visitor’s phone number, you can automatically start a text message (SMS) conversation.\r\n  \r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr'),
(2090, 166, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2091, 166, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2092, 167, 'fld_5462783', 'nom', 'Eric'),
(2093, 167, 'fld_3436924', 'prenom', 'Eric'),
(2094, 167, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2095, 167, 'fld_724362', 'num_tel', '555-555-1212'),
(2096, 167, 'fld_475276', 'socite', 'Gk Pnj'),
(2097, 167, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2098, 167, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2099, 167, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2100, 167, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2101, 167, 'fld_2695739', 'objet', 'Ouimblysfa'),
(2102, 167, 'fld_3396882', 'message', 'Hello artus-securite.fr Webmaster!\r\n\r\nI just found your site, quick question…\r\n\r\nMy name’s Eric, I found artus-securite.fr after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Web Visitors Into Leads can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr'),
(2103, 167, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2104, 167, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2105, 168, 'fld_5462783', 'nom', 'Tina'),
(2106, 168, 'fld_3436924', 'prenom', 'Tina'),
(2107, 168, 'fld_2124341', 'adresse_mail', 'gptdash@databaseen.com'),
(2108, 168, 'fld_724362', 'num_tel', '0376 2239576'),
(2109, 168, 'fld_475276', 'socite', 'Jjzehv ono'),
(2110, 168, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2111, 168, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2112, 168, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2113, 168, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2114, 168, 'fld_2695739', 'objet', 'Hs Frackb cs'),
(2115, 168, 'fld_3396882', 'message', 'Hi,\r\n\r\nAre you tired of creating fresh content for your business?\r\n\r\nProblem solved forever: https://www.databaseen.com/gptdash \r\n\r\nThis new A.I. dashboard is the perfect solution for busy entrepreneurs and business owners who want to create high-quality content without spending hours (or even minutes) writing or hiring expensive writers.\r\n\r\nA team of professional internet marketers and copywriters have created a user-friendly dashboard that allows you to simply fill in a few blanks, click a button, and let the engine do all the \\\"work\\\".\r\n\r\nWith GPTDash, you can easily generate blog posts, emails, social media updates, product reviews, sales letters, video scripts, and more. Just enter a few keywords and watch as GPTDash creates engaging and persuasive content that resonates with your target audience. And, the content is 100% original.\r\n\r\nThis dashboard is a game-changer and they could be charging an arm and a leg for it. However, they\\\'re offering a launch special which will be ending soon.\r\n\r\nI recommend checking it out and getting access to this dashboard today: https://www.databaseen.com/gptdash \r\n\r\nDon\\\'t let content creation hold you back from achieving your goals. Try GPTDash today and experience the power of automated content creation for yourself.\r\n\r\nBest regards,\r\nTina Manning \r\n\r\nUNSUBSCRIBE: https://www.databaseen.com/unsubscribe\r\n\r\nAddress: 1951 W 5600 S #1, Roy, UT 84067'),
(2116, 168, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2117, 168, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2118, 169, 'fld_5462783', 'nom', 'Eric'),
(2119, 169, 'fld_3436924', 'prenom', 'Eric'),
(2120, 169, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2121, 169, 'fld_724362', 'num_tel', '555-555-1212'),
(2122, 169, 'fld_475276', 'socite', 'Hk X y'),
(2123, 169, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2124, 169, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2125, 169, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2126, 169, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2127, 169, 'fld_2695739', 'objet', 'Wbbongf'),
(2128, 169, 'fld_3396882', 'message', 'To the artus-securite.fr Webmaster.\r\n\r\nMy name’s Eric and I just ran across your website at artus-securite.fr...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(2129, 169, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2130, 169, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2131, 170, 'fld_5462783', 'nom', 'Eric'),
(2132, 170, 'fld_3436924', 'prenom', 'Eric'),
(2133, 170, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2134, 170, 'fld_724362', 'num_tel', '555-555-1212'),
(2135, 170, 'fld_475276', 'socite', 'Nutqm A'),
(2136, 170, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2137, 170, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2138, 170, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2139, 170, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2140, 170, 'fld_2695739', 'objet', 'Hup V'),
(2141, 170, 'fld_3396882', 'message', 'Hi artus-securite.fr Admin.\r\n\r\nMy name’s Eric and I just ran across your website at artus-securite.fr...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(2142, 170, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2143, 170, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2144, 171, 'fld_5462783', 'nom', 'Eric'),
(2145, 171, 'fld_3436924', 'prenom', 'Eric'),
(2146, 171, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2147, 171, 'fld_724362', 'num_tel', '555-555-1212'),
(2148, 171, 'fld_475276', 'socite', 'Ogzmjl'),
(2149, 171, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2150, 171, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2151, 171, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2152, 171, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2153, 171, 'fld_2695739', 'objet', 'Erkofk'),
(2154, 171, 'fld_3396882', 'message', 'To the artus-securite.fr Owner. Cool website!\r\n\r\nMy name’s Eric, and I just found your site - artus-securite.fr - while surfing the net. You showed up at the top of the search results, so I checked you out. Looks like what you’re doing is pretty cool.\r\n \r\nBut if you don’t mind me asking – after someone like me stumbles across artus-securite.fr, what usually happens?\r\n\r\nIs your site generating leads for your business? \r\n \r\nI’m guessing some, but I also bet you’d like more… studies show that 7 out 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a thought – what if there was an easy way for every visitor to “raise their hand” to get a phone call from you INSTANTLY… the second they hit your site and said, “call me now.”\r\n\r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead feature… because once you’ve captured the visitor’s phone number, you can automatically start a text message (SMS) conversation.\r\n  \r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\nEric\r\n\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(2155, 171, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2156, 171, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2157, 172, 'fld_5462783', 'nom', 'Kelly'),
(2158, 172, 'fld_3436924', 'prenom', 'Kelly'),
(2159, 172, 'fld_2124341', 'adresse_mail', 'viralfacesai@vauleonline.co'),
(2160, 172, 'fld_724362', 'num_tel', '0369 2394939'),
(2161, 172, 'fld_475276', 'socite', 'Sjhqevvkqmaf'),
(2162, 172, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2163, 172, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2164, 172, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2165, 172, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2166, 172, 'fld_2695739', 'objet', 'Fj Cptedkg'),
(2167, 172, 'fld_3396882', 'message', 'Hey,\r\n\r\nDid you try to make m0ney with AI, ChatGPT, Bard, Midjourney etc but failed miserably?\r\n\r\nThey are all awesome tools, but alone and without a good strategy you\\\'ll just be wasting your time, money & effort with little to NO results.\r\n\r\nWhat if tell you - there is a *SECRET AI HACK* that pulls in millions of visitors/m with 30-sec AI FACE videos WITHOUT subs, followers, ads or SEO...\r\n\r\n==> Go here to Unlock this *AI HACK* now: https://www.vauleonline.co/viralfacesai \r\n\r\nIntroducing ViralFaces AI, the groundbreaking NEW top-secret A.I Face Tech that brings UNLIMITED Traffic to your website!\r\n\r\nWith this revolutionary platform, you can create 100s of attention-grabbing A.I. Face Videos with zero effort in just minutes that speak and go viral on YouTube Shorts & Instagram Reels!\r\n\r\nYou get 10x more sales, reach, followers, and engagement...\r\n\r\nHere\\\'re some results newbies getting with Face videos..\r\n\r\n- 10M views posting a self-improvement short\r\n- 1.5M views posting a gym tips reel\r\n- 2.8M views posting a health tips reel\r\n\r\nAnd they all started with no subs, no followers, no ads - all using AI in min.\r\n\r\nThe sooner you get started, the MOST you\\\'ll be able to exploit this method - just handful of people doing it right now and you can be one of them..\r\n\r\n==> WATCH QUICK DEMO HERE: https://www.vauleonline.co/viralfacesai \r\n\r\nViralFaces AI is available for a Low One Time Price during its public launch for the next few days only..\r\n\r\nAfter this week, it will turn into a higher recurring subscription price model.\r\n\r\nAct fast and get your account at the lowest price ever.\r\n\r\n==> Get ViralFaces AI For A Low One-Time Price Now: https://www.vauleonline.co/viralfacesai \r\n\r\nSee you inside.\r\n\r\nAll the best,\r\nKelly Nelson\r\n\r\n\r\nUNSUBSCRIBE: https://www.vauleonline.co/unsubscribe\r\n\r\nAddress: 671 S Pickett St, Alexandria, VA 22304'),
(2168, 172, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2169, 172, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2170, 173, 'fld_5462783', 'nom', 'Saint-auret'),
(2171, 173, 'fld_3436924', 'prenom', 'Anthony '),
(2172, 173, 'fld_2124341', 'adresse_mail', 'banshee-t@hotmail.fr'),
(2173, 173, 'fld_724362', 'num_tel', '06 09 79 72 37'),
(2174, 173, 'fld_6078931', 'agence_souhait.opt1916226', 'Hauts-de-France '),
(2175, 173, 'fld_6078931', 'agence_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(2176, 173, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/cv-aps-ssiap-2.pdf'),
(2177, 173, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Lettre-de-motivation-.pdf'),
(2178, 173, 'fld_3396882', 'message', 'Madame, Monsieur,\r\nJe vous envoie ma candidature spontanée car je suis à la recherche d’un poste d’agent de sécurité ou de sécurité incendie.\r\nVous souhaitant bonne réception,\r\nCordialement \r\nMr Saint-auret'),
(2179, 173, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2180, 173, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2181, 173, 'fld_3201949', 'envoyer', 'click'),
(2182, 174, 'fld_5462783', 'nom', 'Deb'),
(2183, 174, 'fld_3436924', 'prenom', 'Deb'),
(2184, 174, 'fld_2124341', 'adresse_mail', 'deb.handley@gmail.com'),
(2185, 174, 'fld_724362', 'num_tel', '031 336 38 20'),
(2186, 174, 'fld_475276', 'socite', 'Rvcjrwc'),
(2187, 174, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2188, 174, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2189, 174, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2190, 174, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2191, 174, 'fld_2695739', 'objet', 'Bzf Ktx Yi'),
(2192, 174, 'fld_3396882', 'message', 'Hey there, I just found your site, quick question…\r\n\r\nI found artus-securite.fr after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTurboLeadGeneration.com is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://TurboLeadGeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://TurboLeadGeneration.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nPS: TurboLeadGeneration.com offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://TurboLeadGeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://TurboLeadGeneration.com/unsubscribe.aspx?d=artus-securite.fr'),
(2193, 174, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2194, 174, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2195, 175, 'fld_5462783', 'nom', 'Toney'),
(2196, 175, 'fld_3436924', 'prenom', 'Toney'),
(2197, 175, 'fld_2124341', 'adresse_mail', 'cutlack.toney@hotmail.com'),
(2198, 175, 'fld_724362', 'num_tel', '(07) 4946 2677'),
(2199, 175, 'fld_475276', 'socite', 'X dnnzyah'),
(2200, 175, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2201, 175, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2202, 175, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2203, 175, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2204, 175, 'fld_2695739', 'objet', 'Y vuo'),
(2205, 175, 'fld_3396882', 'message', 'Hey there, I just found your site, quick question…\r\n\r\nI found artus-securite.fr after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTurboLeadGeneration.com is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://TurboLeadGeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://TurboLeadGeneration.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nPS: TurboLeadGeneration.com offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://TurboLeadGeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://TurboLeadGeneration.com/unsubscribe.aspx?d=artus-securite.fr'),
(2206, 175, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2207, 175, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2208, 176, 'fld_5462783', 'nom', 'Steve'),
(2209, 176, 'fld_3436924', 'prenom', 'Steve'),
(2210, 176, 'fld_2124341', 'adresse_mail', 'steve.greener@gmail.com'),
(2211, 176, 'fld_724362', 'num_tel', '079 4246 0916'),
(2212, 176, 'fld_475276', 'socite', 'Yarha s vz'),
(2213, 176, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2214, 176, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2215, 176, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2216, 176, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2217, 176, 'fld_2695739', 'objet', 'Zdrcsqkyf Jpz'),
(2218, 176, 'fld_3396882', 'message', 'Hey there, I just found your site, quick question…\r\n\r\nI found artus-securite.fr after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTurboLeadGeneration.com is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://TurboLeadGeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://TurboLeadGeneration.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nPS: TurboLeadGeneration.com offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://TurboLeadGeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://TurboLeadGeneration.com/unsubscribe.aspx?d=artus-securite.fr'),
(2219, 176, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.');
INSERT INTO `mod284_cf_form_entry_values` (`id`, `entry_id`, `field_id`, `slug`, `value`) VALUES 
(2220, 176, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2221, 177, 'fld_5462783', 'nom', 'Benjamin'),
(2222, 177, 'fld_3436924', 'prenom', 'Benjamin'),
(2223, 177, 'fld_2124341', 'adresse_mail', 'mcknight.benjamin@gmail.com'),
(2224, 177, 'fld_724362', 'num_tel', '(03) 9154 4059'),
(2225, 177, 'fld_475276', 'socite', 'H Iwzuqh gk'),
(2226, 177, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2227, 177, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2228, 177, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2229, 177, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2230, 177, 'fld_2695739', 'objet', 'M g uv Lb'),
(2231, 177, 'fld_3396882', 'message', 'Hey there, I just found your site, quick question…\r\n\r\nI found artus-securite.fr after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nTurboLeadGeneration.com is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://TurboLeadGeneration.com to try out a Live Demo with Talk With Web Visitor now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://TurboLeadGeneration.com to learn more about everything Talk With Web Visitor can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nPS: TurboLeadGeneration.com offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://TurboLeadGeneration.com to try Talk With Web Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://TurboLeadGeneration.com/unsubscribe.aspx?d=artus-securite.fr'),
(2232, 177, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2233, 177, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2234, 178, 'fld_5462783', 'nom', 'Robert'),
(2235, 178, 'fld_3436924', 'prenom', 'Robert'),
(2236, 178, 'fld_2124341', 'adresse_mail', 'seo@howheart.com'),
(2237, 178, 'fld_724362', 'num_tel', '03.21.85.07.42'),
(2238, 178, 'fld_475276', 'socite', 'U N Xs Ovc'),
(2239, 178, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2240, 178, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2241, 178, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2242, 178, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2243, 178, 'fld_2695739', 'objet', 'Phcmp'),
(2244, 178, 'fld_3396882', 'message', 'Hello, \r\nI\\\'m Robert, co-founder of Howheart. Howheart noticed that you have an excellent website . \r\n\r\nHowheart is a website research institute that is looking for website like yours, help you increase revenue by showing you how to find reliable ways to grow your website.\r\n  \r\nMethod: SEO service providers are verified and praised by webmasters, the largest service trading platform in the world to protect your rights and interests, only if you get what you want, the platform will hand over your payment to the service provider  \r\n \r\nService provider example (the highest rating is 5.0):  \r\n	Name: M Aqib - Starting Price: $5, 3 Days Delivery (7,300 orders completed) - Method: Build 500 high quality and low OBL backlinks for your money site - Webmasters satisfaction rating: 4.9\r\n	  \r\n	Name: Wasim Ashraf - Starting price: $15, 1 Days Delivery (1,900 orders completed) - Method: On-Page SEO For Higher Rankings in Google Search Results - Webmasters satisfaction rating: 5.0  \r\n	...  \r\n	For Super website, Provider – Randy M has helped 3400 Super websites grow their site, and webmasters rated him 5.0! Starting Price: $250 \r\n	 \r\nEarn more dollars today: https://www.howheart.com/seo\r\n\r\n(Howheart rely on donations to stay afloat, so, after you get the growth you want, please support Howheart, PayPal: businessinquiries@howheart.com)  \r\n\r\nThank you for your time,  \r\nRobert D. McBride\r\n\r\n\r\nUNSUBSCRIBE: https://www.howheart.com/unsubscribe/\r\n1051 S Main St, Pocatello, ID 83204\r\n'),
(2245, 178, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2246, 178, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2247, 179, 'fld_5462783', 'nom', 'Eric'),
(2248, 179, 'fld_3436924', 'prenom', 'Eric'),
(2249, 179, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2250, 179, 'fld_724362', 'num_tel', '555-555-1212'),
(2251, 179, 'fld_475276', 'socite', 'Z yu sn'),
(2252, 179, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2253, 179, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2254, 179, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2255, 179, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2256, 179, 'fld_2695739', 'objet', 'Vx jbe yyisuhz'),
(2257, 179, 'fld_3396882', 'message', 'Dear artus-securite.fr Webmaster. my name is Eric and I’m betting you’d like your website artus-securite.fr to generate more leads.\r\n\r\nHere’s how:\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at artus-securite.fr.\r\n\r\nWeb Visitors Into Leads – CLICK HERE https://advanceleadgeneration.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(2258, 179, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2259, 179, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2260, 180, 'fld_5462783', 'nom', 'Georgina'),
(2261, 180, 'fld_3436924', 'prenom', 'Georgina'),
(2262, 180, 'fld_2124341', 'adresse_mail', 'georginahaynes620@gmail.com'),
(2263, 180, 'fld_724362', 'num_tel', 'Erlhbtw'),
(2264, 180, 'fld_475276', 'socite', 'Ta Qmjgni'),
(2265, 180, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2266, 180, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2267, 180, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2268, 180, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2269, 180, 'fld_2695739', 'objet', 'Hdbqn vs Zw'),
(2270, 180, 'fld_3396882', 'message', 'Hi,\r\n\r\nWe\\\'d like to introduce to you our explainer video service, which we feel can benefit your site artus-securite.fr.\r\n\r\nCheck out some of our existing videos here:\r\nhttps://www.youtube.com/watch?v=bWz-ELfJVEI\r\nhttps://www.youtube.com/watch?v=Y46aNG-Y3rM\r\nhttps://www.youtube.com/watch?v=hJCFX1AjHKk\r\n\r\nAll of our videos are in a similar animated format as the above examples, and we have voice over artists with US/UK/Australian accents. We can also produce voice overs in languages other than English.\r\n\r\nThey can show a solution to a problem or simply promote one of your products or services. They are concise, can be uploaded to video sites such as YouTube, and can be embedded into your website or featured on landing pages.\r\n\r\nOur prices are as follows depending on video length:\r\nUp to 1 minute = $259\r\n1-2 minutes = $379\r\n2-3 minutes = $489\r\n\r\n*All prices above are in USD and include a full script, voice-over and video.\r\n\r\nIf this is something you would like to discuss further, don\\\'t hesitate to reply.\r\n\r\nKind Regards,\r\nGeorgina\r\n\r\nIf you are not interested, unsubscribe here: https://explainervideos4u.net/unsubscribe.php?d=artus-securite.fr'),
(2271, 180, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2272, 180, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2273, 181, 'fld_5462783', 'nom', 'Betty'),
(2274, 181, 'fld_3436924', 'prenom', 'Betty'),
(2275, 181, 'fld_2124341', 'adresse_mail', 'dorrington.betty@yahoo.com'),
(2276, 181, 'fld_724362', 'num_tel', '06381 68 28 30'),
(2277, 181, 'fld_475276', 'socite', 'Tcjxbzoegvmfzj'),
(2278, 181, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2279, 181, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2280, 181, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2281, 181, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2282, 181, 'fld_2695739', 'objet', 'Labpsc'),
(2283, 181, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2284, 181, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2285, 182, 'fld_5462783', 'nom', 'Eric'),
(2286, 182, 'fld_3436924', 'prenom', 'Eric'),
(2287, 182, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2288, 182, 'fld_724362', 'num_tel', '555-555-1212'),
(2289, 182, 'fld_475276', 'socite', 'Cjldo nl'),
(2290, 182, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2291, 182, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2292, 182, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2293, 182, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2294, 182, 'fld_2695739', 'objet', 'Enqzpti f'),
(2295, 182, 'fld_3396882', 'message', 'Dear artus-securite.fr Owner.\r\n\r\nMy name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at artus-securite.fr.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(2296, 182, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2297, 182, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2298, 183, 'fld_5462783', 'nom', 'Eric'),
(2299, 183, 'fld_3436924', 'prenom', 'Eric'),
(2300, 183, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2301, 183, 'fld_724362', 'num_tel', '555-555-1212'),
(2302, 183, 'fld_475276', 'socite', 'Ztugkh'),
(2303, 183, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2304, 183, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2305, 183, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2306, 183, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2307, 183, 'fld_2695739', 'objet', 'Gi vpc D'),
(2308, 183, 'fld_3396882', 'message', 'Hi artus-securite.fr Webmaster! my name’s Eric and I just ran across your website at artus-securite.fr...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(2309, 183, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2310, 183, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2311, 184, 'fld_5462783', 'nom', 'Kathleen'),
(2312, 184, 'fld_3436924', 'prenom', 'Kathleen'),
(2313, 184, 'fld_2124341', 'adresse_mail', 'writejob@databaseen.com'),
(2314, 184, 'fld_724362', 'num_tel', '07340 14 17 50'),
(2315, 184, 'fld_475276', 'socite', 'Qi wqw dyby Hm'),
(2316, 184, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2317, 184, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2318, 184, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2319, 184, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2320, 184, 'fld_2695739', 'objet', 'Th hae Unkea e'),
(2321, 184, 'fld_3396882', 'message', 'Hi,\r\n\r\nStop searching. Be compensated for writing online.\r\n\r\nPut your writing skills to use and be compensated while doing it! Obtain pre-qualification and discover starter online writing roles that provide up to 35 bucks per hour with complete instruction in merely 30 minutes. You can work from home or on a laptop without traveling.\r\n\r\nClick here to apply: https://www.databaseen.com/writejob \r\n\r\nUse your skills and knowledge and become part of a thriving online community. It\\\'s quick and straightforward, and you\\\'ll start earning! Work directly with a small company and make a real difference to their blog and social media accounts.\r\n\r\nSign up below and be part of the future: https://www.databaseen.com/writejob . Re-enter your details and start work on Monday.\r\n\r\nKathleen Melancon\r\n\r\nUNSUBSCRIBE: https://www.databaseen.com/unsubscribe\r\n\r\nAddress: 631 N Main St, Porterville, CA 93257'),
(2322, 184, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2323, 184, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2324, 185, 'fld_5462783', 'nom', 'Eric'),
(2325, 185, 'fld_3436924', 'prenom', 'Eric'),
(2326, 185, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2327, 185, 'fld_724362', 'num_tel', '555-555-1212'),
(2328, 185, 'fld_475276', 'socite', 'Ph st Qol'),
(2329, 185, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2330, 185, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2331, 185, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2332, 185, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2333, 185, 'fld_2695739', 'objet', 'D Dfccaxl Ent'),
(2334, 185, 'fld_3396882', 'message', 'Hi artus-securite.fr Administrator!\r\n\r\nThis is Eric and I ran across artus-securite.fr a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(2335, 185, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2336, 185, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2337, 186, 'fld_5462783', 'nom', 'MABIALA KOUNSIKILA'),
(2338, 186, 'fld_3436924', 'prenom', 'ULRICH MELIN'),
(2339, 186, 'fld_2124341', 'adresse_mail', 'melinmab@yahoo.fr'),
(2340, 186, 'fld_724362', 'num_tel', '06 14 06 05 62'),
(2341, 186, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(2342, 186, 'fld_6078931', 'agence_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(2343, 186, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/Cv-securite.pdf'),
(2344, 186, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Lettre-de-motivation.pdf'),
(2345, 186, 'fld_3396882', 'message', '.'),
(2346, 186, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2347, 186, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2348, 186, 'fld_3201949', 'envoyer', 'click'),
(2349, 187, 'fld_5462783', 'nom', 'Eric'),
(2350, 187, 'fld_3436924', 'prenom', 'Eric'),
(2351, 187, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2352, 187, 'fld_724362', 'num_tel', '555-555-1212'),
(2353, 187, 'fld_475276', 'socite', 'Rg Hbjl'),
(2354, 187, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2355, 187, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2356, 187, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2357, 187, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2358, 187, 'fld_2695739', 'objet', 'Ftblafote b D'),
(2359, 187, 'fld_3396882', 'message', 'Hi artus-securite.fr Webmaster.\r\n\r\nThis is Eric and I ran across artus-securite.fr a few minutes ago.\r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone like me finds your website – either through Search or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nHonestly, most business websites fall a bit short when it comes to generating paying customers. Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really EASY for every visitor who shows up to get a personal phone call you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nYou’ll be amazed - the difference between contacting someone within 5 minutes versus a half-hour or more later could increase your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal right away, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nPretty sweet – AND effective.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(2360, 187, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2361, 187, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2362, 188, 'fld_5462783', 'nom', 'Eric'),
(2363, 188, 'fld_3436924', 'prenom', 'Eric'),
(2364, 188, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2365, 188, 'fld_724362', 'num_tel', '555-555-1212'),
(2366, 188, 'fld_475276', 'socite', 'Tb Eifnyf'),
(2367, 188, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2368, 188, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2369, 188, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2370, 188, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2371, 188, 'fld_2695739', 'objet', 'Lqdb zasfed'),
(2372, 188, 'fld_3396882', 'message', 'To the artus-securite.fr Webmaster! my name’s Eric and I just ran across your website at artus-securite.fr...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE http://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE http://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(2373, 188, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2374, 188, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2375, 189, 'fld_5462783', 'nom', 'Billy'),
(2376, 189, 'fld_3436924', 'prenom', 'Billy'),
(2377, 189, 'fld_2124341', 'adresse_mail', 'rpm@solveques.xyz'),
(2378, 189, 'fld_724362', 'num_tel', 'Jvzii v X T'),
(2379, 189, 'fld_475276', 'socite', 'Oimqzdsqc Ffbu'),
(2380, 189, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2381, 189, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2382, 189, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2383, 189, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2384, 189, 'fld_2695739', 'objet', 'A htsnclija h'),
(2385, 189, 'fld_3396882', 'message', 'Have you ever wondered why so many people don’t make it online?\r\n\r\nIt’s not a lack of training.\r\n\r\nYouTube alone has more than enough fr-ee training to eclipse every university on earth 10 times over.\r\n\r\nIt’s not a lack of opportunity.\r\n\r\nNew success stories are being created every day and there’s never been so much opportunity out there as there is right now.\r\n\r\nSo what is it?\r\n\r\nIf there’s never been such an opportunity or plethora of free knowledge available, then why do so many fail.\r\n\r\n1 word…\r\n\r\nOverwhelm.\r\n\r\nNot knowing where to start and not having a clear roadmap.\r\n\r\nThat stops now.\r\n\r\nMy mentor James has put together a fr-ee system where overwhelm will be a thing of the past.\r\n\r\nWith weekly live training, a brand new technology which eliminates all the tech headaches and a fr-ee traffic rotator from his own pocket.\r\n\r\n\r\nThere’s no way to get overwhelmed because it’s all done for you…\r\n\r\nAnd if you do need a helping hand, we are with you every step of the way\r\n\r\nNow click here to access the system: https://www.solveques.xyz/rpm \r\n\r\nGet started with this breakthrough system today and then stop by in the group for Wednesday’s Live VIP session and you’ll see what I mean.\r\n\r\nKind regards,\r\n\r\nBilly Goldman\r\n\r\nUNSUBSCRIBE: https://www.solveques.xyz/unsubscribe\r\n\r\nAddress: 631 N Main St, Porterville, CA 93257'),
(2386, 189, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2387, 189, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2388, 190, 'fld_5462783', 'nom', 'Mario'),
(2389, 190, 'fld_3436924', 'prenom', 'Mario'),
(2390, 190, 'fld_2124341', 'adresse_mail', 'gregg.mario@msn.com'),
(2391, 190, 'fld_724362', 'num_tel', '0680 852 02 98'),
(2392, 190, 'fld_475276', 'socite', 'Abufdg Udrlf'),
(2393, 190, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2394, 190, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2395, 190, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2396, 190, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2397, 190, 'fld_2695739', 'objet', 'B vzwc ccpwuqo'),
(2398, 190, 'fld_3396882', 'message', 'I have a question. You just read this message right? That means you\\\'re now a potential customer and I can do the same thing for your business. I can blast YOUR ad to 1 million websites just like I did to yours for just $98. More pricing plans are also available, contact me on Skype for details. Here\\\'s my id : live:.cid.aebc78a94c13344c'),
(2399, 190, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2400, 190, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2401, 191, 'fld_5462783', 'nom', 'Eric'),
(2402, 191, 'fld_3436924', 'prenom', 'Eric'),
(2403, 191, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2404, 191, 'fld_724362', 'num_tel', '555-555-1212'),
(2405, 191, 'fld_475276', 'socite', 'Xhz Id sav'),
(2406, 191, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2407, 191, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2408, 191, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2409, 191, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2410, 191, 'fld_2695739', 'objet', 'Dfmgit gun'),
(2411, 191, 'fld_3396882', 'message', 'To the artus-securite.fr Owner. my name’s Eric and for just a second, imagine this…\r\n\r\n- Someone does a search and winds up at artus-securite.fr.\r\n\r\n- They hang out for a minute to check it out.  “I’m interested… but… maybe…”\r\n\r\n- And then they hit the back button and check out the other search results instead. \r\n\r\n- Bottom line – you got an eyeball, but nothing else to show for it.\r\n\r\n- There they go.\r\n\r\nThis isn’t really your fault – it happens a LOT – studies show 7 out of 10 visitors to any site disappear without leaving a trace.\r\n\r\nBut you CAN fix that.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It lets you know right then and there – enabling you to call that lead while they’re literally looking over your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nTime is money when it comes to connecting with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be huge – like 100 times better!\r\n\r\nPlus, now that you have their phone number, with our new SMS Text With Lead feature you can automatically start a text (SMS) conversation… so even if you don’t close a deal then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nStrong stuff.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(2412, 191, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2413, 191, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2414, 192, 'fld_5462783', 'nom', 'Eric'),
(2415, 192, 'fld_3436924', 'prenom', 'Eric'),
(2416, 192, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2417, 192, 'fld_724362', 'num_tel', '555-555-1212'),
(2418, 192, 'fld_475276', 'socite', 'Ontdi h'),
(2419, 192, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2420, 192, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2421, 192, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2422, 192, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2423, 192, 'fld_2695739', 'objet', 'Mnizo M'),
(2424, 192, 'fld_3396882', 'message', 'Hello artus-securite.fr Administrator.\r\n\r\nMy name’s Eric and I just came across your website - artus-securite.fr - in the search results.\r\n\r\nHere’s what that means to me…\r\n\r\nYour SEO’s working.\r\n\r\nYou’re getting eyeballs – mine at least.\r\n\r\nYour content’s pretty good, wouldn’t change a thing.\r\n\r\nBUT…\r\n\r\nEyeballs don’t pay the bills.\r\n\r\nCUSTOMERS do.\r\n\r\nAnd studies show that 7 out of 10 visitors to a site like artus-securite.fr will drop by, take a gander, and then head for the hills without doing anything else.\r\n\r\nIt’s like they never were even there.\r\n\r\nYou can fix this.\r\n\r\nYou can make it super-simple for them to raise their hand, say, “okay, let’s talk” without requiring them to even pull their cell phone from their pocket… thanks to Web Visitors Into Leads.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know immediately – so you can talk to that lead immediately… without delay… BEFORE they head for those hills.\r\n  \r\nCLICK HERE http://jumboleadmagnet.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nNow it’s also true that when reaching out to hot leads, you MUST act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s what makes our new SMS Text With Lead feature so powerful… you’ve got their phone number, so now you can start a text message (SMS) conversation with them… so even if they don’t take you up on your offer right away, you continue to text them new offers, new content, and new reasons to do business with you.\r\n\r\nThis could change everything for you and your business.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to learn more about everything Web Visitors Into Leads can do and start turing eyeballs into money.\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nPaying customers are out there waiting. \r\nStarting connecting today by CLICKING HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(2425, 192, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2426, 192, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2427, 193, 'fld_5462783', 'nom', 'Eric'),
(2428, 193, 'fld_3436924', 'prenom', 'Eric'),
(2429, 193, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2430, 193, 'fld_724362', 'num_tel', '555-555-1212'),
(2431, 193, 'fld_475276', 'socite', 'Lnn alh'),
(2432, 193, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2433, 193, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2434, 193, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2435, 193, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2436, 193, 'fld_2695739', 'objet', 'P csmfo ahyz'),
(2437, 193, 'fld_3396882', 'message', 'Hi artus-securite.fr Webmaster. my name is Eric and I’m betting you’d like your website artus-securite.fr to generate more leads.\r\n\r\nHere’s how:\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you as soon as they say they’re interested – so that you can talk to that lead while they’re still there at artus-securite.fr.\r\n\r\nWeb Visitors Into Leads – CLICK HERE https://advanceleadgeneration.com for a live demo now.\r\n\r\nAnd now that you’ve got their phone number, our new SMS Text With Lead feature enables you to start a text (SMS) conversation – answer questions, provide more info, and close a deal that way.\r\n\r\nIf they don’t take you up on your offer then, just follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nTry Web Visitors Into Leads and get more leads now.\r\n\r\nEric\r\nPS: The studies show 7 out of 10 visitors don’t hang around – you can’t afford to lose them!\r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(2438, 193, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2439, 193, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2440, 194, 'fld_5462783', 'nom', 'Paillery'),
(2441, 194, 'fld_3436924', 'prenom', 'Quentin'),
(2442, 194, 'fld_2124341', 'adresse_mail', 'quentinpaillery7@gmail.com'),
(2443, 194, 'fld_724362', 'num_tel', '06 35 11 33 62'),
(2444, 194, 'fld_6078931', 'agence_souhait.opt1109492', 'Est Champagne Ardenne '),
(2445, 194, 'fld_6078931', 'agence_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2446, 194, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-Pail0923.pdf'),
(2447, 194, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Lettredemotivation0923paila.pdf'),
(2448, 194, 'fld_3396882', 'message', 'Bonjour, en attente de carte professionnelle je me permets de postuler dans votre société en tant que SSIAP 1, je n\\\'ai aucune contrainte horaire ni journalière, je suis disponible dès maintenant et je suis véhiculé.\r\nVous trouverez ci-join mon curriculum-vitae ainsi que ma lettre de motivation.'),
(2449, 194, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2450, 194, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2451, 194, 'fld_3201949', 'envoyer', 'click'),
(2452, 195, 'fld_5462783', 'nom', 'Anastasia'),
(2453, 195, 'fld_3436924', 'prenom', 'Anastasia'),
(2454, 195, 'fld_2124341', 'adresse_mail', 'market@progarmentscn.com'),
(2455, 195, 'fld_724362', 'num_tel', 'Ziuiasimb mup'),
(2456, 195, 'fld_475276', 'socite', 'Wgfzeo Wlq'),
(2457, 195, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2458, 195, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2459, 195, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2460, 195, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2461, 195, 'fld_2695739', 'objet', 'Nlo Pf'),
(2462, 195, 'fld_3396882', 'message', 'Dear Artus Sécurité & Protection | Ile de France, Hauts de France et Aube,\r\n\r\nI hope this message finds you well. We are a seasoned textile manufacturer with over 20 years of experience, specializing in the production of the following high-quality products with LOW MOQ:\r\n\r\nHigh-quality Swimwear\r\nYoga-wear\r\nFitness Wear\r\nLingerie\r\nUniforms\r\nT-shirts\r\nJackets\r\nSwim Trunks\r\nShapewear\r\nWorkwear\r\nPeriod Swimwear / Underwear (FDA-certified)HOT SELLING\r\nVarious Other Textile Products\r\n\r\nSeveral swimwear styles we\\\'ve designed have achieved remarkable sales figures on the Amazon platform, with some even ranking as best-sellers in their respective categories. Feel free to reach out to us for the latest CATALOGUE.\r\n\r\nOur track record includes collaborations with renowned global brands such as OTTO, JOMA, FILA, DISNEY, GYMSHARK, ASICS, STELLA MCCARTNEY, CARCDESIGNS, KNIX, THINX, INDITEX, ZARA, COSTCO, DISNEY, TATA, LPP, NIKKI, OXYLANEP, KGS, COLES, HAPPY SOCKS, CUPSHE, SHEIN, AUSSIE PACIFIC, LINING, and more.\r\n\r\nWe specialize in a wide range of swimwear fabrics, including eco-friendly options like Italian Carvico ECONYL® (sourced from ocean waste) and American REPREVE® (created from plastic bottles). Our fabric printing is done in-house with OEKO-TEX® certified eco ink and recycled fabrics, ensuring quality and sustainability.\r\n\r\nOperating across 8 production bases in China and Cambodia, we are well-prepared to offer you efficient and dependable manufacturing solutions for your textile requirements. Our advanced production technology and efficient management practices allow us to effectively manage costs, ensuring that you receive the utmost value for your investment.\r\n\r\nWe look forward to the opportunity of serving you and meeting your textile manufacturing needs.\r\n\r\nBest regards,\r\n\r\nAnastasia Catherine\r\n\r\nwww.progarmentscn.com'),
(2463, 195, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.');
INSERT INTO `mod284_cf_form_entry_values` (`id`, `entry_id`, `field_id`, `slug`, `value`) VALUES 
(2464, 195, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2465, 196, 'fld_5462783', 'nom', 'Eric'),
(2466, 196, 'fld_3436924', 'prenom', 'Eric'),
(2467, 196, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2468, 196, 'fld_724362', 'num_tel', '555-555-1212'),
(2469, 196, 'fld_475276', 'socite', 'Sb auw Ou'),
(2470, 196, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2471, 196, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2472, 196, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2473, 196, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2474, 196, 'fld_2695739', 'objet', 'A Gmz I'),
(2475, 196, 'fld_3396882', 'message', 'Hello artus-securite.fr Owner.\r\n\r\nMy name’s Eric and I just found your site artus-securite.fr.\r\n\r\nIt’s got a lot going for it, but here’s an idea to make it even MORE effective.\r\n\r\nWeb Visitors Into Leads – CLICK HERE http://jumboleadmagnet.com for a live demo now.\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  It signals you the moment they let you know they’re interested – so that you can talk to that lead while they’re literally looking over your site.\r\n\r\nAnd once you’ve captured their phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation… and if they don’t take you up on your offer then, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nCLICK HERE http://jumboleadmagnet.com to discover what Web Visitors Into Leads can do for your business.\r\n\r\nThe difference between contacting someone within 5 minutes versus a half-hour means you could be converting up to 100X more leads today!\r\n\r\nEric\r\nPS: Studies show that 70% of a site’s visitors disappear and are gone forever after just a moment. Don’t keep losing them. \r\nWeb Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE http://jumboleadmagnet.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://jumboleadmagnet.com/unsubscribe.aspx?d=artus-securite.fr'),
(2476, 196, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2477, 196, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2478, 197, 'fld_5462783', 'nom', 'RAYMOND'),
(2479, 197, 'fld_3436924', 'prenom', 'Cassandre'),
(2480, 197, 'fld_2124341', 'adresse_mail', 'cailloteens@gmail.com'),
(2481, 197, 'fld_724362', 'num_tel', '07 60 87 50 72'),
(2482, 197, 'fld_475276', 'socite', 'Section Cailloteen\\\'s du comité des fêtes de Rosières-Près-Troyes'),
(2483, 197, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2484, 197, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2485, 197, 'fld_2695739', 'objet', 'Sécurité nouvel an'),
(2486, 197, 'fld_3396882', 'message', 'Bonjour, \r\n\r\nNous souhaiterions avoir deux devis. Le premier comprendrais 1 agent de sécurité pour le 21 décembre et le second devis comprendrais 2 agents de sécurité pour la même date. \r\n\r\nMerci par avance pour votre réponse. '),
(2487, 197, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2488, 197, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2489, 197, 'fld_3201949', 'envoyer', 'click'),
(2490, 198, 'fld_5462783', 'nom', 'Dilek '),
(2491, 198, 'fld_3436924', 'prenom', 'Serkan '),
(2492, 198, 'fld_2124341', 'adresse_mail', 'kemal.d@outlook.fr'),
(2493, 198, 'fld_724362', 'num_tel', '06 24 59 27 92'),
(2494, 198, 'fld_6078931', 'agence_souhait.opt1636010', 'Ile de France '),
(2495, 198, 'fld_6078931', 'agence_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(2496, 198, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/2023-2445-VOL-ACCESSOIRES-VL-DILEK.pdf'),
(2497, 198, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/C.N.I-4.pdf'),
(2498, 198, 'fld_3396882', 'message', 'Je souhaite être agent de sécurité '),
(2499, 198, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2500, 198, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2501, 198, 'fld_3201949', 'envoyer', 'click'),
(2502, 199, 'fld_5462783', 'nom', 'Danielle'),
(2503, 199, 'fld_3436924', 'prenom', 'Danielle'),
(2504, 199, 'fld_2124341', 'adresse_mail', 'simpsondanielle800@gmail.com'),
(2505, 199, 'fld_724362', 'num_tel', '419-543-8151'),
(2506, 199, 'fld_475276', 'socite', 'Lbpip Wbo K'),
(2507, 199, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2508, 199, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2509, 199, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2510, 199, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2511, 199, 'fld_2695739', 'objet', 'Vpf Rsfoolpuk'),
(2512, 199, 'fld_3396882', 'message', 'Hi,\r\n\r\nWe\\\'d like to introduce to you our explainer video service, which we feel can benefit your site artus-securite.fr.\r\n\r\nCheck out some of our existing videos here:\r\nhttps://www.youtube.com/watch?v=bWz-ELfJVEI\r\nhttps://www.youtube.com/watch?v=Y46aNG-Y3rM\r\nhttps://www.youtube.com/watch?v=hJCFX1AjHKk\r\n\r\nAll of our videos are in a similar animated format as the above examples, and we have voice over artists with US/UK/Australian accents. We can also produce voice overs in languages other than English.\r\n\r\nThey can show a solution to a problem or simply promote one of your products or services. They are concise, can be uploaded to video sites such as YouTube, and can be embedded into your website or featured on landing pages.\r\n\r\nOur prices are as follows depending on video length:\r\nUp to 1 minute = $259\r\n1-2 minutes = $379\r\n2-3 minutes = $489\r\n\r\n*All prices above are in USD and include a full script, voice-over and video.\r\n\r\nIf this is something you would like to discuss further, don\\\'t hesitate to reply.\r\n\r\nKind Regards,\r\nDanielle\r\n\r\nIf you are not interested, unsubscribe here: https://explainervideos4u.net/unsubscribe.php?d=artus-securite.fr'),
(2513, 199, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2514, 199, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2515, 200, 'fld_5462783', 'nom', 'Andre'),
(2516, 200, 'fld_3436924', 'prenom', 'Andre'),
(2517, 200, 'fld_2124341', 'adresse_mail', 'angelika.hollins@outlook.com'),
(2518, 200, 'fld_724362', 'num_tel', '(71) 7160-8288'),
(2519, 200, 'fld_475276', 'socite', 'Mqcvm'),
(2520, 200, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2521, 200, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2522, 200, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2523, 200, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2524, 200, 'fld_2695739', 'objet', 'Ggvuhny'),
(2525, 200, 'fld_3396882', 'message', 'Hey there,\r\n\r\nWas looking at your site today and I thought this would probably interest you.\r\n\r\nAre you tired of traditional virtual assistants who lack the expertise to handle complex tasks? Feeling overwhelmed by the thought of diving into generative AI? We\\\'ve got the game-changing solution you\\\'ve been waiting for: Myaa\\\'s AI-Powered Personal Support Agents.\r\n\r\nImagine the best of both worlds: a personal assistant who\\\'s a live professional expert at leveraging the power of thousands of AI Agents. That\\\'s exactly what you get with Myaa. Our AI-Powered Personal Support Agents are trained to perfection in writing excellent prompts and harnessing the capabilities of our AI Agents.\r\n\r\nBut here\\\'s the best part: we\\\'re offering a one-week free trial for you to experience the transformative capabilities of our agents firsthand. No obligations, no strings attached. Just a chance to see how our AI-Powered Personal Support Agents, the experts in leveraging AI technology, can revolutionize the way you manage your business.\r\n\r\nDon\\\'t miss out on this exclusive opportunity. Click below to schedule a call and claim your one-week free trial:\r\n\r\nhttps://bit.ly/Free-AI-Powered-Support-Agent\r\n\r\nDuring the call, our experts will guide you through the process and pair you with the perfect Myaa AI-Powered Personal Support Agent for your business. Say goodbye to inefficiency and hello to expert assistance.\r\n\r\nGet started now and unlock the full potential of generative AI with Myaa\\\'s AI-Powered Personal Support Agents.\r\n\r\nCheers,\r\n\r\nAndre Clarke\r\nBusiness Development\r\nMyaa\r\n'),
(2526, 200, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2527, 200, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2528, 201, 'fld_5462783', 'nom', 'Michele'),
(2529, 201, 'fld_3436924', 'prenom', 'Michele'),
(2530, 201, 'fld_2124341', 'adresse_mail', 'papst.michele58@gmail.com'),
(2531, 201, 'fld_724362', 'num_tel', '01.79.09.11.33'),
(2532, 201, 'fld_475276', 'socite', 'Ptzsa'),
(2533, 201, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2534, 201, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2535, 201, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2536, 201, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2537, 201, 'fld_2695739', 'objet', 'C Tbe ij qpbcw'),
(2538, 201, 'fld_3396882', 'message', 'I\\\'m posting this message to your website at artus-securite.fr to show you how effective contact form blasting is. The same way I sent you this message, I can also send your ad message to websites worldwide. You can reach a million sites for less than a hundred dollars. For info Skype me here:  live:.cid.dd8a3501619891fe'),
(2539, 201, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2540, 201, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2541, 202, 'fld_5462783', 'nom', 'Eric'),
(2542, 202, 'fld_3436924', 'prenom', 'Eric'),
(2543, 202, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2544, 202, 'fld_724362', 'num_tel', '555-555-1212'),
(2545, 202, 'fld_475276', 'socite', 'Sqdnzun K'),
(2546, 202, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2547, 202, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2548, 202, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2549, 202, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2550, 202, 'fld_2695739', 'objet', 'Biq g G Ufmt'),
(2551, 202, 'fld_3396882', 'message', 'To the artus-securite.fr Owner! my name’s Eric and I just ran across your website at artus-securite.fr...\r\n\r\nI found it after a quick search, so your SEO’s working out…\r\n\r\nContent looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA QUICK, EASY way to connect with you NOW.\r\n\r\nBecause studies show that a web lead like me will only hang out a few seconds – 7 out of 10 disappear almost instantly, Surf Surf Surf… then gone forever.\r\n\r\nI have the solution:\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to TALK with them - literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works and even give it a try… it could be huge for your business.\r\n\r\nPlus, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation pronto… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you follow up regularly with new offers, content links, even just follow up notes to build a relationship.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable.\r\n \r\nCLICK HERE https://advanceleadgeneration.com to discover what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here http://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(2552, 202, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2553, 202, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2554, 203, 'fld_5462783', 'nom', 'SANGRONIO'),
(2555, 203, 'fld_3436924', 'prenom', 'Sylvie'),
(2556, 203, 'fld_2124341', 'adresse_mail', 'ssangronio@aatm.fr'),
(2557, 203, 'fld_724362', 'num_tel', '03 25 74 70 22'),
(2558, 203, 'fld_475276', 'socite', 'Association AATM'),
(2559, 203, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2560, 203, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2561, 203, 'fld_2695739', 'objet', 'Fête de fin d\\\'année : demande de SSIAP 1'),
(2562, 203, 'fld_3396882', 'message', 'Bonjour Madame, Monsieur,\r\n\r\nDans le cadre de notre fête de fin d’année 2023, nous souhaiterions avoir recours à un agent SSIAP de niveau 1.\r\nVotre société nous a été recommandée par le Centre Culturel Didier BIENAIME.\r\n\r\nCette fête se déroulera au Centre Culturel Didier BIENAIME, le mercredi 20 décembre de 14h à 18h (accueil du public à 14h).\r\nVous voudriez bien nous adresser un devis à cet effet, à l’attention de : \r\n\r\nAATM CADA AUBE antenne LCSL \r\n2, rue Roger THIEBLEMONT\r\n10600 La Chapelle St Luc\r\nssangronio@aatm.fr / siege@aatm.fr\r\n\r\nMerci et bonne réception.\r\n\r\nSylvie SANGRONIO\r\n\r\n'),
(2563, 203, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2564, 203, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2565, 203, 'fld_3201949', 'envoyer', 'click'),
(2566, 204, 'fld_5462783', 'nom', 'Charlotte'),
(2567, 204, 'fld_3436924', 'prenom', 'Charlotte'),
(2568, 204, 'fld_2124341', 'adresse_mail', 'matney.charlotte@hotmail.com'),
(2569, 204, 'fld_724362', 'num_tel', '044 965 22 69'),
(2570, 204, 'fld_475276', 'socite', 'Nxawh rgi zd'),
(2571, 204, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2572, 204, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2573, 204, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2574, 204, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2575, 204, 'fld_2695739', 'objet', 'X aouny O'),
(2576, 204, 'fld_3396882', 'message', 'Looking for unique advertising that doesn\\\'t cost thousands of dollars to deliver mediocre results? How about contact form blasting? This is how I\\\'m reaching out to you right now! Cost is less than a hundred dollars to send to a million forms. For more info hit me up on Skype here: live:.cid.303294bd15a81bc7'),
(2577, 204, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2578, 204, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2579, 205, 'fld_5462783', 'nom', 'Bourgueil'),
(2580, 205, 'fld_3436924', 'prenom', 'Pierre'),
(2581, 205, 'fld_2124341', 'adresse_mail', 'pierre.bourgueil@utt.fr'),
(2582, 205, 'fld_724362', 'num_tel', '07 66 00 85 40'),
(2583, 205, 'fld_475276', 'socite', 'TUC'),
(2584, 205, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2585, 205, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2586, 205, 'fld_2695739', 'objet', 'Demande de Devis'),
(2587, 205, 'fld_3396882', 'message', 'Madame Monsieur,\r\nJe souhaiterai avoir un devis de sécurité concernant un évènement sportif qui aura lieu le samedi 9 décembre à la halle sportive de l’UTT (12 Rue Marie Curie, 10300 Troyes).\r\nBesoins : 4 agents de sécurité + 1 SSIAP\r\nHoraires : 9h30 - 18h\r\nNous anticipons un maximum 400 personnes pour cet évènement.\r\nJe me tiens à votre disposition si vous avez la moindre question.\r\nCordialement.\r\n\r\nPierre Bourgueil\r\nResponsable Logistique\r\nTUC 2023'),
(2588, 205, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2589, 205, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2590, 205, 'fld_3201949', 'envoyer', 'click'),
(2591, 206, 'fld_5462783', 'nom', 'Megan'),
(2592, 206, 'fld_3436924', 'prenom', 'Megan'),
(2593, 206, 'fld_2124341', 'adresse_mail', 'meganatkinson149@gmail.com'),
(2594, 206, 'fld_724362', 'num_tel', '(07) 4959 0723'),
(2595, 206, 'fld_475276', 'socite', 'Vt Hish au D'),
(2596, 206, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2597, 206, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2598, 206, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2599, 206, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2600, 206, 'fld_2695739', 'objet', 'V ykmur dz'),
(2601, 206, 'fld_3396882', 'message', 'Hi there,\r\n\r\nWe run an Instagram growth service, which increases your number of followers both safely and practically. \r\n\r\n- We guarantee to gain you 400-1000+ followers per month.\r\n- People follow you because they are interested in you, increasing likes, comments and interaction.\r\n- All actions are made manually by our team. We do not use any \\\'bots\\\'.\r\n\r\nThe price is just $60 (USD) per month, and we can start immediately.\r\n\r\nIf you have any questions, let me know, and we can discuss further.\r\n\r\nKind Regards,\r\nMegan'),
(2602, 206, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2603, 206, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2604, 207, 'fld_5462783', 'nom', 'Aidan'),
(2605, 207, 'fld_3436924', 'prenom', 'Aidan'),
(2606, 207, 'fld_2124341', 'adresse_mail', 'aidan.kohler@gmail.com'),
(2607, 207, 'fld_724362', 'num_tel', '06-49363429'),
(2608, 207, 'fld_475276', 'socite', 'Aidan Kohler'),
(2609, 207, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2610, 207, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2611, 207, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2612, 207, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2613, 207, 'fld_2695739', 'objet', 'Xaelujy hvsnxq'),
(2614, 207, 'fld_3396882', 'message', 'To the artus-securite.fr Owner! This is Aidan and I just come across your site at artus-securite.fr...\r\n\r\nI located it after a quick searching, so your SEO is doing well…\r\n\r\nThe content looks quite good…\r\n\r\nOne thing is missing though…\r\n\r\nA QUICK, SIMPLE way to get in touch with you NOW.\r\n\r\nAs research show that a visitor like me will only hang out a few seconds – 7 out of 10 leave instantly, Browse Browse Browse… then gone.\r\n\r\nI possess the remedy:\r\n\r\nWeb Visitors Into Leads is a software that’s operates on your website, prepared to catch any visitor’s Name, Email address, and Phone Number. You will be aware instantly they’re interested, and you can call them directly to TALK with them - literally whilst they’re still on the web browsing your website.\r\n\r\nCLICK HERE https://bit.ly/LeadGena to try out a Live Demo with Web Visitors Into Leads today to see exactly how it functions and even give it a try… it can be massive for your business.\r\n\r\nMoreover, now that you’ve got the phone number, with our new SMS Text With Lead feature, you can immediately initiate a text conversation immediately… which is so strong, since connecting within 5 minutes is 100 times more effective than waiting more later.\r\n\r\nThe new texting feature enables you follow up frequently with new offers, content even follow up notes to build a relationship.\r\n\r\nAll I’ve just outlined is extremely easy to implement,, affordable, and beneficial.\r\n\r\nCLICK HERE https://bit.ly/LeadGena to discover what Web Visitors Into Leads can do for your business, potentially up to 100X more visitors into leads today!\r\n\r\nAidan\r\nPS: Web Visitors Into Leads gives a FREE 14 day trial – and it features International Long Distance Calling. \r\nThere are customers eager to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://bit.ly/LeadGena to try Web Visitors Into Leads now.\r\n\r\nShould you prefer to unsubscribe click here https://bit.ly/3rD0G5c\r\n\r\nOnly a fast note - the names and email used here, Aidan and Kohler, are simulations and not actual contact data. We value transparency and wish to ensure  you’re aware! If you want to contact with the actual person responsible for this message, kindly visit our website, and we’ll connect you with the right individual.}\r\n'),
(2615, 207, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2616, 207, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2617, 208, 'fld_5462783', 'nom', 'Jesus'),
(2618, 208, 'fld_3436924', 'prenom', 'Jesus'),
(2619, 208, 'fld_2124341', 'adresse_mail', 'jesus.heagney28@hotmail.com'),
(2620, 208, 'fld_724362', 'num_tel', '01.08.28.12.65'),
(2621, 208, 'fld_475276', 'socite', 'Jesus Heagney'),
(2622, 208, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2623, 208, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2624, 208, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2625, 208, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2626, 208, 'fld_2695739', 'objet', 'K awpdw'),
(2627, 208, 'fld_3396882', 'message', 'Hello artus-securite.fr Webmaster!\r\n\r\nThis is Jesus and I stumbled upon artus-securite.fr a moment ago.  \r\n\r\nLooks great… but now what?\r\n\r\nBy that I mean, when someone such as me locates your website – either through Searching or just bouncing around – what happens next?  Do you get a lot of leads from your site, or at least enough to make you happy?\r\n\r\nFrankly, most business websites fall somewhat short when it comes to generating paying customers. Studies reveal that 70% of a site’s visitors leave and are gone forever after just a moment.\r\n\r\nHere’s an idea…\r\n \r\nHow about making it really SIMPLE for every visitor who shows up to get a personal phone call from you as soon as they hit your site…\r\n \r\nYou can –\r\n  \r\nLead Conversion is a software widget that’s works on your site, set to capture any visitor’s Name, Email address and Phone Number.  It notifies you the moment they let you know they’re interested – so that you can speak to that lead while they’re actually looking over your site.\r\n\r\nCLICK HERE https://bit.ly/3LPltcD to try out a Live Demo with Web Conversion now to see precisely how it works.\r\n\r\nYou’ll be surprised - the difference between contacting someone within 5 minutes versus a half-hour or more later could boost your results 100-fold.\r\n\r\nIt gets even better… once you’ve captured their phone number, with our new SMS Text With Lead feature, you can instantly start a text (SMS) conversation.\r\n  \r\nThat way, even if you don’t close a deal instantly, you can follow up with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nQuite sweet – AND effective.\r\n\r\nCLICK HERE https://bit.ly/3LPltcD to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more leads today!\r\n\r\nJesus\r\nPS: Lead Conversion offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting with you right now… don’t keep them waiting. \r\nCLICK HERE https://bit.ly/3LPltcD to try Web Conversion now.\r\n\r\nIf you\\\'d like to unsubscribe click here https://bit.ly/3rD0G5c\r\n\r\nOnly a swift message - the names and email address utilized here, Jesus and Heagney, are stand-ins and not really genuine information. We value openness and wanted to assure you’re informed! In case you wish to connect with the actual person behind this communication, do visit our site, and we’ll connect you with the appropriate individual.\r\n'),
(2628, 208, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2629, 208, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2630, 209, 'fld_5462783', 'nom', 'Burysek'),
(2631, 209, 'fld_3436924', 'prenom', 'Gilles'),
(2632, 209, 'fld_2124341', 'adresse_mail', 'gburysek@online-strategie.fr'),
(2633, 209, 'fld_724362', 'num_tel', '06 78 23 24 63'),
(2634, 209, 'fld_475276', 'socite', 'Perspectives Numériques'),
(2635, 209, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2636, 209, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2637, 209, 'fld_2695739', 'objet', 'Sécurité et SSIAD pour événement le 17 octobre à la CCI de Troyes'),
(2638, 209, 'fld_3396882', 'message', 'Bonjour,\r\nNous aurions besoin d\\\'un devis pour une prestation de sécurité au nom de Perspectives Numériques 10 CCI Espace Règley 1 Bd Charles Baltet 10000 Troyes (devis réalisé pour la CCI N°2023090041 du 28/09/23 afin de vous confirmer la commande de prestation.\r\nVous remerciant par avance,\r\nBien cordialement,\r\nGilles Burysek\r\nPrésident de Perspectives Numériques 10'),
(2639, 209, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2640, 209, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2641, 209, 'fld_3201949', 'envoyer', 'click'),
(2642, 210, 'fld_5462783', 'nom', 'Garfield'),
(2643, 210, 'fld_3436924', 'prenom', 'Garfield'),
(2644, 210, 'fld_2124341', 'adresse_mail', 'projectleadsblue@gmail.com'),
(2645, 210, 'fld_724362', 'num_tel', '(07) 5301 5222'),
(2646, 210, 'fld_475276', 'socite', 'Xuuhdx'),
(2647, 210, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2648, 210, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2649, 210, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2650, 210, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2651, 210, 'fld_2695739', 'objet', 'V fbdq w'),
(2652, 210, 'fld_3396882', 'message', 'Want to start getting 10x  more customers today? Reach the exact customer inbox like I reached you and boost sales for your service or products, and I\\\'ll show you how it\\\'s done: Check out: https://leadsblue.net/    once to find more. We are offering an 80% discount today.'),
(2653, 210, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2654, 210, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2655, 211, 'fld_5462783', 'nom', 'NASCIMENTO'),
(2656, 211, 'fld_3436924', 'prenom', 'Fabrice'),
(2657, 211, 'fld_2124341', 'adresse_mail', 'fabmarc1@yahoo.fr'),
(2658, 211, 'fld_724362', 'num_tel', '07 63 00 82 90'),
(2659, 211, 'fld_6078931', 'agence_souhait.opt1109492', 'Est Champagne Ardenne '),
(2660, 211, 'fld_6078931', 'agence_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2661, 211, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/SSIAP-CV-Fabrice-NASCIEMENTO-2023.pdf'),
(2662, 211, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/LM-Fabrice-N-SSIAP-1.pdf'),
(2663, 211, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nJe me permets de vous adresser ma candidature pour le poste de SSIAP 1 au sein de votre société, pour le site de Clairvaux. Fort de mon expérience en tant que Sapeur-Pompier Volontaire et Pompier SSIAP 1. Je suis convaincu de pouvoir apporter une réelle valeur ajoutée à l’équipe et je reste à votre disposition pour échanger davantage.\r\n\r\nCordialement,\r\nFabrice Marcelin NASCIMENTO.'),
(2664, 211, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2665, 211, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2666, 211, 'fld_3201949', 'envoyer', 'click'),
(2667, 212, 'fld_5462783', 'nom', 'Tabatha'),
(2668, 212, 'fld_3436924', 'prenom', 'Tabatha'),
(2669, 212, 'fld_2124341', 'adresse_mail', 'gomez.tabatha@gmail.com'),
(2670, 212, 'fld_724362', 'num_tel', '06-41735791'),
(2671, 212, 'fld_475276', 'socite', 'Btrrvdrvshy'),
(2672, 212, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2673, 212, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2674, 212, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2675, 212, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2676, 212, 'fld_2695739', 'objet', 'Usso Cj'),
(2677, 212, 'fld_3396882', 'message', 'Accidental overdose is the #1 cause of death for people aged 18-45 in the United States.\r\n\r\n \r\n\r\nNarcan is a nasal spray that can reverse an opioid overdose, saving the person’s life.  Our group of volunteers has compiled a website that tracks organizations that are giving out free and discount Narcan, this site is  https://www.narcan-finder.com/. \r\n\r\n \r\n\r\nEventually this life saving medication will be as easy to find as a fire extinguisher, but at the moment, it’s only gradually becoming available, and often expensive at drugstores, etc. Would you consider sharing our resource on your website?  It will save lives.\r\n\r\n \r\n\r\nIf you have any questions or want to help spread the word, contact us at narcanfinder@gmail.com. Thank you for your consideration!'),
(2678, 212, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2679, 212, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2680, 213, 'fld_5462783', 'nom', 'Eric'),
(2681, 213, 'fld_3436924', 'prenom', 'Eric'),
(2682, 213, 'fld_2124341', 'adresse_mail', 'eric.rubino24@yahoo.com'),
(2683, 213, 'fld_724362', 'num_tel', '0323 2018090'),
(2684, 213, 'fld_475276', 'socite', 'Eric Rubino'),
(2685, 213, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2686, 213, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2687, 213, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2688, 213, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2689, 213, 'fld_2695739', 'objet', 'Nhe ai'),
(2690, 213, 'fld_3396882', 'message', 'Hi artus-securite.fr Administrator!\r\n\r\nEric here with a brief thought about your website artus-securite.fr...\r\n\r\nI’m throughout the internet quite a bit and I observe numerous business websites.\r\n\r\nLike yours, several them have fantastic content.\r\n\r\nBut more often than not, they come up short when it comes to interacting and connecting with anybody who visits.\r\n\r\nI get it – it’s challenging. Studies show 7 out of 10 people who visit a site, abandon it in moments without leaving a trace. You got the eyeball, but nothing else.\r\n\r\nI have a solution for you…\r\n\r\nWeb Visitors Into Leads is a software widget that’s operates on your site, ready to capture any visitor’s Name, Email address, and Phone Number. You’ll know right away they’re interested and you can call them directly to chat with them actually while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://bit.ly/3LPltcD to experience a Live Demo with Web Visitors Into Leads now to see specifically how it works.\r\n\r\nIt can be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – instantly… and contacting someone in that 5-minute window is 100 times more effective than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow-up notes to continue the conversation going.\r\n\r\nEverything I’ve just described is very easy to implement, cost-effective, and profitable.\r\n\r\nCLICK HERE https://bit.ly/3LPltcD to discover what Instant Engagement Tool can do for your business.\r\n\r\nYou might be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Lead Capture offers a FREE 14 days trial – and it even includes International Long Distance Calling.\r\nYou have customers ready to talk with you immediately… don’t keep them waiting.\r\nCLICK HERE https://bit.ly/3LPltcD to try Lead Capture now.\r\n\r\nIf you\\\'d choose to unsubscribe click here https://bit.ly/3rD0G5c\r\n\r\nJust a quick message - the names and email applied here, Eric and Rubino, are placeholders and not really actual contact details. We cherish transparency and desired to assure you are conscious! If ever you aspire to get in touch with the genuine individual behind this message, please check out our website, and we’ll associate you with the appropriate entity.\r\n'),
(2691, 213, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2692, 213, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2693, 214, 'fld_5462783', 'nom', 'Charley'),
(2694, 214, 'fld_3436924', 'prenom', 'Charley'),
(2695, 214, 'fld_2124341', 'adresse_mail', 'santiago.charley59@gmail.com'),
(2696, 214, 'fld_724362', 'num_tel', '(02) 6742 4290'),
(2697, 214, 'fld_475276', 'socite', 'Charley Santiago'),
(2698, 214, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2699, 214, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2700, 214, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2701, 214, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2702, 214, 'fld_2695739', 'objet', 'Uerkslwjlmlie'),
(2703, 214, 'fld_3396882', 'message', 'Dear to the artus-securite.fr Admin! I am Charley and I have just ran across your website at artus-securite.fr...\r\n\r\nI located it after a quick searching, so your SEO’s performing well…\r\n\r\nContent seems good…\r\n\r\nOne thing is absent though…\r\n\r\nA RAPID, EFFORTLESS way to get in touch with you IMMEDIATELY.\r\n\r\nBecause research reveal that a web lead like me will only hang out a short time – 7 out of 10 vanish almost instantly, Click Browse Browse… then gone.\r\n\r\nI have the remedy:\r\n\r\nWeb Visitors Into Leads is a software that’s works on your site, set to capture any visitor’s Name, Email address, and Phone Number. You will realize instantly they’re interested, and you can call them directly to CHAT with them - literally while they’re still looking at your website.\r\n\r\nCLICK HERE https://bit.ly/LeadGena to test a Live Demo with Web Visitors Into Leads right now to see exactly how it operates and even give it a try… it could be big for your business.\r\n\r\nPlus, now that you’ve got that that phone number, with our new SMS Text With Lead feature, you can automatically begin a text (SMS) conversation pronto… which so powerful, since connecting with someone within 5 minutes is 100 times more effective than waiting 30 minutes or more later.\r\n\r\nThe new text messaging function lets you follow-up frequently with new offers even follow-up notes to build a relation.\r\n\r\nEverything I’ve just mentioned is extremely simple put in place, cost-effective, and lucrative.\r\n\r\nCLICK HERE https://bit.ly/LeadGena to find out what Web Visitors Into Leads can do for your company, potentially up to 100X more visitors into leads right now!\r\n\r\nCharley\r\nPS: Web Visitors Into Leads gives a FREE 14 days trial – and it even comes with International Long Distance Calls. \r\nYou have customers eager to speak with you right now… don’t leave them waiting. \r\nCLICK HERE https://bit.ly/LeadGena to try Web Visitors Into Leads today.\r\n\r\nShould you like to unsubscribe click here https://bit.ly/3rD0G5c\r\n\r\nJust a fast note - the names and email used here, Charley and Santiago, are placeholders and not genuine contact details. We respect transparency and want to make sure you’re aware! If you desire to reach out with the genuine person behind this message, kindly visit our website, and we’ll associate you with the right individual.}\r\n'),
(2704, 214, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2705, 214, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2706, 215, 'fld_5462783', 'nom', 'DA SILVA'),
(2707, 215, 'fld_3436924', 'prenom', 'Evan'),
(2708, 215, 'fld_2124341', 'adresse_mail', 'guichette10@hotmail.fr'),
(2709, 215, 'fld_724362', 'num_tel', '06 65 14 68 58'),
(2710, 215, 'fld_6078931', 'agence_souhait.opt1109492', 'Est Champagne Ardenne '),
(2711, 215, 'fld_6078931', 'agence_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2712, 215, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-PHOTO-1.pdf'),
(2713, 215, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/ARTUS-securite-.pdf'),
(2714, 215, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nJe vous envoie ma lettre de motivation ainsi que mon CV dans le cadre d’un stage en classe de seconde « Métiers de la sécurité » au lycée Jeanne Mance (pour janvier 2024).\r\n\r\nEn vous remerciant par avance,\r\n\r\nCordialement,\r\n\r\n\r\nEvan DA SILVA, 15 ans.\r\n'),
(2715, 215, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2716, 215, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2717, 215, 'fld_3201949', 'envoyer', 'click'),
(2718, 216, 'fld_5462783', 'nom', 'Lanord'),
(2719, 216, 'fld_3436924', 'prenom', 'Louis'),
(2720, 216, 'fld_2124341', 'adresse_mail', 'louis.lanord@utt.fr'),
(2721, 216, 'fld_724362', 'num_tel', '07 63 17 11 05'),
(2722, 216, 'fld_475276', 'socite', 'BDE UTT'),
(2723, 216, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2724, 216, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2725, 216, 'fld_2695739', 'objet', 'Demande d\\\'agents 9 décembre'),
(2726, 216, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nJe m\\\'appelle Louis LANORD, je suis le président de la fanfare de l\\\'UTT, Peacetone Brass Band. Tout les 3ans, notre fanfare organise un concert appelé le Trib\\\'UT.\r\nCette année, le Trib\\\'Ut aura lieu le samedi 9 décembre à la chapelle Argence à Troyes. Il contera environ 400 personnes et durera de 19h à 1h30.\r\nPour cette évènement nous aurons donc besoin de 5 agents dont au moins une femme.\r\n\r\nExcellente journée,\r\nLouis LANORD\r\nprésident Peacetone Bras Band'),
(2727, 216, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2728, 216, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2729, 216, 'fld_3201949', 'envoyer', 'click'),
(2730, 217, 'fld_5462783', 'nom', 'Mellisa'),
(2731, 217, 'fld_3436924', 'prenom', 'Mellisa'),
(2732, 217, 'fld_2124341', 'adresse_mail', 'mellisa.morwood@gmail.com'),
(2733, 217, 'fld_724362', 'num_tel', '0664 532 91 76'),
(2734, 217, 'fld_475276', 'socite', 'Mellisa Morwood'),
(2735, 217, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2736, 217, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2737, 217, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2738, 217, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2739, 217, 'fld_2695739', 'objet', 'Zb Yxvfjgw'),
(2740, 217, 'fld_3396882', 'message', 'Cool website!\r\n\r\nHello artus-securite.fr Owner.\r\n\r\nMy name’s Mellisa, and I recently located your site - artus-securite.fr - while surfing the net. You appeared at the top of the search results, so I looked you out. Looks like what you’re doing is pretty cool.  \r\n\r\nBut if you don’t mind me inquiring – after someone like me comes across artus-securite.fr, what typically happens?\r\n\r\nIs your site creating leads for your company? \r\n\r\nI’m guessing some, but I also wager you’d like more… studies demonstrate that 7 out 10 who land on a site wind up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a notion – what if there was an easy way for every visitor to “elevate their hand” to get a phone call from you INSTANTLY… the second they hit your site and declared, “call me now.”\r\n\r\nYou can –\r\n  \r\nWeb Visitor is a software widget that’s works on your site, prepared to grab any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can chat to that lead while they’re actually looking your site.\r\n\r\nCLICK HERE https://bit.ly/3LPltcD to experiment with a Live Demo with Web Visitor now to see specifically how it works.\r\n\r\nTime is money when it comes to linking with leads – the distinction between contacting someone within 5 minutes versus 30 minutes later can be massive – like 100 times better!\r\n\r\nThat’s why we built out our new SMS Text With Lead attribute because once you’ve captured the visitor’s phone number, you can instantly a text message (SMS) conversation.\r\n  \r\nThink about the possibilities – even if you don’t close a deal then and there, you can follow with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE https://bit.ly/3LPltcD to discover what Web Visitor can do for your business\r\n\r\nYou could be converting up to 100X more leads today!\r\nMellisa\r\n\r\nPS: Web Visitor provides FREE 14 days trial – and it even includes Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://bit.ly/3LPltcD to try Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here https://bit.ly/3rD0G5c\r\n\r\nMerely a swift notification - the names and email used in this communication, Mellisa and Morwood, are stand-ins and not really actual contact information. We value honesty and wanted to assure you’re informed! Should you want to communicate with the actual individual behind this memo, kindly visit our website, and we’ll associate you with the proper entity.\r\n'),
(2741, 217, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2742, 217, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2743, 218, 'fld_5462783', 'nom', 'Mitchel'),
(2744, 218, 'fld_3436924', 'prenom', 'Mitchel'),
(2745, 218, 'fld_2124341', 'adresse_mail', 'edmonds.mitchel@yahoo.com'),
(2746, 218, 'fld_724362', 'num_tel', '04.27.35.54.30'),
(2747, 218, 'fld_475276', 'socite', 'Mitchel Edmonds'),
(2748, 218, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2749, 218, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2750, 218, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2751, 218, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2752, 218, 'fld_2695739', 'objet', 'Unp Eles R'),
(2753, 218, 'fld_3396882', 'message', 'Hello,\r\n\r\nWe noticed artus-securite.fr is only listed in 8 out of 2500 directories.\r\n\r\nThis severly impacts your backlinks and search engine rankings.\r\n\r\nCome get listed in all 2500 directories on DirectoryBump.com'),
(2754, 218, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2755, 218, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2756, 219, 'fld_5462783', 'nom', 'Eric'),
(2757, 219, 'fld_3436924', 'prenom', 'Eric');
INSERT INTO `mod284_cf_form_entry_values` (`id`, `entry_id`, `field_id`, `slug`, `value`) VALUES 
(2758, 219, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(2759, 219, 'fld_724362', 'num_tel', '555-555-1212'),
(2760, 219, 'fld_475276', 'socite', 'Tfjb Ziyzyerlo'),
(2761, 219, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2762, 219, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2763, 219, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2764, 219, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2765, 219, 'fld_2695739', 'objet', 'Nx dmwp dm Ymi'),
(2766, 219, 'fld_3396882', 'message', 'Hi artus-securite.fr Administrator! Eric here with a quick thought about your website artus-securite.fr...\r\n\r\nI’m on the internet a lot and I look at a lot of business websites.\r\n\r\nLike yours, many of them have great content. \r\n\r\nBut all too often, they come up short when it comes to engaging and connecting with anyone who visits.\r\n\r\nI get it – it’s hard.  Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving even a trace.  You got the eyeball, but nothing else.\r\n\r\nHere’s a solution for you…\r\n\r\nWeb Visitors Into Leads is a software widget that’s works on your site, ready to capture any visitor’s Name, Email address and Phone Number.  You’ll know immediately they’re interested and you can call them directly to talk with them literally while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://bit.ly/leadgenerationc to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nIt could be huge for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation – immediately… and contacting someone in that 5 minute window is 100 times more powerful than reaching out 30 minutes or more later.\r\n\r\nPlus, with text messaging you can follow up later with new offers, content links, even just follow up notes to keep the conversation going.\r\n\r\nEverything I’ve just described is extremely simple to implement, cost-effective, and profitable. \r\n \r\nCLICK HERE https://bit.ly/leadgenerationc to discover what Web Visitors Into Leads can do for your business.\r\n\r\nYou could be converting up to 100X more eyeballs into leads today!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling. \r\nYou have customers waiting to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://bit.ly/leadgenerationc to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here https://bit.ly/3rD0G5c\r\n\r\n'),
(2767, 219, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2768, 219, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2769, 220, 'fld_5462783', 'nom', 'Michael'),
(2770, 220, 'fld_3436924', 'prenom', 'Michael'),
(2771, 220, 'fld_2124341', 'adresse_mail', 'blackwood.eula@outlook.com'),
(2772, 220, 'fld_724362', 'num_tel', '03.71.67.21.42'),
(2773, 220, 'fld_475276', 'socite', 'Jtg upwproabrv'),
(2774, 220, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2775, 220, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2776, 220, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2777, 220, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2778, 220, 'fld_2695739', 'objet', 'Cpbirrfuwkppkk'),
(2779, 220, 'fld_3396882', 'message', 'Hello,\r\n  \r\nI was looking at your site and wanted to ask if you would be interested in getting one-hundred thousand emails sent out within 48 hours for just $48 - we call it our 48-Special.\r\n \r\nI’m with HiveMailers, we use a robust email system to get clients daily leads and/or sales 24/7.\r\n \r\nWE DO ALL THE WORK:\r\n\r\n- We create the content for the email(s).\r\n- We provide the email list (contacts).\r\n- We forward leads to you daily.\r\n- We manage your email campaigns 24/7.\r\n- We make changes to the list and content until we get results.\r\n\r\nJust imagine, getting hot leads within days of getting started with us. \r\n\r\nYou might be wondering if our system works, well if you are reading this message, it works. \r\n\r\nGet started now!!!!! We will send one hundred thousand emails for just $48 \r\n  \r\nBook a 10 min call with me now: https://bit.ly/hive-48-special\r\n\r\nNOTE: To buy an email list and hire an in-house email manager to run your campaign (like our system) would cost around $3,500 a month, but with us, you pay just $48. So, you save over $3,450.\r\n\r\nThis offer is good for the first 20 clients, don’t miss out.  Book appointment now: https://bit.ly/hive-48-special\r\n\r\nSincerely,\r\nMichael'),
(2780, 220, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2781, 220, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2782, 221, 'fld_5462783', 'nom', 'NEYT'),
(2783, 221, 'fld_3436924', 'prenom', 'FLORIAN'),
(2784, 221, 'fld_2124341', 'adresse_mail', 'neytflorian@gmail.com'),
(2785, 221, 'fld_724362', 'num_tel', '07 67 57 46 33'),
(2786, 221, 'fld_6078931', 'agence_souhait.opt1109492', 'Est Champagne Ardenne '),
(2787, 221, 'fld_6078931', 'agence_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2788, 221, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-Florian-1.docx-update1-1.pdf'),
(2789, 221, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/LM_Copie-1.pdf'),
(2790, 221, 'fld_3396882', 'message', 'Bonjour,\r\n  \r\nVeuillez trouver ci-joint ma candidature ,en espérant que celle-ci sera retenir votre attention.\r\n\r\nCordialement \r\n\r\nFlorian NEYT'),
(2791, 221, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2792, 221, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2793, 221, 'fld_3201949', 'envoyer', 'click'),
(2794, 222, 'fld_5462783', 'nom', 'Gertrude'),
(2795, 222, 'fld_3436924', 'prenom', 'Gertrude'),
(2796, 222, 'fld_2124341', 'adresse_mail', 'gertrude.kujawski@gmail.com'),
(2797, 222, 'fld_724362', 'num_tel', '(07) 3397 8509'),
(2798, 222, 'fld_475276', 'socite', 'Z B us f'),
(2799, 222, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2800, 222, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2801, 222, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2802, 222, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2803, 222, 'fld_2695739', 'objet', 'Yaztuo brqlaq'),
(2804, 222, 'fld_3396882', 'message', 'Find the best designer-made video templates for your projects. \r\n\r\nI invite you to buy at\r\nhttps://bit.ly/envatomarketelements\r\n\r\nThank you'),
(2805, 222, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2806, 222, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2807, 223, 'fld_5462783', 'nom', 'LOCHEY'),
(2808, 223, 'fld_3436924', 'prenom', 'Marie-Claude'),
(2809, 223, 'fld_2124341', 'adresse_mail', 'intendant@cathotroyes.fr'),
(2810, 223, 'fld_724362', 'num_tel', '07 44 44 79 84'),
(2811, 223, 'fld_475276', 'socite', 'Association diocésaine de Troyes'),
(2812, 223, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2813, 223, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2814, 223, 'fld_2695739', 'objet', 'demande devis et renseignements'),
(2815, 223, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nNous sommes en train de mettre en place un contrat de télésurveillance pro pour notre site Maison Notre Dame en l\\\'Isle 10 rue de l\\\'ile 10 000 Troyes avec Securitas. Sur conseil de M. Baguet nous souhaiterions connaître vos tarifs en cas de besoin de déplacement de vos agents pour constater l\\\'éventuelle effraction après déclenchement de l\\\'alarme en dehors des heures d\\\'ouverture de nos bureaux.\r\nPour plus de renseignements n\\\'hésitez pas à me contacter.\r\nJe vous remercie.\r\nBien cordialement,\r\nMCL, responsable de maison\r\n'),
(2816, 223, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2817, 223, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2818, 223, 'fld_3201949', 'envoyer', 'click'),
(2819, 224, 'fld_5462783', 'nom', 'Husson -- D\\\'Hon '),
(2820, 224, 'fld_3436924', 'prenom', 'Anaëlle'),
(2821, 224, 'fld_2124341', 'adresse_mail', 'hussondhonanaelle@gmail.com'),
(2822, 224, 'fld_724362', 'num_tel', '06 61 11 07 00'),
(2823, 224, 'fld_475276', 'socite', 'lycéénne'),
(2824, 224, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2825, 224, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(2826, 224, 'fld_2695739', 'objet', 'demande de stage'),
(2827, 224, 'fld_3396882', 'message', 'Bonjour,\r\nje suis en seconde professionnelle métier de la sécurité et je recherche un stage du 4 au 23 décembre 2023.\r\nbien cordialement'),
(2828, 224, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2829, 224, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2830, 224, 'fld_3201949', 'envoyer', 'click'),
(2831, 225, 'fld_5462783', 'nom', 'Eugenio'),
(2832, 225, 'fld_3436924', 'prenom', 'Eugenio'),
(2833, 225, 'fld_2124341', 'adresse_mail', 'eugenio.corbo@msn.com'),
(2834, 225, 'fld_724362', 'num_tel', '06-47246316'),
(2835, 225, 'fld_475276', 'socite', 'Mqlai xq F'),
(2836, 225, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2837, 225, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2838, 225, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2839, 225, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2840, 225, 'fld_2695739', 'objet', 'Avl Rnkane'),
(2841, 225, 'fld_3396882', 'message', 'I was sending you this message on your website contact page (artus-securite.fr) to show you how contact form advertising works. We can send messages just like these for your business to millions of sites for less than a couple of hundred dollars. Let\\\'s get the conversation started and I\\\'ll share pricing and more details. Hit me up on Skype for a chat now -->  contactformmarketing2023'),
(2842, 225, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2843, 225, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2844, 226, 'fld_5462783', 'nom', 'KELDENICH'),
(2845, 226, 'fld_3436924', 'prenom', 'CELINE'),
(2846, 226, 'fld_2124341', 'adresse_mail', 'celine.keldenidh@alumni.utc.fr'),
(2847, 226, 'fld_724362', 'num_tel', '06 10 65 10 69'),
(2848, 226, 'fld_475276', 'socite', 'TREMPLIN UTC / UTC ALUMNI'),
(2849, 226, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2850, 226, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(2851, 226, 'fld_2695739', 'objet', 'Demande de devis'),
(2852, 226, 'fld_3396882', 'message', 'Bonjour,\r\nPourriez-vous me faire parvenir un devis pour une prestation de contrôle d\\\'entrée avec filtrage ?\r\nIl s\\\'agit d\\\'une prestation de 2h00 à Compiègne le samedi 18 novembre 2023.\r\nEn vous remerciant par avance pour votre retour.\r\n\r\nBien cordialement.\r\n\r\nCéline Keldenich'),
(2853, 226, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2854, 226, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2855, 226, 'fld_3201949', 'envoyer', 'click'),
(2856, 227, 'fld_5462783', 'nom', 'Lilia'),
(2857, 227, 'fld_3436924', 'prenom', 'Lilia'),
(2858, 227, 'fld_2124341', 'adresse_mail', 'horrocks.lilia@gmail.com'),
(2859, 227, 'fld_724362', 'num_tel', '(41) 7248-9410'),
(2860, 227, 'fld_475276', 'socite', 'Lilia Horrocks'),
(2861, 227, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2862, 227, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2863, 227, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2864, 227, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2865, 227, 'fld_2695739', 'objet', 'Booo'),
(2866, 227, 'fld_3396882', 'message', 'To the artus-securite.fr Webmaster!\r\n\r\nIt\\\'s Lilia here with a quick thought about your website artus-securite.fr...\r\n\r\nI’m throughout the internet frequently and I observe a lot of business websites.\r\n\r\nLike yours, many them have excellent content.\r\n\r\nBut frequently, they come up short when it comes to engaging and linking with anyone who visits.\r\n\r\nI understand – it’s hard. Studies show 7 out of 10 people who land on a site, abandon it in moments without leaving a trace. You got the eyeball, but nothing else.\r\n\r\nI have a solution for you…\r\n\r\nInstant Engagement Tool is a software widget that’s functions on your site, prepared to capture any visitor’s Name, Email address, and Phone Number. You’ll know right away they’re interested and you can call them directly to chat with them really while they’re still on the web looking at your site.\r\n\r\nCLICK HERE https://bit.ly/3LPltcD to test a Live Demo with Lead Capture now to see specifically how it works.\r\n\r\nIt might be massive for your business – and because you’ve got that phone number, with our new SMS Text With Lead feature, you can immediately start a text (SMS) conversation – right away… and contacting someone in that 5-minute window is 100 times more effective than reaching out 30 minutes or more later.\r\n\r\nMoreover, with text messaging you can follow up later with new offers, content links, even just follow-up notes to continue the conversation going.\r\n\r\nEach aspect I’ve just described is very straightforward to implement, cost-effective, and profitable.\r\n\r\nCLICK HERE https://bit.ly/3LPltcD to find out what Lead Capture can do for your business.\r\n\r\nYou might be converting up to 100X more eyeballs into leads today!\r\n\r\nLilia\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – and it even includes International Long Distance Calling.\r\nYou have customers eager to talk with you right now… don’t keep them waiting.\r\nCLICK HERE https://bit.ly/3LPltcD to use Instant Engagement Tool now.\r\n\r\nIf you\\\'d like to unsubscribe click here https://bit.ly/3rD0G5c\r\n\r\nOnly a brief message - the monikers and email address used in this note, Lilia and Horrocks, are placeholders and not actually authentic information. We esteem transparency and wanted to ensure you’re aware! If you desire to connect with the actual entity behind this message, please check out our website, and we’ll associate you with the appropriate person.\r\n'),
(2867, 227, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2868, 227, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2869, 228, 'fld_5462783', 'nom', 'Jackie'),
(2870, 228, 'fld_3436924', 'prenom', 'Jackie'),
(2871, 228, 'fld_2124341', 'adresse_mail', 'vista@vauleonline.co'),
(2872, 228, 'fld_724362', 'num_tel', '0324 3657945'),
(2873, 228, 'fld_475276', 'socite', 'Ontnn'),
(2874, 228, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2875, 228, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2876, 228, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2877, 228, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2878, 228, 'fld_2695739', 'objet', 'Njycrqpjhisr z'),
(2879, 228, 'fld_3396882', 'message', 'Hey,\r\n\r\nDo you want unlimited likes, followers\r\nand targeted traffic?\r\n\r\nThis is not about paying for clicks\r\nor anything like that...\r\n\r\nI’m talking about TRUE “set & forget”\r\nInstagram traffic that will BUY from you…\r\n\r\nAnd will totally FLOOD your account...\r\nOf course, you can also drive your Instagram traffic to website.\r\n\r\nWant to see proof for everything I say?\r\n\r\n==> Click here to see how I was\r\nable to generate 100k followers\r\nin less than 24 hours: https://www.vauleonline.co/vista \r\n\r\nHere’s the shocker:\r\n\r\nI didn’t have to do anything unethical\r\nor illegal...\r\nAlso, I never put my Instagram\r\naccount at risk…\r\n\r\nOr violated their TOS…\r\n\r\nWith one simple \\\"hack,\\\" I was able\r\nto get an endless amount of\r\n\\\"set & forget\\\" traffic...\r\n\r\nEasy peasy…\r\n\r\nYou can copy and clone this\r\nmethod right out of the box...\r\n\r\n==> Click here to unlock\r\nUNLIMITED Instagram traffic: https://www.vauleonline.co/vista \r\n\r\nIt works in ANY niche…\r\n\r\nIt works for ANY type of marketer…\r\n\r\nAnd it works for ANY type of\r\nonline business...\r\n\r\nDo not miss out on the new \r\nInstagram trend worth $100 billion...\r\n\r\nFinally, get all the world\\\'s traffic\r\n(... and then some...)\r\n\r\n==> Click here to enjoy\r\n“set & forget” Instagram traffic: https://www.vauleonline.co/vista \r\n\r\nTalk soon,\r\n\r\nJackie S. Torain\r\n\r\n\r\nUNSUBSCRIBE: https://www.vauleonline.co/unsubscribe\r\n\r\n231 4th Ave, Brooklyn, NY 11215'),
(2880, 228, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2881, 228, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2882, 229, 'fld_5462783', 'nom', 'Zoe'),
(2883, 229, 'fld_3436924', 'prenom', 'Zoe'),
(2884, 229, 'fld_2124341', 'adresse_mail', 'zoe.horne29@msn.com'),
(2885, 229, 'fld_724362', 'num_tel', '0346 3973284'),
(2886, 229, 'fld_475276', 'socite', 'Zoe Horne'),
(2887, 229, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2888, 229, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2889, 229, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2890, 229, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2891, 229, 'fld_2695739', 'objet', 'Py jjg twoou'),
(2892, 229, 'fld_3396882', 'message', 'Hi artus-securite.fr Administrator.\r\n\r\nI am Zoe and I’m assuming you’d prefer your site artus-securite.fr to create more leads.\r\n\r\nHere’s how:\r\nLead Conversion Software is a tool that’s works on your site, ready to capture any visitor’s Name, Email address, and Phone Number. It notifies you as soon as they declare they’re intrigued – so that you can converse with that lead while they’re still present at artus-securite.fr.\r\n\r\nLead Conversion Software – CLICK HERE https://turboleadgeneration.com for a live-action demo now.\r\n\r\nAnd now you’ve got their phone number, our new SMS Text With Lead feature permits you to initiate a text (SMS) discussion – answer questions, supply more info, and close a deal that way.\r\n\r\nIf they don’t agree on your offer then, just follow-up with text messages for new proposals, content links, even just how you doing? notes to build a connection.\r\n\r\nCLICK HERE https://turboleadgeneration.com to discover what Web Visitors Into Leads can do for your enterprise.\r\n\r\nThe distinction between contacting someone within 5 minutes versus a half-hour indicates you could be converting up to 100X more leads today!\r\n\r\nTest Lead Conversion Software and get more leads immediately.\r\n\r\nZoe\r\nPS: The studies show 7 out of 10 visitors do not hang around – you can’t allow to lose them!\r\nVisitor to Lead Widget offers a FREE 14 days trial – and it also includes International Long Distance Calling.\r\nYou have consumers eager to speak with you right now… do not keep them waiting.\r\nCLICK HERE https://turboleadgeneration.com to test Visitor to Lead Widget now.\r\n\r\nIf you\\\'d prefer to unsubscribe click here https://turboleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n\r\nSimply a quick message - the names and email employed in this message, Zoe and Horne, are substitutes and not really authentic information. We value honesty and aimed to ensure you are aware! If you aspire to communicate with the genuine person responsible for this memo, do visit our website, and we’ll associate you with the appropriate entity.\r\n'),
(2893, 229, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2894, 229, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2895, 230, 'fld_5462783', 'nom', 'Michael'),
(2896, 230, 'fld_3436924', 'prenom', 'Michael'),
(2897, 230, 'fld_2124341', 'adresse_mail', 'holtzmann.terry@gmail.com'),
(2898, 230, 'fld_724362', 'num_tel', '062 572 20 34'),
(2899, 230, 'fld_475276', 'socite', 'Whg awk bl s'),
(2900, 230, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2901, 230, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2902, 230, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2903, 230, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2904, 230, 'fld_2695739', 'objet', 'J Pbt'),
(2905, 230, 'fld_3396882', 'message', 'Hello,\r\n  \r\nI was looking at your site and wanted to ask if you would be interested in getting two-hundred and fifty thousand (250,000) emails sent out within 48 hours for just $48 - we call it our 48-Special.\r\n \r\nI’m with HiveMailers, we use a robust email system to get clients daily leads and/or sales 24/7.\r\n \r\nWE DO ALL THE WORK:\r\n\r\n- We create the content for the email(s).\r\n- We provide the email list (contacts).\r\n- We forward leads to you daily.\r\n- We manage your email campaigns 24/7.\r\n- We make changes to the list and content until we get results.\r\n\r\nWHO THIS IS FOR:\r\n\r\n- Companies who offer products/services to businesses (B2B).\r\n- Companies who provide a product/service with wide appeal (not a small niche).\r\n- Companies who product/service can be sold across the USA and/or international.\r\n\r\nJust imagine, getting hot leads within days of getting started with us. \r\n\r\nYou might be wondering if our system works, well if you are reading this message, it works. \r\n\r\nGet started now!!!!! We will send out two-hundred and fifty thousand (250,000) emails for just $48.\r\n\r\nTake action today and let’s get you some leads. This offer is good for the first 20 clients, don’t miss out.\r\n\r\nSimply book a time to talk on our calendar: https://bit.ly/hivemailer-special \r\n\r\nNOTE: To buy an email list and hire an in-house email manager to run your campaign (like our system) would cost around $3,500 a month, but with us, you pay just $48. So, you save over $3,450.\r\n\r\nSincerely,\r\n\r\nMichael\r\nHiveMailers\r\n\r\nCalendar: https://bit.ly/hivemailer-special \r\n'),
(2906, 230, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2907, 230, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2908, 231, 'fld_5462783', 'nom', 'Marié'),
(2909, 231, 'fld_3436924', 'prenom', 'Guillaume'),
(2910, 231, 'fld_2124341', 'adresse_mail', 'guigui1810@yahoo.fr'),
(2911, 231, 'fld_724362', 'num_tel', '06 24 66 52 39'),
(2912, 231, 'fld_475276', 'socite', 'Association Twirling sport de Noyon'),
(2913, 231, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2914, 231, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(2915, 231, 'fld_2695739', 'objet', 'Protection de site du 08/03 au 10/03'),
(2916, 231, 'fld_3396882', 'message', 'Bonjour,\r\nNous organisons un championnat de France à Noyon (60400) et nous recherchons un service de gardiennage de nuit du 08/03 à 19H au 10/03  à 8h.\r\nVotre tache sera sur 2 sites:\r\n- Gymnase Pierre Dubois Rue Jean Moulin, 60400 Noyon, gardiennage du vendredi soir au dimanche matin.\r\n- Gymnase Jean Bouin 75-209 Av. Jean Bouin, 60400 Noyon, gardiennage du vendredi soir au samedi matin.\r\nPouvez vous nous faire un devis en fonction du prévisionnel ci dessus.\r\nPouvez vous nous faire en parallèle un devis pour un service de sécurité parking pour 2 jours (09 et 10/03) au gymnase Pierre Dubois Rue Jean Moulin, 60400 Noyon\r\nDans l\\\'attente de votre retour.\r\nCordialement\r\nMr Marié'),
(2917, 231, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2918, 231, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2919, 231, 'fld_3201949', 'envoyer', 'click'),
(2920, 232, 'fld_5462783', 'nom', 'Traci'),
(2921, 232, 'fld_3436924', 'prenom', 'Traci'),
(2922, 232, 'fld_2124341', 'adresse_mail', 'reber.traci@gmail.com'),
(2923, 232, 'fld_724362', 'num_tel', 'P Ny ss qz'),
(2924, 232, 'fld_475276', 'socite', 'Traci Reber'),
(2925, 232, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2926, 232, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2927, 232, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2928, 232, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2929, 232, 'fld_2695739', 'objet', 'Qrn Nhch Pptx'),
(2930, 232, 'fld_3396882', 'message', 'Hello artus-securite.fr Owner.\r\n\r\nI\\\'m Traci and I just found your website at artus-securite.fr...\r\n\r\nI discovered it after a swift search, so your search engine optimization is working out…\r\n\r\nInformation looks pretty good…\r\n\r\nOne thing’s missing though…\r\n\r\nA FAST, SIMPLE way to get in touch with you IMMEDIATELY.\r\n\r\nBecause data show that a potential customer like me will only hang out a few seconds – 7 out of 10 leave almost immediately, Click Browse Browse… then disappeared.\r\n\r\nI have the solution:\r\n\r\nVisitor Engagement Widget is a tool that’s operates on your website, ready to capture any visitor’s Name, Email address, and Phone Number. You will know right away they’re engaged and you can call them directly to CHAT with them - literally while they’re still on the internet looking at your site.\r\n\r\nCLICK HERE https://turboleadgeneration.com to test a Live Demo with Visitor Engagement Widget now to see just how it works and even give it a try… it could be massive for your enterprise.\r\n\r\nAdditionally, now that you’ve got that phone number, with our new SMS Text With Lead feature, you can automatically start a text (SMS) conversation right away… which is so powerful, because connecting with someone within the first 5 minutes is 100 times more efficient than waiting 30 minutes or more later.\r\n\r\nThe new text messaging feature lets you stay connected consistently with new offers, content links, even just check-in notes to develop a relationship.\r\n\r\nEvery single thing I’ve just described is extremely easy to implement, cost-effective, and profitable.\r\n\r\nCLICK HERE https://turboleadgeneration.com to find out what Web Visitors Into Leads can do for your business, potentially converting up to 100X more eyeballs into leads right now!\r\n\r\nTraci\r\nPS: Visitor Engagement Widget offers a FREE 14 days trial – and it even includes International Long Distance Calling.\r\nYou have clients waiting to chat with you right now… don’t keep them waiting.\r\nCLICK HERE https://turboleadgeneration.com to use Lead Conversion Tool now.\r\n\r\nIf you\\\'d like to unsubscribe click here https://turboleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n\r\nMerely a brief remark - the identities and email address employed in this communication, Traci and Reber, are placeholders and not actually real information. We value candor and wished to assure you are conscious! In case you wish to connect with the actual entity behind this communication, please go to our site, and we’ll connect you with the proper person.\r\n'),
(2931, 232, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2932, 232, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2933, 233, 'fld_5462783', 'nom', 'James'),
(2934, 233, 'fld_3436924', 'prenom', 'Jimmy'),
(2935, 233, 'fld_2124341', 'adresse_mail', 'hannelore.france95@gmail.com'),
(2936, 233, 'fld_724362', 'num_tel', '8579454975'),
(2937, 233, 'fld_475276', 'socite', 'Wf Oe C'),
(2938, 233, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2939, 233, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2940, 233, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2941, 233, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2942, 233, 'fld_2695739', 'objet', 'Nrrt cgbhpsdt'),
(2943, 233, 'fld_3396882', 'message', 'Is Your Search Console Reporting Errors? Don\\\'t let issues hold back your SEO! Specializing in fixing Search Console errors for higher rankings. Resolve crawl issues, improve indexing, and supercharge your SEO. Let\\\'s boost your site together! Visit now: https://speedexpert.co/search-console/\r\n\r\nWe also offer Web Designing Services:\r\n\r\n7 Pages Website, 2 Contact Forms, Responsive Design, Onsite SEO, Banner with Slideshow on Home Page, Professional and affordable website design - Starts $79 . More details: https://wpexpertspro.co/website/'),
(2944, 233, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2945, 233, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2946, 234, 'fld_5462783', 'nom', 'LANGUILLAT'),
(2947, 234, 'fld_3436924', 'prenom', 'Emilie'),
(2948, 234, 'fld_2124341', 'adresse_mail', 'e.languillat@la-chapelle-st-luc.eu'),
(2949, 234, 'fld_724362', 'num_tel', '03 25 71 62 57'),
(2950, 234, 'fld_475276', 'socite', 'Mairie de La Chapelle Saint-Luc'),
(2951, 234, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2952, 234, 'fld_6078931', 'secteur_souhait', '{\"opt1636010\":\"Ile de France \"}'),
(2953, 234, 'fld_2695739', 'objet', 'demande de devis SSIAP'),
(2954, 234, 'fld_3396882', 'message', 'Bonjour,\r\n\r\n\r\nNous souhaitons obtenir un devis pour la présence de 2 agents SSIAP pour le vendredi 12 janvier 2024 lors de la cérémonie des voeux du personnel qui aura lieu au Centre Cultuel Didier Bienaimé (horaire 17h30 à 03h00 environ).\r\n\r\n\r\nRestant à votre disposition,\r\n\r\n\r\nBien Cordialement'),
(2955, 234, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2956, 234, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2957, 234, 'fld_3201949', 'envoyer', 'click'),
(2958, 235, 'fld_5462783', 'nom', 'LANGUILLAT'),
(2959, 235, 'fld_3436924', 'prenom', 'Emilie'),
(2960, 235, 'fld_2124341', 'adresse_mail', 'e.languillat@la-chapelle-st-luc.eu'),
(2961, 235, 'fld_724362', 'num_tel', '03 25 71 62 57'),
(2962, 235, 'fld_475276', 'socite', 'Mairie de La Chapelle Saint-Luc'),
(2963, 235, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2964, 235, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2965, 235, 'fld_2695739', 'objet', 'demande de devis SSIAP'),
(2966, 235, 'fld_3396882', 'message', 'Bonjour,\r\n\r\n\r\nNous souhaitons obtenir un devis pour la présence de 2 agents SSIAP pour le vendredi 12 janvier 2024 lors de la cérémonie des voeux du personnel qui aura lieu au Centre Cultuel Didier Bienaimé (horaire 17h30 à 03h00 environ).\r\n\r\n\r\nRestant à votre disposition,\r\n\r\n\r\nBien Cordialement'),
(2967, 235, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2968, 235, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2969, 235, 'fld_3201949', 'envoyer', 'click'),
(2970, 236, 'fld_5462783', 'nom', 'Marguerite'),
(2971, 236, 'fld_3436924', 'prenom', 'Marguerite'),
(2972, 236, 'fld_2124341', 'adresse_mail', 'claflin.marguerite61@gmail.com'),
(2973, 236, 'fld_724362', 'num_tel', '(08) 9064 2652'),
(2974, 236, 'fld_475276', 'socite', 'Nzpdejzvkygxnc'),
(2975, 236, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2976, 236, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2977, 236, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2978, 236, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2979, 236, 'fld_2695739', 'objet', 'Bz aij Dfyh'),
(2980, 236, 'fld_3396882', 'message', 'Hi, \r\n\r\nartus-securite.fr is only listed in a 8/10,000+ Directories\r\n\r\nWe have a black friday deal going on at the moment to get your website listed in all 10k+ for $19.95\r\n\r\nVisit us on DirectoryBump.com'),
(2981, 236, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2982, 236, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2983, 237, 'fld_5462783', 'nom', 'Johnathon'),
(2984, 237, 'fld_3436924', 'prenom', 'Johnathon'),
(2985, 237, 'fld_2124341', 'adresse_mail', 'freetraffic@solveques.xyz'),
(2986, 237, 'fld_724362', 'num_tel', '0491 31 14 48'),
(2987, 237, 'fld_475276', 'socite', 'Jbydw eole'),
(2988, 237, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(2989, 237, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(2990, 237, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(2991, 237, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(2992, 237, 'fld_2695739', 'objet', 'Erzterqz'),
(2993, 237, 'fld_3396882', 'message', 'I know you see a lot of new methods for getting traffic and making money cross your desk every week…\r\n\r\nSome are good… some are bad…\r\n\r\nSome work… some don’t.\r\n\r\nI’m very excited to let you know about one of THE BEST methods I’ve ever seen for making money online.\r\n\r\nYou don’t have to run ads…\r\n\r\nYou don’t need any prior online marketing skills or experience…\r\n\r\nYou don’t have to create videos or do anything technical…\r\n\r\nIf you want to bank up to $128 per day, all you have to do is follow the step-by-step training inside this brand new course.\r\n\r\nIt’s called Empire.\r\nEmpire method teaches students how they can build an online business from scratch using only FREE traffic.     This course is designed to help people who are new to internet marketing to get their first sales online within 24-48 hours and to then build that income up to $128 per day over time.\r\n\r\nHere’s the link: https://www.solveques.xyz/freetraffic \r\n\r\nTalk soon,\r\n\r\nJohnathon J. Gervais\r\n\r\nUNSUBSCRIBE: https://www.solveques.xyz/unsubscribe/\r\n\r\n1201 N 2nd St #25, Yakima, WA 98901'),
(2994, 237, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(2995, 237, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(2996, 238, 'fld_5462783', 'nom', 'derval'),
(2997, 238, 'fld_3436924', 'prenom', 'didier'),
(2998, 238, 'fld_2124341', 'adresse_mail', 'didier.derval@assaabloy.com'),
(2999, 238, 'fld_724362', 'num_tel', '03 25 42 31 24'),
(3000, 238, 'fld_475276', 'socite', 'Assa abloy France'),
(3001, 238, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3002, 238, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3003, 238, 'fld_2695739', 'objet', 'appel d\\\'offre'),
(3004, 238, 'fld_3396882', 'message', 'Bonjour ,nous avons lancé un appel d\\\'offre national, mais souhaiterions étudier les solutions locales offert à nos site. Pourriez vous rapidement me contacter afin de vous envoyer notre cahier des charges pour les sites de l\\\'aube\r\ncdt'),
(3005, 238, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3006, 238, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3007, 238, 'fld_3201949', 'envoyer', 'click'),
(3008, 239, 'fld_5462783', 'nom', 'Tam'),
(3009, 239, 'fld_3436924', 'prenom', 'Tam'),
(3010, 239, 'fld_2124341', 'adresse_mail', 'binns.tam56@hotmail.com'),
(3011, 239, 'fld_724362', 'num_tel', '0335 6802861'),
(3012, 239, 'fld_475276', 'socite', 'Tam Binns'),
(3013, 239, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(3014, 239, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(3015, 239, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3016, 239, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3017, 239, 'fld_2695739', 'objet', 'B xnvu ib'),
(3018, 239, 'fld_3396882', 'message', 'Cool website!\r\n\r\nDear artus-securite.fr Administrator.\r\n\r\nMy name’s Tam, and I recently located your site - artus-securite.fr - while browsing the net. You showed up at the top of the search results, so I checked you out. Seems like what you’re doing is quite cool.  \r\n\r\nBut if you don’t mind me inquiring – after someone like me runs across artus-securite.fr, what usually happens?\r\n\r\nIs your site producing leads for your business? \r\n\r\nI’m supposing some, but I also gamble you’d like more… studies reveal that 7 out 10 who touch down on a site end up leaving without a trace.\r\n\r\nNot good.\r\n\r\nHere’s a notion – what if there was an simple way for every visitor to “elevate their hand” to get a phone call from you INSTANTLY… the moment they hit your site and stated, “call me now.”\r\n\r\nYou can –\r\n  \r\nWeb Visitor is a software widget that’s operates on your site, prepared to grab any visitor’s Name, Email address and Phone Number.  It allows you know IMMEDIATELY – so that you can chat to that lead while they’re really looking your site.\r\n\r\nCLICK HERE https://turboleadgeneration.com to test a Live Demo with Web Visitor now to see exactly how it works.\r\n\r\nTime is money when it comes to linking with leads – the difference between contacting someone within 5 minutes versus 30 minutes later can be massive – like 100 times better!\r\n\r\nThat’s why we constructed our new SMS Text With Lead attribute because once you’ve grabbed the visitor’s phone number, you can instantly a text message (SMS) conversation.\r\n  \r\nThink the possibilities – even if you don’t close a deal then and there, you can follow with text messages for new offers, content links, even just “how you doing?” notes to build a relationship.\r\n\r\nWouldn’t that be cool?\r\n\r\nCLICK HERE https://turboleadgeneration.com to learn Web Visitor can do for your enterprise\r\n\r\nYou could be converting up to 100X more leads today!\r\nTam\r\n\r\nPS: Web Visitor provides FREE 14 days trial – and it even includes Long Distance Calling. \r\nYou have customers eager to talk with you right now… don’t keep them waiting. \r\nCLICK HERE https://turboleadgeneration.com to test Visitor now.\r\n\r\nIf you\\\'d like to unsubscribe click here https://turboleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n\r\nJust a brief remark - the monikers and email employed in this communication, Tam and Binns, are substitutes and not authentic information. We value honesty and desired to confirm you are aware of this! Should you desire to communicate with the actual person responsible for this communication, do visit our website, and we’ll unite you with the appropriate individual.\r\n'),
(3019, 239, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3020, 239, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3021, 240, 'fld_5462783', 'nom', 'Jarrod'),
(3022, 240, 'fld_3436924', 'prenom', 'Jarrod'),
(3023, 240, 'fld_2124341', 'adresse_mail', 'jarrod.bury38@outlook.com'),
(3024, 240, 'fld_724362', 'num_tel', '510-619-0995'),
(3025, 240, 'fld_475276', 'socite', 'Jarrod Bury'),
(3026, 240, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(3027, 240, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(3028, 240, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3029, 240, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3030, 240, 'fld_2695739', 'objet', 'Qqg gshh'),
(3031, 240, 'fld_3396882', 'message', 'To the artus-securite.fr Webmaster!\r\n\r\nCool website!\r\n\r\nMy name’s Jarrod, and I just came across your site - artus-securite.fr - when surfing the net. You popped up on the top of the search engine results, so I looked you out. Seems like what you’re doing is really interesting.\r\n\r\nBut just in case you don’t mind me asking – once someone like me stumbles across artus-securite.fr, what typically happens?\r\n\r\nDoes your site create leads for your business?\r\n\r\nI’m assuming some, but I also guess you’d like more… data show that 7 out 10 people that land on a site wind up leaving without a trace.\r\n\r\nThat\\\'s unfortunate.\r\n\r\nHere’s a suggestion – what if there was an easy way for every visitor to signal interest to get a phone call from you RIGHT AWAY… the second they visit your site and said, “call me now.”\r\n\r\nYou can –\r\n\r\nWeb Visitors Into Leads is a software widget that’s functions on your site, set to grab every visitor’s Name, Email address and Phone Number. It lets you be informed INSTANTLY – so that you can speak to that lead as they’re actually checking out your site.\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads today to see exactly how it works.\r\n\r\nTiming is money when it comes to engaging with leads – the distinction between connecting with someone in just 5 minutes compared to 30 minutes later is huge – like 100 times more effective!\r\n\r\nThat’s why we created out our new SMS Text With Lead capability… because once you’ve grabbed the visitor’s phone number, you can instantly start a text message (SMS) chat.\r\n\r\nImagine about the potential – even if you don’t close a deal then and there, you can keep in touch with text messages for fresh promotions, content links, even just “how you doing?” notes to create a relationship.\r\n\r\nWouldn’t that be awesome?\r\n\r\nCLICK HERE https://advanceleadgeneration.com to find out what Web Visitors Into Leads can offer for your business.\r\n\r\nYou could be turning up to 100X more leads right now!\r\nJarrod\r\n\r\nPS: Web Visitors Into Leads gives a FREE 14 days trial – and it also includes International Long Distance Calling. \r\nYou have customers eager to talk with you at this moment… don’t leave them waiting. \r\nCLICK HERE https://advanceleadgeneration.com to experience Web Visitors Into Leads now.\r\n\r\nIf you\\\'d want to unsubscribe click here https://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n\r\n\r\nOnly a quick note - the names and email used in this email, Jarrod and Bury, are placeholders and not genuine contact details. We value transparency and aim to make that you’re informed! If you wish to come in touch with the actual person responsible for this message, kindly visit our website, and we’ll associate you with the appropriate individual.\r\n'),
(3032, 240, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3033, 240, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3034, 241, 'fld_5462783', 'nom', 'DION'),
(3035, 241, 'fld_3436924', 'prenom', 'Aurélie'),
(3036, 241, 'fld_2124341', 'adresse_mail', 'aurelie.dion@utt.fr'),
(3037, 241, 'fld_724362', 'num_tel', '03 25 71 56 52'),
(3038, 241, 'fld_475276', 'socite', 'Université de Technologie de TROYES'),
(3039, 241, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3040, 241, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3041, 241, 'fld_2695739', 'objet', 'Urgent - Demande de devis sécurité évènementiel '),
(3042, 241, 'fld_3396882', 'message', 'Bonjour,\r\n\r\nNous organisons une réception le 24/01/2024, à la salle des fêtes de la maire de TROYES (Hôtel de ville). A cette occasion nous accueillerons entre 100 et 150 personnes (nombre à définir précisément ultérieurement), pour un repas.\r\n\r\nPourriez-vous m\\\'indiquer les obligations en terme de sécurité pour un tel évènement et me faire parvenir le devis correspondant s\\\'il vous plaît ?\r\n\r\nJe reste à votre disposition pour toutes informations complémentaires,\r\n\r\nD\\\'avance merci,\r\n\r\nAurélie DION\r\nAssistante à la direction déléguée EUt+'),
(3043, 241, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3044, 241, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3045, 241, 'fld_3201949', 'envoyer', 'click'),
(3046, 242, 'fld_5462783', 'nom', 'Michael'),
(3047, 242, 'fld_3436924', 'prenom', 'Michael'),
(3048, 242, 'fld_2124341', 'adresse_mail', 'ferro.annabelle15@outlook.com'),
(3049, 242, 'fld_724362', 'num_tel', 'Srp Vw jiit'),
(3050, 242, 'fld_475276', 'socite', 'Gqrfduzo yf p');
INSERT INTO `mod284_cf_form_entry_values` (`id`, `entry_id`, `field_id`, `slug`, `value`) VALUES 
(3051, 242, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(3052, 242, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(3053, 242, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3054, 242, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3055, 242, 'fld_2695739', 'objet', 'Meddg zk'),
(3056, 242, 'fld_3396882', 'message', 'Hello,\r\n  \r\nI was looking at your site and wanted to ask if you would be interested in getting two-hundred and fifty thousand (250,000) emails sent out within 48 hours for just $48 - we call it our 48-Special.\r\n \r\nI’m with HiveMailers, we use a robust email system to get clients daily leads and/or sales 24/7.\r\n \r\nWE DO ALL THE WORK:\r\n\r\n- We create the content for the email(s).\r\n- We provide the email list (contacts).\r\n- We forward leads to you daily.\r\n- We manage your email campaigns 24/7.\r\n- We make changes to the list and content until we get results.\r\n\r\nWHO THIS IS FOR:\r\n\r\n- Companies who offer products/services to businesses (B2B).\r\n- Companies who provide a product/service with wide appeal (not a small niche).\r\n- Companies who product/service can be sold across the USA and/or international.\r\n\r\nJust imagine, getting hot leads within days of getting started with us. \r\n\r\nYou might be wondering if our system works, well if you are reading this message, it works. \r\n\r\nGet started now!!!!! We will send out two-hundred and fifty thousand (250,000) emails for just $48.\r\n\r\nTake action today and let’s get you some leads. This offer is good for the first 20 clients, don’t miss out.\r\n\r\nSimply book a time to talk on our calendar: https://bit.ly/hivemailer-special \r\n\r\nNOTE: To buy an email list and hire an in-house email manager to run your campaign (like our system) would cost around $3,500 a month, but with us, you pay just $48. So, you save over $3,450.\r\n\r\nSincerely,\r\n\r\nMichael\r\nHiveMailers\r\n\r\nCalendar: https://bit.ly/hivemailer-special \r\n'),
(3057, 242, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3058, 242, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3059, 243, 'fld_5462783', 'nom', 'Michael'),
(3060, 243, 'fld_3436924', 'prenom', 'Michael'),
(3061, 243, 'fld_2124341', 'adresse_mail', 'santana.ashli@gmail.com'),
(3062, 243, 'fld_724362', 'num_tel', '917-963-9520'),
(3063, 243, 'fld_475276', 'socite', 'Htqmtqr a'),
(3064, 243, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(3065, 243, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(3066, 243, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3067, 243, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3068, 243, 'fld_2695739', 'objet', 'Uwaiz Sloz'),
(3069, 243, 'fld_3396882', 'message', 'Hello,\r\n  \r\nI was looking at your site and wanted to ask if you would be interested in getting two-hundred and fifty thousand (250,000) emails sent out within 48 hours for just $48 - we call it our 48-Special.\r\n \r\nI’m with HiveMailers, we use a robust email system to get clients daily leads and/or sales 24/7.\r\n \r\nWE DO ALL THE WORK:\r\n\r\n- We create the content for the email(s).\r\n- We provide the email list (contacts).\r\n- We forward leads to you daily.\r\n- We manage your email campaigns 24/7.\r\n- We make changes to the list and content until we get results.\r\n\r\nWHO THIS IS FOR:\r\n\r\n- Companies who offer products/services to businesses (B2B).\r\n- Companies who provide a product/service with wide appeal (not a small niche).\r\n- Companies who product/service can be sold across the USA and/or international.\r\n\r\nJust imagine, getting hot leads within days of getting started with us. \r\n\r\nYou might be wondering if our system works, well if you are reading this message, it works. \r\n\r\nGet started now!!!!! We will send out two-hundred and fifty thousand (250,000) emails for just $48.\r\n\r\nTake action today and let’s get you some leads. This offer is good for the first 20 clients, don’t miss out.\r\n\r\nSimply book a time to talk on our calendar: https://bit.ly/hivemailer-special \r\n\r\nNOTE: To buy an email list and hire an in-house email manager to run your campaign (like our system) would cost around $3,500 a month, but with us, you pay just $48. So, you save over $3,450.\r\n\r\nSincerely,\r\n\r\nMichael\r\nHiveMailers\r\n\r\nCalendar: https://bit.ly/hivemailer-special \r\n'),
(3070, 243, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3071, 243, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3072, 244, 'fld_5462783', 'nom', 'Susan'),
(3073, 244, 'fld_3436924', 'prenom', 'Susan'),
(3074, 244, 'fld_2124341', 'adresse_mail', 'weatherburn.lucinda@gmail.com'),
(3075, 244, 'fld_724362', 'num_tel', '352-848-4653'),
(3076, 244, 'fld_475276', 'socite', 'Jesjm'),
(3077, 244, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(3078, 244, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(3079, 244, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3080, 244, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3081, 244, 'fld_2695739', 'objet', 'Wuvviw un'),
(3082, 244, 'fld_3396882', 'message', 'Hello Again,\r\n\r\nI sent a message a few days ago but I’m not sure if you received it so I figured I would do a quick follow up with you again.\r\n\r\nI was on your site today and I wanted to see if you would be open to getting a FREE 7-Day trial of our AI Agents, like ChatGPT, but much better. \r\n\r\nPlus, our plans start as low as $10 per month if you decide to continue. \r\n\r\nOur AI Agents Can:\r\n\r\n• Assist your team with tasks, projects and research, which will increase productivity.\r\n• Crush to-do list by writing - ads, code, emails, content, sales copy, contracts & more.\r\n• Give you time to focus on important things instead of handling mundane tasks.\r\n• Save you time, save you money and make your team much more effective.\r\n• Make sales calls, take inbound calls and answer support questions (coming soon).\r\n\r\n... and much, MUCH more!\r\n\r\nWatch our video here and see how we can help: https://bit.ly/myaa-trial-offer\r\n\r\nOur clients are saving 20%- 30% on operational costs each month by using our AI Agents to handle hundreds of tasks.\r\n\r\nClaim your FREE Trial Of our AI Agents Now, before this offer ends. Get started here: https://bit.ly/myaa-trial-offer\r\n\r\nBest,\r\n\r\nSusan Karsh\r\n'),
(3083, 244, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3084, 244, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3085, 245, 'fld_5462783', 'nom', 'Christina'),
(3086, 245, 'fld_3436924', 'prenom', 'Christina'),
(3087, 245, 'fld_2124341', 'adresse_mail', 'christinaseo76@gmail.com'),
(3088, 245, 'fld_724362', 'num_tel', '72 524 23 43'),
(3089, 245, 'fld_475276', 'socite', 'GuestPostDownload'),
(3090, 245, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(3091, 245, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(3092, 245, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3093, 245, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3094, 245, 'fld_2695739', 'objet', 'Rp Qh'),
(3095, 245, 'fld_3396882', 'message', 'Hi there,\r\n\r\nWe\\\'re writing to ask if you accept Guest Posts on artus-securite.fr?\r\n\r\nIf you do, would you be interested in adding your site to our list, which has an outreach of over 50 million potential customers each month?\r\n\r\nAs we\\\'re doing the promotion, all you have to do is strike a deal!\r\n\r\nMore information: https://furtherinfo.org/gpfeatured\r\n\r\nIf you\\\'d like to discuss this further, just get back in touch with any questions.\r\n\r\nKind Regards,\r\nChristina\r\n\r\nIf you are not interested in SEO/guest posts/backlinks, then unsubscribe here: https://removeme.click/gp/unsubscribe.php?d=artus-securite.fr'),
(3096, 245, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3097, 245, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3098, 246, 'fld_5462783', 'nom', 'David'),
(3099, 246, 'fld_3436924', 'prenom', 'David'),
(3100, 246, 'fld_2124341', 'adresse_mail', 'powerdirector@busihelp.xyz'),
(3101, 246, 'fld_724362', 'num_tel', '0499-4345952'),
(3102, 246, 'fld_475276', 'socite', 'Zsncx'),
(3103, 246, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(3104, 246, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(3105, 246, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3106, 246, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3107, 246, 'fld_2695739', 'objet', 'Lh g gqa'),
(3108, 246, 'fld_3396882', 'message', 'Hi,\r\n \r\nYou need ways to attract new customers on social media and on blog content too, right?\r\n\r\nAs a small business owner, it’s getting even more important to be able to create and edit videos for all the different social media platforms as well as your blog or even YouTube videos, but how do you do it without breaking the bank?\r\n\r\nYou need to either pay for a professional to create video’s or you do it yourself.     If you choose the latter option, you need to make it as professional looking as you can and for this you need video editing software.\r\n\r\nPowerDirector 365 is a software recommended by PCMAG, Toptenreviews and Techradar.\r\nEven if you\\\'re not a professional, you can create awesome videos for websites or social media to attract a lot of targeted traffic. With the \\\"Ai Image Generator\\\" function, you can instantly generate custom images, stickers, or graphics from text.\r\n\r\nPowerDirector 365 is great for any small business who can’t afford to hire out the video production but understands the importance of having videos on their website and on social media.\r\n\r\nIt’s an awesome piece of technology that is truly amazing, you will be able to tackle the most difficult of video editing without spending a fortune on professionals to do the work for you.\r\n\r\nPro:\r\n	Access millions of premium videos, photos, and music tracks from Getty Images & Meta Sound Collection.\r\n	Instantly generate custom images, stickers, or graphics from text.\r\n	One click auto-generated subtitles for videos of any length.     Create unique looks with custom fonts, colors, and text placement.\r\n	...\r\n	\r\nNow click here to boost your traffic: https://www.busihelp.xyz/powerdirector \r\n\r\nBest,\r\nDavid P. Sweet\r\n\r\n\r\nUNSUBSCRIBE: https://www.busihelp.xyz/unsubscribe/\r\n\r\n8552 W Gage Blvd, Kennewick, WA 99336'),
(3109, 246, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3110, 246, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3111, 247, 'fld_5462783', 'nom', 'Kim'),
(3112, 247, 'fld_3436924', 'prenom', 'Olivier'),
(3113, 247, 'fld_2124341', 'adresse_mail', 'kim.olivier63@gmail.com'),
(3114, 247, 'fld_724362', 'num_tel', '07 81 74 81 77'),
(3115, 247, 'fld_6078931', 'agence_souhait.opt1109492', 'Est Champagne Ardenne '),
(3116, 247, 'fld_6078931', 'agence_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3117, 247, 'fld_3279627', 'cv', 'https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV_NOVEMBRE_2023.pdf'),
(3118, 247, 'fld_3976945', 'lettre_de_motivation', 'https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/CV_NOVEMBRE_2023.pdf'),
(3119, 247, 'fld_3396882', 'message', 'Bonjour \r\n\r\nJe me permets de vous contactez car actuellement demandeur d\\\'emploi, je souhaiterai de venir agent de sécurité.\r\n\r\nUn stage d\\\'immersion me permettra de découvrir le métier  et de vérifier que cela me plaît vraiment\r\n\r\nCette immersion sera encadrée par une convention signée\r\n\r\nil faudrait que je fasse une immersion avant de m’inscrire à une formation. “\r\n\r\nPour la durée du stage serai d\\\'une semaine ou deux en immersion selon vos disponibilités.\r\n\r\nJe souhaite prendre rdv pour vous vous rendiez compte que mon projet de reconversion est sérieux.\r\n\r\nMerci d\\\'avance\r\n\r\nCordialement\r\n\r\nMr KIM Olivier\r\n'),
(3120, 247, 'fld_3410960', '_.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3121, 247, 'fld_3410960', '_', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3122, 247, 'fld_3201949', 'envoyer', 'click'),
(3123, 248, 'fld_5462783', 'nom', 'Russell'),
(3124, 248, 'fld_3436924', 'prenom', 'Russell'),
(3125, 248, 'fld_2124341', 'adresse_mail', 'aichannel@keydollar.xyz'),
(3126, 248, 'fld_724362', 'num_tel', '089 89 90 64'),
(3127, 248, 'fld_475276', 'socite', 'D U Hdeycd'),
(3128, 248, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(3129, 248, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(3130, 248, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3131, 248, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3132, 248, 'fld_2695739', 'objet', 'Vc Aj'),
(3133, 248, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3134, 248, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3135, 249, 'fld_5462783', 'nom', 'Eric'),
(3136, 249, 'fld_3436924', 'prenom', 'Eric'),
(3137, 249, 'fld_2124341', 'adresse_mail', 'ericjonesmyemail@gmail.com'),
(3138, 249, 'fld_724362', 'num_tel', '555-555-1212'),
(3139, 249, 'fld_475276', 'socite', 'Pqzm n'),
(3140, 249, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(3141, 249, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(3142, 249, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3143, 249, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3144, 249, 'fld_2695739', 'objet', 'Ktete R'),
(3145, 249, 'fld_3396882', 'message', 'To the artus-securite.fr Owner! I just found your site, quick question…\r\n\r\nMy name’s Eric, I found artus-securite.fr after doing a quick search – you showed up near the top of the rankings, so whatever you’re doing for SEO, looks like it’s working well.\r\n\r\nSo here’s my question – what happens AFTER someone lands on your site?  Anything?\r\n\r\nResearch tells us at least 70% of the people who find your site, after a quick once-over, they disappear… forever.\r\n\r\nThat means that all the work and effort you put into getting them to show up, goes down the tubes.\r\n\r\nWhy would you want all that good work – and the great site you’ve built – go to waste?\r\n\r\nBecause the odds are they’ll just skip over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a thought… what if you could make it super-simple for someone to raise their hand, say, okay, let’s talk without requiring them to even pull their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can literally make that first call happen NOW.\r\n\r\nWeb Visitors Into Leads is a software widget that sits on your site, ready and waiting to capture any visitor’s Name, Email address and Phone Number.  It lets you know IMMEDIATELY – so that you can talk to that lead while they’re still there at your site.\r\n  \r\nYou know, strike when the iron’s hot!\r\n\r\nCLICK HERE https://blazeleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works.\r\n\r\nWhen targeting leads, you HAVE to act fast – the difference between contacting someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should check out our new SMS Text With Lead feature as well… once you’ve captured the phone number of the website visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n \r\nImagine how powerful this could be – even if they don’t take you up on your offer immediately, you can stay in touch with them using text messages to make new offers, provide links to great content, and build your credibility.\r\n\r\nJust this alone could be a game changer to make your website even more effective.\r\n\r\nStrike when  the iron’s hot!\r\n\r\nCLICK HERE https://blazeleadgeneration.com to learn more about everything Web Visitors Into Leads can do for your business – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nEric\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be converting up to 100x more leads immediately!   \r\nIt even includes International Long Distance Calling. \r\nStop wasting money chasing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://blazeleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here https://blazeleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n'),
(3146, 249, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3147, 249, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3148, 250, 'fld_5462783', 'nom', 'Dr. Mark'),
(3149, 250, 'fld_3436924', 'prenom', 'Dr. Mark'),
(3150, 250, 'fld_2124341', 'adresse_mail', 'wilbamark90@gmail.com'),
(3151, 250, 'fld_724362', 'num_tel', 'E tjnerr Xkz'),
(3152, 250, 'fld_475276', 'socite', 'Leonora Eller'),
(3153, 250, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(3154, 250, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(3155, 250, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3156, 250, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3157, 250, 'fld_2695739', 'objet', 'Xgcwoa Ln'),
(3158, 250, 'fld_3396882', 'message', 'Hi, I have a ton of leads that want to pay for your products / services. When do you have a second to chat about them? Would you be willing to do a comission on the leads I send over? Please respond with the word \\\"interested\\\" if you\\\'d like to discuss. -Dr. Mark W.'),
(3159, 250, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3160, 250, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3161, 251, 'fld_5462783', 'nom', 'Amos'),
(3162, 251, 'fld_3436924', 'prenom', 'Amos'),
(3163, 251, 'fld_2124341', 'adresse_mail', 'amos.neff@yahoo.com'),
(3164, 251, 'fld_724362', 'num_tel', '308-231-7289'),
(3165, 251, 'fld_475276', 'socite', 'Amos Neff'),
(3166, 251, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(3167, 251, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(3168, 251, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3169, 251, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3170, 251, 'fld_2695739', 'objet', 'Qgr tuk q uh'),
(3171, 251, 'fld_3396882', 'message', 'artus-securite.fr Admin, Greetings. I just discovered your website, quick inquiry…\r\n\r\nMy name is Amos, I found artus-securite.fr post performing a quick searching – you popped up close to the top of the search rankings, so whatsoever you’re working on for SEO, seems like it’s operating well.\r\n\r\nSo here’s my question – what transpires AFTER someone lands on your website? Anything?\r\n\r\nStudies shows us at least 70% of the people who discover your website, after a swift glance, they vanish… forever.\r\n\r\nThis means that all of the the hard work and endeavor you put into making them to appear, goes the drain.\r\n\r\nWhy would you want all of that excellent work – and the fantastic site you’ve built – go to waste?\r\n\r\nAs the probabilities are they’ll just skip calling up or even pulling out their phone, leaving in the lurch.\r\n\r\nBut, here’s a thought for you… what if you could make extremely simple for someone to raise hand, say, “okay, let’s talk about it” without needing them to even pull their phone from their pocket, thanks to revolutionary new software can literally that first ever call NOW.\r\n\r\nWeb Visitors Into Leads is a software that sits on your site, ready and waiting to capture visitor’s. It lets know IMMEDIATELY – so that you can talk to that lead while they’re still at your site, you know, strike the iron’s!\r\n\r\nCLICK HERE https://advanceleadgeneration.com to try out a Live Demo with Web Visitors Into Leads now to see exactly how it works, when targeting leads, you HAVE to act fast – the difference contacting within minutes versus 30 minutes is huge 100 times!\r\n\r\nThat’s you should check our new SMS Text With Lead feature as well… once captured the phone number of the website visitor, you can automatically off a text with them.\r\n\r\nImagine how powerful this could be – even if they don’t take you up on your offer, you can stay in touch them using text messages to make new offers links great, and build your credibility this alone be a game changer to make website even more effective, strike when the iron’s!\r\n\r\nCLICK HERE https://advanceleadgeneration.com to learn more about everything Visitors Into Leads can do your business be amazed and keep the great work!\r\n\r\nAmos\r\nPS: Web Visitors Into Leads offers FREE 14 days trial – you could be converting up to 100x more leads! It even includes International Long Distance Calling wasting chasing that don’t turn into paying. CLICK HERE https://advanceleadgeneration.com to try Web Visitors Into Leads.\r\n\r\nNow, if you\\\'d like to unsubscribe here https://advanceleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n\r\nJust quick note - the names used here, Amos and Neff, are placeholders and not real contact information. We value transparency and wanted to make sure you’re aware! If you wish to get touch with the real behind message visit website we’ll connect with the right\r\n'),
(3172, 251, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3173, 251, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3174, 252, 'fld_5462783', 'nom', 'Kit'),
(3175, 252, 'fld_3436924', 'prenom', 'Kit'),
(3176, 252, 'fld_2124341', 'adresse_mail', 'kit.beamon@googlemail.com'),
(3177, 252, 'fld_724362', 'num_tel', '415-983-7767'),
(3178, 252, 'fld_475276', 'socite', 'Hh Sjxy'),
(3179, 252, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(3180, 252, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(3181, 252, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3182, 252, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3183, 252, 'fld_2695739', 'objet', 'Ti c e'),
(3184, 252, 'fld_3396882', 'message', 'I now offer contact form blasting service. With my DFY service you can either do a targeted blast to only websites that match your criteria or bulk blast large volumes of sites worldwide. Prices start at just $50 to reach 500,000 bulk sites. Contact me at my email or skype below for details.\r\n\r\nP. Stewart\r\nSkype: live:.cid.e169e59bb6e6d159\r\nEmail: ps94108@gomail2.xyz'),
(3185, 252, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3186, 252, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3187, 253, 'fld_5462783', 'nom', 'Dr. Mark'),
(3188, 253, 'fld_3436924', 'prenom', 'Dr. Mark'),
(3189, 253, 'fld_2124341', 'adresse_mail', 'wilbamark90@gmail.com'),
(3190, 253, 'fld_724362', 'num_tel', '01.14.25.47.70'),
(3191, 253, 'fld_475276', 'socite', 'Shelia Everingham'),
(3192, 253, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(3193, 253, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(3194, 253, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3195, 253, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3196, 253, 'fld_2695739', 'objet', 'Myian bd'),
(3197, 253, 'fld_3396882', 'message', 'Hi, I have a ton of leads that want to pay for your products / services. When do you have a second to chat about them? Would you be willing to do a comission on the leads I send over? Please respond with the word \\\"interested\\\" if you\\\'d like to discuss. -Dr. Mark W.'),
(3198, 253, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3199, 253, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3200, 254, 'fld_5462783', 'nom', 'Jim'),
(3201, 254, 'fld_3436924', 'prenom', 'Jimmy'),
(3202, 254, 'fld_2124341', 'adresse_mail', 'gabriel.broinowski@yahoo.com'),
(3203, 254, 'fld_724362', 'num_tel', '1808112390'),
(3204, 254, 'fld_475276', 'socite', 'Xu mcbv Kw'),
(3205, 254, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(3206, 254, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(3207, 254, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3208, 254, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3209, 254, 'fld_2695739', 'objet', 'J Yqxn vaho'),
(3210, 254, 'fld_3396882', 'message', 'SEO ensures your website stands out when people search for products or services. Google prioritizes relevance and reliability to decide which sites appear on the first pages, underscoring the need for effective website presentation.\r\n\r\nSEO Benefits in Brief:\r\n1. Boosts Visibility and Traffic:\r\n2. Establishes Trust:\r\n3. Yields High ROI:\r\n4. Enhances User Experience:\r\nGoogle announced prioritizing pages based on user experience in their algorithm.\r\nIn essence, SEO is your key to standing out, building trust, and ensuring a high return on investment.\r\n\r\nContact us at https://digitalpromax.co/\r\n\r\nAlso Need expert hands on your WordPress projects? We\\\'ve got you covered. Let\\\'s discuss how our WordPress developers can boost your web endeavors.\r\n\r\nClick here for more details: https://outsource-bpo.com/website/'),
(3211, 254, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3212, 254, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3213, 255, 'fld_5462783', 'nom', 'Charli'),
(3214, 255, 'fld_3436924', 'prenom', 'Charli'),
(3215, 255, 'fld_2124341', 'adresse_mail', 'marcantel.charli@outlook.com'),
(3216, 255, 'fld_724362', 'num_tel', '01.34.78.45.42'),
(3217, 255, 'fld_475276', 'socite', 'Charli Marcantel'),
(3218, 255, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(3219, 255, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(3220, 255, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3221, 255, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3222, 255, 'fld_2695739', 'objet', 'Uosy o ghntoeu'),
(3223, 255, 'fld_3396882', 'message', 'To the artus-securite.fr Webmaster.\r\n\r\nMy name’s Charli, I discovered artus-securite.fr after performing a quick search – you showed up near the summit of the rankings, so whatever you’re doing for SEO, seems like it’s operating well.  \r\n\r\nSo here’s my query – what occurs AFTER someone reaches on your site?  Anything?\r\n\r\nResearch inform us at least 70% of the individuals who locate your site, after a fast once-over, they vanish… forever.\r\n\r\nThat means that all the work and endeavor you put into making them to show up, goes down the tubes.\r\n\r\nWhy would you wish all that great work – and the great site you’ve built – go to waste?\r\n\r\nBecause the probabilities are they’ll just skip over over calling or even grabbing their phone, leaving you high and dry.\r\n\r\nBut here’s a notion… what if you could formulate it super-simple for someone to elevate their hand, say, okay, let’s talk without demanding them to even extract their cell phone from their pocket?\r\n  \r\nYou can – thanks to revolutionary new software that can actually make that first call take place NOW.\r\n\r\nWeb Visitors Into Leads is a software widget that exists on your site, ready and waiting to seize any visitor’s Name, Email address and Phone Number.  It lets you be aware IMMEDIATELY – so that you can converse to that lead while they’re still present at your site.\r\n  \r\nYou understand, strike when the iron’s hot!\r\n\r\nCLICK HERE https://turboleadgeneration.com to experience a Live Demo with Web Visitors Into Leads now to observe specifically how it works.\r\n\r\nWhen focusing on leads, you HAVE to act fast – the variance between reaching out to someone within 5 minutes versus 30 minutes later is huge – like 100 times better!\r\n\r\nThat’s why you should examine our new SMS Text With Lead feature as well… once you’ve captured the phone number of the site visitor, you can automatically kick off a text message (SMS) conversation with them. \r\n\r\nImagine how strong this could be – even if they don’t take you up on your offer immediately, you can remain in communication with them using text messages to make new offers, supply links to great content, and build your credibility.\r\n\r\nJust this by itself could be a game changer to render your website even more productive.\r\n\r\nStrike when the iron’s hot!\r\n\r\nCLICK HERE https://turboleadgeneration.com to learn more about all the things Web Visitors Into Leads can do for your enterprise – you’ll be amazed.\r\n\r\nThanks and keep up the great work!\r\n\r\nCharli\r\nPS: Web Visitors Into Leads offers a FREE 14 days trial – you could be changing up to 100x more leads instantly!   \r\nIt even comprises International Long Distance Calling. \r\nCease wasting money pursuing eyeballs that don’t turn into paying customers. \r\nCLICK HERE https://turboleadgeneration.com to try Web Visitors Into Leads now.\r\n\r\nIf you\\\'d like to unsubscribe click here https://turboleadgeneration.com/unsubscribe.aspx?d=artus-securite.fr\r\n\r\nJust a quick message - the monikers and email address used in this communication, Charli and Marcantel, are placeholders and not actually genuine contact details. We cherish candor and wanted to make sure you’re conscious! If ever you want to communicate with the real person responsible for this communication, kindly visit our website, and we’ll associate you with the proper person.'),
(3224, 255, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3225, 255, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3226, 256, 'fld_5462783', 'nom', 'Michael'),
(3227, 256, 'fld_3436924', 'prenom', 'Michael'),
(3228, 256, 'fld_2124341', 'adresse_mail', 'mccloughry.cyrus87@gmail.com'),
(3229, 256, 'fld_724362', 'num_tel', 'Dj Fokdiw hz'),
(3230, 256, 'fld_475276', 'socite', 'Hup xfeagzxlom'),
(3231, 256, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(3232, 256, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(3233, 256, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3234, 256, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3235, 256, 'fld_2695739', 'objet', 'Jh jmlv'),
(3236, 256, 'fld_3396882', 'message', 'Hello,\r\n\r\nWould you be open to the opportunity to reach out to a staggering 1.25 million potential clients on a weekly basis through our highly effective email marketing campaign? And the best part? It\\\'s available to you at an incredibly affordable rate of just $240 per week! \r\n\r\nPlus, as an added bonus, we provide the B2B prospect list so you can effortlessly expand your reach weekly and generate consistent leads and sales. \r\n  \r\nI’m with HiveMailers, we use a robust email system to get clients daily leads and/or sales 24/7.\r\n \r\nWE DO ALL THE WORK:\r\n\r\n- We create the content for the email(s).\r\n- We provide the email list (contacts).\r\n- We forward leads to you daily.\r\n- We manage your email campaigns 24/7.\r\n\r\nWHO THIS IS FOR:\r\n\r\n- Companies who sell to businesses (B2B).\r\n- Companies who provide a product/service with wide appeal (not a small niche).\r\n- Companies who product/service can be sold across the USA and/or international.\r\n\r\nJust imagine, getting hot leads within days of getting started with us. \r\n\r\nYou might be wondering if our system works, well if you are reading this message, it works. \r\n\r\nGet started now!!! For just $240 a week, we’ll send 1.25 million emails weekly.\r\n\r\nBook a 10 min call with us: https://bit.ly/hivemailer-special-240 \r\n\r\nNOTE: To buy an email list and hire an email manager to run your campaign (like our system) would cost around $3,500 a month, but with us, you pay just $240 a week. So, you save over $2,000 a month. \r\n\r\nSincerely,\r\nMichael\r\n\r\nP.S. This offer is good for the first 20 clients, don’t miss out.  Book appointment now: \r\nhttps://bit.ly/hivemailer-special-240\r\n'),
(3237, 256, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3238, 256, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3239, 257, 'fld_5462783', 'nom', 'Linda'),
(3240, 257, 'fld_3436924', 'prenom', 'Linda'),
(3241, 257, 'fld_2124341', 'adresse_mail', 'shirleen.posey@hotmail.com'),
(3242, 257, 'fld_724362', 'num_tel', '0343 8967363'),
(3243, 257, 'fld_475276', 'socite', 'X Clwe'),
(3244, 257, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(3245, 257, 'fld_6078931', 'secteur_souhait.opt1636010', 'Ile de France '),
(3246, 257, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3247, 257, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \",\"opt1636010\":\"Ile de France \",\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3248, 257, 'fld_2695739', 'objet', 'Oj z rup'),
(3249, 257, 'fld_3396882', 'message', 'Hi webmaster of artus-securite.fr,\r\n\r\n\r\nHow would you like to make an easy $1,000 TODAY?\r\n\r\nAnd then EVERY DAY after that?\r\n\r\nIf that sounds like something you\\\'re interested in, you need to take action NOW and start making money online using this simple website…\r\n\r\nClick Here For More Information >>>  https://www.moregold.xyz/millions  \r\n\r\nDo NOT pass this information on to anyone else.\r\n\r\nThis is a PRIVATE invitation for you only.\r\n\r\nTake Care,\r\n\r\nLinda \r\n\r\n\r\nUNSUBSCRIBE: https://www.moregold.xyz/unsubscribe\r\nAddress: 821 Annadale Ave Ste # 5, Sanger, CA 93657'),
(3250, 257, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3251, 257, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3252, 258, 'fld_5462783', 'nom', 'VUGHT'),
(3253, 258, 'fld_3436924', 'prenom', 'Marie'),
(3254, 258, 'fld_2124341', 'adresse_mail', 'mfdvught@gmail.com'),
(3255, 258, 'fld_724362', 'num_tel', '06 47 81 63 95'),
(3256, 258, 'fld_475276', 'socite', 'particulier'),
(3257, 258, 'fld_6078931', 'secteur_souhait.opt1916226', 'Hauts-de-France '),
(3258, 258, 'fld_6078931', 'secteur_souhait', '{\"opt1916226\":\"Hauts-de-France \"}'),
(3259, 258, 'fld_2695739', 'objet', 'Gardiennage événement privé'),
(3260, 258, 'fld_3396882', 'message', 'Bonjour, \r\n\r\nJe souhaiterais avoir des informations et un devis dans le cadre d\\\'une mission de gardiennage et de sécurité d\\\'un parking, d\\\'un jardin privé pour un mariage (à côté de Compiègne le 6 juillet).\r\n\r\nJe vous remercie, \r\n\r\nMarie Vught'),
(3261, 258, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3262, 258, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3263, 258, 'fld_3201949', 'envoyer', 'click'),
(3264, 259, 'fld_5462783', 'nom', 'Pilliet '),
(3265, 259, 'fld_3436924', 'prenom', 'Laura '),
(3266, 259, 'fld_2124341', 'adresse_mail', 'apel.ecolestpierre10@gmail.com'),
(3267, 259, 'fld_724362', 'num_tel', '06 69 30 06 79'),
(3268, 259, 'fld_475276', 'socite', 'APEL VISITATION SAINT PIERRE '),
(3269, 259, 'fld_6078931', 'secteur_souhait.opt1109492', 'Est Champagne Ardenne '),
(3270, 259, 'fld_6078931', 'secteur_souhait', '{\"opt1109492\":\"Est Champagne Ardenne \"}'),
(3271, 259, 'fld_2695739', 'objet', 'Devis pour marché de Noël '),
(3272, 259, 'fld_3396882', 'message', 'Bonjour, l\\\'APEL de l\\\'école SAINT-PIERRE organise son marché de Noël vendredi 22 décembre de 16h à 17h30 et nous aurions besoin d\\\'un agent de sécurité. Pourriez-vous nous indiquer vos disponibilités et tarifs. \r\nCordialement\r\nMme Pilliet\r\nSecrétaire APEL SAINT-PIERRE '),
(3273, 259, 'fld_3410960', 'consentement_rgpd.opt1664586', ' En soumettant le formulaire, j\\\'accepte que mes données soient utilisées pour me recontacter.'),
(3274, 259, 'fld_3410960', 'consentement_rgpd', '{\"opt1664586\":\" En soumettant le formulaire, j\'accepte que mes donn\\u00e9es soient utilis\\u00e9es pour me recontacter.\"}'),
(3275, 259, 'fld_3201949', 'envoyer', 'click');
/*!40000 ALTER TABLE `mod284_cf_form_entry_values` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_cf_forms`
--

DROP TABLE IF EXISTS `mod284_cf_forms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_cf_forms` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` varchar(18) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `config` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_cf_forms`
--

LOCK TABLES `mod284_cf_forms` WRITE;
/*!40000 ALTER TABLE `mod284_cf_forms` DISABLE KEYS */;
INSERT INTO `mod284_cf_forms` (`id`, `form_id`, `type`, `config`) VALUES 
(6, 'CF6047390b6259c', 'revision', 'a:25:{s:2:\"ID\";s:15:\"CF6047390b6259c\";s:13:\"_last_updated\";s:31:\"Tue, 09 Mar 2021 08:30:00 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:16:\"demande de devis\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:73:\"Le formulaire a été envoyé. Merci pour votre contribution.												\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";s:0:\"\";s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:12:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:11:\"fld_6078931\";s:3:\"3:1\";s:11:\"fld_3279627\";s:3:\"3:2\";s:11:\"fld_3976945\";s:3:\"3:3\";s:11:\"fld_3396882\";s:3:\"4:1\";s:11:\"fld_7639173\";s:3:\"5:1\";s:11:\"fld_7936120\";s:3:\"5:2\";s:11:\"fld_3410960\";s:3:\"5:3\";s:11:\"fld_3201949\";s:3:\"5:4\";}s:9:\"structure\";s:24:\"6:6|6:6|6:3:3|12|3:3:3:3\";}s:6:\"fields\";a:12:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:6:\"Prenom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:12:\"Adresse mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:12:\"phone_better\";s:5:\"label\";s:8:\"Num tel.\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:16:\"Agence souhaité\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:23:\"Bureau Hauts-de-France \";s:5:\"value\";s:23:\"Bureau Hauts-de-France \";s:5:\"label\";s:23:\"Bureau Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:21:\"Agence Ile de France \";s:5:\"value\";s:21:\"Agence Ile de France \";s:5:\"label\";s:21:\"Agence Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"label\";s:29:\"Agence Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3279627\";a:8:{s:2:\"ID\";s:11:\"fld_3279627\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:2:\"CV\";s:4:\"slug\";s:2:\"cv\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3976945\";a:8:{s:2:\"ID\";s:11:\"fld_3976945\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:20:\"Lettre de motivation\";s:4:\"slug\";s:20:\"lettre_de_motivation\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_7639173\";a:7:{s:2:\"ID\";s:11:\"fld_7639173\";s:4:\"type\";s:13:\"section_break\";s:5:\"label\";s:26:\"section_break__fld_7936120\";s:4:\"slug\";s:26:\"section_break__fld_7936121\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:2:{s:12:\"custom_class\";s:0:\"\";s:5:\"width\";s:0:\"\";}}s:11:\"fld_7936120\";a:7:{s:2:\"ID\";s:11:\"fld_7936120\";s:4:\"type\";s:13:\"section_break\";s:5:\"label\";s:26:\"section_break__fld_7936120\";s:4:\"slug\";s:26:\"section_break__fld_7936120\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:2:{s:12:\"custom_class\";s:0:\"\";s:5:\"width\";s:0:\"\";}}s:11:\"fld_3410960\";a:8:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Consentement RGPD\";s:4:\"slug\";s:17:\"consentement_rgpd\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:10:\"J\'accepte \";s:5:\"value\";s:10:\"J\'accepte \";s:5:\"label\";s:10:\"J\'accepte \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyé\";s:4:\"slug\";s:5:\"envoy\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:29:\"Notification de Caldera Forms\";s:12:\"sender_email\";s:23:\"a.facque@groupe-echo.fr\";s:8:\"reply_to\";s:0:\"\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:0:\"\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";s:4:\"type\";s:7:\"primary\";s:5:\"nonce\";s:10:\"51e113c803\";s:5:\"clone\";s:15:\"CF6047298f195ee\";}'),
(7, 'CF6047390b6259c', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047390b6259c\";s:13:\"_last_updated\";s:31:\"Tue, 09 Mar 2021 09:02:51 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:16:\"demande de devis\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:76:\"Le formulaire a été envoyé. Merci pour votre contribution.															\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";N;s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:12:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:11:\"fld_2695739\";s:3:\"3:1\";s:10:\"fld_475276\";s:3:\"3:2\";s:11:\"fld_6078931\";s:3:\"3:3\";s:11:\"fld_3396882\";s:3:\"4:1\";s:11:\"fld_7639173\";s:3:\"5:1\";s:11:\"fld_7936120\";s:3:\"5:2\";s:11:\"fld_3410960\";s:3:\"5:3\";s:11:\"fld_3201949\";s:3:\"5:4\";}s:9:\"structure\";s:24:\"6:6|6:6|3:3:6|12|3:3:3:3\";}s:6:\"fields\";a:12:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:6:\"Prenom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:12:\"Adresse mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:12:\"phone_better\";s:5:\"label\";s:8:\"Num tel.\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:16:\"Agence souhaité\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:23:\"Bureau Hauts-de-France \";s:5:\"value\";s:23:\"Bureau Hauts-de-France \";s:5:\"label\";s:23:\"Bureau Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:21:\"Agence Ile de France \";s:5:\"value\";s:21:\"Agence Ile de France \";s:5:\"label\";s:21:\"Agence Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"label\";s:29:\"Agence Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_7639173\";a:7:{s:2:\"ID\";s:11:\"fld_7639173\";s:4:\"type\";s:13:\"section_break\";s:5:\"label\";s:26:\"section_break__fld_7936120\";s:4:\"slug\";s:26:\"section_break__fld_7936121\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:2:{s:12:\"custom_class\";s:0:\"\";s:5:\"width\";s:0:\"\";}}s:11:\"fld_7936120\";a:7:{s:2:\"ID\";s:11:\"fld_7936120\";s:4:\"type\";s:13:\"section_break\";s:5:\"label\";s:26:\"section_break__fld_7936120\";s:4:\"slug\";s:26:\"section_break__fld_7936120\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:2:{s:12:\"custom_class\";s:0:\"\";s:5:\"width\";s:0:\"\";}}s:11:\"fld_3410960\";a:8:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Consentement RGPD\";s:4:\"slug\";s:17:\"consentement_rgpd\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:10:\"J\'accepte \";s:5:\"value\";s:10:\"J\'accepte \";s:5:\"label\";s:10:\"J\'accepte \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyé\";s:4:\"slug\";s:5:\"envoy\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}s:11:\"fld_2695739\";a:8:{s:2:\"ID\";s:11:\"fld_2695739\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:5:\"Objet\";s:4:\"slug\";s:5:\"objet\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_475276\";a:8:{s:2:\"ID\";s:10:\"fld_475276\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:9:\"Société\";s:4:\"slug\";s:6:\"socite\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:29:\"Notification de Caldera Forms\";s:12:\"sender_email\";s:23:\"a.facque@groupe-echo.fr\";s:8:\"reply_to\";s:0:\"\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:0:\"\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(9, 'CF6047390b6259c', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047390b6259c\";s:13:\"_last_updated\";s:31:\"Tue, 09 Mar 2021 09:05:37 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:16:\"demande de devis\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:79:\"Le formulaire a été envoyé. Merci pour votre contribution.																		\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";N;s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:12:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:11:\"fld_2695739\";s:3:\"3:1\";s:10:\"fld_475276\";s:3:\"3:2\";s:11:\"fld_6078931\";s:3:\"3:3\";s:11:\"fld_3396882\";s:3:\"4:1\";s:11:\"fld_7639173\";s:3:\"5:1\";s:11:\"fld_7936120\";s:3:\"5:2\";s:11:\"fld_3410960\";s:3:\"5:3\";s:11:\"fld_3201949\";s:3:\"5:4\";}s:9:\"structure\";s:24:\"6:6|6:6|3:3:6|12|3:3:3:3\";}s:6:\"fields\";a:12:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:6:\"Prenom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:12:\"Adresse mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:12:\"phone_better\";s:5:\"label\";s:8:\"Num tel.\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2695739\";a:8:{s:2:\"ID\";s:11:\"fld_2695739\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:5:\"Objet\";s:4:\"slug\";s:5:\"objet\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_475276\";a:8:{s:2:\"ID\";s:10:\"fld_475276\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:9:\"Société\";s:4:\"slug\";s:6:\"socite\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:16:\"Agence souhaité\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:23:\"Bureau Hauts-de-France \";s:5:\"value\";s:23:\"Bureau Hauts-de-France \";s:5:\"label\";s:23:\"Bureau Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:21:\"Agence Ile de France \";s:5:\"value\";s:21:\"Agence Ile de France \";s:5:\"label\";s:21:\"Agence Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"label\";s:29:\"Agence Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_7639173\";a:7:{s:2:\"ID\";s:11:\"fld_7639173\";s:4:\"type\";s:13:\"section_break\";s:5:\"label\";s:26:\"section_break__fld_7936120\";s:4:\"slug\";s:26:\"section_break__fld_7936121\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:2:{s:12:\"custom_class\";s:0:\"\";s:5:\"width\";s:0:\"\";}}s:11:\"fld_7936120\";a:7:{s:2:\"ID\";s:11:\"fld_7936120\";s:4:\"type\";s:13:\"section_break\";s:5:\"label\";s:26:\"section_break__fld_7936120\";s:4:\"slug\";s:26:\"section_break__fld_7936120\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:2:{s:12:\"custom_class\";s:0:\"\";s:5:\"width\";s:0:\"\";}}s:11:\"fld_3410960\";a:8:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Consentement RGPD\";s:4:\"slug\";s:17:\"consentement_rgpd\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:10:\"J\'accepte \";s:5:\"value\";s:10:\"J\'accepte \";s:5:\"label\";s:10:\"J\'accepte \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:29:\"Notification de Caldera Forms\";s:12:\"sender_email\";s:23:\"a.facque@groupe-echo.fr\";s:8:\"reply_to\";s:0:\"\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:0:\"\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(14, 'CF6047298f195ee', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047298f195ee\";s:13:\"_last_updated\";s:31:\"Fri, 19 Mar 2021 16:12:21 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:11:\"Recrutement\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:82:\"Le formulaire a été envoyé. Merci pour votre contribution.																					\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";N;s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:11:\"fld_6078931\";s:3:\"3:1\";s:11:\"fld_3279627\";s:3:\"4:1\";s:11:\"fld_3976945\";s:3:\"4:2\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"5:1\";s:11:\"fld_3201949\";s:3:\"5:1\";}s:9:\"structure\";s:17:\"6:6|6:6|12|6:6|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:6:\"Prenom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:12:\"Adresse mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:12:\"phone_better\";s:5:\"label\";s:8:\"Num tel.\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:16:\"Agence souhaité\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:23:\"Bureau Hauts-de-France \";s:5:\"value\";s:23:\"Bureau Hauts-de-France \";s:5:\"label\";s:23:\"Bureau Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:21:\"Agence Ile de France \";s:5:\"value\";s:21:\"Agence Ile de France \";s:5:\"label\";s:21:\"Agence Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"label\";s:29:\"Agence Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3279627\";a:8:{s:2:\"ID\";s:11:\"fld_3279627\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:2:\"CV\";s:4:\"slug\";s:2:\"cv\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3976945\";a:8:{s:2:\"ID\";s:11:\"fld_3976945\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:20:\"Lettre de motivation\";s:4:\"slug\";s:20:\"lettre_de_motivation\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:9:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:1:\" \";s:4:\"slug\";s:1:\"_\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:10:\"entry_list\";i:1;s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:10:\"J\'accepte \";s:5:\"value\";s:94:\"En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:94:\"En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:29:\"Notification de Caldera Forms\";s:12:\"sender_email\";s:23:\"a.facque@groupe-echo.fr\";s:8:\"reply_to\";s:0:\"\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:0:\"\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(15, 'CF6047298f195ee', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047298f195ee\";s:13:\"_last_updated\";s:31:\"Fri, 19 Mar 2021 16:12:42 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:11:\"Recrutement\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:82:\"Le formulaire a été envoyé. Merci pour votre contribution.																					\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";N;s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:11:\"fld_6078931\";s:3:\"3:1\";s:11:\"fld_3279627\";s:3:\"4:1\";s:11:\"fld_3976945\";s:3:\"4:2\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"5:1\";s:11:\"fld_3201949\";s:3:\"5:1\";}s:9:\"structure\";s:17:\"6:6|6:6|12|6:6|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:6:\"Prenom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:12:\"Adresse mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:12:\"phone_better\";s:5:\"label\";s:8:\"Num tel.\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:16:\"Agence souhaité\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:23:\"Bureau Hauts-de-France \";s:5:\"value\";s:23:\"Bureau Hauts-de-France \";s:5:\"label\";s:23:\"Bureau Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:21:\"Agence Ile de France \";s:5:\"value\";s:21:\"Agence Ile de France \";s:5:\"label\";s:21:\"Agence Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"label\";s:29:\"Agence Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3279627\";a:8:{s:2:\"ID\";s:11:\"fld_3279627\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:2:\"CV\";s:4:\"slug\";s:2:\"cv\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3976945\";a:8:{s:2:\"ID\";s:11:\"fld_3976945\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:20:\"Lettre de motivation\";s:4:\"slug\";s:20:\"lettre_de_motivation\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:9:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:4:\"slug\";s:1:\"_\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:10:\"entry_list\";i:1;s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:10:\"J\'accepte \";s:5:\"value\";s:9:\"J\'accepte\";s:5:\"label\";s:9:\"J\'accepte\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:29:\"Notification de Caldera Forms\";s:12:\"sender_email\";s:23:\"a.facque@groupe-echo.fr\";s:8:\"reply_to\";s:0:\"\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:0:\"\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(16, 'CF6047298f195ee', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047298f195ee\";s:13:\"_last_updated\";s:31:\"Fri, 19 Mar 2021 16:13:34 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:11:\"Recrutement\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:82:\"Le formulaire a été envoyé. Merci pour votre contribution.																					\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";N;s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:11:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:10:\"fld_567135\";s:3:\"2:2\";s:11:\"fld_6078931\";s:3:\"3:1\";s:11:\"fld_3279627\";s:3:\"4:1\";s:11:\"fld_3976945\";s:3:\"4:2\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"5:1\";s:11:\"fld_3201949\";s:3:\"5:1\";}s:9:\"structure\";s:17:\"6:6|6:6|12|6:6|12\";}s:6:\"fields\";a:11:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:6:\"Prenom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:12:\"Adresse mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:12:\"phone_better\";s:5:\"label\";s:8:\"Num tel.\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:16:\"Agence souhaité\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:23:\"Bureau Hauts-de-France \";s:5:\"value\";s:23:\"Bureau Hauts-de-France \";s:5:\"label\";s:23:\"Bureau Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:21:\"Agence Ile de France \";s:5:\"value\";s:21:\"Agence Ile de France \";s:5:\"label\";s:21:\"Agence Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"label\";s:29:\"Agence Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3279627\";a:8:{s:2:\"ID\";s:11:\"fld_3279627\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:2:\"CV\";s:4:\"slug\";s:2:\"cv\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3976945\";a:8:{s:2:\"ID\";s:11:\"fld_3976945\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:20:\"Lettre de motivation\";s:4:\"slug\";s:20:\"lettre_de_motivation\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:10:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:4:\"RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:1:\"_\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:10:\"entry_list\";i:1;s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:10:\"J\'accepte \";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}s:10:\"fld_567135\";a:7:{s:2:\"ID\";s:10:\"fld_567135\";s:4:\"type\";s:12:\"phone_better\";s:5:\"label\";s:3:\"tel\";s:4:\"slug\";s:3:\"tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:29:\"Notification de Caldera Forms\";s:12:\"sender_email\";s:23:\"a.facque@groupe-echo.fr\";s:8:\"reply_to\";s:0:\"\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:0:\"\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(17, 'CF6047298f195ee', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047298f195ee\";s:13:\"_last_updated\";s:31:\"Fri, 19 Mar 2021 16:14:30 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:11:\"Recrutement\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:82:\"Le formulaire a été envoyé. Merci pour votre contribution.																					\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";N;s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:11:\"fld_6078931\";s:3:\"3:1\";s:11:\"fld_3279627\";s:3:\"4:1\";s:11:\"fld_3976945\";s:3:\"4:2\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"5:1\";s:11:\"fld_3201949\";s:3:\"5:1\";}s:9:\"structure\";s:17:\"6:6|6:6|12|6:6|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:6:\"Prenom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:12:\"Adresse mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:8:\"Num tel.\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:5:\"local\";s:6:\"custom\";s:13:\"(999)999-9999\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:16:\"Agence souhaité\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:23:\"Bureau Hauts-de-France \";s:5:\"value\";s:23:\"Bureau Hauts-de-France \";s:5:\"label\";s:23:\"Bureau Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:21:\"Agence Ile de France \";s:5:\"value\";s:21:\"Agence Ile de France \";s:5:\"label\";s:21:\"Agence Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"label\";s:29:\"Agence Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3279627\";a:8:{s:2:\"ID\";s:11:\"fld_3279627\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:2:\"CV\";s:4:\"slug\";s:2:\"cv\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3976945\";a:8:{s:2:\"ID\";s:11:\"fld_3976945\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:20:\"Lettre de motivation\";s:4:\"slug\";s:20:\"lettre_de_motivation\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:10:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:4:\"RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:1:\"_\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:10:\"entry_list\";i:1;s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:10:\"J\'accepte \";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:29:\"Notification de Caldera Forms\";s:12:\"sender_email\";s:23:\"a.facque@groupe-echo.fr\";s:8:\"reply_to\";s:0:\"\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:0:\"\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(18, 'CF6047390b6259c', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047390b6259c\";s:13:\"_last_updated\";s:31:\"Fri, 19 Mar 2021 16:16:01 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:16:\"demande de devis\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:82:\"Le formulaire a été envoyé. Merci pour votre contribution.																					\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";N;s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:10:\"fld_475276\";s:3:\"3:1\";s:11:\"fld_6078931\";s:3:\"3:2\";s:11:\"fld_2695739\";s:3:\"4:1\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"6:1\";s:11:\"fld_3201949\";s:3:\"6:2\";}s:9:\"structure\";s:21:\"6:6|6:6|6:6|12|12|9:3\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:6:\"Prenom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:12:\"Adresse mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:8:\"Num tel.\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:5:\"local\";s:6:\"custom\";s:13:\"(999)999-9999\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2695739\";a:8:{s:2:\"ID\";s:11:\"fld_2695739\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:5:\"Objet\";s:4:\"slug\";s:5:\"objet\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_475276\";a:8:{s:2:\"ID\";s:10:\"fld_475276\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:9:\"Société\";s:4:\"slug\";s:6:\"socite\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:16:\"Agence souhaité\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:23:\"Bureau Hauts-de-France \";s:5:\"value\";s:23:\"Bureau Hauts-de-France \";s:5:\"label\";s:23:\"Bureau Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:21:\"Agence Ile de France \";s:5:\"value\";s:21:\"Agence Ile de France \";s:5:\"label\";s:21:\"Agence Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"label\";s:29:\"Agence Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:9:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Consentement RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:17:\"consentement_rgpd\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:10:\"J\'accepte \";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:29:\"Notification de Caldera Forms\";s:12:\"sender_email\";s:23:\"a.facque@groupe-echo.fr\";s:8:\"reply_to\";s:0:\"\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:0:\"\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}');
INSERT INTO `mod284_cf_forms` (`id`, `form_id`, `type`, `config`) VALUES 
(19, 'CF6047390b6259c', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047390b6259c\";s:13:\"_last_updated\";s:31:\"Fri, 19 Mar 2021 16:16:50 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:16:\"demande de devis\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:82:\"Le formulaire a été envoyé. Merci pour votre contribution.																					\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";N;s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:10:\"fld_475276\";s:3:\"3:1\";s:11:\"fld_6078931\";s:3:\"3:2\";s:11:\"fld_2695739\";s:3:\"4:1\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"6:1\";s:11:\"fld_3201949\";s:3:\"6:2\";}s:9:\"structure\";s:21:\"6:6|6:6|6:6|12|12|9:3\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Prénom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:12:\"Adresse mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:8:\"Num tel.\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:5:\"local\";s:6:\"custom\";s:13:\"(999)999-9999\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2695739\";a:8:{s:2:\"ID\";s:11:\"fld_2695739\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:5:\"Objet\";s:4:\"slug\";s:5:\"objet\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_475276\";a:8:{s:2:\"ID\";s:10:\"fld_475276\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:9:\"Société\";s:4:\"slug\";s:6:\"socite\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Agence souhaitée\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:23:\"Bureau Hauts-de-France \";s:5:\"value\";s:23:\"Bureau Hauts-de-France \";s:5:\"label\";s:23:\"Bureau Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:21:\"Agence Ile de France \";s:5:\"value\";s:21:\"Agence Ile de France \";s:5:\"label\";s:21:\"Agence Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"label\";s:29:\"Agence Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:9:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Consentement RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:17:\"consentement_rgpd\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:10:\"J\'accepte \";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:29:\"Notification de Caldera Forms\";s:12:\"sender_email\";s:23:\"a.facque@groupe-echo.fr\";s:8:\"reply_to\";s:0:\"\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:0:\"\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(20, 'CF6047298f195ee', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047298f195ee\";s:13:\"_last_updated\";s:31:\"Fri, 19 Mar 2021 16:17:42 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:11:\"Recrutement\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:85:\"Le formulaire a été envoyé. Merci pour votre contribution.																								\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";N;s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:11:\"fld_6078931\";s:3:\"3:1\";s:11:\"fld_3279627\";s:3:\"4:1\";s:11:\"fld_3976945\";s:3:\"4:2\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"5:1\";s:11:\"fld_3201949\";s:3:\"5:1\";}s:9:\"structure\";s:17:\"6:6|6:6|12|6:6|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Prénom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:12:\"Adresse mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:9:\"Num tél.\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:5:\"local\";s:6:\"custom\";s:13:\"(999)999-9999\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Agence souhaitée\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:23:\"Bureau Hauts-de-France \";s:5:\"value\";s:23:\"Bureau Hauts-de-France \";s:5:\"label\";s:23:\"Bureau Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:21:\"Agence Ile de France \";s:5:\"value\";s:21:\"Agence Ile de France \";s:5:\"label\";s:21:\"Agence Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"label\";s:29:\"Agence Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3279627\";a:8:{s:2:\"ID\";s:11:\"fld_3279627\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:2:\"CV\";s:4:\"slug\";s:2:\"cv\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3976945\";a:8:{s:2:\"ID\";s:11:\"fld_3976945\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:20:\"Lettre de motivation\";s:4:\"slug\";s:20:\"lettre_de_motivation\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:10:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:4:\"RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:1:\"_\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:10:\"entry_list\";i:1;s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:29:\"Notification de Caldera Forms\";s:12:\"sender_email\";s:23:\"a.facque@groupe-echo.fr\";s:8:\"reply_to\";s:0:\"\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:0:\"\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(21, 'CF6047390b6259c', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047390b6259c\";s:13:\"_last_updated\";s:31:\"Fri, 19 Mar 2021 16:18:25 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:16:\"demande de devis\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:85:\"Le formulaire a été envoyé. Merci pour votre contribution.																								\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";N;s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:10:\"fld_475276\";s:3:\"3:1\";s:11:\"fld_6078931\";s:3:\"3:2\";s:11:\"fld_2695739\";s:3:\"4:1\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"6:1\";s:11:\"fld_3201949\";s:3:\"7:1\";}s:9:\"structure\";s:23:\"6:6|6:6|6:6|12|12|12|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Prénom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:12:\"Adresse mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:8:\"Num tel.\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:5:\"local\";s:6:\"custom\";s:13:\"(999)999-9999\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_475276\";a:8:{s:2:\"ID\";s:10:\"fld_475276\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:9:\"Société\";s:4:\"slug\";s:6:\"socite\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Agence souhaitée\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:23:\"Bureau Hauts-de-France \";s:5:\"value\";s:23:\"Bureau Hauts-de-France \";s:5:\"label\";s:23:\"Bureau Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:21:\"Agence Ile de France \";s:5:\"value\";s:21:\"Agence Ile de France \";s:5:\"label\";s:21:\"Agence Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"label\";s:29:\"Agence Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2695739\";a:8:{s:2:\"ID\";s:11:\"fld_2695739\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:5:\"Objet\";s:4:\"slug\";s:5:\"objet\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:9:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Consentement RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:17:\"consentement_rgpd\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:29:\"Notification de Caldera Forms\";s:12:\"sender_email\";s:23:\"a.facque@groupe-echo.fr\";s:8:\"reply_to\";s:0:\"\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:0:\"\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(22, 'CF6047298f195ee', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047298f195ee\";s:13:\"_last_updated\";s:31:\"Tue, 30 Mar 2021 10:31:13 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:11:\"Recrutement\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:88:\"Le formulaire a été envoyé. Merci pour votre contribution.																											\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";N;s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:11:\"fld_6078931\";s:3:\"3:1\";s:11:\"fld_3279627\";s:3:\"4:1\";s:11:\"fld_3976945\";s:3:\"4:2\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"5:1\";s:11:\"fld_3201949\";s:3:\"5:1\";}s:9:\"structure\";s:17:\"6:6|6:6|12|6:6|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Prénom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:12:\"Adresse mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:9:\"Num tél.\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:5:\"local\";s:6:\"custom\";s:13:\"(999)999-9999\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Secteur souhaité\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:23:\"Bureau Hauts-de-France \";s:5:\"value\";s:16:\"Hauts-de-France \";s:5:\"label\";s:16:\"Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:21:\"Agence Ile de France \";s:5:\"value\";s:14:\"Ile de France \";s:5:\"label\";s:14:\"Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"value\";s:22:\"Est Champagne Ardenne \";s:5:\"label\";s:22:\"Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3279627\";a:8:{s:2:\"ID\";s:11:\"fld_3279627\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:2:\"CV\";s:4:\"slug\";s:2:\"cv\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3976945\";a:8:{s:2:\"ID\";s:11:\"fld_3976945\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:20:\"Lettre de motivation\";s:4:\"slug\";s:20:\"lettre_de_motivation\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:10:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:4:\"RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:1:\"_\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:10:\"entry_list\";i:1;s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:29:\"Notification de Caldera Forms\";s:12:\"sender_email\";s:23:\"a.facque@groupe-echo.fr\";s:8:\"reply_to\";s:0:\"\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:0:\"\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(23, 'CF6047298f195ee', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047298f195ee\";s:13:\"_last_updated\";s:31:\"Tue, 30 Mar 2021 10:31:28 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:11:\"Recrutement\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:88:\"Le formulaire a été envoyé. Merci pour votre contribution.																											\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";N;s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:11:\"fld_6078931\";s:3:\"3:1\";s:11:\"fld_3279627\";s:3:\"4:1\";s:11:\"fld_3976945\";s:3:\"4:2\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"5:1\";s:11:\"fld_3201949\";s:3:\"5:1\";}s:9:\"structure\";s:17:\"6:6|6:6|12|6:6|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Prénom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:12:\"Adresse mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:9:\"Num tél.\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:5:\"local\";s:6:\"custom\";s:13:\"(999)999-9999\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Secteur souhaité\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:23:\"Bureau Hauts-de-France \";s:5:\"value\";s:16:\"Hauts-de-France \";s:5:\"label\";s:16:\"Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:21:\"Agence Ile de France \";s:5:\"value\";s:14:\"Ile de France \";s:5:\"label\";s:14:\"Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"value\";s:22:\"Est Champagne Ardenne \";s:5:\"label\";s:22:\"Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3279627\";a:8:{s:2:\"ID\";s:11:\"fld_3279627\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:2:\"CV\";s:4:\"slug\";s:2:\"cv\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3976945\";a:8:{s:2:\"ID\";s:11:\"fld_3976945\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:20:\"Lettre de motivation\";s:4:\"slug\";s:20:\"lettre_de_motivation\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:10:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:4:\"RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:1:\"_\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:10:\"entry_list\";i:1;s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:29:\"Notification de Caldera Forms\";s:12:\"sender_email\";s:23:\"a.facque@groupe-echo.fr\";s:8:\"reply_to\";s:0:\"\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:0:\"\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(24, 'CF6047298f195ee', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047298f195ee\";s:13:\"_last_updated\";s:31:\"Tue, 30 Mar 2021 10:31:55 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:11:\"Recrutement\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:88:\"Le formulaire a été envoyé. Merci pour votre contribution.																											\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";N;s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:11:\"fld_6078931\";s:3:\"3:1\";s:11:\"fld_3279627\";s:3:\"4:1\";s:11:\"fld_3976945\";s:3:\"4:2\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"5:1\";s:11:\"fld_3201949\";s:3:\"5:1\";}s:9:\"structure\";s:17:\"6:6|6:6|12|6:6|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Prénom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:12:\"Adresse mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:9:\"Num tél.\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"custom\";s:6:\"custom\";s:14:\"99 99 99 99 99\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Secteur souhaité\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:23:\"Bureau Hauts-de-France \";s:5:\"value\";s:16:\"Hauts-de-France \";s:5:\"label\";s:16:\"Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:21:\"Agence Ile de France \";s:5:\"value\";s:14:\"Ile de France \";s:5:\"label\";s:14:\"Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"value\";s:22:\"Est Champagne Ardenne \";s:5:\"label\";s:22:\"Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3279627\";a:8:{s:2:\"ID\";s:11:\"fld_3279627\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:2:\"CV\";s:4:\"slug\";s:2:\"cv\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3976945\";a:8:{s:2:\"ID\";s:11:\"fld_3976945\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:20:\"Lettre de motivation\";s:4:\"slug\";s:20:\"lettre_de_motivation\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:10:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:4:\"RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:1:\"_\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:10:\"entry_list\";i:1;s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:29:\"Notification de Caldera Forms\";s:12:\"sender_email\";s:23:\"a.facque@groupe-echo.fr\";s:8:\"reply_to\";s:0:\"\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:0:\"\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(25, 'CF6047298f195ee', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047298f195ee\";s:13:\"_last_updated\";s:31:\"Tue, 30 Mar 2021 10:32:13 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:11:\"Recrutement\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:88:\"Le formulaire a été envoyé. Merci pour votre contribution.																											\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";N;s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:11:\"fld_6078931\";s:3:\"3:1\";s:11:\"fld_3279627\";s:3:\"4:1\";s:11:\"fld_3976945\";s:3:\"4:2\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"5:1\";s:11:\"fld_3201949\";s:3:\"5:1\";}s:9:\"structure\";s:17:\"6:6|6:6|12|6:6|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Prénom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:14:\"Adresse e-mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:11:\"Téléphone\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"custom\";s:6:\"custom\";s:14:\"99 99 99 99 99\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Secteur souhaité\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:23:\"Bureau Hauts-de-France \";s:5:\"value\";s:16:\"Hauts-de-France \";s:5:\"label\";s:16:\"Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:21:\"Agence Ile de France \";s:5:\"value\";s:14:\"Ile de France \";s:5:\"label\";s:14:\"Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"value\";s:22:\"Est Champagne Ardenne \";s:5:\"label\";s:22:\"Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3279627\";a:8:{s:2:\"ID\";s:11:\"fld_3279627\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:2:\"CV\";s:4:\"slug\";s:2:\"cv\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3976945\";a:8:{s:2:\"ID\";s:11:\"fld_3976945\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:20:\"Lettre de motivation\";s:4:\"slug\";s:20:\"lettre_de_motivation\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:10:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:4:\"RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:1:\"_\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:10:\"entry_list\";i:1;s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:29:\"Notification de Caldera Forms\";s:12:\"sender_email\";s:23:\"a.facque@groupe-echo.fr\";s:8:\"reply_to\";s:0:\"\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:0:\"\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(26, 'CF6047390b6259c', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047390b6259c\";s:13:\"_last_updated\";s:31:\"Tue, 30 Mar 2021 10:33:10 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:16:\"demande de devis\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:88:\"Le formulaire a été envoyé. Merci pour votre contribution.																											\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";N;s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:10:\"fld_475276\";s:3:\"3:1\";s:11:\"fld_6078931\";s:3:\"3:2\";s:11:\"fld_2695739\";s:3:\"4:1\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"6:1\";s:11:\"fld_3201949\";s:3:\"7:1\";}s:9:\"structure\";s:23:\"6:6|6:6|6:6|12|12|12|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Prénom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:14:\"Adresse e-mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:11:\"Téléphone\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"custom\";s:6:\"custom\";s:14:\"99 99 99 99 99\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_475276\";a:8:{s:2:\"ID\";s:10:\"fld_475276\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:9:\"Société\";s:4:\"slug\";s:6:\"socite\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Agence souhaitée\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:23:\"Bureau Hauts-de-France \";s:5:\"value\";s:23:\"Bureau Hauts-de-France \";s:5:\"label\";s:23:\"Bureau Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:21:\"Agence Ile de France \";s:5:\"value\";s:21:\"Agence Ile de France \";s:5:\"label\";s:21:\"Agence Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"label\";s:29:\"Agence Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2695739\";a:8:{s:2:\"ID\";s:11:\"fld_2695739\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:5:\"Objet\";s:4:\"slug\";s:5:\"objet\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:9:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Consentement RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:17:\"consentement_rgpd\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:29:\"Notification de Caldera Forms\";s:12:\"sender_email\";s:23:\"a.facque@groupe-echo.fr\";s:8:\"reply_to\";s:0:\"\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:0:\"\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}');
INSERT INTO `mod284_cf_forms` (`id`, `form_id`, `type`, `config`) VALUES 
(27, 'CF6047298f195ee', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047298f195ee\";s:13:\"_last_updated\";s:31:\"Tue, 30 Mar 2021 10:40:48 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:11:\"Recrutement\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:91:\"Le formulaire a été envoyé. Merci pour votre contribution.																														\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";s:0:\"\";s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:11:\"fld_6078931\";s:3:\"3:1\";s:11:\"fld_3279627\";s:3:\"4:1\";s:11:\"fld_3976945\";s:3:\"4:2\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"5:1\";s:11:\"fld_3201949\";s:3:\"5:1\";}s:9:\"structure\";s:17:\"6:6|6:6|12|6:6|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Prénom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:14:\"Adresse e-mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:11:\"Téléphone\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"custom\";s:6:\"custom\";s:14:\"99 99 99 99 99\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Secteur souhaité\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:16:\"Hauts-de-France \";s:5:\"value\";s:16:\"Hauts-de-France \";s:5:\"label\";s:16:\"Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:14:\"Ile de France \";s:5:\"value\";s:14:\"Ile de France \";s:5:\"label\";s:14:\"Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:22:\"Est Champagne Ardenne \";s:5:\"value\";s:22:\"Est Champagne Ardenne \";s:5:\"label\";s:22:\"Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3279627\";a:8:{s:2:\"ID\";s:11:\"fld_3279627\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:2:\"CV\";s:4:\"slug\";s:2:\"cv\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3976945\";a:8:{s:2:\"ID\";s:11:\"fld_3976945\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:20:\"Lettre de motivation\";s:4:\"slug\";s:20:\"lettre_de_motivation\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:10:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:4:\"RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:1:\"_\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:10:\"entry_list\";i:1;s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:24:\"Candidature - Site Artus\";s:12:\"sender_email\";s:36:\"contact.commercial@artus-securite.fr\";s:8:\"reply_to\";s:36:\"contact.commercial@artus-securite.fr\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:36:\"contact.commercial@artus-securite.fr\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(28, 'CF6047390b6259c', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047390b6259c\";s:13:\"_last_updated\";s:31:\"Tue, 30 Mar 2021 10:41:26 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:16:\"demande de devis\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:91:\"Le formulaire a été envoyé. Merci pour votre contribution.																														\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";s:0:\"\";s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:10:\"fld_475276\";s:3:\"3:1\";s:11:\"fld_6078931\";s:3:\"3:2\";s:11:\"fld_2695739\";s:3:\"4:1\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"6:1\";s:11:\"fld_3201949\";s:3:\"7:1\";}s:9:\"structure\";s:23:\"6:6|6:6|6:6|12|12|12|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Prénom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:14:\"Adresse e-mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:11:\"Téléphone\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"custom\";s:6:\"custom\";s:14:\"99 99 99 99 99\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_475276\";a:8:{s:2:\"ID\";s:10:\"fld_475276\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:9:\"Société\";s:4:\"slug\";s:6:\"socite\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:7:\"Secteur\";s:4:\"slug\";s:15:\"secteur_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:23:\"Bureau Hauts-de-France \";s:5:\"value\";s:16:\"Hauts-de-France \";s:5:\"label\";s:16:\"Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:21:\"Agence Ile de France \";s:5:\"value\";s:14:\"Ile de France \";s:5:\"label\";s:14:\"Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"value\";s:22:\"Est Champagne Ardenne \";s:5:\"label\";s:22:\"Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2695739\";a:8:{s:2:\"ID\";s:11:\"fld_2695739\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:5:\"Objet\";s:4:\"slug\";s:5:\"objet\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:9:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Consentement RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:17:\"consentement_rgpd\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:29:\"Notification de Caldera Forms\";s:12:\"sender_email\";s:23:\"a.facque@groupe-echo.fr\";s:8:\"reply_to\";s:0:\"\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:0:\"\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(29, 'CF6047390b6259c', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047390b6259c\";s:13:\"_last_updated\";s:31:\"Tue, 30 Mar 2021 10:41:39 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:16:\"demande de devis\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:91:\"Le formulaire a été envoyé. Merci pour votre contribution.																														\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";s:0:\"\";s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:10:\"fld_475276\";s:3:\"3:1\";s:11:\"fld_6078931\";s:3:\"3:2\";s:11:\"fld_2695739\";s:3:\"4:1\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"6:1\";s:11:\"fld_3201949\";s:3:\"7:1\";}s:9:\"structure\";s:23:\"6:6|6:6|6:6|12|12|12|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Prénom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:14:\"Adresse e-mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:11:\"Téléphone\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"custom\";s:6:\"custom\";s:14:\"99 99 99 99 99\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_475276\";a:8:{s:2:\"ID\";s:10:\"fld_475276\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:9:\"Société\";s:4:\"slug\";s:6:\"socite\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:7:\"Secteur\";s:4:\"slug\";s:15:\"secteur_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:23:\"Bureau Hauts-de-France \";s:5:\"value\";s:16:\"Hauts-de-France \";s:5:\"label\";s:16:\"Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:21:\"Agence Ile de France \";s:5:\"value\";s:14:\"Ile de France \";s:5:\"label\";s:14:\"Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:29:\"Agence Est Champagne Ardenne \";s:5:\"value\";s:22:\"Est Champagne Ardenne \";s:5:\"label\";s:22:\"Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2695739\";a:8:{s:2:\"ID\";s:11:\"fld_2695739\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:5:\"Objet\";s:4:\"slug\";s:5:\"objet\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:9:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Consentement RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:17:\"consentement_rgpd\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:32:\"Demande de devis - site internet\";s:12:\"sender_email\";s:36:\"contact.commercial@artus-securite.fr\";s:8:\"reply_to\";s:36:\"contact.commercial@artus-securite.fr\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:36:\"contact.commercial@artus-securite.fr\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(30, 'CF6047390b6259c', 'primary', 'a:22:{s:2:\"ID\";s:15:\"CF6047390b6259c\";s:13:\"_last_updated\";s:31:\"Mon, 12 Apr 2021 08:24:30 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:16:\"demande de devis\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:94:\"Le formulaire a été envoyé. Merci pour votre contribution.																																	\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";s:0:\"\";s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:10:\"fld_475276\";s:3:\"3:1\";s:11:\"fld_6078931\";s:3:\"3:2\";s:11:\"fld_2695739\";s:3:\"4:1\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"6:1\";s:11:\"fld_3201949\";s:3:\"7:1\";}s:9:\"structure\";s:23:\"6:6|6:6|6:6|12|12|12|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Prénom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:14:\"Adresse e-mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:11:\"Téléphone\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"custom\";s:6:\"custom\";s:14:\"99 99 99 99 99\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_475276\";a:8:{s:2:\"ID\";s:10:\"fld_475276\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:9:\"Société\";s:4:\"slug\";s:6:\"socite\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:7:\"Secteur\";s:4:\"slug\";s:15:\"secteur_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:16:\"Hauts-de-France \";s:5:\"value\";s:16:\"Hauts-de-France \";s:5:\"label\";s:16:\"Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:14:\"Ile de France \";s:5:\"value\";s:14:\"Ile de France \";s:5:\"label\";s:14:\"Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:22:\"Est Champagne Ardenne \";s:5:\"value\";s:22:\"Est Champagne Ardenne \";s:5:\"label\";s:22:\"Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2695739\";a:8:{s:2:\"ID\";s:11:\"fld_2695739\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:5:\"Objet\";s:4:\"slug\";s:5:\"objet\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:9:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Consentement RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:17:\"consentement_rgpd\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:32:\"Demande de devis - site internet\";s:12:\"sender_email\";s:36:\"contact.commercial@artus-securite.fr\";s:8:\"reply_to\";s:36:\"contact.commercial@artus-securite.fr\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:36:\"contact.commercial@artus-securite.fr\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:16:\"Demande de devis\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(31, 'CF6047298f195ee', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047298f195ee\";s:13:\"_last_updated\";s:31:\"Tue, 13 Apr 2021 12:40:54 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:11:\"Recrutement\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:94:\"Le formulaire a été envoyé. Merci pour votre contribution.																																	\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";s:0:\"\";s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:11:\"fld_6078931\";s:3:\"3:1\";s:11:\"fld_3279627\";s:3:\"4:1\";s:11:\"fld_3976945\";s:3:\"4:2\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"5:1\";s:11:\"fld_3201949\";s:3:\"5:1\";}s:9:\"structure\";s:17:\"6:6|6:6|12|6:6|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Prénom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:14:\"Adresse e-mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:11:\"Téléphone\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"custom\";s:6:\"custom\";s:14:\"99 99 99 99 99\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Secteur souhaité\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:16:\"Hauts-de-France \";s:5:\"value\";s:16:\"Hauts-de-France \";s:5:\"label\";s:16:\"Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:14:\"Ile de France \";s:5:\"value\";s:14:\"Ile de France \";s:5:\"label\";s:14:\"Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:22:\"Est Champagne Ardenne \";s:5:\"value\";s:22:\"Est Champagne Ardenne \";s:5:\"label\";s:22:\"Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3279627\";a:8:{s:2:\"ID\";s:11:\"fld_3279627\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:2:\"CV\";s:4:\"slug\";s:2:\"cv\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3976945\";a:8:{s:2:\"ID\";s:11:\"fld_3976945\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:20:\"Lettre de motivation\";s:4:\"slug\";s:20:\"lettre_de_motivation\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:10:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:4:\"RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:1:\"_\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:10:\"entry_list\";i:1;s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:24:\"Candidature - Site Artus\";s:12:\"sender_email\";s:36:\"contact.commercial@artus-securite.fr\";s:8:\"reply_to\";s:36:\"contact.commercial@artus-securite.fr\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:27:\"s.lefevre@artus-securite.fr\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(32, 'CF6047298f195ee', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047298f195ee\";s:13:\"_last_updated\";s:31:\"Tue, 13 Apr 2021 12:41:16 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:11:\"Recrutement\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:94:\"Le formulaire a été envoyé. Merci pour votre contribution.																																	\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";s:0:\"\";s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:11:\"fld_6078931\";s:3:\"3:1\";s:11:\"fld_3279627\";s:3:\"4:1\";s:11:\"fld_3976945\";s:3:\"4:2\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"5:1\";s:11:\"fld_3201949\";s:3:\"5:1\";}s:9:\"structure\";s:17:\"6:6|6:6|12|6:6|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Prénom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:14:\"Adresse e-mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:11:\"Téléphone\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"custom\";s:6:\"custom\";s:14:\"99 99 99 99 99\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Secteur souhaité\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:16:\"Hauts-de-France \";s:5:\"value\";s:16:\"Hauts-de-France \";s:5:\"label\";s:16:\"Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:14:\"Ile de France \";s:5:\"value\";s:14:\"Ile de France \";s:5:\"label\";s:14:\"Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:22:\"Est Champagne Ardenne \";s:5:\"value\";s:22:\"Est Champagne Ardenne \";s:5:\"label\";s:22:\"Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3279627\";a:8:{s:2:\"ID\";s:11:\"fld_3279627\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:2:\"CV\";s:4:\"slug\";s:2:\"cv\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3976945\";a:8:{s:2:\"ID\";s:11:\"fld_3976945\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:20:\"Lettre de motivation\";s:4:\"slug\";s:20:\"lettre_de_motivation\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:10:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:4:\"RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:1:\"_\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:10:\"entry_list\";i:1;s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:24:\"Candidature - Site Artus\";s:12:\"sender_email\";s:36:\"contact.commercial@artus-securite.fr\";s:8:\"reply_to\";s:27:\"s.lefevre@artus-securite.fr\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:27:\"s.lefevre@artus-securite.fr\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(33, 'CF6047298f195ee', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047298f195ee\";s:13:\"_last_updated\";s:31:\"Tue, 13 Apr 2021 13:06:14 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:11:\"Recrutement\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:97:\"Le formulaire a été envoyé. Merci pour votre contribution.																																				\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";N;s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:11:\"fld_6078931\";s:3:\"3:1\";s:11:\"fld_3279627\";s:3:\"4:1\";s:11:\"fld_3976945\";s:3:\"4:2\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"5:1\";s:11:\"fld_3201949\";s:3:\"5:1\";}s:9:\"structure\";s:17:\"6:6|6:6|12|6:6|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Prénom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:14:\"Adresse e-mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:11:\"Téléphone\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"custom\";s:6:\"custom\";s:14:\"99 99 99 99 99\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Secteur souhaité\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:16:\"Hauts-de-France \";s:5:\"value\";s:16:\"Hauts-de-France \";s:5:\"label\";s:16:\"Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:14:\"Ile de France \";s:5:\"value\";s:14:\"Ile de France \";s:5:\"label\";s:14:\"Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:22:\"Est Champagne Ardenne \";s:5:\"value\";s:22:\"Est Champagne Ardenne \";s:5:\"label\";s:22:\"Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3279627\";a:8:{s:2:\"ID\";s:11:\"fld_3279627\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:2:\"CV\";s:4:\"slug\";s:2:\"cv\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:6:\"attach\";i:1;s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3976945\";a:8:{s:2:\"ID\";s:11:\"fld_3976945\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:20:\"Lettre de motivation\";s:4:\"slug\";s:20:\"lettre_de_motivation\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:6:\"attach\";i:1;s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:10:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:4:\"RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:1:\"_\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:10:\"entry_list\";i:1;s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:24:\"Candidature - Site Artus\";s:12:\"sender_email\";s:36:\"contact.commercial@artus-securite.fr\";s:8:\"reply_to\";s:27:\"s.lefevre@artus-securite.fr\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:27:\"s.lefevre@artus-securite.fr\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}'),
(34, 'CF6047298f195ee', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047298f195ee\";s:13:\"_last_updated\";s:31:\"Tue, 13 Apr 2021 13:07:31 +0000\";s:10:\"cf_version\";s:5:\"1.9.4\";s:4:\"name\";s:11:\"Recrutement\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:97:\"Le formulaire a été envoyé. Merci pour votre contribution.																																				\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";N;s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:11:\"fld_6078931\";s:3:\"3:1\";s:11:\"fld_3279627\";s:3:\"4:1\";s:11:\"fld_3976945\";s:3:\"4:2\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"5:1\";s:11:\"fld_3201949\";s:3:\"5:1\";}s:9:\"structure\";s:17:\"6:6|6:6|12|6:6|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Prénom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:14:\"Adresse e-mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:11:\"Téléphone\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"custom\";s:6:\"custom\";s:14:\"99 99 99 99 99\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Secteur souhaité\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:16:\"Hauts-de-France \";s:5:\"value\";s:16:\"Hauts-de-France \";s:5:\"label\";s:16:\"Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:14:\"Ile de France \";s:5:\"value\";s:14:\"Ile de France \";s:5:\"label\";s:14:\"Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:22:\"Est Champagne Ardenne \";s:5:\"value\";s:22:\"Est Champagne Ardenne \";s:5:\"label\";s:22:\"Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3279627\";a:8:{s:2:\"ID\";s:11:\"fld_3279627\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:2:\"CV\";s:4:\"slug\";s:2:\"cv\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:6:\"attach\";i:1;s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3976945\";a:8:{s:2:\"ID\";s:11:\"fld_3976945\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:20:\"Lettre de motivation\";s:4:\"slug\";s:20:\"lettre_de_motivation\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:6:\"attach\";i:1;s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:10:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:4:\"RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:1:\"_\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:10:\"entry_list\";i:1;s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:24:\"Candidature - Site Artus\";s:12:\"sender_email\";s:36:\"contact.commercial@artus-securite.fr\";s:8:\"reply_to\";s:27:\"s.lefevre@artus-securite.fr\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:27:\"s.lefevre@artus-securite.fr\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.4\";}');
INSERT INTO `mod284_cf_forms` (`id`, `form_id`, `type`, `config`) VALUES 
(35, 'CF6047298f195ee', 'revision', 'a:22:{s:2:\"ID\";s:15:\"CF6047298f195ee\";s:13:\"_last_updated\";s:31:\"Mon, 30 Jan 2023 15:37:55 +0000\";s:10:\"cf_version\";s:5:\"1.9.6\";s:4:\"name\";s:11:\"Recrutement\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:100:\"Le formulaire a été envoyé. Merci pour votre contribution.																																							\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";s:0:\"\";s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:11:\"fld_6078931\";s:3:\"3:1\";s:11:\"fld_3279627\";s:3:\"4:1\";s:11:\"fld_3976945\";s:3:\"4:2\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"5:1\";s:11:\"fld_3201949\";s:3:\"5:1\";}s:9:\"structure\";s:17:\"6:6|6:6|12|6:6|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Prénom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:14:\"Adresse e-mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:11:\"Téléphone\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"custom\";s:6:\"custom\";s:14:\"99 99 99 99 99\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Secteur souhaité\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:16:\"Hauts-de-France \";s:5:\"value\";s:16:\"Hauts-de-France \";s:5:\"label\";s:16:\"Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:14:\"Ile de France \";s:5:\"value\";s:14:\"Ile de France \";s:5:\"label\";s:14:\"Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:22:\"Est Champagne Ardenne \";s:5:\"value\";s:22:\"Est Champagne Ardenne \";s:5:\"label\";s:22:\"Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3279627\";a:8:{s:2:\"ID\";s:11:\"fld_3279627\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:2:\"CV\";s:4:\"slug\";s:2:\"cv\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:6:\"attach\";i:1;s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3976945\";a:8:{s:2:\"ID\";s:11:\"fld_3976945\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:20:\"Lettre de motivation\";s:4:\"slug\";s:20:\"lettre_de_motivation\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:6:\"attach\";i:1;s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:10:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:4:\"RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:1:\"_\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:10:\"entry_list\";i:1;s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:24:\"Candidature - Site Artus\";s:12:\"sender_email\";s:36:\"contact.commercial@artus-securite.fr\";s:8:\"reply_to\";s:24:\"t.fava@artus-securite.fr\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:27:\"s.lefevre@artus-securite.fr\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.6\";}'),
(36, 'CF6047298f195ee', 'primary', 'a:22:{s:2:\"ID\";s:15:\"CF6047298f195ee\";s:13:\"_last_updated\";s:31:\"Fri, 03 Feb 2023 15:19:00 +0000\";s:10:\"cf_version\";s:5:\"1.9.6\";s:4:\"name\";s:11:\"Recrutement\";s:10:\"scroll_top\";i:0;s:7:\"success\";s:103:\"Le formulaire a été envoyé. Merci pour votre contribution.																																										\";s:10:\"db_support\";i:1;s:6:\"pinned\";i:0;s:9:\"hide_form\";i:1;s:11:\"check_honey\";i:1;s:12:\"avatar_field\";s:0:\"\";s:9:\"form_ajax\";i:1;s:15:\"custom_callback\";s:0:\"\";s:11:\"layout_grid\";a:2:{s:6:\"fields\";a:10:{s:11:\"fld_5462783\";s:3:\"1:1\";s:11:\"fld_3436924\";s:3:\"1:2\";s:11:\"fld_2124341\";s:3:\"2:1\";s:10:\"fld_724362\";s:3:\"2:2\";s:11:\"fld_6078931\";s:3:\"3:1\";s:11:\"fld_3279627\";s:3:\"4:1\";s:11:\"fld_3976945\";s:3:\"4:2\";s:11:\"fld_3396882\";s:3:\"5:1\";s:11:\"fld_3410960\";s:3:\"5:1\";s:11:\"fld_3201949\";s:3:\"5:1\";}s:9:\"structure\";s:17:\"6:6|6:6|12|6:6|12\";}s:6:\"fields\";a:10:{s:11:\"fld_5462783\";a:8:{s:2:\"ID\";s:11:\"fld_5462783\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:3:\"Nom\";s:4:\"slug\";s:3:\"nom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3436924\";a:8:{s:2:\"ID\";s:11:\"fld_3436924\";s:4:\"type\";s:4:\"text\";s:5:\"label\";s:7:\"Prénom\";s:4:\"slug\";s:6:\"prenom\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:13:\"type_override\";s:4:\"text\";s:4:\"mask\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_2124341\";a:8:{s:2:\"ID\";s:11:\"fld_2124341\";s:4:\"type\";s:5:\"email\";s:5:\"label\";s:14:\"Adresse e-mail\";s:4:\"slug\";s:12:\"adresse_mail\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:10:\"fld_724362\";a:8:{s:2:\"ID\";s:10:\"fld_724362\";s:4:\"type\";s:5:\"phone\";s:5:\"label\";s:11:\"Téléphone\";s:4:\"slug\";s:7:\"num_tel\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:7:\"default\";s:0:\"\";s:4:\"type\";s:6:\"custom\";s:6:\"custom\";s:14:\"99 99 99 99 99\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_6078931\";a:8:{s:2:\"ID\";s:11:\"fld_6078931\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:17:\"Secteur souhaité\";s:4:\"slug\";s:14:\"agence_souhait\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:3:{s:10:\"opt1916226\";a:3:{s:10:\"calc_value\";s:16:\"Hauts-de-France \";s:5:\"value\";s:16:\"Hauts-de-France \";s:5:\"label\";s:16:\"Hauts-de-France \";}s:10:\"opt1636010\";a:3:{s:10:\"calc_value\";s:14:\"Ile de France \";s:5:\"value\";s:14:\"Ile de France \";s:5:\"label\";s:14:\"Ile de France \";}s:10:\"opt1109492\";a:3:{s:10:\"calc_value\";s:22:\"Est Champagne Ardenne \";s:5:\"value\";s:22:\"Est Champagne Ardenne \";s:5:\"label\";s:22:\"Est Champagne Ardenne \";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3279627\";a:8:{s:2:\"ID\";s:11:\"fld_3279627\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:2:\"CV\";s:4:\"slug\";s:2:\"cv\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:6:\"attach\";i:1;s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3976945\";a:8:{s:2:\"ID\";s:11:\"fld_3976945\";s:4:\"type\";s:4:\"file\";s:5:\"label\";s:20:\"Lettre de motivation\";s:4:\"slug\";s:20:\"lettre_de_motivation\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:7:{s:12:\"custom_class\";s:0:\"\";s:6:\"attach\";i:1;s:17:\"multi_upload_text\";s:0:\"\";s:7:\"allowed\";s:3:\"pdf\";s:10:\"max_upload\";i:0;s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3396882\";a:8:{s:2:\"ID\";s:11:\"fld_3396882\";s:4:\"type\";s:9:\"paragraph\";s:5:\"label\";s:7:\"Message\";s:4:\"slug\";s:7:\"message\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:6:\"config\";a:6:{s:12:\"custom_class\";s:0:\"\";s:11:\"placeholder\";s:0:\"\";s:4:\"rows\";i:10;s:7:\"default\";s:0:\"\";s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3410960\";a:10:{s:2:\"ID\";s:11:\"fld_3410960\";s:4:\"type\";s:8:\"checkbox\";s:5:\"label\";s:4:\"RGPD\";s:10:\"hide_label\";i:1;s:4:\"slug\";s:1:\"_\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:8:\"required\";i:1;s:7:\"caption\";s:0:\"\";s:10:\"entry_list\";i:1;s:6:\"config\";a:13:{s:12:\"custom_class\";s:0:\"\";s:14:\"default_option\";s:0:\"\";s:9:\"auto_type\";s:0:\"\";s:8:\"taxonomy\";s:8:\"category\";s:9:\"post_type\";s:4:\"post\";s:11:\"value_field\";s:4:\"name\";s:11:\"orderby_tax\";s:4:\"name\";s:12:\"orderby_post\";s:4:\"name\";s:5:\"order\";s:3:\"ASC\";s:7:\"default\";s:0:\"\";s:6:\"option\";a:1:{s:10:\"opt1664586\";a:3:{s:10:\"calc_value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"value\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";s:5:\"label\";s:95:\" En soumettant le formulaire, j\'accepte que mes données soient utilisées pour me recontacter.\";}}s:16:\"email_identifier\";i:0;s:22:\"personally_identifying\";i:0;}}s:11:\"fld_3201949\";a:7:{s:2:\"ID\";s:11:\"fld_3201949\";s:4:\"type\";s:6:\"button\";s:5:\"label\";s:7:\"Envoyer\";s:4:\"slug\";s:7:\"envoyer\";s:10:\"conditions\";a:1:{s:4:\"type\";s:0:\"\";}s:7:\"caption\";s:0:\"\";s:6:\"config\";a:5:{s:12:\"custom_class\";s:0:\"\";s:4:\"type\";s:6:\"submit\";s:5:\"class\";s:15:\"btn btn-default\";s:11:\"label_space\";i:1;s:6:\"target\";s:0:\"\";}}}s:10:\"page_names\";a:1:{i:0;s:6:\"Page 1\";}s:6:\"mailer\";a:9:{s:9:\"on_insert\";i:1;s:11:\"sender_name\";s:24:\"Candidature - Site Artus\";s:12:\"sender_email\";s:36:\"contact.commercial@artus-securite.fr\";s:8:\"reply_to\";s:24:\"t.fava@artus-securite.fr\";s:10:\"email_type\";s:4:\"html\";s:10:\"recipients\";s:24:\"t.fava@artus-securite.fr\";s:6:\"bcc_to\";s:0:\"\";s:13:\"email_subject\";s:11:\"Recrutement\";s:13:\"email_message\";s:9:\"{summary}\";}s:8:\"settings\";a:1:{s:10:\"responsive\";a:1:{s:11:\"break_point\";s:2:\"sm\";}}s:18:\"conditional_groups\";a:1:{s:10:\"conditions\";a:0:{}}s:10:\"processors\";a:0:{}s:24:\"privacy_exporter_enabled\";b:0;s:7:\"version\";s:5:\"1.9.6\";}');
/*!40000 ALTER TABLE `mod284_cf_forms` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_cf_pro_messages`
--

DROP TABLE IF EXISTS `mod284_cf_pro_messages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_cf_pro_messages` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `cfp_id` bigint(20) unsigned DEFAULT NULL,
  `entry_id` bigint(20) unsigned DEFAULT NULL,
  `hash` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_cf_pro_messages`
--

LOCK TABLES `mod284_cf_pro_messages` WRITE;
/*!40000 ALTER TABLE `mod284_cf_pro_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod284_cf_pro_messages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_cf_queue_failures`
--

DROP TABLE IF EXISTS `mod284_cf_queue_failures`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_cf_queue_failures` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `job` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `error` text COLLATE utf8mb4_unicode_520_ci,
  `failed_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_cf_queue_failures`
--

LOCK TABLES `mod284_cf_queue_failures` WRITE;
/*!40000 ALTER TABLE `mod284_cf_queue_failures` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod284_cf_queue_failures` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_cf_queue_jobs`
--

DROP TABLE IF EXISTS `mod284_cf_queue_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_cf_queue_jobs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `job` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attempts` tinyint(3) NOT NULL DEFAULT '0',
  `reserved_at` datetime DEFAULT NULL,
  `available_at` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=221 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_cf_queue_jobs`
--

LOCK TABLES `mod284_cf_queue_jobs` WRITE;
/*!40000 ALTER TABLE `mod284_cf_queue_jobs` DISABLE KEYS */;
INSERT INTO `mod284_cf_queue_jobs` (`id`, `job`, `attempts`, `reserved_at`, `available_at`, `created_at`) VALUES 
(5, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:90:\"/home/xdrvhgi/www/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/BOUTAIEBIKamelCV.pdf\";s:3:\"url\";s:98:\"https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/BOUTAIEBIKamelCV.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 127, '2023-12-14 09:34:50', '2023-06-22 19:31:53', '2023-06-22 19:31:53'),
(6, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:90:\"/home/xdrvhgi/www/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/BOUTAIEBIKamelCV.pdf\";s:3:\"url\";s:98:\"https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/BOUTAIEBIKamelCV.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-06-22 19:31:53', '2023-06-22 19:31:53'),
(7, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_649794aa3b57f\";}', 0, NULL, '2023-06-25 01:23:14', '2023-06-25 01:13:14'),
(8, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_649805f207b55\";}', 0, NULL, '2023-06-25 09:26:34', '2023-06-25 09:16:34'),
(9, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_649c44bc8a3bc\";}', 0, NULL, '2023-06-28 14:43:32', '2023-06-28 14:33:32'),
(10, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_649d0676b2346\";}', 0, NULL, '2023-06-29 04:30:06', '2023-06-29 04:20:06'),
(11, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_649d52a783757\";}', 0, NULL, '2023-06-29 09:55:11', '2023-06-29 09:45:11'),
(12, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_649fc98edc308\";}', 0, NULL, '2023-07-01 06:47:02', '2023-07-01 06:37:02'),
(13, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_649fcbd64f991\";}', 0, NULL, '2023-07-01 06:56:46', '2023-07-01 06:46:46'),
(14, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64a1165726a40\";}', 0, NULL, '2023-07-02 06:26:55', '2023-07-02 06:16:55'),
(15, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64a1165726a3c\";}', 0, NULL, '2023-07-02 06:26:55', '2023-07-02 06:16:55'),
(16, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64a2c9cccb8f1\";}', 0, NULL, '2023-07-03 13:24:52', '2023-07-03 13:14:52'),
(17, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64a3bc652af45\";}', 0, NULL, '2023-07-04 06:39:57', '2023-07-04 06:29:57'),
(18, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64a3c8f26cbed\";}', 0, NULL, '2023-07-04 07:33:30', '2023-07-04 07:23:30'),
(19, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:114:\"/home/xdrvhgi/www/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/Minimalist-Modern-Professional-CV-Resume.pdf\";s:3:\"url\";s:122:\"https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/Minimalist-Modern-Professional-CV-Resume.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-07-04 09:19:39', '2023-07-04 09:19:39'),
(20, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:94:\"/home/xdrvhgi/www/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/L.M-Thiffany-Mangeot.pdf\";s:3:\"url\";s:102:\"https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/L.M-Thiffany-Mangeot.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-07-04 09:19:39', '2023-07-04 09:19:39'),
(21, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64a426f583211\";}', 0, NULL, '2023-07-04 14:14:37', '2023-07-04 14:04:37'),
(22, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64a5b9106985e\";}', 0, NULL, '2023-07-05 18:50:16', '2023-07-05 18:40:16'),
(23, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64a5e168a46f4\";}', 0, NULL, '2023-07-05 21:42:24', '2023-07-05 21:32:24'),
(24, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64a5f353e143e\";}', 0, NULL, '2023-07-05 22:58:51', '2023-07-05 22:48:51'),
(25, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64a60a098ce08\";}', 0, NULL, '2023-07-06 00:35:45', '2023-07-06 00:25:45'),
(26, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64a8059a62227\";}', 0, NULL, '2023-07-07 12:41:22', '2023-07-07 12:31:22'),
(27, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64ab18aabb988\";}', 0, NULL, '2023-07-09 20:39:30', '2023-07-09 20:29:30'),
(28, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64ab915caf385\";}', 0, NULL, '2023-07-10 05:14:28', '2023-07-10 05:04:28'),
(29, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64af3b62231b6\";}', 0, NULL, '2023-07-12 23:56:42', '2023-07-12 23:46:42'),
(30, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64af5a28c2faa\";}', 0, NULL, '2023-07-13 02:08:01', '2023-07-13 01:58:01'),
(31, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64b443d4da3c3\";}', 0, NULL, '2023-07-16 19:34:04', '2023-07-16 19:24:04'),
(32, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64b541d1b4eb9\";}', 0, NULL, '2023-07-17 13:37:45', '2023-07-17 13:27:45'),
(33, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64b8817d4aeef\";}', 0, NULL, '2023-07-20 00:46:13', '2023-07-20 00:36:13'),
(34, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64b881f5c7b9a\";}', 0, NULL, '2023-07-20 00:48:13', '2023-07-20 00:38:13'),
(35, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64b8a1ce0dd3a\";}', 0, NULL, '2023-07-20 03:04:06', '2023-07-20 02:54:06'),
(36, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64b8aac4a9a5f\";}', 0, NULL, '2023-07-20 03:42:20', '2023-07-20 03:32:20'),
(37, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64b8bede26791\";}', 0, NULL, '2023-07-20 05:08:06', '2023-07-20 04:58:06'),
(38, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64ba0c2fafcb7\";}', 0, NULL, '2023-07-21 04:50:15', '2023-07-21 04:40:15'),
(39, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64ba336fd28e6\";}', 0, NULL, '2023-07-21 07:37:44', '2023-07-21 07:27:44'),
(40, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64bf7aed2acef\";}', 0, NULL, '2023-07-25 07:44:05', '2023-07-25 07:34:05'),
(41, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64bfc20fa27cf\";}', 0, NULL, '2023-07-25 12:47:35', '2023-07-25 12:37:35'),
(42, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64c36bccacda3\";}', 0, NULL, '2023-07-28 07:28:36', '2023-07-28 07:18:36'),
(43, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64c36bccacd98\";}', 0, NULL, '2023-07-28 07:28:36', '2023-07-28 07:18:36'),
(44, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64c8fa1d52489\";}', 0, NULL, '2023-08-01 12:37:09', '2023-08-01 12:27:09'),
(45, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64c9b1ddb3a39\";}', 0, NULL, '2023-08-02 01:41:09', '2023-08-02 01:31:09'),
(46, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64caa64b56db5\";}', 0, NULL, '2023-08-02 19:04:03', '2023-08-02 18:54:03'),
(47, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64caa8f7a503a\";}', 0, NULL, '2023-08-02 19:15:27', '2023-08-02 19:05:27'),
(48, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64caaa7bc5570\";}', 0, NULL, '2023-08-02 19:21:55', '2023-08-02 19:11:55'),
(49, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64cab080ef3f3\";}', 0, NULL, '2023-08-02 19:47:36', '2023-08-02 19:37:36'),
(50, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64cac7711ecb1\";}', 0, NULL, '2023-08-02 21:25:29', '2023-08-02 21:15:29'),
(51, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64cac7711edbe\";}', 0, NULL, '2023-08-02 21:25:29', '2023-08-02 21:15:29'),
(52, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64cac771deddd\";}', 0, NULL, '2023-08-02 21:25:29', '2023-08-02 21:15:29'),
(53, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64cacfff721cb\";}', 0, NULL, '2023-08-02 22:01:59', '2023-08-02 21:51:59'),
(54, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64cb0cdee57e5\";}', 0, NULL, '2023-08-03 02:21:42', '2023-08-03 02:11:42'),
(55, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64cb0e727bdb3\";}', 0, NULL, '2023-08-03 02:28:26', '2023-08-03 02:18:26'),
(56, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64ceee61a196c\";}', 0, NULL, '2023-08-06 01:00:41', '2023-08-06 00:50:41'),
(57, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64cfaaf0b09ed\";}', 0, NULL, '2023-08-06 14:25:12', '2023-08-06 14:15:12'),
(58, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64d334f7eb700\";}', 0, NULL, '2023-08-09 06:50:55', '2023-08-09 06:40:55'),
(59, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64d34993b83f9\";}', 0, NULL, '2023-08-09 08:18:51', '2023-08-09 08:08:51'),
(60, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64d352cf96138\";}', 0, NULL, '2023-08-09 08:58:15', '2023-08-09 08:48:15'),
(61, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64d36df9cfe0e\";}', 0, NULL, '2023-08-09 10:54:09', '2023-08-09 10:44:09'),
(62, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64d6426b0b1db\";}', 0, NULL, '2023-08-11 14:25:07', '2023-08-11 14:15:07'),
(63, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64d64815a83d9\";}', 0, NULL, '2023-08-11 14:49:17', '2023-08-11 14:39:17'),
(64, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:88:\"/home/xdrvhgi/www/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/cv-aps-ssiap-2.pdf\";s:3:\"url\";s:96:\"https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/cv-aps-ssiap-2.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-08-11 14:42:17', '2023-08-11 14:42:17'),
(65, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:95:\"/home/xdrvhgi/www/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Lettre-de-motivation-.pdf\";s:3:\"url\";s:103:\"https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Lettre-de-motivation-.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-08-11 14:42:17', '2023-08-11 14:42:17'),
(66, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64da47aa54022\";}', 0, NULL, '2023-08-14 15:36:34', '2023-08-14 15:26:34'),
(67, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64dbf57f53691\";}', 0, NULL, '2023-08-15 22:10:31', '2023-08-15 22:00:31'),
(68, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64e356df4abfa\";}', 0, NULL, '2023-08-21 12:31:51', '2023-08-21 12:21:51'),
(69, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64e49486c87f7\";}', 0, NULL, '2023-08-22 11:07:10', '2023-08-22 10:57:10'),
(70, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64e5918abc2d4\";}', 0, NULL, '2023-08-23 05:06:42', '2023-08-23 04:56:42'),
(71, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64e5918b20e58\";}', 0, NULL, '2023-08-23 05:06:43', '2023-08-23 04:56:43'),
(72, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64e60f2ac1872\";}', 0, NULL, '2023-08-23 14:02:42', '2023-08-23 13:52:42'),
(73, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64e6ebf59f065\";}', 0, NULL, '2023-08-24 05:44:45', '2023-08-24 05:34:45'),
(74, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64e8bdabb9de7\";}', 0, NULL, '2023-08-25 14:51:47', '2023-08-25 14:41:47'),
(75, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64ea33ad4446d\";}', 0, NULL, '2023-08-26 17:27:33', '2023-08-26 17:17:33'),
(76, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64eb1c466a20b\";}', 0, NULL, '2023-08-27 09:59:58', '2023-08-27 09:49:58'),
(77, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64eb544867a64\";}', 0, NULL, '2023-08-27 13:58:56', '2023-08-27 13:48:56'),
(78, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64eb8d51be002\";}', 0, NULL, '2023-08-27 18:02:17', '2023-08-27 17:52:17'),
(79, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64ec82c8d537b\";}', 0, NULL, '2023-08-28 11:29:36', '2023-08-28 11:19:36'),
(80, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64ee2b9ca25bc\";}', 0, NULL, '2023-08-29 17:42:12', '2023-08-29 17:32:12'),
(81, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64f1fb9a266e1\";}', 0, NULL, '2023-09-01 15:06:26', '2023-09-01 14:56:26'),
(82, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64f24d93f2b1e\";}', 0, NULL, '2023-09-01 20:56:12', '2023-09-01 20:46:12'),
(83, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64f274fb746ce\";}', 0, NULL, '2023-09-01 23:44:19', '2023-09-01 23:34:19'),
(84, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64f362042734e\";}', 0, NULL, '2023-09-02 16:35:40', '2023-09-02 16:25:40'),
(85, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64f377549b597\";}', 0, NULL, '2023-09-02 18:06:36', '2023-09-02 17:56:36'),
(86, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:85:\"/home/xdrvhgi/www/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/Cv-securite.pdf\";s:3:\"url\";s:93:\"https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/Cv-securite.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-09-02 21:39:13', '2023-09-02 21:39:13'),
(87, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:94:\"/home/xdrvhgi/www/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Lettre-de-motivation.pdf\";s:3:\"url\";s:102:\"https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Lettre-de-motivation.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-09-02 21:39:13', '2023-09-02 21:39:13'),
(88, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64f3ddc6166e5\";}', 0, NULL, '2023-09-03 01:23:42', '2023-09-03 01:13:42'),
(89, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64f58c5adb140\";}', 0, NULL, '2023-09-04 08:00:50', '2023-09-04 07:50:50'),
(90, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64f5a56818310\";}', 0, NULL, '2023-09-04 09:47:44', '2023-09-04 09:37:44'),
(91, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64f5a56dc49a6\";}', 0, NULL, '2023-09-04 09:47:49', '2023-09-04 09:37:49'),
(92, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64f5a56dc49a6\";}', 0, NULL, '2023-09-04 09:47:52', '2023-09-04 09:37:52'),
(93, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64f5a56dc49a6\";}', 0, NULL, '2023-09-04 09:47:55', '2023-09-04 09:37:55'),
(94, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64f5a56dc49a6\";}', 0, NULL, '2023-09-04 09:47:58', '2023-09-04 09:37:58'),
(95, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64f98f7447c0d\";}', 0, NULL, '2023-09-07 09:03:08', '2023-09-07 08:53:08'),
(96, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64fc9b8e5d5fd\";}', 0, NULL, '2023-09-09 16:31:34', '2023-09-09 16:21:34'),
(97, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64fc9cd348e77\";}', 0, NULL, '2023-09-09 16:36:59', '2023-09-09 16:26:59'),
(98, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64fc9cd348e77\";}', 0, NULL, '2023-09-09 16:37:02', '2023-09-09 16:27:02'),
(99, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64fc9cd348e77\";}', 0, NULL, '2023-09-09 16:37:04', '2023-09-09 16:27:04'),
(100, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64fc9cdf9f38b\";}', 0, NULL, '2023-09-09 16:37:11', '2023-09-09 16:27:11'),
(101, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64fc9cdf9f38b\";}', 0, NULL, '2023-09-09 16:37:15', '2023-09-09 16:27:15'),
(102, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64fcfa5f37f1c\";}', 0, NULL, '2023-09-09 23:16:07', '2023-09-09 23:06:07'),
(103, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64fd2d9e98276\";}', 0, NULL, '2023-09-10 02:54:46', '2023-09-10 02:44:46'),
(104, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64fd2f9d88372\";}', 0, NULL, '2023-09-10 03:03:17', '2023-09-10 02:53:17'),
(105, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64feac5c959eb\";}', 0, NULL, '2023-09-11 06:07:48', '2023-09-11 05:57:48'),
(106, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_64fffd4aad8d0\";}', 0, NULL, '2023-09-12 06:05:22', '2023-09-12 05:55:22'),
(107, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_65022b1817b0d\";}', 0, NULL, '2023-09-13 21:45:20', '2023-09-13 21:35:20'),
(108, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_65022b5c6ec40\";}', 0, NULL, '2023-09-13 21:46:28', '2023-09-13 21:36:28'),
(109, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_65022b5c6ec40\";}', 0, NULL, '2023-09-13 21:46:31', '2023-09-13 21:36:31'),
(110, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_65022b6439d21\";}', 0, NULL, '2023-09-13 21:46:36', '2023-09-13 21:36:36'),
(111, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_65022b6439d21\";}', 0, NULL, '2023-09-13 21:46:38', '2023-09-13 21:36:38'),
(112, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_65049939c9c12\";}', 0, NULL, '2023-09-15 17:59:45', '2023-09-15 17:49:45'),
(113, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6504c1581a1ec\";}', 0, NULL, '2023-09-15 20:50:56', '2023-09-15 20:40:56'),
(114, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6505c2da44ed0\";}', 0, NULL, '2023-09-16 15:09:38', '2023-09-16 14:59:38'),
(115, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6505c2dc572e7\";}', 0, NULL, '2023-09-16 15:09:40', '2023-09-16 14:59:40'),
(116, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6508835ecc064\";}', 0, NULL, '2023-09-18 17:15:34', '2023-09-18 17:05:34'),
(117, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6508d44c86cc5\";}', 0, NULL, '2023-09-18 23:00:52', '2023-09-18 22:50:52'),
(118, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_650a319dc8b51\";}', 0, NULL, '2023-09-19 23:51:17', '2023-09-19 23:41:17'),
(119, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_650a3f97b9513\";}', 0, NULL, '2023-09-20 00:50:55', '2023-09-20 00:40:55'),
(120, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_650a7e4459bfd\";}', 0, NULL, '2023-09-20 05:18:20', '2023-09-20 05:08:20'),
(121, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_650ab3fe44271\";}', 0, NULL, '2023-09-20 09:07:34', '2023-09-20 08:57:34'),
(122, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_650c354171972\";}', 0, NULL, '2023-09-21 12:31:21', '2023-09-21 12:21:21'),
(123, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:85:\"/home/xdrvhgi/www/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-Pail0923.pdf\";s:3:\"url\";s:93:\"https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-Pail0923.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-09-21 12:22:13', '2023-09-21 12:22:13'),
(124, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:101:\"/home/xdrvhgi/www/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Lettredemotivation0923paila.pdf\";s:3:\"url\";s:109:\"https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/Lettredemotivation0923paila.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-09-21 12:22:13', '2023-09-21 12:22:13'),
(125, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_650d626e6a662\";}', 0, NULL, '2023-09-22 09:56:22', '2023-09-22 09:46:22'),
(126, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_650d7dcb18ea2\";}', 0, NULL, '2023-09-22 11:53:07', '2023-09-22 11:43:07'),
(127, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_65119ad7e83da\";}', 0, NULL, '2023-09-25 14:46:07', '2023-09-25 14:36:07'),
(128, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6511e91b2522c\";}', 0, NULL, '2023-09-25 20:20:03', '2023-09-25 20:10:03'),
(129, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:79:\"/home/xdrvhgi/www/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/C.N.I.pdf\";s:3:\"url\";s:87:\"https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/C.N.I.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-09-25 21:27:15', '2023-09-25 21:27:15'),
(130, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6511fb3374843\";}', 0, NULL, '2023-09-25 21:37:15', '2023-09-25 21:27:15'),
(131, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:81:\"/home/xdrvhgi/www/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/C.N.I-1.pdf\";s:3:\"url\";s:89:\"https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/C.N.I-1.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-09-25 21:27:38', '2023-09-25 21:27:38'),
(132, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6511fb4aaa890\";}', 0, NULL, '2023-09-25 21:37:38', '2023-09-25 21:27:38'),
(133, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:81:\"/home/xdrvhgi/www/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/C.N.I-2.pdf\";s:3:\"url\";s:89:\"https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/C.N.I-2.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-09-25 21:27:56', '2023-09-25 21:27:56'),
(134, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6511fb5c6483f\";}', 0, NULL, '2023-09-25 21:37:56', '2023-09-25 21:27:56'),
(135, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:81:\"/home/xdrvhgi/www/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/C.N.I-3.pdf\";s:3:\"url\";s:89:\"https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/C.N.I-3.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-09-25 21:28:19', '2023-09-25 21:28:19'),
(136, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6511fb7303ac6\";}', 0, NULL, '2023-09-25 21:38:19', '2023-09-25 21:28:19'),
(137, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:108:\"/home/xdrvhgi/www/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/2023-2445-VOL-ACCESSOIRES-VL-DILEK.pdf\";s:3:\"url\";s:116:\"https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/2023-2445-VOL-ACCESSOIRES-VL-DILEK.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-09-25 21:28:34', '2023-09-25 21:28:34'),
(138, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:81:\"/home/xdrvhgi/www/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/C.N.I-4.pdf\";s:3:\"url\";s:89:\"https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/C.N.I-4.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-09-25 21:28:34', '2023-09-25 21:28:34'),
(139, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_65124a0e37316\";}', 0, NULL, '2023-09-26 03:13:42', '2023-09-26 03:03:42'),
(140, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6519cf0775552\";}', 0, NULL, '2023-10-01 20:06:55', '2023-10-01 19:56:55'),
(141, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_651c996721e69\";}', 0, NULL, '2023-10-03 22:54:55', '2023-10-03 22:44:55'),
(142, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_651ecf8dbe510\";}', 0, NULL, '2023-10-05 15:10:29', '2023-10-05 15:00:29'),
(143, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_651fb08a35a70\";}', 0, NULL, '2023-10-06 07:10:26', '2023-10-06 07:00:26'),
(144, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_651fbccdc5ef0\";}', 0, NULL, '2023-10-06 08:02:45', '2023-10-06 07:52:45'),
(145, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6520205b92c00\";}', 0, NULL, '2023-10-06 15:07:31', '2023-10-06 14:57:31'),
(146, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6523507058650\";}', 0, NULL, '2023-10-09 01:09:28', '2023-10-09 00:59:28'),
(147, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_652371a002caa\";}', 0, NULL, '2023-10-09 03:31:04', '2023-10-09 03:21:04'),
(148, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_652398ef8221d\";}', 0, NULL, '2023-10-09 06:18:47', '2023-10-09 06:08:47'),
(149, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6523a16722be6\";}', 0, NULL, '2023-10-09 06:54:55', '2023-10-09 06:44:55'),
(150, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:107:\"/home/xdrvhgi/www/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/SSIAP-CV-Fabrice-NASCIEMENTO-2023.pdf\";s:3:\"url\";s:115:\"https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/SSIAP-CV-Fabrice-NASCIEMENTO-2023.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-10-10 16:26:24', '2023-10-10 16:26:24'),
(151, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:94:\"/home/xdrvhgi/www/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/LM-Fabrice-N-SSIAP-1.pdf\";s:3:\"url\";s:102:\"https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/LM-Fabrice-N-SSIAP-1.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-10-10 16:26:24', '2023-10-10 16:26:24'),
(152, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6525a8a54a4bf\";}', 0, NULL, '2023-10-10 19:50:21', '2023-10-10 19:40:21'),
(153, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6527d98ae1442\";}', 0, NULL, '2023-10-12 11:43:30', '2023-10-12 11:33:30'),
(154, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6527e90e36bc7\";}', 0, NULL, '2023-10-12 12:49:42', '2023-10-12 12:39:42'),
(155, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_652829be61a86\";}', 0, NULL, '2023-10-12 17:25:42', '2023-10-12 17:15:42'),
(156, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_652a707f15545\";}', 0, NULL, '2023-10-14 10:52:07', '2023-10-14 10:42:07'),
(157, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_652a707f15545\";}', 0, NULL, '2023-10-14 10:52:08', '2023-10-14 10:42:08'),
(158, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_652b2845070f1\";}', 0, NULL, '2023-10-14 23:56:13', '2023-10-14 23:46:13'),
(159, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:82:\"/home/xdrvhgi/www/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-PHOTO.pdf\";s:3:\"url\";s:90:\"https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-PHOTO.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-10-16 10:49:06', '2023-10-16 10:49:06'),
(160, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_652d1522d889e\";}', 0, NULL, '2023-10-16 10:59:06', '2023-10-16 10:49:06'),
(161, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:84:\"/home/xdrvhgi/www/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-PHOTO-1.pdf\";s:3:\"url\";s:92:\"https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-PHOTO-1.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-10-16 10:50:40', '2023-10-16 10:50:40'),
(162, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:89:\"/home/xdrvhgi/www/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/ARTUS-securite-.pdf\";s:3:\"url\";s:97:\"https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/ARTUS-securite-.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-10-16 10:50:40', '2023-10-16 10:50:40'),
(163, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_652d23a0888db\";}', 0, NULL, '2023-10-16 12:00:56', '2023-10-16 11:50:56'),
(164, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_652f7874eb56d\";}', 0, NULL, '2023-10-18 06:27:24', '2023-10-18 06:17:24'),
(165, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_652fea031de11\";}', 0, NULL, '2023-10-18 14:31:55', '2023-10-18 14:21:55'),
(166, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6530245f847df\";}', 0, NULL, '2023-10-18 18:40:55', '2023-10-18 18:30:55'),
(167, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6530809861558\";}', 0, NULL, '2023-10-19 01:14:24', '2023-10-19 01:04:24'),
(168, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_65311df4641a6\";}', 0, NULL, '2023-10-19 12:25:48', '2023-10-19 12:15:48'),
(169, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6532e0a12edbb\";}', 0, NULL, '2023-10-20 20:28:41', '2023-10-20 20:18:41'),
(170, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:99:\"/home/xdrvhgi/www/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-Florian-1.docx-update1.pdf\";s:3:\"url\";s:107:\"https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-Florian-1.docx-update1.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-10-24 20:40:26', '2023-10-24 20:40:26'),
(171, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_65382bbaa3133\";}', 0, NULL, '2023-10-24 20:50:26', '2023-10-24 20:40:26'),
(172, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_65382dbe9c92b\";}', 0, NULL, '2023-10-24 20:59:02', '2023-10-24 20:49:02'),
(173, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:101:\"/home/xdrvhgi/www/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-Florian-1.docx-update1-1.pdf\";s:3:\"url\";s:109:\"https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV-Florian-1.docx-update1-1.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-10-24 21:14:20', '2023-10-24 21:14:20'),
(174, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:84:\"/home/xdrvhgi/www/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/LM_Copie-1.pdf\";s:3:\"url\";s:92:\"https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/LM_Copie-1.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-10-24 21:14:20', '2023-10-24 21:14:20'),
(175, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6538ac9bad434\";}', 0, NULL, '2023-10-25 06:00:19', '2023-10-25 05:50:19'),
(176, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6539620675577\";}', 0, NULL, '2023-10-25 18:54:22', '2023-10-25 18:44:22'),
(177, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6539780bcfa1e\";}', 0, NULL, '2023-10-25 20:28:19', '2023-10-25 20:18:19'),
(178, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6539eb0fc89a2\";}', 0, NULL, '2023-10-26 04:39:03', '2023-10-26 04:29:03'),
(179, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_653a70aa1698d\";}', 0, NULL, '2023-10-26 14:09:06', '2023-10-26 13:59:06'),
(180, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_653ae6934feb0\";}', 0, NULL, '2023-10-26 22:32:11', '2023-10-26 22:22:11'),
(181, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_653b098c92e4a\";}', 0, NULL, '2023-10-27 01:01:24', '2023-10-27 00:51:24'),
(182, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_653b622ea1a7a\";}', 0, NULL, '2023-10-27 07:19:34', '2023-10-27 07:09:34'),
(183, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_653f6024b826b\";}', 0, NULL, '2023-10-30 07:59:56', '2023-10-30 07:49:56'),
(184, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_653f8392798df\";}', 0, NULL, '2023-10-30 10:31:06', '2023-10-30 10:21:06'),
(185, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6542183586898\";}', 0, NULL, '2023-11-01 09:29:49', '2023-11-01 09:19:49'),
(186, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_65461cbe756fb\";}', 0, NULL, '2023-11-04 10:38:14', '2023-11-04 10:28:14'),
(187, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6546295791b32\";}', 0, NULL, '2023-11-04 11:31:59', '2023-11-04 11:21:59'),
(188, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_654aba5265d44\";}', 0, NULL, '2023-11-07 22:39:38', '2023-11-07 22:29:38'),
(189, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_654ad81de3223\";}', 0, NULL, '2023-11-08 00:46:45', '2023-11-08 00:36:45'),
(190, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_654d8229804d5\";}', 0, NULL, '2023-11-10 01:16:49', '2023-11-10 01:06:49'),
(191, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_654da792087cb\";}', 0, NULL, '2023-11-10 03:56:26', '2023-11-10 03:46:26'),
(192, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_654ddbcb4ff5e\";}', 0, NULL, '2023-11-10 07:39:15', '2023-11-10 07:29:15'),
(193, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_654df62d0d4d8\";}', 0, NULL, '2023-11-10 09:31:49', '2023-11-10 09:21:49'),
(194, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_654df630813ce\";}', 0, NULL, '2023-11-10 09:31:52', '2023-11-10 09:21:52'),
(195, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_655040205dde8\";}', 0, NULL, '2023-11-12 03:11:52', '2023-11-12 03:01:52'),
(196, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6550d7a31988f\";}', 0, NULL, '2023-11-12 13:58:19', '2023-11-12 13:48:19'),
(197, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_655212bb800ca\";}', 0, NULL, '2023-11-13 12:22:43', '2023-11-13 12:12:43'),
(198, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6555faf4c5aa0\";}', 0, NULL, '2023-11-16 11:30:20', '2023-11-16 11:20:20'),
(199, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6557530736f25\";}', 0, NULL, '2023-11-17 11:58:23', '2023-11-17 11:48:23'),
(200, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_655aa5a1d28c0\";}', 0, NULL, '2023-11-20 00:27:37', '2023-11-20 00:17:37'),
(201, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_655dc59582915\";}', 0, NULL, '2023-11-22 09:20:45', '2023-11-22 09:10:45'),
(202, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_655dc59b3f3d5\";}', 0, NULL, '2023-11-22 09:20:51', '2023-11-22 09:10:51'),
(203, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_655dc635b7dea\";}', 0, NULL, '2023-11-22 09:23:25', '2023-11-22 09:13:25'),
(204, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6560f97ac78c5\";}', 0, NULL, '2023-11-24 19:38:58', '2023-11-24 19:28:58'),
(205, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_65615b89083cd\";}', 0, NULL, '2023-11-25 02:37:21', '2023-11-25 02:27:21'),
(206, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_65648da8d60c6\";}', 0, NULL, '2023-11-27 12:48:00', '2023-11-27 12:38:00'),
(207, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6564a3b73a5ec\";}', 0, NULL, '2023-11-27 14:22:07', '2023-11-27 14:12:07'),
(208, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6564fba5a73d6\";}', 0, NULL, '2023-11-27 20:37:17', '2023-11-27 20:27:17'),
(209, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6565432e33197\";}', 0, NULL, '2023-11-28 01:42:30', '2023-11-28 01:32:30'),
(210, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:90:\"/home/xdrvhgi/www/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV_NOVEMBRE_2023.pdf\";s:3:\"url\";s:98:\"https://artus-securite.fr/wp-content/uploads/1bb266c370c6cd8d598883f7bdc0233e/CV_NOVEMBRE_2023.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-12-01 08:35:28', '2023-12-01 08:35:28'),
(211, 'O:45:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteFileJob\":1:{s:7:\"\0*\0path\";a:3:{s:4:\"file\";s:90:\"/home/xdrvhgi/www/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/CV_NOVEMBRE_2023.pdf\";s:3:\"url\";s:98:\"https://artus-securite.fr/wp-content/uploads/be0f76e968ac1815073d23dd12745e25/CV_NOVEMBRE_2023.pdf\";s:4:\"type\";s:15:\"application/pdf\";}}', 0, NULL, '2023-12-01 08:35:28', '2023-12-01 08:35:28'),
(212, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6569a6a36cea3\";}', 0, NULL, '2023-12-01 09:35:55', '2023-12-01 09:25:55'),
(213, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_656cc5518c275\";}', 0, NULL, '2023-12-03 18:23:37', '2023-12-03 18:13:37'),
(214, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_656e1eddf1a2a\";}', 0, NULL, '2023-12-04 18:57:57', '2023-12-04 18:47:57'),
(215, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_656f39cdb6e34\";}', 0, NULL, '2023-12-05 15:05:09', '2023-12-05 14:55:09'),
(216, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_65739d5b395a0\";}', 0, NULL, '2023-12-08 22:58:59', '2023-12-08 22:48:59'),
(217, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_65739d61e60e2\";}', 0, NULL, '2023-12-08 22:59:05', '2023-12-08 22:49:05'),
(218, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_6574716d6961f\";}', 0, NULL, '2023-12-09 14:03:49', '2023-12-09 13:53:49'),
(219, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_657553326aaaa\";}', 0, NULL, '2023-12-10 06:07:06', '2023-12-10 05:57:06'),
(220, 'O:50:\"calderawp\\calderaforms\\cf2\\Jobs\\DeleteTransientJob\":1:{s:14:\"\0*\0transientId\";s:25:\"_cf_process_65781fb60c1ff\";}', 0, NULL, '2023-12-12 09:04:14', '2023-12-12 08:54:14');
/*!40000 ALTER TABLE `mod284_cf_queue_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_cmplz_cookiebanners`
--

DROP TABLE IF EXISTS `mod284_cmplz_cookiebanners`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_cmplz_cookiebanners` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `banner_version` int(11) NOT NULL,
  `default` int(11) NOT NULL,
  `archived` int(11) NOT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `position` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `theme` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `checkbox_style` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `revoke` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `header` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `dismiss` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `save_preferences` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `view_preferences` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `accept_all` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_functional` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_all` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_stats` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_prefs` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `accept` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message_optin` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `readmore_optin` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `use_categories` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tagmanager_categories` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `use_categories_optinstats` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hide_revoke` int(11) NOT NULL,
  `disable_cookiebanner` int(11) NOT NULL,
  `banner_width` int(11) NOT NULL,
  `soft_cookiewall` int(11) NOT NULL,
  `dismiss_on_scroll` int(11) NOT NULL,
  `dismiss_on_timeout` int(11) NOT NULL,
  `dismiss_timeout` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `accept_informational` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message_optout` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `readmore_optout` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `readmore_optout_dnsmpi` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `readmore_privacy` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `readmore_impressum` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `use_custom_cookie_css` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `custom_css` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `statistics` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_background` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_toggles` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_border_radius` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `border_width` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_button_accept` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_button_deny` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `colorpalette_button_settings` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `buttons_border_radius` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `animation` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `use_box_shadow` int(11) NOT NULL,
  `hide_preview` int(11) NOT NULL,
  `use_logo` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `logo_attachment_id` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `close_button` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `manage_consent_options` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `functional_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `statistics_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `statistics_text_anonymous` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `preferences_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `marketing_text` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `font_size` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `header_footer_shadow` int(11) NOT NULL,
  `disable_width_correction` int(11) NOT NULL,
  `legal_documents` int(11) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_cmplz_cookiebanners`
--

LOCK TABLES `mod284_cmplz_cookiebanners` WRITE;
/*!40000 ALTER TABLE `mod284_cmplz_cookiebanners` DISABLE KEYS */;
INSERT INTO `mod284_cmplz_cookiebanners` (`ID`, `banner_version`, `default`, `archived`, `title`, `position`, `theme`, `checkbox_style`, `revoke`, `header`, `dismiss`, `save_preferences`, `view_preferences`, `accept_all`, `category_functional`, `category_all`, `category_stats`, `category_prefs`, `accept`, `message_optin`, `readmore_optin`, `use_categories`, `tagmanager_categories`, `use_categories_optinstats`, `hide_revoke`, `disable_cookiebanner`, `banner_width`, `soft_cookiewall`, `dismiss_on_scroll`, `dismiss_on_timeout`, `dismiss_timeout`, `accept_informational`, `message_optout`, `readmore_optout`, `readmore_optout_dnsmpi`, `readmore_privacy`, `readmore_impressum`, `use_custom_cookie_css`, `custom_css`, `statistics`, `colorpalette_background`, `colorpalette_text`, `colorpalette_toggles`, `colorpalette_border_radius`, `border_width`, `colorpalette_button_accept`, `colorpalette_button_deny`, `colorpalette_button_settings`, `buttons_border_radius`, `animation`, `use_box_shadow`, `hide_preview`, `use_logo`, `logo_attachment_id`, `close_button`, `manage_consent_options`, `functional_text`, `statistics_text`, `statistics_text_anonymous`, `preferences_text`, `marketing_text`, `font_size`, `header_footer_shadow`, `disable_width_correction`, `legal_documents`) VALUES 
(1, 21, 1, 0, 'bottom-right minimal', 'bottom-right', 'minimal', 'slider', 'Gérer le consentement', 'a:2:{s:4:\"text\";s:34:\"Gérer le consentement aux cookies\";s:4:\"show\";i:0;}', 'a:2:{s:4:\"text\";s:7:\"Refuser\";s:4:\"show\";i:1;}', 'Enregistrer les préférences', 'Préférences', 'Tout accepter', 'Fonctionnel', 'a:2:{s:4:\"text\";s:9:\"Marketing\";s:4:\"show\";i:1;}', 'a:2:{s:4:\"text\";s:12:\"Statistiques\";s:4:\"show\";i:1;}', 'a:2:{s:4:\"text\";s:13:\"Préférences\";s:4:\"show\";i:1;}', 'Accepter', 'Notre site et ceux de nos partenaires utilisent des cookies afin de mesurer l’audience et la performance, pour vous proposer des contenus ainsi que des offres et des servies adaptés à vos attentes.', 'En savoir plus', 'view-preferences', '', 'visible', 0, 0, 320, 0, 0, 0, '10', 'a:2:{s:4:\"text\";s:8:\"Accepter\";s:4:\"show\";i:1;}', 'Nous utilisons des cookies pour optimiser notre site web et notre service.', 'Cookie Policy', 'Do Not Sell My Personal Information', 'Déclaration de confidentialité', 'Impressum', '0', '/* Container */\n.cmplz-cookiebanner{}\n\n/* Logo */\n.cmplz-cookiebanner .cmplz-logo{}\n/* Title */\n.cmplz-cookiebanner .cmplz-title{}\n/* Close icon */\n.cmplz-cookiebanner .cmplz-close{}\n\n/* Message */\n.cmplz-cookiebanner .cmplz-message{}\n\n /* All buttons */\n.cmplz-buttons .cmplz-btn{}\n/* Accept button */\n.cmplz-btn .cmplz-accept{} \n /* Deny button */\n.cmplz-btn .cmplz-deny{}\n /* Save preferences button */\n.cmplz-btn .cmplz-deny{}\n /* View preferences button */\n.cmplz-btn .cmplz-deny{}\n\n /* Document hyperlinks */\n.cmplz-links .cmplz-documents{}\n\n /* Categories */\n.cmplz-cookiebanner .cmplz-category{}\n.cmplz-cookiebanner .cmplz-category-title{} \n\n/* Manage consent tab */\n#cmplz-manage-consent .cmplz-manage-consent{} \n\n/* Soft cookie wall */\n.cmplz-soft-cookiewall{}\n\n/* Placeholder button - Per category */\n.cmplz-blocked-content-container .cmplz-blocked-content-notice{}\n\n/* Placeholder button & message - Per service */\n.cmplz-blocked-content-container .cmplz-blocked-content-notice,\n.cmplz-blocked-content-notice{}\nbutton.cmplz-accept-service{}\n\n/* Styles for the AMP notice */\n#cmplz-consent-ui, #cmplz-post-consent-ui {}\n/* Message */\n#cmplz-consent-ui .cmplz-consent-message {}\n/* Buttons */\n#cmplz-consent-ui button, #cmplz-post-consent-ui button {}', 'a:0:{}', 'a:2:{s:5:\"color\";s:7:\"#f9f9f9\";s:6:\"border\";s:7:\"#f9f9f9\";}', 'a:2:{s:5:\"color\";s:7:\"#191e23\";s:9:\"hyperlink\";s:7:\"#191e23\";}', 'a:3:{s:10:\"background\";s:7:\"#003d7c\";s:6:\"bullet\";s:7:\"#ffffff\";s:8:\"inactive\";s:7:\"#c6c6c6\";}', 'a:5:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;s:4:\"type\";s:2:\"px\";}', 'a:4:{s:3:\"top\";i:0;s:5:\"right\";i:0;s:6:\"bottom\";i:0;s:4:\"left\";i:0;}', 'a:3:{s:10:\"background\";s:7:\"#003d7c\";s:6:\"border\";s:7:\"#003d7c\";s:4:\"text\";s:7:\"#ffffff\";}', 'a:3:{s:10:\"background\";s:7:\"#f1f1f1\";s:6:\"border\";s:7:\"#f1f1f1\";s:4:\"text\";s:7:\"#003d7c\";}', 'a:3:{s:10:\"background\";s:7:\"#f1f1f1\";s:6:\"border\";s:7:\"#003d7c\";s:4:\"text\";s:7:\"#003d7c\";}', 'a:5:{s:3:\"top\";i:5;s:5:\"right\";i:5;s:6:\"bottom\";i:5;s:4:\"left\";i:5;s:4:\"type\";s:2:\"px\";}', 'fade', 1, 0, 'hide', '0', '0', 'hover-hide-mobile', 'a:2:{s:4:\"text\";s:341:\"Le stockage ou l’accès technique est strictement nécessaire dans la finalité d’intérêt légitime de permettre l’utilisation d’un service spécifique explicitement demandé par l’abonné ou l’utilisateur, ou dans le seul but d’effectuer la transmission d’une communication sur un réseau de communications électroniques.\";s:4:\"show\";i:1;}', 'a:2:{s:4:\"text\";s:92:\"Le stockage ou l’accès technique qui est utilisé exclusivement à des fins statistiques.\";s:4:\"show\";i:1;}', 'a:2:{s:4:\"text\";s:448:\"Le stockage ou l’accès technique qui est utilisé exclusivement dans des finalités statistiques anonymes. En l’absence d’une assignation à comparaître, d’une conformité volontaire de la part de votre fournisseur d’accès à internet ou d’enregistrements supplémentaires provenant d’une tierce partie, les informations stockées ou extraites à cette seule fin ne peuvent généralement pas être utilisées pour vous identifier.\";s:4:\"show\";i:1;}', 'a:2:{s:4:\"text\";s:185:\"Le stockage ou l’accès technique est nécessaire dans la finalité d’intérêt légitime de stocker des préférences qui ne sont pas demandées par l’abonné ou l’utilisateur.\";s:4:\"show\";i:1;}', 'a:2:{s:4:\"text\";s:243:\"Le stockage ou l’accès technique est nécessaire pour créer des profils d’utilisateurs afin d’envoyer des publicités, ou pour suivre l’utilisateur sur un site web ou sur plusieurs sites web ayant des finalités marketing similaires.\";s:4:\"show\";i:1;}', '12', 0, 0, 1);
/*!40000 ALTER TABLE `mod284_cmplz_cookiebanners` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_cmplz_cookies`
--

DROP TABLE IF EXISTS `mod284_cmplz_cookies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_cmplz_cookies` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slug` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `sync` int(11) NOT NULL,
  `ignored` int(11) NOT NULL,
  `retention` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `serviceID` int(11) NOT NULL,
  `cookieFunction` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `collectedPersonalData` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `purpose` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `language` varchar(6) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `isTranslationFrom` int(11) NOT NULL,
  `isPersonalData` int(11) NOT NULL,
  `deleted` int(11) NOT NULL,
  `isMembersOnly` int(11) NOT NULL,
  `showOnPolicy` int(11) NOT NULL,
  `lastUpdatedDate` int(11) NOT NULL,
  `lastAddDate` int(11) NOT NULL,
  `firstAddDate` int(11) NOT NULL,
  `isOwnDomainCookie` int(11) NOT NULL,
  `domain` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=97 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_cmplz_cookies`
--

LOCK TABLES `mod284_cmplz_cookies` WRITE;
/*!40000 ALTER TABLE `mod284_cmplz_cookies` DISABLE KEYS */;
INSERT INTO `mod284_cmplz_cookies` (`ID`, `name`, `slug`, `sync`, `ignored`, `retention`, `type`, `serviceID`, `cookieFunction`, `collectedPersonalData`, `purpose`, `language`, `isTranslationFrom`, `isPersonalData`, `deleted`, `isMembersOnly`, `showOnPolicy`, `lastUpdatedDate`, `lastAddDate`, `firstAddDate`, `isOwnDomainCookie`, `domain`) VALUES 
(1, 'wp-api-schema-model*', 'wp-api-schema-model-2', 1, 0, 'session', 'localstorage', 9, '', '', 'Functional', 'en', 0, 0, 0, 1, 1, 1625479210, 1669301568, 1625478924, 1, ''),
(2, 'wp-api-schema-model*', 'wp-api-schema-model-2', 1, 0, 'session', '', 10, '', '', 'Fonctionnel', 'fr', 1, 0, 0, 1, 1, 1625479210, 1669301568, 1625478924, 1, ''),
(3, '_gid', '_gid', 1, 0, '1 day', 'cookie', 1, 'store and count pageviews', '', 'Statistics', 'en', 0, 1, 0, 0, 1, 1625479210, 1699867929, 1625478924, 1, 'self'),
(4, '_gid', '_gid', 1, 0, '1 jour', '', 2, 'Compter et suivre les pages visitées', '', 'Statistiques', 'fr', 3, 1, 0, 0, 1, 1625479210, 1699867929, 1625478924, 1, 'self'),
(5, 'wordpress_test_cookie', 'wordpress_test_cookie', 1, 0, 'session', 'cookie', 9, 'read if cookies can be placed', '', 'Functional', 'en', 0, 0, 0, 1, 1, 1625479210, 1699867929, 1625478924, 1, 'self'),
(6, 'wordpress_test_cookie', 'wordpress_test_cookie', 1, 0, 'session', '', 10, 'Vérifier si des cookies peuvent être déposés', '', 'Fonctionnel', 'fr', 5, 0, 0, 1, 1, 1625479210, 1699867929, 1625478924, 1, 'self'),
(7, 'wp-settings-2', '', 1, 0, '', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1699867929, 1625478924, 1, 'self'),
(8, 'wp-settings-2', '', 1, 0, '', '', 0, '', '', '', 'fr', 7, 0, 0, 0, 1, 0, 1699867929, 1625478924, 1, 'self'),
(9, 'wp-settings-time-2', '', 1, 0, '', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1699867929, 1625478924, 1, 'self'),
(10, 'wp-settings-time-2', '', 1, 0, '', '', 0, '', '', '', 'fr', 9, 0, 0, 0, 1, 0, 1699867929, 1625478924, 1, 'self'),
(11, 'mp_a36067b00a263cce0299cfd960e26ecf_mixpanel', '', 1, 0, '', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1646754894, 1625478924, 1, ''),
(12, 'mp_a36067b00a263cce0299cfd960e26ecf_mixpanel', '', 1, 0, '', '', 0, '', '', '', 'fr', 11, 0, 0, 0, 1, 0, 1646754894, 1625478924, 1, ''),
(13, '_ga_*', '_ga_', 1, 0, '1 year', 'cookie', 1, 'store and count pageviews', '', 'Statistics', 'en', 0, 0, 0, 0, 1, 1625479210, 1699867929, 1625478924, 1, 'self'),
(14, '_ga_*', '_ga_', 1, 0, '1 an', '', 2, 'Compter et suivre les pages visitées', '', 'Statistiques', 'fr', 13, 0, 0, 0, 1, 1625479210, 1699867929, 1625478924, 1, 'self'),
(15, '_ga', '_ga', 1, 0, '2 years', 'cookie', 1, 'store and count pageviews', '', 'Statistics', 'en', 0, 0, 0, 0, 1, 1625479210, 1699867929, 1625478924, 1, 'self'),
(16, '_ga', '_ga', 1, 0, '2 ans', '', 2, 'Compter et suivre les pages visitées', '', 'Statistiques', 'fr', 15, 0, 0, 0, 1, 1625479210, 1699867929, 1625478924, 1, 'self'),
(17, 'wordpress_*', 'wordpress_', 1, 1, '3 months', 'cookie', 9, '', 'none', 'Functional', 'en', 0, 0, 0, 0, 1, 1625479210, 1669301568, 1625478924, 1, ''),
(18, 'wordpress_*', 'wordpress_', 1, 1, '3 mois', '', 10, '', 'aucune', 'Fonctionnel', 'fr', 17, 0, 0, 0, 1, 1625479210, 1669301568, 1625478924, 1, ''),
(19, 'wordpress_logged_in_*', 'wordpress_logged_in_0fccad09e111918db6363377b39bc8af', 1, 0, 'session', 'cookie', 9, 'Store logged in users', '', 'Functional', 'en', 0, 0, 0, 0, 1, 1625479210, 1699867929, 1625478924, 1, 'self'),
(20, 'wordpress_logged_in_*', 'wordpress_logged_in_0fccad09e111918db6363377b39bc8af', 1, 0, 'session', '', 10, 'Garder les utilisateurs connectés', '', 'Fonctionnel', 'fr', 19, 0, 0, 0, 1, 1625479210, 1699867929, 1625478924, 1, 'self'),
(21, '_gat_gtag_UA_*', '_gat_gtag_ua_-2', 1, 0, '1 minute', 'cookie', 1, 'store a unique user ID', 'user ID', 'Statistics', 'en', 0, 1, 0, 0, 1, 1625479210, 1699867929, 1625478932, 1, 'self'),
(22, '_gat_gtag_UA_*', '_gat_gtag_ua_-2', 1, 0, '1 minute', '', 2, 'Stocker un ID utilisateur unique', 'ID utilisateur', 'Statistiques', 'fr', 21, 1, 0, 0, 1, 1625479210, 1699867929, 1625478932, 1, 'self'),
(23, 'Google Fonts API', 'tcb_google_fonts', 1, 0, 'expires immediately', 'API', 3, 'read user IP address', 'IP address', 'Marketing/Tracking', 'en', 0, 1, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(24, 'Google Fonts API', 'tcb_google_fonts', 1, 0, 'aucune', '', 4, 'Demander l’adresse IP de l’utilisateur', 'adresse IP', 'Marketing/Suivi', 'fr', 23, 1, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(25, 'Google Maps API', 'google-maps-api', 1, 0, 'expires immediately', '', 5, 'read user IP address', 'IP address', 'Marketing/Tracking', 'en', 0, 1, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(26, 'Google Maps API', 'google-maps-api', 1, 0, 'aucune', '', 6, 'Demander l’adresse IP de l’utilisateur', 'adresse IP', 'Marketing/Suivi', 'fr', 25, 1, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(27, 'bcookie', 'bcookie-2', 1, 0, '2 years', '', 7, 'store browser details', '', 'Marketing/Tracking', 'en', 0, 0, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(28, 'bcookie', 'bcookie-2', 1, 0, '2 ans', '', 8, 'Stocker les informations du navigateur', '', 'Marketing/Suivi', 'fr', 27, 0, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(29, 'li-oatml', 'li-oatml', 1, 0, '1 month', 'Cookie', 7, 'provide ad delivery or retargeting', '', 'Marketing/Tracking', 'en', 0, 0, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(30, 'li-oatml', 'li-oatml', 1, 0, '1 mois', '', 8, 'Activer la diffusion ou le reciblage des publicités', '', 'Marketing/Suivi', 'fr', 29, 0, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(31, 'BizographicsOptOut', 'bizographicsoptout', 1, 0, '10 years', '', 7, 'store privacy preferences', '', 'Functional', 'en', 0, 0, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(32, 'BizographicsOptOut', 'bizographicsoptout', 1, 0, '10 ans', '', 8, 'Stocker les préférences de confidentialité', '', 'Fonctionnel', 'fr', 31, 0, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(33, 'li_sugr', 'li_sugr', 1, 0, '3 months', '', 7, 'store browser details', '', 'Marketing/Tracking', 'en', 0, 0, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(34, 'li_sugr', 'li_sugr', 1, 0, '3 mois', '', 8, 'Stocker les informations du navigateur', '', 'Marketing/Suivi', 'fr', 33, 0, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(35, 'UserMatchHistory', 'usermatchhistory', 1, 0, '30 days', '', 7, 'provide ad delivery or retargeting', '', 'Marketing/Tracking', 'en', 0, 0, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(36, 'UserMatchHistory', 'usermatchhistory', 1, 0, '30 jours', '', 8, 'Activer la diffusion ou le reciblage des publicités', '', 'Marketing/Suivi', 'fr', 35, 0, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(37, 'linkedin_oauth_', 'linkedin_oauth_', 1, 0, 'session', 'Cookie', 7, 'provide functions across pages', '', 'Functional', 'en', 0, 0, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(38, 'linkedin_oauth_', 'linkedin_oauth_', 1, 0, 'session', '', 8, 'Fournir des fonctions sur toutes les pages', '', 'Fonctionnel', 'fr', 37, 0, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(39, 'lidc', 'lidc', 1, 0, '1 day', '', 7, 'store performed actions on the website', '', 'Marketing/Tracking', 'en', 0, 0, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(40, 'lidc', 'lidc', 1, 0, '1 jour', '', 8, 'Stocker les actions effectuées par les utilisateurs sur le site web', '', 'Marketing/Suivi', 'fr', 39, 0, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(41, 'bscookie', 'bscookie', 1, 0, '2 years', '', 7, 'store performed actions on the website', '', 'Marketing/Tracking', 'en', 0, 0, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(42, 'bscookie', 'bscookie', 1, 0, '2 ans', '', 8, 'Stocker les actions effectuées par les utilisateurs sur le site web', '', 'Marketing/Suivi', 'fr', 41, 0, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(43, 'X-LI-IDC', 'x-li-idc', 1, 0, 'session', '', 7, 'provide functions across pages', 'social media account details', 'Marketing/Tracking', 'en', 0, 0, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(44, 'X-LI-IDC', 'x-li-idc', 1, 0, 'session', '', 8, 'Fournir des fonctions sur toutes les pages', 'coordonnées des comptes de réseaux sociaux', 'Marketing/Suivi', 'fr', 43, 0, 0, 0, 1, 1625479220, 1625479214, 1625479214, 0, ''),
(45, 'lfwexobse67kgfogflay1640096660819', '', 1, 0, '', 'localstorage', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1640096665, 1640096665, 0, ''),
(46, 'lfwexobse67kgfogflay1640096660819', '', 1, 0, '', '', 0, '', '', '', 'fr', 45, 0, 0, 0, 1, 0, 1640096665, 1640096665, 0, ''),
(47, 'lfwexobse67kgfogflayctry1640096460074', '', 1, 0, '', 'localstorage', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1640096665, 1640096665, 0, ''),
(48, 'lfwexobse67kgfogflayctry1640096460074', '', 1, 0, '', '', 0, '', '', '', 'fr', 47, 0, 0, 0, 1, 0, 1640096665, 1640096665, 0, ''),
(49, 'cmplz_policy_id', '', 1, 0, '365 jours', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1699867928, 1640096665, 1, 'self'),
(50, 'cmplz_policy_id', '', 1, 0, '365 jours', '', 0, '', '', '', 'fr', 49, 0, 0, 0, 1, 0, 1699867928, 1640096665, 1, 'self'),
(51, 'cmplz_functional', '', 1, 0, '365 jours', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1699867929, 1640096665, 1, 'self'),
(52, 'cmplz_functional', '', 1, 0, '365 jours', '', 0, '', '', '', 'fr', 51, 0, 0, 0, 1, 0, 1699867929, 1640096665, 1, 'self'),
(53, 'cmplz_statistics-anonymous', '', 1, 0, '365 jours', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1686815507, 1640096665, 1, ''),
(54, 'cmplz_statistics-anonymous', '', 1, 0, '365 jours', '', 0, '', '', '', 'fr', 53, 0, 0, 0, 1, 0, 1686815507, 1640096665, 1, ''),
(55, 'lfwexobse67kgfogflayctry1646754642630', '', 1, 0, '', 'localstorage', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1646754893, 1646754729, 1, ''),
(56, 'lfwexobse67kgfogflayctry1646754642630', '', 1, 0, '', '', 0, '', '', '', 'fr', 55, 0, 0, 0, 1, 0, 1646754893, 1646754729, 1, ''),
(57, 'lfwexobse67kgfogflay1646754726065', '', 1, 0, '', 'localstorage', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1646754729, 1646754729, 1, ''),
(58, 'lfwexobse67kgfogflay1646754726065', '', 1, 0, '', '', 0, '', '', '', 'fr', 57, 0, 0, 0, 1, 0, 1646754729, 1646754729, 0, ''),
(59, 'cmplz_choice', '', 1, 0, '365 jours', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1686815507, 1646754729, 1, ''),
(60, 'cmplz_choice', '', 1, 0, '365 jours', '', 0, '', '', '', 'fr', 59, 0, 0, 0, 1, 0, 1686815507, 1646754729, 1, ''),
(61, 'lfwexobse67kgfogflay1646754747906', '', 1, 0, '', 'localstorage', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1646754751, 1646754751, 1, ''),
(62, 'lfwexobse67kgfogflay1646754747906', '', 1, 0, '', '', 0, '', '', '', 'fr', 61, 0, 0, 0, 1, 0, 1646754751, 1646754751, 0, ''),
(63, 'lfwexobse67kgfogflay1646754769228', '', 1, 0, '', 'localstorage', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1646754773, 1646754773, 1, ''),
(64, 'lfwexobse67kgfogflay1646754769228', '', 1, 0, '', '', 0, '', '', '', 'fr', 63, 0, 0, 0, 1, 0, 1646754773, 1646754773, 0, ''),
(65, 'lfwexobse67kgfogflay1646754779142', '', 1, 0, '', 'localstorage', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1646754786, 1646754786, 1, ''),
(66, 'lfwexobse67kgfogflay1646754779142', '', 1, 0, '', '', 0, '', '', '', 'fr', 65, 0, 0, 0, 1, 0, 1646754786, 1646754786, 0, ''),
(67, 'lfwexobse67kgfogflay1646754891396', '', 1, 0, '', 'localstorage', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1646754894, 1646754894, 1, ''),
(68, 'lfwexobse67kgfogflay1646754891396', '', 1, 0, '', '', 0, '', '', '', 'fr', 67, 0, 0, 0, 1, 0, 1646754894, 1646754894, 0, ''),
(69, '_pk_id.1.0a0a', '', 1, 0, '', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1699867928, 1660893025, 1, 'self'),
(70, '_pk_id.1.0a0a', '', 1, 0, '', '', 0, '', '', '', 'fr', 69, 0, 0, 0, 1, 0, 1699867928, 1660893025, 1, 'self'),
(71, 'cmplz_consent_status', '', 1, 0, '365 jours', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1686815507, 1660893025, 1, ''),
(72, 'cmplz_consent_status', '', 1, 0, '365 jours', '', 0, '', '', '', 'fr', 71, 0, 0, 0, 1, 0, 1686815507, 1660893025, 1, ''),
(73, 'cmplz_marketing', '', 1, 0, '365 jours', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1699867928, 1660893025, 1, 'self'),
(74, 'cmplz_marketing', '', 1, 0, '365 jours', '', 0, '', '', '', 'fr', 73, 0, 0, 0, 1, 0, 1699867928, 1660893025, 1, 'self'),
(75, 'cmplz_statistics', '', 1, 0, '365 jours', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1699867928, 1660893025, 1, 'self'),
(76, 'cmplz_statistics', '', 1, 0, '365 jours', '', 0, '', '', '', 'fr', 75, 0, 0, 0, 1, 0, 1699867928, 1660893025, 1, 'self'),
(77, '_pk_ref.1.0a0a', '', 1, 0, '', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1699867928, 1660893025, 1, 'self'),
(78, '_pk_ref.1.0a0a', '', 1, 0, '', '', 0, '', '', '', 'fr', 77, 0, 0, 0, 1, 0, 1699867928, 1660893025, 1, 'self'),
(79, '_pk_ses.1.0a0a', '', 1, 0, '', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1699867928, 1660893025, 1, 'self'),
(80, '_pk_ses.1.0a0a', '', 1, 0, '', '', 0, '', '', '', 'fr', 79, 0, 0, 0, 1, 0, 1699867928, 1660893025, 1, 'self'),
(81, '_pk_id_1_0a0a', '', 1, 0, '', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1699867929, 1660893025, 1, 'self'),
(82, '_pk_id_1_0a0a', '', 1, 0, '', '', 0, '', '', '', 'fr', 81, 0, 0, 0, 1, 0, 1699867929, 1660893025, 1, 'self'),
(83, '_pk_ref_1_0a0a', '', 1, 0, '', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1699867929, 1660893025, 1, 'self'),
(84, '_pk_ref_1_0a0a', '', 1, 0, '', '', 0, '', '', '', 'fr', 83, 0, 0, 0, 1, 0, 1699867929, 1660893025, 1, 'self'),
(85, '_pk_ses_1_0a0a', '', 1, 0, '', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1699867929, 1660893025, 1, 'self'),
(86, '_pk_ses_1_0a0a', '', 1, 0, '', '', 0, '', '', '', 'fr', 85, 0, 0, 0, 1, 0, 1699867929, 1660893025, 1, 'self'),
(87, 'cmplz_preferences', '', 1, 0, '365 jours', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1699867929, 1661503965, 1, 'self'),
(88, 'cmplz_preferences', '', 1, 0, '365 jours', '', 0, '', '', '', 'fr', 87, 0, 0, 0, 1, 0, 1699867929, 1661503965, 1, 'self'),
(89, 'cmplz_consented_services', '', 1, 0, '365 jours', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1699867928, 1675092913, 1, 'self'),
(90, 'cmplz_consented_services', '', 1, 0, '365 jours', '', 0, '', '', '', 'fr', 89, 0, 0, 0, 1, 0, 1699867928, 1675092913, 1, 'self'),
(91, 'cmplz_banner-status', '', 1, 0, '365 jours', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1699867929, 1675092913, 1, 'self'),
(92, 'cmplz_banner-status', '', 1, 0, '365 jours', '', 0, '', '', '', 'fr', 91, 0, 0, 0, 1, 0, 1699867929, 1675092913, 1, 'self'),
(93, 'et-editor-available-post-49507-fb', '', 1, 0, '', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1675093103, 1675093040, 1, ''),
(94, 'et-editor-available-post-49507-fb', '', 1, 0, '', '', 0, '', '', '', 'fr', 93, 0, 0, 0, 1, 0, 1675093103, 1675093040, 1, ''),
(95, 'wp_lang', '', 1, 0, '', 'cookie', 0, '', '', '', 'en', 0, 0, 0, 0, 1, 0, 1686815507, 1675437511, 1, ''),
(96, 'wp_lang', '', 1, 0, '', '', 0, '', '', '', 'fr', 95, 0, 0, 0, 1, 0, 1686815507, 1675437511, 1, '');
/*!40000 ALTER TABLE `mod284_cmplz_cookies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_cmplz_services`
--

DROP TABLE IF EXISTS `mod284_cmplz_services`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_cmplz_services` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `slug` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `serviceType` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `thirdParty` int(11) NOT NULL,
  `sharesData` int(11) NOT NULL,
  `secondParty` int(11) NOT NULL,
  `privacyStatementURL` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `language` varchar(6) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `isTranslationFrom` int(11) NOT NULL,
  `sync` int(11) NOT NULL,
  `lastUpdatedDate` int(11) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_cmplz_services`
--

LOCK TABLES `mod284_cmplz_services` WRITE;
/*!40000 ALTER TABLE `mod284_cmplz_services` DISABLE KEYS */;
INSERT INTO `mod284_cmplz_services` (`ID`, `name`, `slug`, `serviceType`, `category`, `thirdParty`, `sharesData`, `secondParty`, `privacyStatementURL`, `language`, `isTranslationFrom`, `sync`, `lastUpdatedDate`) VALUES 
(1, 'Google Analytics', 'google-analytics', 'website statistics', '', 1, 1, 1, 'https://policies.google.com/privacy', 'en', 0, 1, 1625479214),
(2, 'Google Analytics', 'google-analytics', 'les statistiques du site web', '', 1, 1, 1, 'https://policies.google.com/privacy', 'fr', 1, 1, 0),
(3, 'Google Fonts', 'google-fonts', 'display of webfonts', 'service', 1, 1, 0, 'https://policies.google.com/privacy', 'en', 0, 1, 1625479214),
(4, 'Google Fonts', 'google-fonts', 'l’affichage des polices web', 'service', 1, 1, 0, 'https://policies.google.com/privacy', 'fr', 3, 1, 0),
(5, 'Google Maps', 'google-maps', 'maps display', 'service', 1, 1, 0, 'https://policies.google.com/privacy', 'en', 0, 1, 1625479214),
(6, 'Google Maps', 'google-maps', 'l’affichage de cartes', 'service', 1, 1, 0, 'https://policies.google.com/privacy', 'fr', 5, 1, 0),
(7, 'LinkedIn', 'linkedin', 'display of recent social posts and/or social share buttons', 'social', 1, 1, 0, 'https://www.linkedin.com/legal/privacy-policy', 'en', 0, 1, 1625479214),
(8, 'LinkedIn', 'linkedin', 'l’affichage de publications sociales récentes et/ou des boutons de partage de réseaux sociaux', 'social', 1, 1, 0, 'https://www.linkedin.com/legal/privacy-policy', 'fr', 7, 1, 0),
(9, 'WordPress', 'wordpress', 'website development', '', 0, 0, 0, '', 'en', 0, 1, 1625479214),
(10, 'WordPress', 'wordpress', 'le développement du site web', '', 0, 0, 0, '', 'fr', 9, 1, 0);
/*!40000 ALTER TABLE `mod284_cmplz_services` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_commentmeta`
--

DROP TABLE IF EXISTS `mod284_commentmeta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_commentmeta`
--

LOCK TABLES `mod284_commentmeta` WRITE;
/*!40000 ALTER TABLE `mod284_commentmeta` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod284_commentmeta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_comments`
--

DROP TABLE IF EXISTS `mod284_comments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_comments`
--

LOCK TABLES `mod284_comments` WRITE;
/*!40000 ALTER TABLE `mod284_comments` DISABLE KEYS */;
INSERT INTO `mod284_comments` (`comment_ID`, `comment_post_ID`, `comment_author`, `comment_author_email`, `comment_author_url`, `comment_author_IP`, `comment_date`, `comment_date_gmt`, `comment_content`, `comment_karma`, `comment_approved`, `comment_agent`, `comment_type`, `comment_parent`, `user_id`) VALUES 
(1, 100, 'Alexandr', '51791@gmail.com', '', '85.13.86.130', '2021-08-30 13:42:47', '2021-08-30 11:42:47', 'How he makes $300 per day - https://bit.ly/3iixYy0', 0, '0', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36', 'comment', 0, 0),
(2, 100, 'Alexandr', '77377@gmail.com', '', '117.252.215.21', '2021-09-07 21:41:10', '2021-09-07 19:41:10', 'How he makes $1,300 per day – http://2dr.eu/TXfqhI', 0, '0', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36', 'comment', 0, 0),
(3, 100, 'Alexandr', '56458@gmail.com', '', '181.129.30.18', '2021-09-19 16:29:39', '2021-09-19 14:29:39', 'EXPOSED: Get paid $374.32/HOUR to browse websites like YouTube &amp; Facebook?!\r\n\r\nThe Brand New App everyone is *raving* about just LAUNCHED!  \r\nIt’s called “Browse n’ Bank”..\r\nIn a nutshell, Browse n’ Bank is The World’s First System That PAYS You To Use The Internet!\r\nIt exploits a $267 BILLION Dollar Loophole that’s paying complete newbies $374.32/HOUR To Browse Websites Like YouTube &amp; Facebook!\r\nNo Traffic Needed... No Expenses Needed... No Waiting For Results...\r\n\r\nGo here to check it out now.. ==&gt; https://bit.ly/3CumCPE\r\n\r\nNothing else on the market comes anywhere close to what this does for you.\r\n[x] Prior Experience\r\n[x] Tech Skills...\r\n[x] Being On Camera...\r\n[x] Manual Hard Work…\r\n[x] Talking To Anyone\r\n[x] NO Traffic needed…\r\nIt’s truly the ultimate “Set N Forget” Online Income System that is suitable for newbies..\r\nIt’s easy. And it works.\r\n\r\nClick Here To Get Instant Access To Browse n’ Bank Now (GO! GO!) ==&gt; https://bit.ly/3CumCPE', 0, '0', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36', 'comment', 0, 0),
(4, 100, 'Generate Income', '82366@gmail.com', '', '110.78.164.188', '2021-11-02 23:41:48', '2021-11-02 22:41:48', 'Here’s How TOP 1% Of Marketers Make Profits\r\n\r\nHey,\r\n\r\nDid you know… that Online Learning is the quickest growing market in the education industry with a whopping 900% growth rate since 2000?\r\n\r\nYou’ve already left a lot of money on the table (and are leaving even more with each passing day) if you haven’t tapped into this market.\r\n\r\nClick here to see how the TOP MARKETERS are doing it. https://bit.ly/Generate_Income', 0, '0', 'Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.114 Safari/537.36', 'comment', 0, 0);
/*!40000 ALTER TABLE `mod284_comments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_links`
--

DROP TABLE IF EXISTS `mod284_links`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_links`
--

LOCK TABLES `mod284_links` WRITE;
/*!40000 ALTER TABLE `mod284_links` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod284_links` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_matomo_access`
--

DROP TABLE IF EXISTS `mod284_matomo_access`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_matomo_access` (
  `idaccess` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `login` varchar(100) NOT NULL,
  `idsite` int(10) unsigned NOT NULL,
  `access` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`idaccess`),
  KEY `index_loginidsite` (`login`,`idsite`)
) ENGINE=InnoDB AUTO_INCREMENT=1930 DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_matomo_access`
--

LOCK TABLES `mod284_matomo_access` WRITE;
/*!40000 ALTER TABLE `mod284_matomo_access` DISABLE KEYS */;
INSERT INTO `mod284_matomo_access` (`idaccess`, `login`, `idsite`, `access`) VALUES 
(1927, 'documentation', 1, 'view'),
(1928, 'MARCHE_PUBLIC_4', 1, 'view'),
(1929, 'MARCHE_PUBLIC_5', 1, 'view');
/*!40000 ALTER TABLE `mod284_matomo_access` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_matomo_archive_blob_2022_01`
--

DROP TABLE IF EXISTS `mod284_matomo_archive_blob_2022_01`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_matomo_archive_blob_2022_01` (
  `idarchive` int(10) unsigned NOT NULL,
  `name` varchar(190) NOT NULL,
  `idsite` int(10) unsigned DEFAULT NULL,
  `date1` date DEFAULT NULL,
  `date2` date DEFAULT NULL,
  `period` tinyint(3) unsigned DEFAULT NULL,
  `ts_archived` datetime DEFAULT NULL,
  `value` mediumblob,
  PRIMARY KEY (`idarchive`,`name`),
  KEY `index_period_archived` (`period`,`ts_archived`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_matomo_archive_blob_2022_01`
--

LOCK TABLES `mod284_matomo_archive_blob_2022_01` WRITE;
/*!40000 ALTER TABLE `mod284_matomo_archive_blob_2022_01` DISABLE KEYS */;
INSERT INTO `mod284_matomo_archive_blob_2022_01` (`idarchive`, `name`, `idsite`, `date1`, `date2`, `period`, `ts_archived`, `value`) VALUES 
(19864, 'Actions_actions', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 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),
(19864, 'Actions_actions_url', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 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),
(19864, 'Actions_actions_url_chunk_0_99', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 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),
(19864, 'Actions_downloads', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Actions_outlink', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789ced93618e83201085efc2019a8a55bbc31df60a8456d692223442d74d8c775f6c0ba24bbb17e80fcdc4f79ceffd98c700c320604b18e47ec07b180c1480243b708988816c07a8effb4da37523f9e6a85b4404e0e929dc2bbb4dd534e564dae1fe2801996b4bad683955dcf6ba3b2352df34ec56ab033d096b682fec69659a17b442adb44fafb09f94524450c3bb6fde05e62ec5f49e07b288905ef27b0371215411d0764c99af0859a690b3eb01ad22e82cfaed01bb94701e816bddd24ba78fdc18a11a8fcf710abff6de434ceb4288b5c5f3429467864520772317c9add0eaff40b1f749a0d8920cb4362c0e502b2a35ab5f1f6030250e30687f0e30524677ffae3e5b18dc341521f39f5e55abbc574b0a75e6b55071b9f6be5b1fef6abdabf5ae56542d4cc6f117ff7855a2),
(19864, 'Actions_outlink_chunk_0_99', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789ced98cd8ea34610c79fc55cb14d77437f61458a769339e63049cea881b28d960f876eaf67329af7d9535e625e2cddb6c1d86bcf3aca2159094b584095ea5f7fe8fa095031895f8a182f741c71ce624fc5d49d400b1587dd0e91f18bb6e7bd52a5507a361733117b41a5363ad8942a8300fb1f9a6d099f559bfb1fd7aa2d41fb1f5469c04c7d8ceccfffad6d9e41073f46624e24a221a1d3688e98e0824653ccff0c7265d40f93b0c29328b55b45ed7e34c11a3d451c400a4a53402963611aa3274e96144b42484a18209c4f444526617e2c4ee424ca6d758e248fb0b7286262374cdddf7e8fb9bf70e1ec3933b1a7b755628a0a921accae693f798b7c1f23d6759d26ebc2e8645798f545d2a94055d417b15fba887aba16a103510ded67687bcde89a66977394a403c92ed4d5ed15cf027c20685a55ebe540925d933c651d45f940f414ecaaf7b2e721120e84f3a64a366d9381d645bdeae443724dfe32f7d0842bd7377199d2e9f5addc4a386b286baa4d09a668ea6f3734ccbdd1d030e56a439709670bb0a993b251f9fb0bb04fbab200fbd8570b7010b1cb1f1f46e2d54dbf8ab11b71dbe8b63d0cb844b1b73666a3e320d8ed76f355d3ac4a98dbd6bf9fb1b7d642ebf5e8f03d9cf1f01c67d4ba017b45fd1cfc52f93fbdfd55c1d497945b478f4da1f5f30cead9835de736d9799352621cb12999534c22c9eef0c630e50ce125417229ad372284a04a2c29b04c66849cbc1d8b5b73ae7cc404ed99d6238d8e441b8936122dbe0d347a0fd0be83c13f518dfcd38734ee3f6ec1ff79bb7afb5283ff50367f6c1da91922d6de477b0f8bb72fabda1993f3080bc224b5c604091947ecdbc678ce04cb330c3953d41a0b959088e35010487314a59db163f1832f41a8a032ec80168d401b813602ed04b4e85f3ea1fdaf67fec4b2f07d9685f620286a5306cb76f6f098fcfe6bb086721318682b9d38bff3b5a9cafe55af7fd31b29325264a4889d83eb14a1fc2644ee99b6d3fccece07d8a9107b6db3a6dc5675a256ab1656ca5d89a4d9686f91eeed0c27dc652789638d516909490546b9a324f1bade51fcd209be1e26ddfa4602bbaf56e48eaf567b88b87ba2eae740b566ab671ab26d5b1898d9b56320730d061d4444071139426484c808113b10372022cf215216f527c88b7a8f917be6edbfc4c8ebdfa576a366),
(19864, 'Actions_sitesearch', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Actions_SiteSearchCategories', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Contents_name_piece', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:31', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Contents_piece_name', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:31', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'DevicePlugins_plugin', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:31', 0x789c7dd0410e82301005d0bbcc09a005d4df3b7887518a8c5451aa1043bcbbdd9455ed62d29f49f3f2338c3d564161183a0685d5a306393e5947c6a3019dc771104b46a0c29455dd986f78c3ef026b48da1ce3e2bf1372e7d8f791d9250d95352ad09567de9a144943670d0d7ab45d246a95ee51658d03e8f996f3f092db769674973aeb940568b2ec1e8e3f76ca4b4d5e2a415edc6c272797fe15299da476794a8116b9b7e3e26fb615ced5fafe007fc2adb5),
(19864, 'DevicesDetection_brands', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789cb594cb6ec2301045ff255fe019bf9d15adfa406aa10295769baa5d20b16389f8f7da3013b58ef0a89558383826f23d737d3d43029f0edba4fa21699ec474d8279bbaddf0f1b5ebfa7d52a9ebfa6dc23c22c4fcd47980d326ff98fe334ff3c4e6e150dbf25f7977a67ceffbb267fe1af223d8f26ad469ed9817b3984a8763d970c10b97313075b31706416f09c49e77fdc9815e83210e70a6e640c436074a1ceb19730006e240638923104604a588c2bb1a024030434b10ef738630ec450884e00941a36523d0d6083ab6098c44f0f8ca0456712c14f069203304601b34d40cc6b419acc4b0d98c9120048e25eb9f4c7124fa3b086d6d27692fc7389efd2c9350a9eb533c1d71551168eb7b495f8dfa1cc258a93bcedfc4f7b674104b5f8ce1e3cad9778ebf715cf9c478413d4aeab7301a4fea9ac435dbee2e690ba643bb1766f1b7f1deb130bbceb70e81bd9ff4402da88b2d70bdacf36eabd25dc07f061ec4c6f7bcaa6b67e381d4c7abfed7cac57e37bfaf0f1d2e684fba8c74e662a75bddd5753bd236a40d9e13373973c975b1c73d3d5cad72b1c7dde075b48fdfd3605341),
(19864, 'DevicesDetection_browserEngines', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c7dd0b18ec3200c00d07fe10b6c0c01cc764b874a379dd439bd66408d7ad2b55b947faf8970865462001b4bd84f1ed9f35218f2c8a449e2e52965338fd7693679cbbfe6f2b89b5cd8ca41842481ea13d04970f9c63848e2e5046f23481cb61ceb9d6be7fab15e80f5ed602bae529099c0cb5a3b7e6ba1ab394dbff73fd5446c164c3b051b05c1066c14678f92e0fa0edb750c6c2ed3f55c5e0ab1e49bc4111d976291926f1274e1632989fa16ea5a029b9fff729b1e3b46295bf72a218524551c0dbe2f705d01b0d9f710740da1cdd625c4483a3c1ea7dbeef8f50d6eb3bbb0),
(19864, 'DevicesDetection_browsers', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789cb596c14ee33010865f05e5093c63c74e9c1374e9b662cba22d05ed318588ad5ab5088e55df7de3c8e3169b7ac48143a0b821f365fef97fbbb5a8ec7e6545d35a491f6abb7fb7a52d36edb2db14cdbb455b8c2645b3b2d85f652dfa9fb2bf0094ea7fa9e6d98276dfb83f2a54eeb3bb64e5ee328d7baabbdbdd22dd239418d60efd625f4ed8fdc13df09616b220e33181988a386a200cf01820d00061d431c5f05506023988598000839e42621937033468e92900448c0152e53924c731bd0eaa044d3c84f48b581340a245beb8e28acf43139094282b5fdd10922e4906c018004d9ea0648772160886d774084a0719a82fa0b5085d1854fa8821649e43731c77f3a339480795601840e52950276230be30ac1a5761248961e88943509ea0aac99a9038131831aa2c40658b1fabedcb7dbb591386a299f010d4861ac9973102e3869a6bc164741c07ca28943232841115a9f0c9480eff98cba77c5282b1c5cfddee65d35dccbbf6ede9dfc5e5eb2b5185d9205d42686ad22519ce9ac161f37234a5f2212e31ea88463c579e190ac827a5b4c5e2f626cc25d52763f882a23913504c4a433e1efb91fcb5daaebbe7e9960868ea86283eed001cf7acc4980c041b93bfef928ca6f2e44b909a52329948c614c086e46c11d7d79123f571f18b2fcf26e33824b43cb93e533f693c13cac026e2dfcb6fab9d0f43e7ba8778ea6967ac48084d9b417a2e60aab34178fd1882d057c7336f9e0660be36b207c5c9e2bbfc8ef9acebfd3e6e9fbae56eb78edfde341ff316ccd94311c7c01e0daffec4d5c96e6117d6b40125ca73ddcf271e88be7cbf0b3f76cb935d875c1fce23910c49e6674d7ff80fdb4f5ba5),
(19864, 'DevicesDetection_browserVersions', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 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),
(19864, 'DevicesDetection_models', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 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),
(19864, 'DevicesDetection_os', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c85d3cd6ec3200c00e077c91380c1fc9853d45e2aadd9a41d76ceb41d2af5d66394771f203b558704071060c9fe12c34a9eb61ba9b4929145a4ed4148d37dfdfebd4fe99123d3e5fd734a37823c74b4793665b832dbf443dae50596a037b684cb5e4309fb54b2e69d2e1396a055f56ccffb5c4ed1b6977c8b1c74215f974520ce3b866863f1bfc42974c0125b4f5f244e87be044692eb7c12495002895a1c8a1d316a7f301a85ef23cc08312f6741c0f13bb066ac0a90be84a08ebeb8c601d6f5217604797bf6050019c26933c4b3c347c30ad0d828ea85e92870a4383dafa918b474442e8609c884e67a62bfbc1bbe928ff97825f246b8bae1f428dfaf9ab7d12bbeff014447ff00),
(19864, 'DevicesDetection_osVersions', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 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),
(19864, 'DevicesDetection_types', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c7d903d0ec3200c46ef9213608c033877e81d52b543a46c19a3dcbd76642f44f500828f9ff7ec9589cf8dd3b232faa2f379483cedebfbbb4f8b861b6719bd91cc28036ad7b02c1f8659169a57a0a6b7743fd73bb1b700fa18f4b0a43bbb241452e2f3d20f5f1efc7700732819cca1a5362a60eed44c21d34301a9c60a3954c8ae6002d5f0e80d488e1ec125c6625cb9b7bfcc06ee60e4e675434567d7073cc5f412d00fb93a79edde781ceb2663a7110d11f9fa01985caea7),
(19864, 'Events_action_category', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Events_action_name', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Events_category_action', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Events_category_name', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Events_name_action', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Events_name_category', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Goals_ItemsCategory', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Goals_ItemsCategory_Cart', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Goals_ItemsName', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Goals_ItemsName_Cart', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Goals_ItemsSku', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Goals_ItemsSku_Cart', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Goal_-1_days_until_conv', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Goal_-1_visits_until_conv', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Goal_0_days_until_conv', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Goal_0_visits_until_conv', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Goal_days_until_conv', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Goal_visits_until_conv', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Referrers_keywordByCampaign', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'Referrers_keywordBySearchEngine', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789cb5d4cd4e84301007f067b14fd06fcaf4b6c9eac58b478fdd85ac8d841ed068b2e1dd6d6b87c41a404d3cb4947f42fb6386e0a085ab076a1d085cc46402056470a77e20760209e4e0c70bb11e781a264e220ea5e3246d07295071302ed245e7659c1a9b768c370c1f93344773cce24914aef3e7560ca37585067217c265e8d1a1a52c10260d52982e162368c30b86b7a6d6684637383c457c9313d707e7bb57d4e417ce185128bc485a64e483bf28f2436b0861f36207f1f0e6c617440834b06250c5a08d41446d101b049922b9d796e3394cde2d6d297b365519f0cb50bf01a814a93dc0a37b0ae1e65b11b011b9d5e95869e45a15b61aa153a4371106c8ad3bf7a7109e6bc6a228085ad5e847756852d4ecd761ecfaf77f01981499bddfc4bd1fc2f29ba88ec7ef80ffa907ad9de70fc92f4e21),
(19864, 'Referrers_keywordBySearchEngine_chunk_0_99', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789ce556dd6e8320147e9586fbaefc89787887bd82a1adeb4cec6c945e353e509fa32f3660603ab62e75bd589bc544050f9cf3fd806828e05003513db02203a481b93656672f36a207fbadd1cbaa413692bac0ceecfb595fadf65d6daad9ae6b4db53275fb86540d54b9296b60e19dabb57f66ae1fdb9b506eea1af2f024248ce0d8f70caea501c36170b33cc78ecb3561403133cd43ea8c87dc32e6a6340bd9094dd3fb613fe49fb3f302a82b805240abb6d96fdf4abdd974d5463b06ca76d723b5b461096d36ba2cd7dad86bd954e5b632dab5ca127d9370f880d3db92d895ba9c7120380b24102e59a08188c08364d8a3756d5ac89409818b5ba4a002d0ab31bb1e160b6f9379b4c9d34bb748fd118b63a1361e159aea8fbfd087b961dcaf1b3a491f6f3f2f4fc41fd74741a343c91702e8fd31c03d036c3a03a33f4920200b04082923032901ecfef0671e3f9e8e5f043c79a27fb47ff600e08507cf6f107fdc9a705cfe925f52ff0edd9fff567da63eef7e24c08f3f479682bf43f5e57f065ff87390bc123c11e389e974f4ffc2d3713cae246cc48d803ece4218de0104f01022),
(19864, 'Referrers_searchEngineByKeyword', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c9d91cf0e82300cc65fc57057d6fd03bba79988710911c2e689f0403e072fe6989d07123978e8da7ec9da5ffa5994383964c6a2c8c519278f0a8bce5edaae301e796cec189efee0dbe639bad01e86b10f6d135cff288c431e036208aaa5b9a6ac569dc5479b75b4c38a3200fd902c29f3da596438cd9f2990a5df540c8bbcbb628cb683aa2b02004d04b5521c084208b9c5d09aef80f055e2bb20a0bfe7595ee93ecb2b9371e2129bab704940b0c5d983112615bb5e45987b0883c7b24c50c7ecd9e936965bb33296202ca9fe314b9a797e031113a963),
(19864, 'Referrers_searchEngineByKeyword_chunk_0_99', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789ccd95414f833014807f8bdc4de86b29e5715ba25e8c89474fa40c828d8c1a61d164e1bfdb624b1c53101333b364b45ddbf7ed7baf4522c3834292b6082cc24022d87e984aa4be91e0a145f35b2df3b20ecc4c86c1463555902a84d42e56485d9ba5c5f08cec7868be786a375118bb27216e050b8791def6248678e8ed2e7776e0927e0e0f363c00065b5def774d26abeaa5ac64a77493e9e736487333ed18d0ceceb24276e693d765b62b3b697b59167c11b0fff823ad61e3dc2a4896159879375a5775e92570469d06c204752608772a040d2176362011531f3c4ce68d905918d3de4855ecc7848047f1203e2509388821ec714e601e019610ee5f65d37984510671049123e042788429019d07a06b6a72b06d378c980310be2a01224f00538461d90c035b2a8aabad6e951c8bc241c49334788068a5826829fc837cd4fae22409633d862e2813ecbb2c2c94019f4510185ccb6d996bfd348518191c82bf1ce84a07f1b283a628dffe2afc39ee26baf676be55b51e4fc24480af41f86d059cc3001b0cc43f34707239938903ea8f813f88ffff0dd5bf03645c38fb),
(19864, 'Referrers_type', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c85904b0ec3200c44ef9213187f08983bf40e54ed2252765d22ee5e1c994daaa40b5b7800cfd354656d9b42a94af390b57d5474d9ebf3bd2f65d3300a47c5c4a3d3a84ca67179693049ec91009b186dce69f4b5d8be7173c862170c87d66d6755d0d66ddf630ad708e408223e044a4e901c2022b2fb239eed85eeddf1d61dbd56980104c93213880e902402380191fc2410ff2440b70cab338489401340dc3f6772773e7b1f9f2eadfb177eb88ddd),
(19864, 'Referrers_urlBySocialNetwork', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c7d8e410e83201045efc20918c456feec4d9af4125859108d2e5c12eede41a19b262efe307cfe0ccfc3204568f6e85ae3900ef450ab9fc2aaf8c000f58edb12e6d7a638c288a89372ca4ab13ca397b3c8b9623feaf393cb4ec9531bb2fab4b25ce52f8d94af2435eb9663f49f30edfbf2e3e0367d5150a5d09581fe186e100ce7fc0549134d11),
(19864, 'Referrers_urlBySocialNetwork_chunk_0_99', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789cd5925b6e83301045f7e2ff043c4050c77be816ac015c6a05300a547c20f6de99d449dbf411f5b342c85ccfeb706d42c0d5a3361316854645988b4e0d6176f978c095a3a83aaa5ca7383345a58c473052e8318b6f6e9af35a48ac94c8c148078f655cb58e25797aded94411f75b3769f178d9f87934b0789ee771c224599665dff9e1e81a3fecebd02757a82b551ab18a885502442cf88275870b7ee5ca58d0d09c826f76348e4cc740ef743194dcdaa6239f8e7c69a4d37f346d977da403a103405587eea51f2cb5edc9b534fb30d8304eca549c76e32b675bdbd0cc4fd539dbbb994459abbe19b8bdfd07971d32b93370ffcec800393876a6df3f51edaa108e9f4feddf7bb2bd02ad91fba7),
(19864, 'Referrers_urlByWebsite', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789cb594eb6e84201085dfc5ff1a47bce2d3b0ca5a5a10226e4cb3f1dd0b88c9762f6cdb6c7f20e351c99733c72118009f194e5b82d15e34f8ac7181234e0e9447adc650e1484d522bdacdf12c254f3a29a296e1cc2c300bf93a6f7bb717b64ecda56ced910c577e07f05fb8a769bbda3b82537c5eb75360971ed36408471d197bd693395192d3980ac5254b8ed3cee44e77c7a5a9c7aa3d560135783040d764a809a06556cac268298e167a8805613ce144493dd364a4f3b557e0a1c043ed56c16fac42ad2b9e5a258573c99ba4a89007c6e98e842ed63da41b8fb200526ea53c8c54e288f4828dc69725e694f4b1215464fcfc49a8e04fa12aac5484239ebbceb9c6e9e37491a597f6acb452193608b69e0d520e9c2626e893647d3288eb8e351ea8f24019141e29bbc97500a9b252f53446cbb2245b84624dbbd3c44cb22f1ab683c1febf95fb1880fc51cb4249aaad543f9d4aec381141cd4ce2f283dc0bd04bbad658a909c3949b457a24aa7b3383e90e4bdd7e1f45a87c684d70446eda93915d6f3c8a0c54bf93d348f57f65dabcb0ae5f9d35d27a),
(19864, 'Referrers_urlByWebsite_chunk_0_99', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789cdd96cb92a3201486dfc5bd17c02b2e673fd5f304165134cca050622ad595cabb3710323126dd6d764997a582221e3fffff700806001f1806a5c230cdb1473034fda824189d1b053e289c608f930de59e1d89bded344985c3508e42495a4ffe24040f6ad1875ec9302ccd9c0c23d78ecbc69e13d38ef4212dcddc0c67ee0c807bc2de8dcaa3e9111ce1c3d1ccf2db5cf0d13c2a68a282107bb5e0bb7ea848d78db42313134325a4f2ca8d1eb6885b8faeaa864c7adb705af57422a65755de9d171e4f1fa2707c0283be0783e0054c4d8686e9d9032938f5692fb960413bfec7830ac7a7c81ca0dc0142790e1c2280968c50fe3524f0658029fa3e40d1b62355e148eb2d1df51e361a13e32140f0edcfdbafe5ef452e7ae4a207287aa51f8ccc6359b456f9c585df9e6efc5e83093891424d3418e874237ee0e80047e78c06bc009ad8a22956a241c62443330ad6f8444a2330d15b6d396949da8b0de3f4e2808582968c6eb40f9f8f516219656b192517f990a66783d6ccdee79434be8625c9f0be2a83825732586a178c78adc1d095c1acbf543bce13e74fb056f698b5d27bd6ea84e8380ddc8da0eb6f8c55384299230441e218c19b65e5f918e59651ba96d16ce9ddeff7c129e9f88ad6bb91e9e43cf7d59991f59101943a4031883f73d613e69ec23a6b6dee99176dac1d494f75c9c6c53f7237e5bcb2b940f458359b5c2b470d44d65b5d17dde392978b5a2dfd5431cf48e6c13a3fbb26234947d55fb21ba8fa5909f9f8019f0ef9a9),
(19864, 'Resolution_configuration', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:31', 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),
(19864, 'Resolution_resolution', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:31', 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),
(19864, 'UserCountry_city', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789cbd5ddd76d448927e953adc2c5c948e3253bf70659b86a6c7a61960e8edb94b5709971695c44825779bd13cc0bcc6ec4db37bbb977be7b3efb511b2259491a50ae172f9cc81069f31442591f17df1f7a57e2afde0e9dfd3a7ee33fd5475bf889ffebd7aea3f7d94e9f3247bf4ac7a2ac2a78f4e56d7ffdaa45956e4cdabe72f9a8fe5a367e953093f848ce16785bff37cf8d97bb684afc12ff037b11be07f02f811e1ff257c867f057c93c09f5cfc4ecf6dbff60ff83dfcdd12ff6e857ff7e611fc415ee444ae00133cf852915fe0d7a423630fffffead9ebeedb76d81e3c7d74946f740eff2bd3cba269d617bde99de1b7667756b72605b7a69a267306cf05581c85a6c55ee878513c3059ee3619bef59dce673f1555d29c1c3575d51becde5adcfea23de95b933b8b856db2cbd9ac4247a9c834792ea4800f120c8c56bb8d863fefa85a9dd765de7c18daacba5356f1adcdf1adcdbe776bb4b28c56bcd1b1e37a1e313ac4830e07367bbb6d964f1fbd01afa8884bfbbd4bc75275071ddc5aad02215467781851cbbd88f511746a5f51a756ded043fc9d86cbf8e9a30f7019933ca92f93f93b9de69bf9f324b73e4977f6deeda7f0ba7b29eeece1683d1c06b13e34ae64b0dbfae09b7fcf1e1f2765799554957e62faba7f6b7a1f5388a7fbd4729fb31cfd3cdaeee7d1c0f890f599d7c96fbafcd4bcfe6960ae474e9a9aeb598ec21eb4eb842aa01eee392294036ba39dd62ab0f65da2379b0c4efa5d516f56b353fd2999fd254f8bfc49f38b7151073fb67d022b7e2bf613844e20a575e0e0eb6a7849e3dd070ebe7e56d410c2d37cf6214d7e2321b18b886301f1bb1d1cdcc4db6ab51b19b0b31b33954027c77bf921cd1709fc37d3f31644cba4797df4e761b8a141bdbba5d2ef028dfc7eef091c290972ce5dc7354e5eecc64e38f9b749baae9a6144e9acf5fa13ef8e5caa40deda1b58a7ce1b1c3b40460870428c17437b19e084333f4d66673a374d7eb61de6a5e84cbd43140c9d3826c7eb3a22364e97414cb89b676952ffbeb8fe3a3457f697adf3872edcf9d2ed0ed8c21dc9863f08dc9e88a8c9ae6b98bc1b30a5428fa8aa22afe6555dcecff4e64bf3e356c4b9bffb088ee10377a080e3199791c1cb0009ac5e7fd61779d25afe2e49f384c27e677a17c33ba2227b126bc5c029a7ae62dbfa78883862375e22b57aa3f34d6a51effb3f6b00f7d8a3d67aee909a0806209108aeab4d522ef5ba69f2acb3b6e75423d6c6d45a363bf03115b042466c7ac66e80446b8f937c76541635048d4dce058df8eeb9810a9cd0f74d73850b617a88e7824143081aa735468c930fa7c3a031704e34d7bf3557047d4cb60c96532206e1a9c2f10c9e2a99cc11feb0b3a45e5a59a3ecb382eeb2755c4f48d59153613bf0948c31a4f9976ca17060f46ed8c328f7bab840ccbe0972a5152a4633c770f4b427dd3d6559ee41de3cb07c37004a8979c1a6bc1a8d719d9fd0530ffb33bf8b976c3971cf35ecde0d851280fb45a9f34f1feb7233d36b80700876cd32391cbbf601ad0501f0c809a2e15d940c1aca9ee2e9ecfa6b99267973fce2e4d0015a8404c495e3c6fed0ecdd608877f2244b3f6ee0521a294c47fe8367260d55e1b31116ca67002ef8f49614c6f00d06fde07bdf16f5b94e7fa75423ec6e614794fa18a27aa224ac3cb1fd36ce378258d24346f235b09a47c1bfae92fce2cbaaa89b66911fce9395076488dc3f2114a45e8653ecc641aff7e5b68c307b7caa676f32f882515d7842a289f7ad1ed5fd13749c49a9a8234dc2fa4c2a98e0e7b16bd1264c30061f8981ca10a0b2a86647f9459225d5c1d34648567c2b6d1491230d3ea27603a6e775ff0e3fa670fce50d5b0586a2d32f49fbaff2a228afff6bf384e27f475e5574fb89c2675d5616f7ff10a115dcf91b1c387e40e2a4803472c85f1553828d80bf427c4cf2c52a857f8843270c787d8388fa4e1c0e838eda0da4ca350a6cf86ff02129cf1388f123e687e4d8e146ec410520170e7dfa098221f1520ca282f31f17755660c2730c9f44e78b02c0752ce5e9627ec71b65a8c6ac9f92f244ca4a2230b91f98cf5766c1d1936a6316930f52ed5181554786f3370e9b41540f4b54f932b9449799547ad8c7354440a2fddc759430820c9f50be4cf2cbf28a387307a8a2ab0176802abb4a899500f3911cd2f7d8662caee10dbbc154c2b71eeb4c97f5620e917c7e0c01b26a7e3e39d9426cbb93a69e6171179ed72ac7a3657a40d5d808234c76897587222bd66952528329dbea5c231af50d3e56837982409020c556c5e797ef563abf58e974485ba26766f2dea7c39db516b444eccd138ea4d9a584fc321c7ab2c7e49710a7df97c5556216fc3a6bfb96539f0e4bb1a35336859528da8e04d88f8644cb63924b1f03730eb89266a3e9e5d03f8cb0311ae72665697692160ea39cc75457c135dea6585b35a9c701929c10921c8bfc054688f3f8e2eafb7a51418e73f4d7c3775001de68ea0edc0f929f785877f0987c129cf9a806928130d2460c5274e82a687e1733a2cead63af0b2576ba33a56412bb966f1851c363003032b2873192d1c5e6be952abbe86145e7292423a6fd0d30da1f46678f8141f8cd9b22ddb4476db6643a9fee9a8fdfca695dcffa0ec80d4cda2abf2bc3a7f99cf2c75467895e352f4e074e7dffd8277d27a6c1791eb96d297b602f837e614b8b36d90ac8ffd548058d9eb01fef71c29143a99c6c89f4c0e4ddf01743caa82f75b68dc3dd6b11c70de9e9ba189fbf19eaef063eac519ee86a9364b9ae8114cd4f932f8460f4d7ae4b4dda387673efc4a8f17c9f0e48069d16514e2c867ccee767724e8a720dbe51220e3687e57140e6059dc8815c7d682f8f7cef217bb290afc3e87e4aa48fc06e5733b3ba1a620afc29da848194d66019fe84699c7c53e4f4da7df7f14e71e6d09e66914627d46780cf18679901c59f9d275fb670e60358af2075f2a937cb6175c3e7cba94740f0735ad850dd058c7aaad1d9abc29ee54b7bac628a4747b43e09d8e71a5633d8072e7dfdcfcf4999ebab03073b1cd4b2c2856f0c3b31e99f6cdbfac758c3989f25550e1163da989310fbb4f88161d87d672f18323a7f370222d9ff704be66ec87e518e767169ceedef657a448b76d28942c3419844105b329073a7d5d682c63db79c69dd14472986e12e60d240f490b6f6428a735d22e8f7f6f6c818f4e77b974c106b8c32a66eedfac3a817302808dffa2abf00d75825e9faf08c83166100658c1e5dc0806080addcbcde56463c4cd490c460e1185313015301759164d4f922cd2074d41f3f425a72b465608fd65f6438daeee2b9917064407d39f6dbcb38309ca97dc237ff08f72e1f2d95d36aa2e82cfefe48017eecbb56ad9c4c73320008bf79adf34d5296569bbcb7b88bcc1d4192aeec78be55399ac090b6c40ce01cc208197cf2775c168b4f5972d5fcf0fa657371ce166de3bb1fb300e0a055663a8d1730e99f87e96ab901185c363fbf1db8f2fd4fd6783eb805a145ed0c64606453013f5c73a6cb2aa16571d955615417313abf10beea4ed96e1b4e2865a896791a76fb66292360700fbef30310d1cd8682c96851aebb7d7728cac58e475313c069232c874c221874a597d3a4c619d39bfee0c482e2b7c3be5384b66d377ace210380613b07bed1b3934c979a34683b93fbaa91052a36db670fbc1d01a79937569d6363cc26e4e74cdf6de6673a2bb6c136dd73d8a7661441b24d67c0453b7a3ab096c9059184eababcfeaac778b305289e7f7793c12f94950fe2970616330888b1f9faeb6655e763ed566af11e0623045af60643000c99e9d208434659a6d77f944985c598e33ac521d989443fda8be8879eb58c2103639f81d9c6682b49655ed4bfcf937cfea62c2e937c7168d20f71da27f419202730a207038711b623aaf9cfa5ce2f46175fe85d0cef8ee178177d2ba9f28cae44c8f7037b409cb9e1f0903b3e6a4d1f87fdb28e75ce533a8292c63bc0c361ad2e64f0d0479333fda9f8f87172f4d8e78c23bbb031b0366212c1084737cbcd6a769c9417091970eb20a5a3fc8a3598477017e09a12a5d07390de0eacde0d840abef9a82c8b7c0961235927f966b64c6637a87e5ca649bdd85621ed3b58fda48f8ceefe39a276becdfc1cd2898db01d31d3a76e4745dee9fa32a94b12bbfb3d516ab8f0ba5b6975afd8593d801b45b71a2081315675222653843feda7a2befe3acfaeffa8e6db2abdd473fa025320ee7ee4b8764962204e2e1927ce8fc93cd759a6abe6fdbf0fc99335d7d3ddcda88fd936bbe617e8e0606913791e07902e0e0976c4a48b315ed1b4ba42a07c972c1e66a7c10a2a9e8135113f30f341e797c918ccd01018dc3d236f43e0967afad05aa65e8a880e74eff31502fa0760a9e9d44a82ea37ceee44fca43df665ee56460c3e7a37be91261653ed3246d9ef83f67730525d31dd2a25f0151b386dcf1e3530a33783907d06f61261bd6a9af3e470deecbbf6709d07816408e93103927e67f0d165912d0f5efe17b4fe0f11c318ff8a993c1170e5af75992e564db358f5ed95c18f7b5b5755b47a1739fe30d58af9462100b9b65a41ddb176e7da0f6eb87dbbfbfbab07e00ad6fa132ec60d035bcce4866dad71bdd6ebf969fa71dbfed3fd7902ae3fd192b9c00988e14c77cc67861dc548cb641b2da2258e30b8f30183ef06315dd8723c63023066d0ae0d0ee5226923c303405d4ccb5f38c9330cc1310f7547799e2cae9aa3b747876dccfb00ccc4210247185017f335d1b705ce95e70f3156ee537371f5c6880f3cbefd9864559a7f4a1b11351f530bdfee752e2d701dab44e701a937fc81cfff5e94e9459ede347e0eedbfd6a0861f1beb912e5f0efd73ddf75b8fafbf7ec1c1ec113a3fd99779cb711fdc8ac59eb9bdee3238a7706125c76549b32171ff50e70bc7a7237fd87435061f84cb2f490c166c668f4f20732d75363b3d225a1ef71f3bda6d1bda5069b76d02639fdde5f1ef75f2dbecd702f53c7e3dac1a86eb8462cb329c390a8f6489d538b8c2b156233a8fedee8920183b63de601fc8444cef63e499073c69356253263a6bfe7cd22cf401a30736ad680d23548e4f5c8201c000a74daad98f4979de8e204d499bf6a8e0064e14529d0ee1b8c2748add30e8d19bf8bcf82ddfc08fd9e0ab0f72272d49a6f64efa6608e7bb8670f86d1cfc7058811a057c896ee4b72252aea9f4b21b225164e7f9f5ff5655922d8bf2e3ecf1bb8d5e6e7082adfc34738327c345e6fb3f755fb4318fb0a84818919c11abc15bfa7e0529565e91b872905b1ad092b4e704265232c234b8dd76a2fb8ecbd8b2fb6881ba9f3bbf537966cbb0bc30162904a35383ebeebfe80a48ebc5a6c867cf9d13a7797e72503129b5c56cf474aa073461a6262daf20fbca2a5c2d9cd8221f6d604c49c154602d6179c61eb060546bda06685a161f333d36854e5b72e17ef53b5bb250108b19d48473fea5483f7f3efc6ca6a0080f195868fa04bf9f7fa67fbffe6a2d3f8e4d58f57b8356b09b52ae0b5d6519acccdbc7e48c7ebbfd88629663ee4003c61e933fad5c9e55ce358b1e8213a969e30564b9b893b7fac45a7bf7fe9bc47d094b4b0035e70c40e4446ae0373f64b39ff4325deac60d9ab5c5faac49dd3d1ab30a9bc934b645c0050daf98a05473b4fe5c40a66bca718d591cf9ee9d2d866c31a2e223907e45c6f48c60646ab0d789d4fa73d20e189351f903040bdc2e25462b20af065165046a5a9b35de3cecfe9ce8f5e703ef7e444e101082e739d2d01f119c384ddfd6fc6193263980de0350246b5ad003526a503a469ce6460bcf5a4ae88eb8eba2f4f7ef9b5cc19d2a639e3df21399c50446950647e55f803727b9be512f3a2d801e8dd46d2c8d8be8ee557454d4a10d0aec739a57911f267d57e7f955952e135355f300de11384a5a699644293f33e0313088436c35700c7377fa00a5b1b8ade9d2b21e8975bb113006e7c0eda0ad03339da9fd0c69343ad538a507e487f636821f9b1183c7bfd364f6aec846c3324513353abac19faf6c65abac116ec36246760609e79ba2cc5363d2841695fac0b1c7c46be808cb79515ad5b496dfa17f87485d6057059bdc38253391dacb3d601b27c0ec506158ce3708ffaa2f817d266ba34fdc95ff55676ed721ecc5b7026aee1489b3d8562bf00c516fc1e8c8b4510261c41436eb0e362487eb8bb1c3e56f5ed4caa75a9b78a663f0ab13c7fa0ae515c84237c5bdfed7a3dec0bbb26a5b81b472e785a6c513602f4beaf2aa553639aacf4b9d3e88c2424c115b38b15934e25464fc762b362bea2a2151ae0bcd1d4ef7aa42fde5b36a7593f68ee9a41daa511a89092324d3aa9c5dff6731fba9c09f9749367b9ba4b3c73fe97299ae67274576fd3f79aa9f34672f9bf3031eff5c0a4758e5180f98a9911632ea3238e7f34d1667fe01b5841f220ba003c78aec260b466306d77dcf7479915fdd0cdc9d14ebcfe9f51f7639a9b39e6a6b49b1d778ba470108b8aa30a813a33ad37e80b6a9b12cf2f9297c19a7bdf31412c7edc74f33746f8f7e8172283f91c0078d98ce48d06012d6ae5b5fea7a09364fc44d6fbfa2a93da419986d8109f233efea2f05d5ac3a4855ccb70955ec9967cc2fe09fe995fe0f9d5fe86d6f8edc633011be135a020790240853d97b3774a25efd590d0470357bfc56af93b2c25ec6fc4d52667ab1327a18e31eb20789c52c8c4677e19847ce8fdafc5ce6009f85a50e3646bbf729ec294744f68eb5594fe71468bc561fac5e9fd760f18f5bd2461a39ee5e9756b113d39df079047e1d9ba18f7ffee243511679f265d534657d38b7f6855dea85cf4024f639099a18f5c1f4a22d377dd0d943c40e8fbe31a26866ce88d0b45ea1d7c8041f62a84984169e4b65e039a3458344f004c54a0b5ba277c48de55e63c61edd0c976d8d7d6831bf7affa6d41b94cf698e4f0753a507a1dabe24d1397402d38d39011a08ce6fb22229937c6b43a84bd0fb478aa4d823b08576cd145274f3f1134e7f06a5b57456cc8eb24df1100fb678b46683cbca08d2439b19159adb7a3a9cb2aee72f749d6de6bfb6a9e4b45d5a71f7022aea0ad29e384466f312f232346f8ab4aaa6b638f799594165146aad6bce0571fa333865a3cfafbf5ed4cb0728a8e38081d5065086a0aee05468e29b36c0c52acdb1e47476fd35d3f9c6dead18ab9a894044639f801fd87381935a323ac2641b8c1a4d8bdd40f0f69eec9d52a2c64a18edda9b255f4e80061d7a552439808a29e178ff01046cb31fc013e0d366418451a1693597812fa739be6ad64eff9ca580314f9ae31fb6d0e77b04710910438e5b28fa6ccb04399a339debaad295397775ff6d39859a61948b86216d0a708a34ad487792e79060e19f9b7e9bc77bf6add247adb5560cd9b5b77637926ad1407e65f6c419391a156c79e262f6f815e04b5ee1bcd8ecd5d624eb7ea91e2d07474e60960e386d9ab0eb85fe5c27d69b2ecfb60323729d3dba73dbb4498db554c109d4606aab9765ba6cce9a844db1d41edcd4b5f53ce60af218d353f8baea4d2774b4d6414d16e38ffc4ce2d3f484f1b10b631e6f8234cd69ba2e2e122aa47a80dbe8db0b70380269dacbefe13f4faad95991a2cad2abc3463b4f00765b6bb3f4810ec108d3a8b6b7915fd4e9ecb148ca99b9300e18f3f245b3f878400e057c89440f1139be39f8c888d560c46ea5a2b64e5553863ade4c9a92c348abbe2eda77e486d632888865dea45c175f66c7853ed7e7cdf33f35d50137e484e784b6d590dd9833368c3a4d3ba4b96a37ac218f39d68b07297a50fe8472830639e5546abc9b27faceb30729f05a6f2810e922c149d4dc985bafb1fb7535650fd1df0b0405d50b06fe61166938919adb29a66abeace7af8b723992b5748229bd3643bfa06a05be29498b4b856c3d5a0c63e4695af04ef53a3525afefdf29a4ef84219d4c885088d2006f469546b65ce3a22ef5ec795a6dca74b16964d89c2f0f68b86a1fbd36791d0a8b9941835fbaf84197b6185ee71b5de5bcafe0dd5d33a515c32307ed3ab132109c91a591374fbdbe4db264f1b7f99f927255175b6b6316bb1b337b4ad5c3224a73af257c03bb39811af8f3feb22993c56ad3fce5fde075cc8364852e7da2d67784f112a2609469f0f65dfff3b2c4cef284698a6fbae2dfef15ade2a7c5eb846f9acb401f76c48b0a972afa15a827cdd9b6f223f58b3d3acaf8ec00ad1e84c2717d233e3322344849dba6ec6275fd7583bbf83c41f2f6125a52f4a9188f164c19f519dcb57d555537932b67459d0199d6e0280f21e8623ffd204dba314185e62691fda96e5f27d8de2fa4278eab607b340c63cf6249d244434688a67fc838c5e989ef7d9d54ee41a8718dc1de6f36b191d1a5c1fae30f4b6ccf6e97e5bac78ccb757cebf1f3103218b3463d418de68dceb23a397cdf10b53ca8f6088a0b98f791ef1b1e6b4808739a855310efddd90f464de60fd9b39f68c45159438557705a34618be32745bd2cf5d5e1e7de00c3a963e02abc01329c1c4d84ad8bd9db62b142558f91a3b6e8ff3efc3f70045d829b23369a0f47f36f03dfb4c26fa7ebcbe4f0afd5860e6d03504528c129d4f8ad0efd27ac9226e6a3c007b9851e7d7751e0b3a3a64b33a921645a6f714fa4da36ad4e276665ff3ae7f7e75798175ae546e104a179c05391f04ce7e3e360f7caa3a32def2a98e90aa352a3d4f8ca754277ae0fe027233bd706ba30d235f8a8e1e089d1e5bf1d558bbf8d24e53e39fcf1759729397940573e1511dd118c8c0d36ca93cd9749e9d65e939ab868682da71a90c8a9d784d815cf3790d9e28adcf67867ed62ecb1fc1b00265a6a67cac80424236173f334cbe5e417b384da6f3233b057b78ca16ac9c9d68856e2ea0b70ff032f12618390265ad27c364b329a35f2a66e5726f838120e85a1778c1cb43576acf614b6b5f8b332df6de7c46a14da9e2ef445d1bc3aecfb6f9e685f8b21c5b0d031c44925275583fcb9de6cc9092539e17e1c735c0a7b4a9134a2c54648af4c4fe69f317cae3fe972f6f8d7e2e3c7270f51ef5796f64b48564824275883ef722658f438f85bc92897422b77e1cd03ca437bf9fdfb635414c345177312a523495d11baf30b6f8f853edf090262331cbb419d25a74813b64fc994e7c96561ed998d1648fd3d54a5237b734bb68ae943a3d9a70c5f959f9131d707d45cc2b9240ad2ca25d78e539f69e76674bd42157af089c3cb44594fbea14c94f93c966424685ae9e5fa3c83039e34b8bd47dd08bb2834cf8e80b309f3909961192c8da6d562f5208f4d05b45614b68f040ecd65b0aebd72cc5e106542b21fc1bc13dbf4ec697e83164b4e6706f1396b07ecf67c74f18e014209d383f989d19fcbcd2af93252c2b847e6a6eca9f8f6c153d3257865d2f77a9dfddf7f7f6a7e396ed20302b394f63bdfc07e6263564a723a33588e2bceb152fb20c2af963b1842c092d198c186da8dc8f2ecf12f69b24c3f15f99366cb64bc957ec83d068979c565c968cde0d4f68ba2fe5bddbdbe821b855b842f0e532cb217116263114132aa33d8b03a4d2e75861aedb86c552663d948374edc4f4deda749b4852a4746b063d467d0f20f4979534cd4f5f73c98158f8e414f69125a6b62287f602021a74173f3ecd4ac7d1f372dc8cb09f71f4bb62c9ccee388f44e242742133c7d7454e51305efee39b0d8a33291e9e4139e732aca659b086e7f679db2a53d428ae744d62cb74be6d4242346f36dccf56552ae75ba7debe63e0fd912b0f21cd73c631e1c4f0ac8a91623276cf58ef7081f905251b4812356265962e467946b943fdbb07d74899a1ef9c45eac8addbb7f04e5c441444fdcd44c918c26cdb7771f9ea7f858f5e14935f56bcf893df3cc996a28e4846ff5b9decc1e1f5d2c75f6a471bd8136dbfdd35405c74c9f9d9d074ee4193c758236cd2fbaacf46f4df3f9b0f332d6bb2b28c46b540a38659a1bf9f11cbb6c455dcddf5d7fcdf5433c970bde412704a5e32b0362386d1a38e7a3dfb12673d8daa272c16de9ba5e14c1491b7c9513a671715baf5a14bf1d780dd987cc952ec88690e01a556746970649ea69abec3e7bfcaaca9259f171f6bcb8a89e8c0cdbdddf61fb37dd6d1aabe959337088d20babba5ae9f2eac0a71d3b119d29007f51917909f9219963e0a33a6f9f2c681f4505667dfd75da7b21fbdd425b303d363d85491a55abb7944d7eb1698f5e556ccfc8cb76536168ee6e0cf4c2ee16ce1ebfaf6ee4fff3abab995eaed31ce75ff526bdc42f149fcafae2c9e1afaab5750857d510ee909c380dfc792f4b9d2f2fd3e4b7d98f497ab1da4cd466d843c134762c988c94e31aa2d89251a5696f6951eb6ca2084db0875a87727caa9b2e1d61b4f0e504151a5cb706e684ebb4cf1f804079b4a505942f348f9887c8b77a095c75db5349f480f7e823e35b495486d775a4214a2939091affe6803516a01e42d59d0e56c1e99a448f91a0c146f2cb74393605468f77bff5a038b2b4c422655acbbf6cf11e92f1ca7a7a680c5982b1d3e551dc7502aa9fa4c8668264b466908318392ddeba537df5203584c87e1bc7987b958cec0c3eb17094fe3e6f33c6b5aecbf99beb7f0148ce1ebfd1f09f2753a6a551706d8f8a99b4655d42d774185eaead9dddadbe7b7077cf17759515aafdc8b49cc91b6f261e8ff5a25539fb63fbc36bf7d82e881c61bdd2eeb635cb81d19c2a0dce3beaabac28cd8466f48cef5e4d5002481eed284681238d3565c989d208ec8b5b2ffb1c2456877400cfa3856b469106a749dfd6499a811f67eb56736ba2ee48b0dfe4208545a01d4620e18469b08984fa559ba2f9f9f5963e33750bb9c7009b7202fab2fc3c8c5ba997a1c57c57f1d734bf58ac6a9d37cde2902f347a8ef540a35034fbe28468e037477509815a2f468446bab19f6f6a45817f67a3710c5d5a016e30c1f68fff07a56b426f);
INSERT INTO `mod284_matomo_archive_blob_2022_01` (`idarchive`, `name`, `idsite`, `date1`, `date2`, `period`, `ts_archived`, `value`) VALUES 
(19864, 'UserCountry_country', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789cb596dd8e82301085dfc527e8f4874279877d07f0972c9a8dac57c6775f4a667ad1464edc840b0316ed77ceccf46817b40dcf21a8b60b466e9af09c820bbbb1eb8fe3ae9d820ebbd37dd70e41cf2fd244f3c5c4b7a6aee78b6d0f81aaf9c6c5c7aa323e7e2e2e781bef7c1bf79d1fd1f2bc895fb56a597ccd0b335185e72b6ef9250bab5aae67d1a2598861159a452cbb470194e3f53a5b23f6634a75b03593c913f31be63b251520531515b07e5d8441226e6312a144839246b08454015576601d6f11fef72678a9bdcbea4fdabf6b0068be43f0c3317997ed48da2f52f4d29a37ee695d408504ec937b12fb6433ff4d6a7f39ffa0001ef1cfbdf0d3fc51867786f12ea7d7ebf01ac1fbb2fa46ccd70c34d27b9fd3dd3abd81a5bf08dd31bc61b64b835731dc7e08271c81c396a78e60ecedbbfcd8e563a71de38ba943910b73eff29dccf3763a875b8697d6011ce6ddb5705e31dc4adf7df35feb30eefa7b6e5dce5bd1f54f9dc3b4bb3f846db39ee7ec62de2d60c3a0eb7ef3d3e6deb08b9841670d86dc7142e366640c3e1e371872fbd3660d871137a55f179d19cfd9c5a0a3bf3630e0fac356be350cb747b7191b66db70db8c0da3ed67dc86fdfa034bf546e0),
(19864, 'UserCountry_region', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789cb597cb72da301440ff852fb024eb61b10213485a02934c9ab4ddf16c99a12cc27485f8f7ca46d71516d29dccc40b126118dfe3fb38120bcd943eed74d65f68068b429f8e9aebde7eb1dcec7bfda316baf7301a9bed7bafbfd3d4be14cded5f665f840b65ffe5fdb526c22eb87d09aa58f579fd9e561fcb7e7567fb6d52bdc9abbf79565f3bdb8b3664a64fe7ea8633b81087c9740f3068c61d464e020a928b4c390a42599b822891a6a0490abb2e07e6ef11501824a45ed4208e23730cf507570897afc6091846f07a45a02017c211148e804331980c10641a21c710665f3c84cb2debe43a841c10884308ba8120cdc03182373f0950855811821a202510d85ccc064fde5c5048002b1c00770054d0029a91043928d21412a3b8bf9a4e42a5c3a0924122288c05cf2477245284d5401a426128e5ebd443e19923519010091d4145331934a80a4f531418c5705c7a1402da12b2016da9401001012207820a735efa048d2f398782648e21270530d6d7ae30284538d2aeb4ebc1cf9b034a220372a339315ba3a21c4f7d4d79af9b9a6cc7674878d4920fbe202004080ac6824a195304d60a6947da56b89b4dccaf65b377b64b00089cb960bc4da01002d491f3672f05850380896c57a0688747ec44d292b4eb97ef7e0f36d3285b09504d13061920581150450e9e07be22a10a0caa0089a7ec3f46786840bc44d27ab46ba2cc76d750801debc5cd710c8c70f96a0221edc66acbfed1e138d2b418edfaa934ab45e34577471a091f7819f121457d382a3b3c2e50d48599307f9aa727adf0b02d11096785b0fc08006ac3c78959beb701a2bbc147c3a3e7c5f9fd8de683036b23631e7b7cacfb50130ea766f5bbb3c7474d38bc33eb4d67e1d312cc6df1cde6d88e0ea307c96750910ff71e7a361c4ec666b5edecf151f38dbe9ae3a12bf530d47c549ae5baaba767a8f9bebd98c3beb3f0a8f91efd6358acf9a2838f85c74f81fe21f4d36b8f7aef6d687687ce928f6a2fcbbd6de7d39f1ed5dee0d62f00d8f59a5fa6d1f888f559da7bd5ae33f3ce1cb1de8bef3ac9f49fff01c9dc5c05),
(19864, 'UserId_users', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:31', 0x789c4bb432b0aaae0500064f01fe),
(19864, 'UserLanguage_language', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789cb594dd6ac3300c85df25f701cbff56de61ef9074e91ae8ca4857280b79f7d999159843ed52c8851dc5109f4f478a5a0489d380ac695150e070baa2c2eadc76fdb96aaec8b1badfab66401e9609bb0891937e97cd3b6aff546129e7f7f0c635f3bb69c28d0302ac1f4ab69ccdfed04b319ce670d91b1d3c86f0717fa96f57e280457de1503672b8c861848c1c6074ca01c6e53978c98ce348104e5b8200662205901dc0a49544a2984b49ac843c8928920cab1d910308223230326263435e5a968a711cebc36eeaaa9478bff60175a388d23c4a5bf548bbd086fa8936fce8d6cc1935008b0092aa2ff45afb14a1d081a684f073aa0f97bdccb74f94beeb53759ef80f9c47fdcd2428e8bb62f137a9a7e25cbea80df949e8e3afefba1bf7b21ef233d0e73ede485b34ff1b3fd516a9b62868e7e75efce54f69ea2acaabb5eefa55eff3e3ee0fe0b3ddc7fbf91794faf40f),
(19864, 'VisitorInterest_daysSinceLastVisit', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:31', 0x789c85d33d8bc3300c06e0ff62e828b0247fa4f276cb6d19bb96143204c20d97831b42ff7bb53859147b0811863c88d76f26c128fb22be4cc27520d93789e2d6e935afae6c8259dcf7fc33ff4eeb739cff1fcbb6fc6dae2c42fa200e4379eb5bbff4b2ebc465ac07d7268bf3e00f84a26950cf40c06a503209ee110474ac914d22f40806ae849d45ec090142158229a49e10219e576212b947244895b083187a42865c05fb36ee4d21881b008f24f0a258edb6ea8c11f8e816dd6da5dd4f9d19219d0db50b8aed86260d552b4ae732b6d22ea9fe7e48089cce646ca65d545d8653bcd15755bca1bc3f89d6271e),
(19864, 'VisitorInterest_pageGap', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:31', 0x789c85d2bd0ac4200c07f077116e0c98c4b4366e7d807b871edc2074eb58faee97456f093a08c18f1f7fa38762d4bb6a2c87722b48ef4b45c3797cbe672897ad04040ca52ad9d8642b4f55b49d76d62a2eef36313408a81994a26bd0cc60e09e835d82674482d488455c22cd0801e937f19b21336281b5119c5d6219124943068c3d86df8c7568588df6b0bd1d7e8e3c3504e81fc435b69941f8a2bd19dedf787e947fc04e),
(19864, 'VisitorInterest_timeGap', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:31', 0x789c85d13b0ac3300c06e0bb183a0af470fc90b71ea07748a143205bc690bb574b9c0e6a3c180b637ff8976625d47d516cb3ca59b0ee9b4e1ad6f9fd5943db346a40200c6d51b64528d80edbedaebdb64adaeb3cf8af584d04d2992a2ec223440852474a7511b94592866481b82ba9b84abc55b2e561048e9dc9c965a6116304c4eb37e2674a23c608ebcc35a6ec3279c41801f587f143955ba6683002a85c0efb3daec31e17a4073ffba81ce5f802f1ddc5d5),
(19864, 'VisitorInterest_visitsByVisitCount', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:31', 0x789c85d2b10a03210c06e077113a064c34eac5ad0fd077b8428783db6e3cfaeecda2934d0631a87c68fc77c12cf721b1ef924641725fc212cefdfd3943bf74272060e887900ec4d6fa57673d1ae5d62af5d7583011029a48aa4b833c23411a462e4b227944863c085adf227b04034f222e09f688026536634d148fa85007c14ba17a4283660bcd14b2840d7076735b129b49688d0cc44e2fd04ea8d65480e350fe2076428bfeabe63c7a8a9dd1aa0f8a08e432764ef53214f1414f4bf9fe0080f00d89),
(19864, 'VisitTime_localTime', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:31', 0x789c95964d8edb300c85ef3227107f4489ce1d7a8714ed6280d97519e4eeb5143d05b5500ab370e228713e917c7ce2fd603d1e9f47badd0fc18d1f8f3f473e3ebeee3f7f7f7ddcdae2e7c1e725b5bd9c97f9f9a2b75f477bcfeddb9adb0facddb6b5329e226a4fb4654d7de979ae9d88743c9eedaf7e60e1fff03ce0a403cee502274e834de9ca2689d91cb28907bc207252d0fb7e1aded4f3e0eb127bd9f025e43321f33cf835039f065e4809e1d725f514e3350e7fd03923f575d005a97f975daeecfe54c0ce71e8b864b0335d23e79c40275be89bc45b4817d053c2a784cc1bf00eb82f657f3d17e04b8857681eb2d35976d04908aaeb4afc57f59b8eab21dd4047ea099a87e445269bbedb711eb20b12ef881c9243b75741b7332f69af319b629fab039e51f4aa17b869cf45a34bb9d27523788a8dce07ddcb4c3b6cb6fb50fbf7ac0cbe2d55af3bfec6ec60f3f4b28e2e635b7447b9cad84259edb67764b487d8f00896f34e822f4970ab90405ee4e71bc7a38de5a1f32b8e1beadedb3650a0fe52e03bb6f05f350bf8b1ed115adf6d26609e384880714209f25202df5520763ec279ebe8407e9b0f3640e25d195d1d6b09ca6607b1f911fcc7e13fccf0fe3a3720791eba8b0d6c5310fb1fc1840c3e4073e680068c187c594a601bf3a7d803093ea46802bf4a9093ce837739fa74e3fe1cbb20c188740e3d699ebd50805a8500d6f87563c31c1b21cf791312ac887fce9b3e879e75f0901d3ef641c6e821d09fa1fa901f170b66ae8dfa7833f3c9153ffb2f43fd54317b74157e03fffc0ba9d544c0),
(19864, 'VisitTime_serverTime', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:31', 0x789c8596498e1b310c45efd22710075183ef903b384816067a97a5e1bba75cd697bb4534b5a8825d1e9e487e7ef2da59fbfdd6d3e5da052f5abfffebb97f7c5e7ffffdfcb8dcba1d171f17c9717b5e548e9b5efe1cd7ade7e743c9e37b44c7edf971c29bf3579ace478fe3ed4148fdfe78fed32f3cf8994d3ce05501cf32e804bc69013fe7955f5acce790cfe00b0fbee581af83ce9608d197952e14d325a4a701e736e0995678c91525e215ce35866b9c7ac0d38033122f034e99117875ec14b3739c76486e069e50f484c8b320727291d326720be902cd417275c06db0b50cb2ade00db7845c45e4195133a2069984207576adc69b56ab213dcf9ca3cf39a1e20df8b7d45b72496f1b7e0bf965adb9d242afda2e3fda4c89d9147b5c1d7045eca52e705345ec673b7e6ff34ddd2976b906c11914970d95e7c1cf344d363b9b293b7eec7204a379d5f7a5f9e6b447da7004732dd7747384d8ea0876438cb663c59c9949a09454d177ce73682b828de3a1f1cbcc02c377ca3881940611aa2b83d9861fbb1ec10088a6e7129a60e6c0a8c2f84c5d0ad2ee08b1f5d17481b7ed9bd322497b9fc19befce7d29b641c2c2d1a612cecc7c9d7b0723c184d509a1ed74103b21c18a0c464c02294207c50cc34fdccef1da11027eec8434dda80c7e73f1379d73df0d21dd6880632f24d8914e3b4a731041025a0c8dc8ae0f74133fc776c8b02341fc751d44dcca8cdf0d22d9c5bfd9f96045826150671362fb9034ddd8ef5de7ae18f1632b64d890a00515c328a3fc7a8e6643b5beaf01e1c6fbf80fcc11456b),
(19865, 'Goals_ItemsCategory', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:29', 0x789c4bb432b0aaae0500064f01fe),
(19865, 'Goals_ItemsCategory_Cart', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:29', 0x789c4bb432b0aaae0500064f01fe),
(19865, 'Goals_ItemsName', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:29', 0x789c4bb432b0aaae0500064f01fe),
(19865, 'Goals_ItemsName_Cart', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:29', 0x789c4bb432b0aaae0500064f01fe),
(19865, 'Goals_ItemsSku', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:29', 0x789c4bb432b0aaae0500064f01fe),
(19865, 'Goals_ItemsSku_Cart', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:29', 0x789c4bb432b0aaae0500064f01fe),
(19865, 'Goal_-1_days_until_conv', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:29', 0x789c4bb432b0aaae0500064f01fe),
(19865, 'Goal_-1_visits_until_conv', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:29', 0x789c4bb432b0aaae0500064f01fe),
(19865, 'Goal_0_days_until_conv', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:29', 0x789c4bb432b0aaae0500064f01fe),
(19865, 'Goal_0_visits_until_conv', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:29', 0x789c4bb432b0aaae0500064f01fe),
(19865, 'Goal_days_until_conv', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:29', 0x789c4bb432b0aaae0500064f01fe),
(19865, 'Goal_visits_until_conv', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:29', 0x789c4bb432b0aaae0500064f01fe),
(19866, 'Goals_ItemsCategory', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19866, 'Goals_ItemsCategory_Cart', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19866, 'Goals_ItemsName', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19866, 'Goals_ItemsName_Cart', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19866, 'Goals_ItemsSku', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19866, 'Goals_ItemsSku_Cart', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19866, 'Goal_-1_days_until_conv', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19866, 'Goal_-1_visits_until_conv', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19866, 'Goal_0_days_until_conv', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19866, 'Goal_0_visits_until_conv', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19866, 'Goal_days_until_conv', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe),
(19866, 'Goal_visits_until_conv', 1, '2022-01-01', '2022-12-31', 4, '2023-01-13 12:45:30', 0x789c4bb432b0aaae0500064f01fe);
/*!40000 ALTER TABLE `mod284_matomo_archive_blob_2022_01` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_matomo_archive_blob_2022_02`
--

DROP TABLE IF EXISTS `mod284_matomo_archive_blob_2022_02`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_matomo_archive_blob_2022_02` (
  `idarchive` int(10) unsigned NOT NULL,
  `name` varchar(190) NOT NULL,
  `idsite` int(10) unsigned DEFAULT NULL,
  `date1` date DEFAULT NULL,
  `date2` date DEFAULT NULL,
  `period` tinyint(3) unsigned DEFAULT NULL,
  `ts_archived` datetime DEFAULT NULL,
  `value` mediumblob,
  PRIMARY KEY (`idarchive`,`name`),
  KEY `index_period_archived` (`period`,`ts_archived`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_matomo_archive_blob_2022_02`
--

LOCK TABLES `mod284_matomo_archive_blob_2022_02` WRITE;
/*!40000 ALTER TABLE `mod284_matomo_archive_blob_2022_02` DISABLE KEYS */;
/*!40000 ALTER TABLE `mod284_matomo_archive_blob_2022_02` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for `mod284_matomo_archive_blob_2022_03`
--

DROP TABLE IF EXISTS `mod284_matomo_archive_blob_2022_03`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = 'utf8mb4' */;
CREATE TABLE `mod284_matomo_archive_blob_2022_03` (
  `idarchive` int(10) unsigned NOT NULL,
  `name` varchar(190) NOT NULL,
  `idsite` int(10) unsigned DEFAULT NULL,
  `date1` date DEFAULT NULL,
  `date2` date DEFAULT NULL,
  `period` tinyint(3) unsigned DEFAULT NULL,
  `ts_archived` datetime DEFAULT NULL,
  `value` mediumblob,
  PRIMARY KEY (`idarchive`,`name`),
  KEY `index_period_archived` (`period`,`ts_archived`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Backup data for table `mod284_matomo_archive_blob_2022_03`
--

LOCK TABLES `mod284_matomo_archive_blob_2022_03` WRITE;
/*!40000 ALTER TABLE `mod284_matomo_archive_blob_2022_03` DISABLE KEYS */;
INSERT INTO `mod284_matomo_archive_blob_2022_03` (`idarchive`, `name`, `idsite`, `date1`, `date2`, `period`, `ts_archived`, `value`) VALUES 
(211, 'Actions_actions', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789ced96cb8e9b3014865fc562d15515f902e192d54855d56ea24a7d00e4249e092a97083b3395d23cd03cc7bc580f013b261060d4645169221162f3f39f3fc6e7133c62d12189f0829f7fb8383ac8c88b9c94af44ea2c64e4c3003d946a2fd1cfb7d7f5be4cd4db2bfac4b3dd02fd280b25d62a2972f4077d4f05da08f4b5e4f95a7c46dff85ec9f304120a3dec57c25924118583c141f4d94c545f2cacbe30942691832b3d23f6802e96d589c10966e79123f759ac924cc4b9502f45f9ab4a0dd36446fd1057030a7f215fc5db44c9f82551db8e1abc99d3b86549dee78667183e46c47ff797c48cd622cfca2545f92c4a63e4066e1dcbed8b75169b549e95eac2cb84f2ac50171ae6ce6b8d6f6552f054e4a3a50a82da89cefb52d97293cbb77275fc70b3f827954ed651cd9bfc9459d9364516efca622da44cf227b3b6a4d132da97b07b13e4a4dadbe4ecf58635a2d4e43069af687d3fe8cfbc2eb25d2aaa76e83c9feb99db37d5bbbc27b32d5bf605bd14b43aa3c8e3b4e09b4eacfeceb0d43a4fab33cc755dc704b1ae4037fb66b3c020b406b4e96ef734a8ba1b96c73db537a5e6c9c14dae3df0cce058b183c3e050effc1d7f82bd95a854c43baeb6276c4173dd925ac78a504b5d7980972114465f44c6f3cdc979239e1309856e8f50621f66a24228be154171482613948c10f4ec364c502d1a20280efda90425a3046dbc86086a348304354d3585a064024135db07098a271314cf2863ef2528994a50ed3d85a0b6f683a0e304253641894d506208aabb5b0394d800253640c9248086b03c77c6d899a9d4662af33a4c852c6859482823a4e25599ff14a9631be77d489df452da7e49ec412ae0857ab379e8dd82a96db32b50bd100d529504e4a654d57ec354355547a94ae1fd3ab81355cfdee3546d6b3fa83a40d57f80222cd77d39a49978fc0ba62afc2d),
(211, 'Actions_actions_url', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789ced96e16eab201886efc5ff6b01b52abd87dd82b1959e9263b501ba2d597aefe743016945dbe56cffd6a415cacbcb2bf23db1a231fde4146dabb19120fa29694aa3a6dab126da4abaa1d19ab735fb88b69c12f8c6f0c5f6eafed03f71a17f104cc234425a1f63bf43b6affa12c305fe05637939958a9f58d932f5de89bf663dbc2259817487409276571eb992e53b57c7891abce3c8b89d781b72432b041f27aa3ec24ba2980ca2d4cb25997863c219257932c44a42b146b14b957aa9eebc5ca8d40b75a78993cda0c9bc4c4a54ad3c78aa3c1f9cc82694ca97bb5c99976be287cce6f72a9b6ca2da98fc24f6b2d5dda93c8b6ecfa4e4ed1fb7b7d86863124a389d043989f5763983deb04784b81c2eed8c36cbf270e67d773a374cf1ae9d3c9ff9ccb79386531ec8eccb5e4341ef053795d1b565d355f52456b8323cb5cd7353196edcaee382782350cd993b2cd029bc0e31d59df41d5dddb03d495fde84b827079312bf93bace55b3a3820e5006f6e1221a7b728f4a9d255daf2ba12ef245b2fd4570c55607b1ee67696898c923b5b27b586148b3ef5a55ed55cddeb8b4ccc29655d8b20a0da8320d6c1b0e513b8a66215553c045811ff349af37c7a6d1248c256f3c44a49ac25928b28730321142201a2d820cf286c3f8a9fb2d7a441d13204c9cc1620634c67f892f3a2381a7f52c5a86308b58192d1789722b9b85c9700fcf3184bbfbfd097e98dd5cc60677a7fecbc8284c7511641bb6a8882bbcb46ff80cd08687aea999288105a55450fe3d75f32522dc96f8d5be935c75b1fb7c88277cd0b7dfc997b360b094deb21f43c4fc6e3f8907b48006348f0592ae3645fa7f5c701e336018c767c9b0c239fe063a189b7942d875962941e0552aff5e4a58cb0794f065bf94f8020112bc448049111b0890edf5fa0fef20343e),
(211, 'Actions_actions_url_chunk_0_99', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789ced945d6ee3201485f7c27b63032669f01eba058b3a7482268608485ba9cade07484caf13ff4ca58efa32962cfbe2c3e1c3f63d8213fea138ae1dc704571c098ee340590b4efb9baae41f8e338e0ee2591e50d0ae392a94dec977542b4eea6800ce3c40eb68a0382da33f476594530c0b523fc50b0d97301a7cdda96bbcea64a3a57f33f6f77539bc2ab7b88c050920fab9d92bef9a37e5f777eae08dd1d5ad537ade2d89c4fb8288012e27edabb4574d19349b0b563586f529ce540c504d78254d0f35a5d900266f85762f50158e44b51ea382f2ccb5015c937e49d5934daf4a01dbce74cdd19a563aa7f4afac2594262d256384f7937acee89d3917bc93b6a7fd0bed80b935ddf120bd32fa6e7fd3ccc34997bf7c8419ca9ec6406f0583ce30ba3918b1bb7feda39d01d43dcfa033f2f37e9d0c029e8466dee48f108a2d2848090bd8dd84c039152c582ece312c52ec8417cbd1c9a684a15b8ef6de1f1d2f0a61fdc93d38d99eacf272f5628bd6682f5abf93afca15c92206c8f97c89a3e08c191bcf32ca7e3ecb96bed8d7b20c34e7749601d1789685be266cb5deb2ef08b3a1d9449add8866e30c3fe26f8db3de6f3ecef2aa8b714656b47afc4771f6e9bd1c6743edff389b89b32fa55145e6d2481bf770b4d2791177781348e73f00d2f427),
(211, 'Actions_downloads', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(211, 'Actions_outlink', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(211, 'Actions_sitesearch', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(211, 'Actions_SiteSearchCategories', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(211, 'DevicePlugins_plugin', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c85d04d0e82301005e0bbcc09f813f5f50ede61842223459022c410ee6e37242cb0ddbdbcccfb16c3b86011448a916e21c162710219be6b43ca2207155dd7882625485c11833252ab2076e71116975275db8aff90cb95615bef9cf8d849bc4e067af2c46126f53229a82fabb09279952be8fd91a219a5dd3f283ab64e5e2b8e408366d31bfeea21ace57ecd0dad98490f461ef518e6ce7e2e01cdf22abbd9b6ba140e79eb0f170bb23b),
(211, 'DevicesDetection_brands', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c7d8ebb0d80300c4477f10471f829978a05102b044181449732caeec4c86e90a038f97fcf091ee5848b099d25012563005d693b2e8a190e44f10437754d5ea3a89718a21c4ab13fc34172698cba3d3d0b552c52732b558e176b7c833d685e0dcd6a666ff01bcd8a3632ff90eb0da9344533),
(211, 'DevicesDetection_browserEngines', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b6aaceb432b04e44302cadaa8bad4cad94721293527394acc16ca79cccbc6c25eb4c2b43203642c2c6306c690dd29d6965629d02963005b1410266505de66005b5204ea2958155752d48a31f4c00afedeea9c9d9f930db612e3084da6c886ebb21d476e22c37c26bb9999552786a927766094d6caf0500f1c16bff),
(211, 'DevicesDetection_browsers', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b6aaceb432b04e44302cadaa8bad4cad94721293527394ac8bad8cac949c3d94ac33ad0c81d808091bc3b0a535486ba69589750a58c214c40609984175998315d4823889560656d5b5208d7e3001bc56bbb9c1ac86596f08b5d610dd6a43a8d5c4d96c44c8665fdad85c0b0066e56780),
(211, 'DevicesDetection_browserVersions', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789cb5cfb10a03210c06e077f1010e2f6aad7fc68274e9bd83a51d84db6e14dfbd78c4a5d073283784e40f860f132c4a86e604d38780b2c141ade9f95e156ff050b73b079ab4e28c598aa49bde03b7fb0ccbaf7de1245fe481df736d2141a3d476bbf4c590bffee6e99b27e16df7f5a14f233f46f607fe9fdf3723fe117976933985af1f30168d6a),
(211, 'DevicesDetection_models', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c7d8e4d0e82301085af627a020604d3372b2f60b84285461b0918cbaee9dd65486743a28b9737bf2f9f438d1450b143a385458a68612677f793e108ea60f8e167ff09c369f4f1b52e6fc301b4a9d95417179dc52d4b9234e3be6ca5964157ae2ffb419608870a29cbf34d07bf492cccb5e7d03f97d92b01954ca5a12301150205a03f00f90b38514e41),
(211, 'DevicesDetection_os', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b2aaceb432b04eb43286312cadaa8bad4cad94721293527394ac8b81324a9efec14ad6995686506c04a58d61b4a535486fa69589750a58c014ca37832a3007f36b419c442b03abea5a905e3f98005eabc33dfd9490ac3382d2c660dbd0ac36825a6d02b3db088fddb500e34b467f),
(211, 'DevicesDetection_osVersions', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c7dcf3b0ac3300c06e0bbe800c18f388f5f27c8920e1d3abbb483215b46e3bb1727122d947810f22f6c7d38c22327188edfc38cbc2380b6f87c6fc43b26d072bbb30d9d274eb0524ebad73e735d90d0f3eb1804c9835c188f5c6a8830c8a5be5d7570ed0fa0c7b2b235f4236b79ed2ddd3575d7d4c7539f3a7bf5f93fde09dfab6f1a7ef9002e986b1c),
(211, 'DevicesDetection_types', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b2aaceb432b04eb43286312cadaa8bad4cad94721293527394ac4182995686406c0cc446501a844d40b425548189750a58d214c406099841559b8315d4828c48b432b0aaae0569f68309e0b6d510091b21b9c010dd5643a8ad304b0df1585a0b00dacf4391),
(211, 'Goals_ItemsCategory', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(211, 'Goals_ItemsCategory_Cart', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(211, 'Goals_ItemsName', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(211, 'Goals_ItemsName_Cart', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(211, 'Goals_ItemsSku', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(211, 'Goals_ItemsSku_Cart', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(211, 'Goal_days_until_conv', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(211, 'Goal_visits_until_conv', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(211, 'Referrers_keywordByCampaign', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(211, 'Referrers_keywordBySearchEngine', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(211, 'Referrers_searchEngineByKeyword', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(211, 'Referrers_type', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b2aaceb432b04eb43286312cadaa8bad4cad94721293527394ac33ad0ca1d818888da0341c5b5a8374655a9958a780159942f9665005e6607e2dc884442b03abea5a90b01f4c00b7a5c648161ba13b00d95223a8a526305b0df0d85a0b00e4bd4394),
(211, 'Referrers_urlBySocialNetwork', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(211, 'Referrers_urlByWebsite', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c358cc10a80201883dfc57ba19949fb9fc6ca836018d94d7cf7f8cd0e631f1b9b83420990e4a07f5851320c44749b8f82329485b8ee942fbf3fc393521cf7740a0a505d5377dd59afc45701331d2d30cc1c2cbdb0cd2bcf1c244afdc68a6a7d0191b12aeb),
(211, 'Referrers_urlByWebsite_chunk_0_99', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c358c510ec2300c43ef927fe8baae4373eec01dc298c4a4a256b47f55ef0ed9ca47e41727b6c0a2eeb09c61fd0492731f58e0feb0a066785090c716e8f739cea0572929c398f489396d6bb99418c3758d6f43ac7de78c5d5d67b7b076ee98f879185e598db91f6e87368d0906d4a6e13bb746dcbe3484326c),
(211, 'Resolution_configuration', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789cb590bd0ac3300c84dfc54f20ffc4714e63213443d3a1436797763064cb62307ef734c15e0a4dbb6410a71392f8380f831440eca16bd321cd682026ff784d82674803315c6f7ce9d948135d670507c852aaa8aedaf1fa27c0f0731b34c5dbb2d06e3eafc68390f27a3bd6c10ec6dbdc87914f6796dadad85af78d437d72a8c2612a08ed82a89f79141047142dd14179e8bff2e87b96ca51740771e405c75a96bf),
(211, 'Resolution_resolution', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789cb590310ec3200c45efc2098c21063e77e81da8da01295b1624c4dd5b22582a854e192cfb5b36efe3048b9a4131c1cc22a01ed8a0f6f47cef2a1ef0509a3d154fa462861ec1239b9943ec0f64d8f83a1bdbd03206dca95b170984dafaee6336d67c23529cf82b3efff279f0ed34404b03bc34e0a0acb6c507b9e9ffe61ffe7bfa22379dbf7d00945e8e45),
(211, 'UserCountry_city', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789cb5d0c16a03211000d05f29de23ab4e561d4f4b4a2139e452e8ddd03411b62eac9b5e627ea6bfd21f8b06b724816e4f414467189da716018f0e2b63518c1b8dc7807324addd6c5b6202328964b1fff91e5cdb763e2e9f5fe2474f8c4356262fab18576df2550ec1bc5f12f312d7a5405ee2530e2cf2dc4fe47e0349f5a0a8aa586a0b29d5f95dce71ca35e47a61d6e3b1096f8da4f183f569f4eeab8bf173f71797df7379e1c2e8adfef1ce58022b790b064941e92b319f16a7a3afd63fadbab08d8b261ec2c3be57482a84bad5ce1867e90df595574c7bd37d4dd86f0ebd8f6f8fe56a5a01dc7165fe5df9ab3d9d015a63c9f1),
(211, 'UserCountry_country', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b6aaceb432b04e44302cadaa8bad4cad94721293527394ac8bad8cac94d28a94ac33ad0ca1d8084a1bc3684b6b90d64c2b13eb14b08029946f0655600ee6d7823889560656d5b520bd7e3001bc36e7a6e3b2d908dd6623a8cd2630ab0df05a6d44c8ead26225246b6118abd5e89e36c263732d0027e0686a),
(211, 'UserCountry_region', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b1aaceb432b04eb43286312cadaa8bad4cad94721293527394ac8badccac943c5ddc6ad28a94ac33ad0ca1d8084a1bc3684b6b90f64c2b13eb14b08029946f0655600ee6d7823889560656d5b520bd7e3001dcb61b5829e1b2d708dd5e23a8bd26308b0df05a6c84d76220dbd9b1a6b49846be3626647918cd2caf05009fbf8d1b),
(211, 'UserId_users', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(211, 'UserLanguage_language', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b6aaceb432b04e44302cadaa8bad4cad94721293527394ac8bad8cac942a2a94ac33ad0ca1d8084a1bc3684b6b90d64c2b13eb14b08029946f0655600ee6d7823889560656d5b520bd7e3001dc3603d9a979baa5c534b2dc8890b7d38a94906c8561631846b6d9086ab3093156d70200bb956989),
(211, 'VisitorInterest_daysSinceLastVisit', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c8dd33d0b03210c06e0ff22740c18e3c7356e5dbaddd8b55870108e0eb5d0e1b8ff5e3b1c74688ddb8b920709af89d1f15a58c7c4b407c36b65c76a49b7bca8581903ab73bee7475aae737e5d4a2dcfaa6261f3b9646555dc0a631bd5bcb64471de0ffea3c44a83fe52f46fc5480a02ca0a498a01232b56520848569ca458b0b2e225c581939520291ebcac4c921220c8cab1ab585613e0c062b05fe696d1010d340ffb056e9910fc08d4efb06f5b6e25362352bfc7ed9fa241203fb2a67e99dba3c8bb833949d2f60601fc2f87),
(211, 'VisitorInterest_pageGap', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c8dd1310ac3300c05d0bb083a0a2cc94e5279cb017a07173a18b2650cb97bb5043284fc6cdf92fc30567349be754fb5b91d417d5bbd382dedfb5ba8aed12161a1da5de3244e4675ef2e311bb72359fd1c855b45594f8a5c2b8a14633b29e95a31a464ce58c948295cb0529032f08895e156c94e134bc2cc78cb4496d8f583af99a053581fbce78d1c9597cec8d9fffdf9c583),
(211, 'VisitorInterest_timeGap', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c8dd0310ac3300c05d0bb083a0a24d9719cef2d07e81d52e810c89631e4eed512c890dadebe8dfdf8d202151c2ba42c0857301c3b06d0b67cbe1b951d1124ac426585f9514181cab942fdb17ff714cafbbaf8cf7856e57077e4d9b1961394d3ddd16727549d044a3e9775148a5568f402266cb1431a5a922b1c7b3aa596e48a6fa9431a5b922b3cf548b92a65902bacb9879a9a2bcfa22f9b5bd2f90389d5ca9c),
(211, 'VisitorInterest_visitsByVisitCount', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c8dd33b0ac3300c06e0bb083a0a24f995c85b0fd03bb8d021902d63c8ddab25d0a148de7e3ff8b0657928673d37a53e34dd41f43cb428ece3fdd9a11fb6028c0c7d53b1112b64e8d7a66c7b494f4ba9bfee095711941f85fe2b12290953aca448c9986325474ac1122b25522ad658a991d2b0c54a8b94059758595c252bacc813e55d5dc63217948902b3dfbf96a562a109c86fe16a0f6e3f816624bf8d9bdd8d18658af27bd90e25c40f7946d2f50565801584),
(211, 'VisitTime_localTime', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789cb5d64b0a84301084e1bb788254c7f868ef307770985908ee6629de7d88b41bc172550b31c4c887487e9ddd5adf164fd3ecf91c8cbefdbc78b3ceefefda4c757271c46171ce31ce632c68a7cf3151eab84e7471a13fce7bbd6df6e4db5e6f7e9d13f76ab9517155118b4f1414358ac2346aa6aa41a3b6fc59e34881a640d3154d1794bfd5c21f55837614cd1ab4a768ab41078a761a74a468af41c1ab3488545ea551a43e64298958de25881281873089f62b789a20dab1e0714211b13c4f10a5023c5050c582270aa25a186f1444b9301e2913e5c278a54cf471b787bf27492ef63fcccc182e),
(211, 'VisitTime_serverTime', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789cb5d64b0a83301485e1bdb8829c6b7c5df7d03da4b403c15987e2deab9240b1781c9d41f041f4c3407e4c6ed197c9c398bc2e27832f1f6fbc9ad3f33d57e3e4ed36b00dfb1975390ee3fed4e4717c1d939a7cdde609dd71bdee6f481e7c59f7671fe5c6350acb6a919155dca9a0aa51d5aed4bf6fb5acc6c206cad6940d590a590a590d67359cbe95a391afb0066df8026bd096a2b506ed281a35684fd146830e14ed342878957a91cab33488549e258802019e258812819b3089f62b789a20dab1e0718268cf82e709ad88e581822a163c5110d5c278a320ca85f14899281776f3f324ca85f14a992417eb17d645182d),
(212, 'Goals_ItemsCategory', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(212, 'Goals_ItemsCategory_Cart', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(212, 'Goals_ItemsName', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(212, 'Goals_ItemsName_Cart', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(212, 'Goals_ItemsSku', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(212, 'Goals_ItemsSku_Cart', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(212, 'Goal_days_until_conv', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(212, 'Goal_visits_until_conv', 1, '2022-03-09', '2022-03-09', 1, '2022-03-10 00:30:48', 0x789c4bb432b0aaae0500064f01fe),
(301, 'Actions_actions', 1, '2022-03-10', '2022-03-10', 1, '2022-03-11 02:00:43', 0x789cad944b6e83301086af62b1e8aaaab081a098553655bb892af500c8216e639597b0692aa53950ce918b751c823309a40fa948868cf9f9e70bcc8ce0946f14f713c183fe47e8f38de611f772b190b997681e4340668d693579deefb2b65166bf2337a2a813f2d4544666465525f9248fb9244b49ee1b5166f2963c88d6e8d3069186ccda85f412c5192c8a17eb3703384d61053e64a6dcf3ad3ca03860c9dc5e02b8c0ee847bba2d52a30a9996d2acabe6cd42c3b67fe7c3610306ffa05ca42b6574ba566635508337f38e6e852abf773b88c4c70fa2087169d9bccb0669a20e2b1cc33a891d5584a8065ed4e57350034dd86962c464e0a3e817a4a293ce894dc6a8b0dc71c5886be0e7c862443692f5f88902c4b6ac8ab46eaa4c6aadcad7c1bb0dd818e1f0a1ae623a6fc779299bf7821ef19ae08c2eab8a3a97b6eeff4077fed0553a2c1ba5bb149cf54055a6792596bfec01a4ee79ce7ac0ddeff338107407da36ee0ca86d503a4501f35dc14060fb185e0f3d343263a8ab69881d22176ced8010764e75355e8b57a822657299d6c2ac0ef309dae83fc713a4b4b365bbfd026deea20a),
(301, 'Actions_actions_url', 1, '2022-03-10', '2022-03-10', 1, '2022-03-11 02:00:43', 0x789c9594eb8e83201085df85ff5bb9684df11dfa0a86b6744b56d1006e9b347df7855ad8b1dabd98200e9c397c4106c109bf2a8e2bc159fcc831bf5a5e70d4889d6c5065f99aa34ce983bca04a71ea1b818dc641e65f1bdf18f63984231ce48cc08056dbd031dff951ef6b87b676aa95b596eedc998fc7727885fd1302ea41f4ae3e2967ebb372a799da7b53f4706b95fed9ed2e12975f4405e0b2d27c4a0334c588952f617d8b135501a8665e24ad97a0669a7cd49480c919a1ed11a8c87a74a2eb252a284f5c25e09af925b212902dacfaf8450cb01dbab6ee4db797d62afd3edb5b469708e749e38919bd13e7b36c1b0511f1956042b7efdabe914e75fa1f74d3a4977450b648f72c98d440a7eba613873fd60050479e490da4f9b84e020133be6ccbd1808402251b10509c0e8c0f421dfbed21f742a6145435c9a14391825bb82044b861fcce723498269ed19373bde559268c1bec9b95fbc12827574793ddb3c2f570bb7d01e0d572c6),
(301, 'Actions_downloads', 1, '2022-03-10', '2022-03-10', 1, '2022-03-11 02:00:43', 0x789c4bb432b0aaae0500064f01fe),
(301, 'Actions_outlink', 1, '2022-03-10', '2022-03-10', 1, '2022-03-11 02:00:43', 0x789c4bb432b0aaae0500064f01fe),
(301, 'Actions_sitesearch', 1, '2022-03-10', '2022-03-10', 1, '2022-03-11 02:00:43', 0x789c4bb432b0aaae0500064f01fe),
(301, 'Actions_SiteSearchCategories', 1, '2022-03-10', '2022-03-10', 1, '2022-03-11 02:00:43', 0x789c4bb432b0aaae0500064f01fe),
(301, 'DevicePlugins_plugin', 1, '2022-03-10', '2022-03-10', 1, '2022-03-11 02:00:43', 0x789c85d04d0e82301005e0bbcc09ca8fa8af77f00e23141929821421867077bb2171a1edee6532f3e5651827ac02a519d91e52ac0e0790e5abb1a41d0a50d9f7ad18d282d40f1250427a13247e5d61f529d3977df01ff2b9b6ec9a2f47fd76d2a09383ee3c73bc4e166432d050d5f132795039839e2f29db493a13b70e412b51a0d1b01d2cbfcd18d78ab0e60f9dd8d98c566ecd147fd731cca5a0451e55bfb8ce54c2b17adb070ddab237),
(301, 'DevicesDetection_brands', 1, '2022-03-10', '2022-03-10', 1, '2022-03-11 02:00:43', 0x789c358cc10dc0200c0377c904504a2b9c1dba432afa40e2c71365f736287d58b61c5f0411b321b020fda1600e645097fbe9c4030144dc105d9b7bf29c0a1bd8b0735d45b68115871fcee56a987cdfa61a7cb1ea0bc98a2362),
(301, 'DevicesDetection_browserEngines', 1, '2022-03-10', '2022-03-10', 1, '2022-03-11 02:00:43', 0x789c358b410e80201003ffc20b404442f70f9efc00060e24c4837823fb77b3663d346dda4e86c36cb094e1ff903007024ccf67ed860622cc71b752afc75083532dea5eb34f247cc34ae52b821ca4d874889fb36019169305de89f9051feb2643),
(301, 'DevicesDetection_browsers', 1, '2022-03-10', '2022-03-10', 1, '2022-03-11 02:00:43', 0x789c358b3b0e80300c43ef9213f4c34775660616ee100443a56e1dabdc1da50a8365cbf613448c8ac082fc8782d1b1829adc6f23ee48a0f320ae88aee49e3de7c286562cfccc62b583159b0ffb74354c1030d4e08b553f126623f2),
(301, 'DevicesDetection_browserVersions', 1, '2022-03-10', '2022-03-10', 1, '2022-03-11 02:00:43', 0x789c358bb10e80201043ff850f302022a1373bb8f80f677420616324f7efe6c839346dda3e46c0a8f0c4887f28181d09aef1fd36471d19ee3c2884c53baa08a6d53c5a8e8594afd8e89945d28316bb0d79ba28c6f018a2f045221fa8e824f2),
(301, 'DevicesDetection_models', 1, '2022-03-10', '2022-03-10', 1, '2022-03-11 02:00:43', 0x789c354c5b0a802010bc4a7802cd2c9cbd4377b09290a422fb13ef1e2bf631cc302f07851c20c941ffc222271888e8161f0525a81182767ffa27acdde6d3f15eb7a000d5d037d64d6b4bfc1430d0560dc30536c6164c950bcf1c2472e1f14ca57cf13929cb),
(301, 'DevicesDetection_os', 1, '2022-03-10', '2022-03-10', 1, '2022-03-11 02:00:43', 0x789c4bb432b4aaceb432b04eb43286312cadaa8bad4cad94721293527394ac8b81324ae19e7e4ad6995686506c04a58da16c634b6b90de4c2b13eb14b08029480148c00c2a610ea66b41da12ad0cacaa6b419afdac6b6b013ff12453),
(301, 'DevicesDetection_osVersions', 1, '2022-03-10', '2022-03-10', 1, '2022-03-11 02:00:43', 0x789c358b310ec0200c03ffc20ba0142a9c177461ed9caa1d90d81851fe5e05a58365cbf6310266832746fc43c11c48709defb73b1ac870d7592978470dc1b49947cbb190e20d3b3dab487ad022db702c17c5181e5314ae24f2019ca524f2),
(301, 'DevicesDetection_types', 1, '2022-03-10', '2022-03-10', 1, '2022-03-11 02:00:43', 0x789c4bb432b4aaceb432b04eb43286312cadaa8bad4cad94721293527394ac4182995686506c04a58da16c634ba80213eb14b08029480148c00c2a610ea66b41da12ad0cacaa6b419afdac6b6b01794222da),
(301, 'Goals_ItemsCategory', 1, '2022-03-10', '2022-03-10', 1, '2022-03-11 02:00:43', 0x789c4bb432b0aaae0500064f